/*
 * USB vendor ids
 * This file was generated by running python ./make-USB_IDs.py > UHS_USB_IDs.h
 * Don't change it directly.
 *
 * Copyright 2014, Andrew J. Kroll for Circuits At Home, LTD. All rights reserved.
 *
 * Copyright 2012, Michal Labedzki for Tieto Corporation
 * Other values imported from libghoto2/camlibs/ptp2/library.c, music-players.h
 * Copyright (C) 2001-2005 Mariusz Woloszyn <emsi@ipartners.pl>
 * Copyright (C) 2003-2013 Marcus Meissner <marcus@jet.franken.de>
 * Copyright (C) 2005 Hubert Figuiere <hfiguiere@teaser.fr>
 * Copyright (C) 2009 Axel Waggershauser <awagger@web.de>
 * Copyright (C) 2005-2007 Richard A. Low <richard@wentnet.com>
 * Copyright (C) 2005-2012 Linus Walleij <triad@df.lth.se>
 * Copyright (C) 2007 Ted Bullock
 * Copyright (C) 2012 Sony Mobile Communications AB
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
#ifndef _UHS_USB_IDs_h_
#define _UHS_USB_IDs_h_
#include "UHS_UNOFFICIAL_IDs.h"

#define UHS_VID_FRYS_ELECTRONICS 0x0001U // Fry's Electronics
#define UHS_VID_INGRAM 0x0002U // Ingram
#define UHS_VID_CLUB_MAC 0x0003U // Club Mac
#define UHS_VID_NEBRASKA_FURNITURE_MART 0x0004U // Nebraska Furniture Mart
#define UHS_VID_UNKNOWN 0x0011U // Unknown
#define UHS_VID_PLANEX 0x0053U // Planex
#define UHS_VID_DRAGONRISE 0x0079U // DragonRise Inc.
#define UHS_VID_TRUST_INTERNATIONAL_BV 0x0105U // Trust International B.V.
#define UHS_VID_IBP 0x0127U // IBP
#define UHS_VID_UNKNOWN_1 0x0145U // Unknown
#define UHS_VID_MLK 0x017cU // MLK
#define UHS_VID_TP_LINK 0x0200U // TP-Link
#define UHS_VID_CHIPSBANK_MICROELECTRONICS 0x0204U // Chipsbank Microelectronics Co., Ltd
#define UHS_VID_HANGZHOU_WORLDE 0x0218U // Hangzhou Worlde
#define UHS_VID_HUMAX 0x02adU // HUMAX Co., Ltd.
#define UHS_VID_MM300_EBOOK_READER 0x0300U // MM300 eBook Reader
#define UHS_VID_OCZ_TECHNOLOGY 0x0324U // OCZ Technology Inc
#define UHS_VID_OCZ_TECHNOLOGY_1 0x0325U // OCZ Technology Inc
#define UHS_VID_LTS 0x0386U // LTS
#define UHS_VID_SHENZHEN_SINOTE_TECH_ELECTRON 0x03d9U // Shenzhen Sinote Tech-Electron Co., Ltd
#define UHS_VID_BERND_WALTER_COMPUTER_TECHNOLOGY 0x03daU // Bernd Walter Computer Technology
#define UHS_VID_ENDPOINTS 0x03e8U // EndPoints, Inc.
#define UHS_VID_THESYS_MICROELECTRONICS 0x03e9U // Thesys Microelectronics
#define UHS_VID_DATA_BROADCASTING 0x03eaU // Data Broadcasting Corp.
#define UHS_VID_ATMEL 0x03ebU // Atmel Corp.
#define UHS_VID_IWATSU_AMERICA 0x03ecU // Iwatsu America, Inc.
#define UHS_VID_MITEL 0x03edU // Mitel Corp.
#define UHS_VID_MITSUMI 0x03eeU // Mitsumi
#define UHS_VID_HEWLETT_PACKARD 0x03f0U // Hewlett-Packard
#define UHS_VID_GENOA_TECHNOLOGY 0x03f1U // Genoa Technology
#define UHS_VID_OAK_TECHNOLOGY 0x03f2U // Oak Technology, Inc.
#define UHS_VID_ADAPTEC 0x03f3U // Adaptec, Inc.
#define UHS_VID_DIEBOLD 0x03f4U // Diebold, Inc.
#define UHS_VID_SIEMENS_ELECTROMECHANICAL 0x03f5U // Siemens Electromechanical
#define UHS_VID_EPSON_IMAGING_TECHNOLOGY_CENTER 0x03f8U // Epson Imaging Technology Center
#define UHS_VID_KEYTRONIC 0x03f9U // KeyTronic Corp.
#define UHS_VID_OPTI 0x03fbU // OPTi, Inc.
#define UHS_VID_ELITEGROUP_COMPUTER_SYSTEMS 0x03fcU // Elitegroup Computer Systems
#define UHS_VID_XILINX 0x03fdU // Xilinx, Inc.
#define UHS_VID_FARALLON_COMUNICATIONS 0x03feU // Farallon Communications
#define UHS_VID_NATIONAL_SEMICONDUCTOR 0x0400U // National Semiconductor Corp.
#define UHS_VID_NATIONAL_REGISTRY 0x0401U // National Registry, Inc.
#define UHS_VID_ALI 0x0402U // ALi Corp.
#define UHS_VID_FUTURE_TECHNOLOGY_DEVICES_INTERNATIONAL 0x0403U // Future Technology Devices International, Ltd
#define UHS_VID_NCR 0x0404U // NCR Corp.
#define UHS_VID_SYNOPSYS 0x0405U // Synopsys, Inc.
#define UHS_VID_FUJITSU_ICL_COMPUTERS 0x0406U // Fujitsu-ICL Computers
#define UHS_VID_FUJITSU_PERSONAL_SYSTEMS 0x0407U // Fujitsu Personal Systems, Inc.
#define UHS_VID_QUANTA_COMPUTER 0x0408U // Quanta Computer, Inc.
#define UHS_VID_NEC 0x0409U // NEC Corp.
#define UHS_VID_KODAK 0x040aU // Kodak Co.
#define UHS_VID_WELTREND_SEMICONDUCTOR 0x040bU // Weltrend Semiconductor
#define UHS_VID_VTECH_COMPUTERS 0x040cU // VTech Computers, Ltd
#define UHS_VID_VIA_TECHNOLOGIES 0x040dU // VIA Technologies, Inc.
#define UHS_VID_MCCI 0x040eU // MCCI
#define UHS_VID_ECHO_SPEECH 0x040fU // Echo Speech Corp.
#define UHS_VID_BUFFALO_INC_FORMERLY_MELCO 0x0411U // BUFFALO INC. (formerly MelCo., Inc.)
#define UHS_VID_AWARD_SOFTWARE_INTERNATIONAL 0x0412U // Award Software International
#define UHS_VID_LEADTEK_RESEARCH 0x0413U // Leadtek Research, Inc.
#define UHS_VID_GIGA_BYTE_TECHNOLOGY 0x0414U // Giga-Byte Technology Co., Ltd
#define UHS_VID_WINBOND_ELECTRONICS 0x0416U // Winbond Electronics Corp.
#define UHS_VID_SYMBIOS_LOGIC 0x0417U // Symbios Logic
#define UHS_VID_AST_RESEARCH 0x0418U // AST Research
#define UHS_VID_SAMSUNG_INFO_SYSTEMS_AMERICA 0x0419U // Samsung Info. Systems America, Inc.
#define UHS_VID_PHOENIX_TECHNOLOGIES 0x041aU // Phoenix Technologies, Ltd
#define UHS_VID_DTV 0x041bU // d'TV
#define UHS_VID_S3 0x041dU // S3, Inc.
#define UHS_VID_CREATIVE_TECHNOLOGY 0x041eU // Creative Technology, Ltd
#define UHS_VID_LCS_TELEGRAPHICS 0x041fU // LCS Telegraphics
#define UHS_VID_CHIPS_AND_TECHNOLOGIES 0x0420U // Chips and Technologies
#define UHS_VID_NOKIA_MOBILE_PHONES 0x0421U // Nokia Mobile Phones
#define UHS_VID_ADI_SYSTEMS 0x0422U // ADI Systems, Inc.
#define UHS_VID_COMPUTER_ACCESS_TECHNOLOGY 0x0423U // Computer Access Technology Corp.
#define UHS_VID_STANDARD_MICROSYSTEMS 0x0424U // Standard Microsystems Corp.
#define UHS_VID_MOTOROLA_SEMICONDUCTORS_HK 0x0425U // Motorola Semiconductors HK, Ltd
#define UHS_VID_INTEGRATED_DEVICE_TECHNOLOGY 0x0426U // Integrated Device Technology, Inc.
#define UHS_VID_MOTOROLA_ELECTRONICS_TAIWAN 0x0427U // Motorola Electronics Taiwan, Ltd
#define UHS_VID_ADVANCED_GRAVIS_COMPUTER_TECH 0x0428U // Advanced Gravis Computer Tech, Ltd
#define UHS_VID_CIRRUS_LOGIC 0x0429U // Cirrus Logic
#define UHS_VID_ERICSSON_AUSTRIAN_AG 0x042aU // Ericsson Austrian, AG
#define UHS_VID_INTEL 0x042bU // Intel Corp.
#define UHS_VID_INNOVATIVE_SEMICONDUCTORS 0x042cU // Innovative Semiconductors, Inc.
#define UHS_VID_MICRONICS 0x042dU // Micronics
#define UHS_VID_ACER 0x042eU // Acer, Inc.
#define UHS_VID_MOLEX 0x042fU // Molex, Inc.
#define UHS_VID_SUN_MICROSYSTEMS 0x0430U // Sun Microsystems, Inc.
#define UHS_VID_ITAC_SYSTEMS 0x0431U // Itac Systems, Inc.
#define UHS_VID_UNISYS 0x0432U // Unisys Corp.
#define UHS_VID_ALPS_ELECTRIC 0x0433U // Alps Electric, Inc.
#define UHS_VID_SAMSUNG_INFO_SYSTEMS_AMERICA_1 0x0434U // Samsung Info. Systems America, Inc.
#define UHS_VID_HYUNDAI_ELECTRONICS_AMERICA 0x0435U // Hyundai Electronics America
#define UHS_VID_TAUGAGREINING_HF 0x0436U // Taugagreining HF
#define UHS_VID_FRAMATOME_CONNECTORS_USA 0x0437U // Framatome Connectors USA
#define UHS_VID_ADVANCED_MICRO_DEVICES 0x0438U // Advanced Micro Devices, Inc.
#define UHS_VID_VOICE_TECHNOLOGIES_GROUP 0x0439U // Voice Technologies Group
#define UHS_VID_LEXMARK_INTERNATIONAL 0x043dU // Lexmark International, Inc.
#define UHS_VID_LG_ELECTRONICS_USA 0x043eU // LG Electronics USA, Inc.
#define UHS_VID_RADISYS 0x043fU // RadiSys Corp.
#define UHS_VID_EIZO_NANAO 0x0440U // Eizo Nanao Corp.
#define UHS_VID_WINBOND_SYSTEMS_LAB 0x0441U // Winbond Systems Lab.
#define UHS_VID_ERICSSON 0x0442U // Ericsson, Inc.
#define UHS_VID_GATEWAY 0x0443U // Gateway, Inc.
#define UHS_VID_LUCENT_TECHNOLOGIES 0x0445U // Lucent Technologies, Inc.
#define UHS_VID_NMB_TECHNOLOGIES 0x0446U // NMB Technologies Corp.
#define UHS_VID_MOMENTUM_MICROSYSTEMS 0x0447U // Momentum Microsystems
#define UHS_VID_SHAMROCK_TECH 0x044aU // Shamrock Tech. Co., Ltd
#define UHS_VID_WSI 0x044bU // WSI
#define UHS_VID_CCLITRI 0x044cU // CCL/ITRI
#define UHS_VID_SIEMENS_NIXDORF_AG 0x044dU // Siemens Nixdorf AG
#define UHS_VID_ALPS_ELECTRIC_1 0x044eU // Alps Electric Co., Ltd
#define UHS_VID_THRUSTMASTER 0x044fU // ThrustMaster, Inc.
#define UHS_VID_DFI 0x0450U // DFI, Inc.
#define UHS_VID_TEXAS_INSTRUMENTS 0x0451U // Texas Instruments, Inc.
#define UHS_VID_MITSUBISHI_ELECTRONICS_AMERICA 0x0452U // Mitsubishi Electronics America, Inc.
#define UHS_VID_CMD_TECHNOLOGY 0x0453U // CMD Technology
#define UHS_VID_VOBIS_MICROCOMPUTER_AG 0x0454U // Vobis Microcomputer AG
#define UHS_VID_TELEMATICS_INTERNATIONAL 0x0455U // Telematics International, Inc.
#define UHS_VID_ANALOG_DEVICES 0x0456U // Analog Devices, Inc.
#define UHS_VID_SILICON_INTEGRATED_SYSTEMS 0x0457U // Silicon Integrated Systems Corp.
#define UHS_VID_KYE_SYSTEMS_CORP_MOUSE_SYSTEMS 0x0458U // KYE Systems Corp. (Mouse Systems)
#define UHS_VID_ADOBE_SYSTEMS 0x0459U // Adobe Systems, Inc.
#define UHS_VID_SONICBLUE 0x045aU // SONICblue, Inc.
#define UHS_VID_HITACHI 0x045bU // Hitachi, Ltd
#define UHS_VID_NORTEL_NETWORKS 0x045dU // Nortel Networks, Ltd
#define UHS_VID_MICROSOFT 0x045eU // Microsoft Corp.
#define UHS_VID_ACE_CAD_ENTERPRISE 0x0460U // Ace Cad Enterprise Co., Ltd
#define UHS_VID_PRIMAX_ELECTRONICS 0x0461U // Primax Electronics, Ltd
#define UHS_VID_MGE_UPS_SYSTEMS 0x0463U // MGE UPS Systems
#define UHS_VID_AMPTYCOELECTRONICS 0x0464U // AMP/Tycoelectronics Corp.
#define UHS_VID_ATANDT_PARADYNE 0x0467U // AT&T Paradyne
#define UHS_VID_WIESON_TECHNOLOGIES 0x0468U // Wieson Technologies Co., Ltd
#define UHS_VID_CHERRY 0x046aU // Cherry GmbH
#define UHS_VID_AMERICAN_MEGATRENDS 0x046bU // American Megatrends, Inc.
#define UHS_VID_TOSHIBA_CORP_DIGITAL_MEDIA_EQUIPMENT 0x046cU // Toshiba Corp., Digital Media Equipment
#define UHS_VID_LOGITECH 0x046dU // Logitech, Inc.
#define UHS_VID_BEHAVIOR_TECH_COMPUTER 0x046eU // Behavior Tech. Computer Corp.
#define UHS_VID_CRYSTAL_SEMICONDUCTOR 0x046fU // Crystal Semiconductor
#define UHS_VID_PHILIPS_OR_NXP 0x0471U // Philips (or NXP)
#define UHS_VID_CHICONY_ELECTRONICS 0x0472U // Chicony Electronics Co., Ltd
#define UHS_VID_SANYO_INFORMATION_BUSINESS 0x0473U // Sanyo Information Business Co., Ltd
#define UHS_VID_SANYO_ELECTRIC 0x0474U // Sanyo Electric Co., Ltd
#define UHS_VID_RELISYSTECO_INFORMATION_SYSTEM 0x0475U // Relisys/Teco Information System
#define UHS_VID_AESP 0x0476U // AESP
#define UHS_VID_SEAGATE_TECHNOLOGY 0x0477U // Seagate Technology, Inc.
#define UHS_VID_CONNECTIX 0x0478U // Connectix Corp.
#define UHS_VID_ADVANCED_PERIPHERAL_LABORATORIES 0x0479U // Advanced Peripheral Laboratories
#define UHS_VID_SEMTECH 0x047aU // Semtech Corp.
#define UHS_VID_SILITEK 0x047bU // Silitek Corp.
#define UHS_VID_DELL_COMPUTER 0x047cU // Dell Computer Corp.
#define UHS_VID_KENSINGTON 0x047dU // Kensington
#define UHS_VID_AGERE_SYSTEMS_INC_LUCENT 0x047eU // Agere Systems, Inc. (Lucent)
#define UHS_VID_PLANTRONICS 0x047fU // Plantronics, Inc.
#define UHS_VID_TOSHIBA_AMERICA 0x0480U // Toshiba America Inc
#define UHS_VID_ZENITH_DATA_SYSTEMS 0x0481U // Zenith Data Systems
#define UHS_VID_KYOCERA 0x0482U // Kyocera Corp.
#define UHS_VID_STMICROELECTRONICS 0x0483U // STMicroelectronics
#define UHS_VID_SPECIALIX 0x0484U // Specialix
#define UHS_VID_NOKIA_MONITORS 0x0485U // Nokia Monitors
#define UHS_VID_ASUS_COMPUTERS 0x0486U // ASUS Computers, Inc.
#define UHS_VID_STEWART_CONNECTOR 0x0487U // Stewart Connector
#define UHS_VID_CIRQUE 0x0488U // Cirque Corp.
#define UHS_VID_FOXCONN_HON_HAI 0x0489U // Foxconn / Hon Hai
#define UHS_VID_S_MOS_SYSTEMS 0x048aU // S-MOS Systems, Inc.
#define UHS_VID_ALPS_ELECTRIC_IRELAND 0x048cU // Alps Electric Ireland, Ltd
#define UHS_VID_INTEGRATED_TECHNOLOGY_EXPRESS 0x048dU // Integrated Technology Express, Inc.
#define UHS_VID_EICON_TECH 0x048fU // Eicon Tech.
#define UHS_VID_UNITED_MICROELECTRONICS 0x0490U // United Microelectronics Corp.
#define UHS_VID_CAPETRONIC 0x0491U // Capetronic
#define UHS_VID_SAMSUNG_SEMICONDUCTOR 0x0492U // Samsung SemiConductor, Inc.
#define UHS_VID_MAG_TECHNOLOGY 0x0493U // MAG Technology Co., Ltd
#define UHS_VID_ESS_TECHNOLOGY 0x0495U // ESS Technology, Inc.
#define UHS_VID_MICRON_ELECTRONICS 0x0496U // Micron Electronics
#define UHS_VID_SMILE_INTERNATIONAL 0x0497U // Smile International
#define UHS_VID_CAPETRONIC_KAOHSIUNG 0x0498U // Capetronic (Kaohsiung) Corp.
#define UHS_VID_YAMAHA 0x0499U // Yamaha Corp.
#define UHS_VID_GANDALF_TECHNOLOGIES 0x049aU // Gandalf Technologies, Ltd
#define UHS_VID_CURTIS_COMPUTER_PRODUCTS 0x049bU // Curtis Computer Products
#define UHS_VID_ACER_ADVANCED_LABS 0x049cU // Acer Advanced Labs, Inc.
#define UHS_VID_VLSI_TECHNOLOGY 0x049dU // VLSI Technology
#define UHS_VID_COMPAQ_COMPUTER 0x049fU // Compaq Computer Corp.
#define UHS_VID_DIGITAL_EQUIPMENT 0x04a0U // Digital Equipment Corp.
#define UHS_VID_SYSTEMSOFT 0x04a1U // SystemSoft Corp.
#define UHS_VID_FIREPOWER_SYSTEMS 0x04a2U // FirePower Systems
#define UHS_VID_TRIDENT_MICROSYSTEMS 0x04a3U // Trident Microsystems, Inc.
#define UHS_VID_HITACHI_1 0x04a4U // Hitachi, Ltd
#define UHS_VID_ACER_PERIPHERALS_INC_NOW_BENQ 0x04a5U // Acer Peripherals Inc. (now BenQ Corp.)
#define UHS_VID_NOKIA_DISPLAY_PRODUCTS 0x04a6U // Nokia Display Products
#define UHS_VID_VISIONEER 0x04a7U // Visioneer
#define UHS_VID_MULTIVIDEO_LABS 0x04a8U // Multivideo Labs, Inc.
#define UHS_VID_CANON 0x04a9U // Canon, Inc.
#define UHS_VID_DAEWOO_TELECOM 0x04aaU // DaeWoo Telecom, Ltd
#define UHS_VID_CHROMATIC_RESEARCH 0x04abU // Chromatic Research
#define UHS_VID_MICRO_AUDIOMETRICS 0x04acU // Micro Audiometrics Corp.
#define UHS_VID_DOOIN_ELECTRONICS 0x04adU // Dooin Electronics
#define UHS_VID_WINNOV_LP 0x04afU // Winnov L.P.
#define UHS_VID_NIKON 0x04b0U // Nikon Corp.
#define UHS_VID_PAN_INTERNATIONAL 0x04b1U // Pan International
#define UHS_VID_IBM 0x04b3U // IBM Corp.
#define UHS_VID_CYPRESS_SEMICONDUCTOR 0x04b4U // Cypress Semiconductor Corp.
#define UHS_VID_ROHM_LSI_SYSTEMS_USA 0x04b5U // ROHM LSI Systems USA, LLC
#define UHS_VID_HINT 0x04b6U // Hint Corp.
#define UHS_VID_COMPAL_ELECTRONICS 0x04b7U // Compal Electronics, Inc.
#define UHS_VID_SEIKO_EPSON 0x04b8U // Seiko Epson Corp.
#define UHS_VID_RAINBOW_TECHNOLOGIES 0x04b9U // Rainbow Technologies, Inc.
#define UHS_VID_TOUCAN_SYSTEMS 0x04baU // Toucan Systems, Ltd
#define UHS_VID_I_O_DATA_DEVICE 0x04bbU // I-O Data Device, Inc.
#define UHS_VID_TOSHIBA_ELECTRONICS_TAIWAN 0x04bdU // Toshiba Electronics Taiwan Corp.
#define UHS_VID_TELIA_RESEARCH 0x04beU // Telia Research AB
#define UHS_VID_TDK 0x04bfU // TDK Corp.
#define UHS_VID_US_ROBOTICS_3COM 0x04c1U // U.S. Robotics (3Com)
#define UHS_VID_METHODE_ELECTRONICS_FAR_EAST_PTE 0x04c2U // Methode Electronics Far East PTE, Ltd
#define UHS_VID_MAXI_SWITCH 0x04c3U // Maxi Switch, Inc.
#define UHS_VID_LOCKHEED_MARTIN_ENERGY_RESEARCH 0x04c4U // Lockheed Martin Energy Research
#define UHS_VID_FUJITSU 0x04c5U // Fujitsu, Ltd
#define UHS_VID_TOSHIBA_AMERICA_ELECTRONIC_COMPONENTS 0x04c6U // Toshiba America Electronic Components
#define UHS_VID_MICRO_MACRO_TECHNOLOGIES 0x04c7U // Micro Macro Technologies
#define UHS_VID_KONICA 0x04c8U // Konica Corp.
#define UHS_VID_LITE_ON_TECHNOLOGY 0x04caU // Lite-On Technology Corp.
#define UHS_VID_FUJI_PHOTO_FILM 0x04cbU // Fuji Photo Film Co., Ltd
#define UHS_VID_ST_ERICSSON 0x04ccU // ST-Ericsson
#define UHS_VID_TATUNG_CO_OF_AMERICA 0x04cdU // Tatung Co. Of America
#define UHS_VID_SCANLOGIC 0x04ceU // ScanLogic Corp.
#define UHS_VID_MYSON_CENTURY 0x04cfU // Myson Century, Inc.
#define UHS_VID_DIGI_INTERNATIONAL 0x04d0U // Digi International
#define UHS_VID_ITT_CANON 0x04d1U // ITT Canon
#define UHS_VID_ALTEC_LANSING_TECHNOLOGIES 0x04d2U // Altec Lansing Technologies
#define UHS_VID_VIDUS 0x04d3U // VidUS, Inc.
#define UHS_VID_LSI_LOGIC 0x04d4U // LSI Logic, Inc.
#define UHS_VID_FORTE_TECHNOLOGIES 0x04d5U // Forte Technologies, Inc.
#define UHS_VID_MENTOR_GRAPHICS 0x04d6U // Mentor Graphics
#define UHS_VID_OKI_SEMICONDUCTOR 0x04d7U // Oki Semiconductor
#define UHS_VID_MICROCHIP_TECHNOLOGY 0x04d8U // Microchip Technology, Inc.
#define UHS_VID_HOLTEK_SEMICONDUCTOR 0x04d9U // Holtek Semiconductor, Inc.
#define UHS_VID_PANASONIC_MATSUSHITA 0x04daU // Panasonic (Matsushita)
#define UHS_VID_HYPERTEC_PTY 0x04dbU // Hypertec Pty, Ltd
#define UHS_VID_HUAN_HSIN_HOLDINGS 0x04dcU // Huan Hsin Holdings, Ltd
#define UHS_VID_SHARP 0x04ddU // Sharp Corp.
#define UHS_VID_MINDSHARE 0x04deU // MindShare, Inc.
#define UHS_VID_INTERLINK_ELECTRONICS 0x04dfU // Interlink Electronics
#define UHS_VID_IIYAMA_NORTH_AMERICA 0x04e1U // Iiyama North America, Inc.
#define UHS_VID_EXAR 0x04e2U // Exar Corp.
#define UHS_VID_ZILOG 0x04e3U // Zilog, Inc.
#define UHS_VID_ACC_MICROELECTRONICS 0x04e4U // ACC Microelectronics
#define UHS_VID_PROMISE_TECHNOLOGY 0x04e5U // Promise Technology
#define UHS_VID_SCM_MICROSYSTEMS 0x04e6U // SCM Microsystems, Inc.
#define UHS_VID_ELO_TOUCHSYSTEMS 0x04e7U // Elo TouchSystems
#define UHS_VID_SAMSUNG_ELECTRONICS 0x04e8U // Samsung Electronics Co., Ltd
#define UHS_VID_PC_TEL 0x04e9U // PC-Tel, Inc.
#define UHS_VID_BROOKTREE 0x04eaU // Brooktree Corp.
#define UHS_VID_NORTHSTAR_SYSTEMS 0x04ebU // Northstar Systems, Inc.
#define UHS_VID_TOKYO_ELECTRON_DEVICE 0x04ecU // Tokyo Electron Device, Ltd
#define UHS_VID_ANNABOOKS 0x04edU // Annabooks
#define UHS_VID_PACIFIC_ELECTRONIC_INTERNATIONAL 0x04efU // Pacific Electronic International, Inc.
#define UHS_VID_DAEWOO_ELECTRONICS 0x04f0U // Daewoo Electronics Co., Ltd
#define UHS_VID_VICTOR_COMPANY_OF_JAPAN 0x04f1U // Victor Company of Japan, Ltd
#define UHS_VID_CHICONY_ELECTRONICS_1 0x04f2U // Chicony Electronics Co., Ltd
#define UHS_VID_ELAN_MICROELECTRONICS 0x04f3U // Elan Microelectronics Corp.
#define UHS_VID_HARTING_ELEKTRONIK 0x04f4U // Harting Elektronik, Inc.
#define UHS_VID_FUJITSU_ICL_SYSTEMS 0x04f5U // Fujitsu-ICL Systems, Inc.
#define UHS_VID_NORAND 0x04f6U // Norand Corp.
#define UHS_VID_NEWNEX_TECHNOLOGY 0x04f7U // Newnex Technology Corp.
#define UHS_VID_FUTUREPLUS_SYSTEMS 0x04f8U // FuturePlus Systems
#define UHS_VID_BROTHER_INDUSTRIES 0x04f9U // Brother Industries, Ltd
#define UHS_VID_DALLAS_SEMICONDUCTOR 0x04faU // Dallas Semiconductor
#define UHS_VID_BIOSTAR_MICROTECH_INTERNATIONAL 0x04fbU // Biostar Microtech International Corp.
#define UHS_VID_SUNPLUS_TECHNOLOGY 0x04fcU // Sunplus Technology Co., Ltd
#define UHS_VID_SOLITON_SYSTEMS_KK 0x04fdU // Soliton Systems, K.K.
#define UHS_VID_PFU 0x04feU // PFU, Ltd
#define UHS_VID_E_CMOS 0x04ffU // E-CMOS Corp.
#define UHS_VID_SIAM_UNITED_HI_TECH 0x0500U // Siam United Hi-Tech
#define UHS_VID_FUJIKURA_DDK 0x0501U // Fujikura DDK, Ltd
#define UHS_VID_ACER_1 0x0502U // Acer, Inc.
#define UHS_VID_HITACHI_AMERICA 0x0503U // Hitachi America, Ltd
#define UHS_VID_HAYES_MICROCOMPUTER_PRODUCTS 0x0504U // Hayes Microcomputer Products
#define UHS_VID_3COM 0x0506U // 3Com Corp.
#define UHS_VID_HOSIDEN 0x0507U // Hosiden Corp.
#define UHS_VID_CLARION 0x0508U // Clarion Co., Ltd
#define UHS_VID_AZTECH_SYSTEMS 0x0509U // Aztech Systems, Ltd
#define UHS_VID_CINCH_CONNECTORS 0x050aU // Cinch Connectors
#define UHS_VID_CABLE_SYSTEM_INTERNATIONAL 0x050bU // Cable System International
#define UHS_VID_INNOMEDIA 0x050cU // InnoMedia, Inc.
#define UHS_VID_BELKIN_COMPONENTS 0x050dU // Belkin Components
#define UHS_VID_NEON_TECHNOLOGY 0x050eU // Neon Technology, Inc.
#define UHS_VID_KC_TECHNOLOGY 0x050fU // KC Technology, Inc.
#define UHS_VID_SEJIN_ELECTRON 0x0510U // Sejin Electron, Inc.
#define UHS_VID_NABLE_DATABOOK_TECHNOLOGIES 0x0511U // N'Able (DataBook) Technologies, Inc.
#define UHS_VID_HUALON_MICROELECTRONICS 0x0512U // Hualon Microelectronics Corp.
#define UHS_VID_DIGITAL_X 0x0513U // digital-X, Inc.
#define UHS_VID_FCI_ELECTRONICS 0x0514U // FCI Electronics
#define UHS_VID_ACTC 0x0515U // ACTC
#define UHS_VID_LONGWELL_ELECTRONICS 0x0516U // Longwell Electronics
#define UHS_VID_BUTTERFLY_COMMUNICATIONS 0x0517U // Butterfly Communications
#define UHS_VID_EZKEY 0x0518U // EzKEY Corp.
#define UHS_VID_STAR_MICRONICS 0x0519U // Star Micronics Co., Ltd
#define UHS_VID_WYSE_TECHNOLOGY 0x051aU // WYSE Technology
#define UHS_VID_SILICON_GRAPHICS 0x051bU // Silicon Graphics
#define UHS_VID_SHUTTLE 0x051cU // Shuttle, Inc.
#define UHS_VID_AMERICAN_POWER_CONVERSION 0x051dU // American Power Conversion
#define UHS_VID_SCIENTIFIC_ATLANTA 0x051eU // Scientific Atlanta, Inc.
#define UHS_VID_IO_SYSTEMS_ELITE_ELECTRONICS 0x051fU // IO Systems (Elite Electronics), Inc.
#define UHS_VID_TAIWAN_SEMICONDUCTOR_MANUFACTURING 0x0520U // Taiwan Semiconductor Manufacturing Co.
#define UHS_VID_AIRBORN_CONNECTORS 0x0521U // Airborn Connectors
#define UHS_VID_ADVANCED_CONNECTEK 0x0522U // Advanced Connectek, Inc.
#define UHS_VID_ATEN 0x0523U // ATEN GmbH
#define UHS_VID_SOLA_ELECTRONICS 0x0524U // Sola Electronics
#define UHS_VID_NETCHIP_TECHNOLOGY 0x0525U // Netchip Technology, Inc.
#define UHS_VID_TEMIC_MHS 0x0526U // Temic MHS S.A.
#define UHS_VID_ALTRA 0x0527U // ALTRA
#define UHS_VID_ATI_TECHNOLOGIES 0x0528U // ATI Technologies, Inc.
#define UHS_VID_ALADDIN_KNOWLEDGE_SYSTEMS 0x0529U // Aladdin Knowledge Systems
#define UHS_VID_CRESCENT_HEART_SOFTWARE 0x052aU // Crescent Heart Software
#define UHS_VID_TEKOM_TECHNOLOGIES 0x052bU // Tekom Technologies, Inc.
#define UHS_VID_CANON_INFORMATION_SYSTEMS 0x052cU // Canon Information Systems, Inc.
#define UHS_VID_AVID_ELECTRONICS 0x052dU // Avid Electronics Corp.
#define UHS_VID_STANDARD_MICROSYSTEMS_1 0x052eU // Standard Microsystems Corp.
#define UHS_VID_UNICORE_SOFTWARE 0x052fU // Unicore Software, Inc.
#define UHS_VID_AMERICAN_MICROSYSTEMS 0x0530U // American Microsystems, Inc.
#define UHS_VID_WACOM_TECHNOLOGY 0x0531U // Wacom Technology Corp.
#define UHS_VID_SYSTECH 0x0532U // Systech Corp.
#define UHS_VID_ALCATEL_MOBILE_PHONES 0x0533U // Alcatel Mobile Phones
#define UHS_VID_MOTOROLA 0x0534U // Motorola, Inc.
#define UHS_VID_LIH_TZU_ELECTRIC 0x0535U // LIH TZU Electric Co., Ltd
#define UHS_VID_HAND_HELD_PRODUCTS_WELCH_ALLYN 0x0536U // Hand Held Products (Welch Allyn, Inc.)
#define UHS_VID_INVENTEC 0x0537U // Inventec Corp.
#define UHS_VID_CALDERA_INTERNATIONAL_INC_SCO 0x0538U // Caldera International, Inc. (SCO)
#define UHS_VID_SHYH_SHIUN_TERMINALS 0x0539U // Shyh Shiun Terminals Co., Ltd
#define UHS_VID_PREHKEYTEC 0x053aU // PrehKeyTec GmbH
#define UHS_VID_GLOBAL_VILLAGE_COMMUNICATION 0x053bU // Global Village Communication
#define UHS_VID_INSTITUT_OF_MICROELECTRONIC_AND_MECHATRONIC_SYSTEMS 0x053cU // Institut of Microelectronic & Mechatronic Systems
#define UHS_VID_SILICON_ARCHITECT 0x053dU // Silicon Architect
#define UHS_VID_MOBILITY_ELECTRONICS 0x053eU // Mobility Electronics
#define UHS_VID_SYNOPSYS_1 0x053fU // Synopsys, Inc.
#define UHS_VID_UNIACCESS 0x0540U // UniAccess AB
#define UHS_VID_SIRF_TECHNOLOGY 0x0541U // Sirf Technology, Inc.
#define UHS_VID_VIEWSONIC 0x0543U // ViewSonic Corp.
#define UHS_VID_CRISTIE_ELECTRONICS 0x0544U // Cristie Electronics, Ltd
#define UHS_VID_XIRLINK 0x0545U // Xirlink, Inc.
#define UHS_VID_POLAROID 0x0546U // Polaroid Corp.
#define UHS_VID_ANCHOR_CHIPS 0x0547U // Anchor Chips, Inc.
#define UHS_VID_TYAN_COMPUTER 0x0548U // Tyan Computer Corp.
#define UHS_VID_PIXERA 0x0549U // Pixera Corp.
#define UHS_VID_FUJITSU_MICROELECTRONICS 0x054aU // Fujitsu Microelectronics, Inc.
#define UHS_VID_NEW_MEDIA 0x054bU // New Media Corp.
#define UHS_VID_SONY 0x054cU // Sony Corp.
#define UHS_VID_TRY 0x054dU // Try Corp.
#define UHS_VID_PROSIDE 0x054eU // Proside Corp.
#define UHS_VID_WYSE_TECHNOLOGY_TAIWAN 0x054fU // WYSE Technology Taiwan
#define UHS_VID_FUJI_XEROX 0x0550U // Fuji Xerox Co., Ltd
#define UHS_VID_COMPUTREND_SYSTEMS 0x0551U // CompuTrend Systems, Inc.
#define UHS_VID_PHILIPS_MONITORS 0x0552U // Philips Monitors
#define UHS_VID_STMICROELECTRONICS_IMAGING_DIVISION_VLSI_VISION 0x0553U // STMicroelectronics Imaging Division (VLSI Vision)
#define UHS_VID_DICTAPHONE 0x0554U // Dictaphone Corp.
#define UHS_VID_ANAM_SANDT 0x0555U // ANAM S&T Co., Ltd
#define UHS_VID_ASAHI_KASEI_MICROSYSTEMS 0x0556U // Asahi Kasei Microsystems Co., Ltd
#define UHS_VID_ATEN_INTERNATIONAL 0x0557U // ATEN International Co., Ltd
#define UHS_VID_TRUEVISION 0x0558U // Truevision, Inc.
#define UHS_VID_CADENCE_DESIGN_SYSTEMS 0x0559U // Cadence Design Systems, Inc.
#define UHS_VID_KENWOOD_USA 0x055aU // Kenwood USA
#define UHS_VID_KNOWLEDGETEK 0x055bU // KnowledgeTek, Inc.
#define UHS_VID_PROTON_ELECTRONIC_IND 0x055cU // Proton Electronic Ind.
#define UHS_VID_SAMSUNG_ELECTRO_MECHANICS 0x055dU // Samsung Electro-Mechanics Co.
#define UHS_VID_CTX_OPTO_ELECTRONICS 0x055eU // CTX Opto-Electronics Corp.
#define UHS_VID_MUSTEK_SYSTEMS 0x055fU // Mustek Systems, Inc.
#define UHS_VID_INTERFACE 0x0560U // Interface Corp.
#define UHS_VID_OASIS_DESIGN 0x0561U // Oasis Design, Inc.
#define UHS_VID_TELEX_COMMUNICATIONS 0x0562U // Telex Communications, Inc.
#define UHS_VID_IMMERSION 0x0563U // Immersion Corp.
#define UHS_VID_KODAK_DIGITAL_PRODUCT_CENTER_JAPAN_LTD_FORMERLY_CHINON_INDUSTRIES 0x0564U // Kodak Digital Product Center, Japan Ltd. (formerly Chinon Industries Inc.)
#define UHS_VID_PERACOM_NETWORKS 0x0565U // Peracom Networks, Inc.
#define UHS_VID_MONTEREY_INTERNATIONAL 0x0566U // Monterey International Corp.
#define UHS_VID_XYRATEX_INTERNATIONAL 0x0567U // Xyratex International, Ltd
#define UHS_VID_QUARTZ_INGENIERIE 0x0568U // Quartz Ingenierie
#define UHS_VID_SEGASOFT 0x0569U // SegaSoft
#define UHS_VID_WACOM 0x056aU // Wacom Co., Ltd
#define UHS_VID_DECICON 0x056bU // Decicon, Inc.
#define UHS_VID_ETEK_LABS 0x056cU // eTEK Labs
#define UHS_VID_EIZO 0x056dU // EIZO Corp.
#define UHS_VID_ELECOM 0x056eU // Elecom Co., Ltd
#define UHS_VID_KOREA_DATA_SYSTEMS 0x056fU // Korea Data Systems Co., Ltd
#define UHS_VID_EPSON_AMERICA 0x0570U // Epson America
#define UHS_VID_INTEREX 0x0571U // Interex, Inc.
#define UHS_VID_CONEXANT_SYSTEMS_ROCKWELL 0x0572U // Conexant Systems (Rockwell), Inc.
#define UHS_VID_ZORAN_CO_PERSONAL_MEDIA_DIVISION_NOGATECH 0x0573U // Zoran Co. Personal Media Division (Nogatech)
#define UHS_VID_CITY_UNIVERSITY_OF_HONG_KONG 0x0574U // City University of Hong Kong
#define UHS_VID_PHILIPS_CREATIVE_DISPLAY_SOLUTIONS 0x0575U // Philips Creative Display Solutions
#define UHS_VID_BAFOQUALITY_COMPUTER_ACCESSORIES 0x0576U // BAFO/Quality Computer Accessories
#define UHS_VID_ELSA 0x0577U // ELSA
#define UHS_VID_INTRINSIX 0x0578U // Intrinsix Corp.
#define UHS_VID_GVC 0x0579U // GVC Corp.
#define UHS_VID_SAMSUNG_ELECTRONICS_AMERICA 0x057aU // Samsung Electronics America
#define UHS_VID_Y_E_DATA 0x057bU // Y-E Data, Inc.
#define UHS_VID_AVM 0x057cU // AVM GmbH
#define UHS_VID_SHARK_MULTIMEDIA 0x057dU // Shark Multimedia, Inc.
#define UHS_VID_NINTENDO 0x057eU // Nintendo Co., Ltd
#define UHS_VID_QUICKSHOT 0x057fU // QuickShot, Ltd
#define UHS_VID_DENRON 0x0580U // Denron, Inc.
#define UHS_VID_RACAL_DATA_GROUP 0x0581U // Racal Data Group
#define UHS_VID_ROLAND 0x0582U // Roland Corp.
#define UHS_VID_PADIX_CO_LTD_ROCKFIRE 0x0583U // Padix Co., Ltd (Rockfire)
#define UHS_VID_RATOC_SYSTEM 0x0584U // RATOC System, Inc.
#define UHS_VID_FLASHPOINT_TECHNOLOGY 0x0585U // FlashPoint Technology, Inc.
#define UHS_VID_ZYXEL_COMMUNICATIONS 0x0586U // ZyXEL Communications Corp.
#define UHS_VID_AMERICA_KOTOBUKI_ELECTRONICS_INDUSTRIES 0x0587U // America Kotobuki Electronics Industries, Inc.
#define UHS_VID_SAPIEN_DESIGN 0x0588U // Sapien Design
#define UHS_VID_VICTRON 0x0589U // Victron
#define UHS_VID_NOHAU 0x058aU // Nohau Corp.
#define UHS_VID_INFINEON_TECHNOLOGIES 0x058bU // Infineon Technologies
#define UHS_VID_IN_FOCUS_SYSTEMS 0x058cU // In Focus Systems
#define UHS_VID_MICREL_SEMICONDUCTOR 0x058dU // Micrel Semiconductor
#define UHS_VID_TRIPATH_TECHNOLOGY 0x058eU // Tripath Technology, Inc.
#define UHS_VID_ALCOR_MICRO 0x058fU // Alcor Micro Corp.
#define UHS_VID_OMRON 0x0590U // Omron Corp.
#define UHS_VID_QUESTRA_CONSULTING 0x0591U // Questra Consulting
#define UHS_VID_POWERWARE 0x0592U // Powerware Corp.
#define UHS_VID_INCITE 0x0593U // Incite
#define UHS_VID_PRINCETON_GRAPHIC_SYSTEMS 0x0594U // Princeton Graphic Systems
#define UHS_VID_ZORAN_MICROELECTRONICS 0x0595U // Zoran Microelectronics, Ltd
#define UHS_VID_MICROTOUCH_SYSTEMS 0x0596U // MicroTouch Systems, Inc.
#define UHS_VID_TRISIGNAL_COMMUNICATIONS 0x0597U // Trisignal Communications
#define UHS_VID_NIIGATA_CANOTEC 0x0598U // Niigata Canotec Co., Inc.
#define UHS_VID_BRILLIANCE_SEMICONDUCTOR 0x0599U // Brilliance Semiconductor, Inc.
#define UHS_VID_SPECTRUM_SIGNAL_PROCESSING 0x059aU // Spectrum Signal Processing, Inc.
#define UHS_VID_IOMEGA 0x059bU // Iomega Corp.
#define UHS_VID_A_TREND_TECHNOLOGY 0x059cU // A-Trend Technology Co., Ltd
#define UHS_VID_ADVANCED_INPUT_DEVICES 0x059dU // Advanced Input Devices
#define UHS_VID_INTELLIGENT_INSTRUMENTATION 0x059eU // Intelligent Instrumentation
#define UHS_VID_LACIE 0x059fU // LaCie, Ltd
#define UHS_VID_VETRONIX 0x05a0U // Vetronix Corp.
#define UHS_VID_USC 0x05a1U // USC Corp.
#define UHS_VID_FUJI_FILM_MICRODEVICES 0x05a2U // Fuji Film Microdevices Co., Ltd
#define UHS_VID_ARC_INTERNATIONAL 0x05a3U // ARC International
#define UHS_VID_ORTEK_TECHNOLOGY 0x05a4U // Ortek Technology, Inc.
#define UHS_VID_SAMPO_TECHNOLOGY 0x05a5U // Sampo Technology Corp.
#define UHS_VID_CISCO_SYSTEMS 0x05a6U // Cisco Systems, Inc.
#define UHS_VID_BOSE 0x05a7U // Bose Corp.
#define UHS_VID_SPACETEC_IMC 0x05a8U // Spacetec IMC Corp.
#define UHS_VID_OMNIVISION_TECHNOLOGIES 0x05a9U // OmniVision Technologies, Inc.
#define UHS_VID_UTILUX_SOUTH_CHINA 0x05aaU // Utilux South China, Ltd
#define UHS_VID_IN_SYSTEM_DESIGN 0x05abU // In-System Design
#define UHS_VID_APPLE 0x05acU // Apple, Inc.
#define UHS_VID_YC_CABLE_USA 0x05adU // Y.C. Cable U.S.A., Inc.
#define UHS_VID_SYNOPSYS_2 0x05aeU // Synopsys, Inc.
#define UHS_VID_JING_MOLD_ENTERPRISE 0x05afU // Jing-Mold Enterprise Co., Ltd
#define UHS_VID_FOUNTAIN_TECHNOLOGIES 0x05b0U // Fountain Technologies, Inc.
#define UHS_VID_FIRST_INTERNATIONAL_COMPUTER 0x05b1U // First International Computer, Inc.
#define UHS_VID_LG_SEMICON 0x05b4U // LG Semicon Co., Ltd
#define UHS_VID_DIALOGIC 0x05b5U // Dialogic Corp.
#define UHS_VID_PROXIMA 0x05b6U // Proxima Corp.
#define UHS_VID_MEDIANIX_SEMICONDUCTOR 0x05b7U // Medianix Semiconductor, Inc.
#define UHS_VID_AGILER 0x05b8U // Agiler, Inc.
#define UHS_VID_PHILIPS_RESEARCH_LABORATORIES 0x05b9U // Philips Research Laboratories
#define UHS_VID_DIGITALPERSONA 0x05baU // DigitalPersona, Inc.
#define UHS_VID_GREY_CELL_SYSTEMS 0x05bbU // Grey Cell Systems
#define UHS_VID_3G_GREEN_GREEN_GLOBE 0x05bcU // 3G Green Green Globe Co., Ltd
#define UHS_VID_RAFI_GMBH_AND_CO_KG 0x05bdU // RAFI GmbH & Co. KG
#define UHS_VID_TYCO_ELECTRONICS_RAYCHEM 0x05beU // Tyco Electronics (Raychem)
#define UHS_VID_S_AND_S_RESEARCH 0x05bfU // S & S Research
#define UHS_VID_KEIL_SOFTWARE 0x05c0U // Keil Software
#define UHS_VID_KAWASAKI_MICROELECTRONICS 0x05c1U // Kawasaki Microelectronics, Inc.
#define UHS_VID_MEDIA_PHONICS_SUISSE 0x05c2U // Media Phonics (Suisse) S.A.
#define UHS_VID_DIGI_INTERNATIONAL_1 0x05c5U // Digi International, Inc.
#define UHS_VID_QUALCOMM 0x05c6U // Qualcomm, Inc.
#define UHS_VID_QTRONIX 0x05c7U // Qtronix Corp.
#define UHS_VID_CHENG_UEI_PRECISION_INDUSTRY_CO_LTD_FOXLINK 0x05c8U // Cheng Uei Precision Industry Co., Ltd (Foxlink)
#define UHS_VID_SEMTECH_1 0x05c9U // Semtech Corp.
#define UHS_VID_RICOH 0x05caU // Ricoh Co., Ltd
#define UHS_VID_POWERVISION_TECHNOLOGIES 0x05cbU // PowerVision Technologies, Inc.
#define UHS_VID_ELSA_AG 0x05ccU // ELSA AG
#define UHS_VID_SILICOM 0x05cdU // Silicom, Ltd
#define UHS_VID_SCI_WORX 0x05ceU // sci-worx GmbH
#define UHS_VID_SUNG_FORN 0x05cfU // Sung Forn Co., Ltd
#define UHS_VID_GE_MEDICAL_SYSTEMS_LUNAR 0x05d0U // GE Medical Systems Lunar
#define UHS_VID_BRAINBOXES 0x05d1U // Brainboxes, Ltd
#define UHS_VID_WAVE_SYSTEMS 0x05d2U // Wave Systems Corp.
#define UHS_VID_TOHOKU_RICOH 0x05d3U // Tohoku Ricoh Co., Ltd
#define UHS_VID_SUPER_GATE_TECHNOLOGY 0x05d5U // Super Gate Technology Co., Ltd
#define UHS_VID_PHILIPS_SEMICONDUCTORS_CICT 0x05d6U // Philips Semiconductors, CICT
#define UHS_VID_THOMAS_AND_BETTS 0x05d7U // Thomas & Betts Corp.
#define UHS_VID_ULTIMA_ELECTRONICS 0x05d8U // Ultima Electronics Corp.
#define UHS_VID_AXIOHM_TRANSACTION_SOLUTIONS 0x05d9U // Axiohm Transaction Solutions
#define UHS_VID_MICROTEK_INTERNATIONAL 0x05daU // Microtek International, Inc.
#define UHS_VID_SUN_CORP_SUNTAC_UNKNOWN 0x05dbU // Sun Corp. (Suntac?)
#define UHS_VID_LEXAR_MEDIA 0x05dcU // Lexar Media, Inc.
#define UHS_VID_DELTA_ELECTRONICS 0x05ddU // Delta Electronics, Inc.
#define UHS_VID_SILICON_VISION 0x05dfU // Silicon Vision, Inc.
#define UHS_VID_SYMBOL_TECHNOLOGIES 0x05e0U // Symbol Technologies
#define UHS_VID_SYNTEK_SEMICONDUCTOR 0x05e1U // Syntek Semiconductor Co., Ltd
#define UHS_VID_ELECVISION 0x05e2U // ElecVision, Inc.
#define UHS_VID_GENESYS_LOGIC 0x05e3U // Genesys Logic, Inc.
#define UHS_VID_RED_WING 0x05e4U // Red Wing Corp.
#define UHS_VID_FUJI_ELECTRIC 0x05e5U // Fuji Electric Co., Ltd
#define UHS_VID_KEITHLEY_INSTRUMENTS 0x05e6U // Keithley Instruments
#define UHS_VID_ICC 0x05e8U // ICC, Inc.
#define UHS_VID_KAWASAKI_LSI 0x05e9U // Kawasaki LSI
#define UHS_VID_FFC 0x05ebU // FFC, Ltd
#define UHS_VID_COM21 0x05ecU // COM21, Inc.
#define UHS_VID_CYTECHINFO 0x05eeU // Cytechinfo Inc.
#define UHS_VID_AVB_INC_ANKO_UNKNOWN_ 0x05efU // AVB, Inc. [anko?]
#define UHS_VID_CANOPUS 0x05f0U // Canopus Co., Ltd
#define UHS_VID_COMPASS_COMMUNICATIONS 0x05f1U // Compass Communications
#define UHS_VID_DEXIN 0x05f2U // Dexin Corp., Ltd
#define UHS_VID_PI_ENGINEERING 0x05f3U // PI Engineering, Inc.
#define UHS_VID_UNIXTAR_TECHNOLOGY 0x05f5U // Unixtar Technology, Inc.
#define UHS_VID_AOC_INTERNATIONAL 0x05f6U // AOC International
#define UHS_VID_RFC_DISTRIBUTIONS_PTE 0x05f7U // RFC Distribution(s) PTE, Ltd
#define UHS_VID_PSC_SCANNING 0x05f9U // PSC Scanning, Inc.
#define UHS_VID_SIEMENS_TELECOMMUNICATIONS_SYSTEMS 0x05faU // Siemens Telecommunications Systems, Ltd
#define UHS_VID_HARMAN 0x05fcU // Harman
#define UHS_VID_INTERACT 0x05fdU // InterAct, Inc.
#define UHS_VID_CHIC_TECHNOLOGY 0x05feU // Chic Technology Corp.
#define UHS_VID_LECROY 0x05ffU // LeCroy Corp.
#define UHS_VID_BARCO_DISPLAY_SYSTEMS 0x0600U // Barco Display Systems
#define UHS_VID_JAZZ_HIPSTER 0x0601U // Jazz Hipster Corp.
#define UHS_VID_VISTA_IMAGING 0x0602U // Vista Imaging, Inc.
#define UHS_VID_NOVATEK_MICROELECTRONICS 0x0603U // Novatek Microelectronics Corp.
#define UHS_VID_JEAN 0x0604U // Jean Co., Ltd
#define UHS_VID_ANCHOR_CANDC 0x0605U // Anchor C&C Co., Ltd
#define UHS_VID_ROYAL_INFORMATION_ELECTRONICS 0x0606U // Royal Information Electronics Co., Ltd
#define UHS_VID_BRIDGE_INFORMATION 0x0607U // Bridge Information Co., Ltd
#define UHS_VID_GENRAD_ADS 0x0608U // Genrad Ads
#define UHS_VID_SMK_MANUFACTURING 0x0609U // SMK Manufacturing, Inc.
#define UHS_VID_WORTHINGTON_DATA_SOLUTIONS 0x060aU // Worthington Data Solutions, Inc.
#define UHS_VID_SOLID_YEAR 0x060bU // Solid Year
#define UHS_VID_EEH_DATALINK 0x060cU // EEH Datalink GmbH
#define UHS_VID_AUCTOR 0x060dU // Auctor Corp.
#define UHS_VID_TRANSMONDE_TECHNOLOGIES 0x060eU // Transmonde Technologies, Inc.
#define UHS_VID_JOINSOON_ELECTRONICS_MFG 0x060fU // Joinsoon Electronics Mfg. Co., Ltd
#define UHS_VID_COSTAR_ELECTRONICS 0x0610U // Costar Electronics, Inc.
#define UHS_VID_TOTOKU_ELECTRIC 0x0611U // Totoku Electric Co., Ltd
#define UHS_VID_TRANSACT_TECHNOLOGIES 0x0613U // TransAct Technologies, Inc.
#define UHS_VID_BIO_RAD_LABORATORIES 0x0614U // Bio-Rad Laboratories
#define UHS_VID_QUABBIN_WIRE_AND_CABLE 0x0615U // Quabbin Wire & Cable Co., Inc.
#define UHS_VID_FUTURE_TECHNO_DESIGNS_PVT 0x0616U // Future Techno Designs PVT, Ltd
#define UHS_VID_SWISS_FEDERAL_INSITUTE_OF_TECHNOLOGY 0x0617U // Swiss Federal Insitute of Technology
#define UHS_VID_MACALLY 0x0618U // MacAlly
#define UHS_VID_SEIKO_INSTRUMENTS 0x0619U // Seiko Instruments, Inc.
#define UHS_VID_VERIDICOM_INTERNATIONAL 0x061aU // Veridicom International, Inc.
#define UHS_VID_PROMPTUS_COMMUNICATIONS 0x061bU // Promptus Communications, Inc.
#define UHS_VID_ACT_LABS 0x061cU // Act Labs, Ltd
#define UHS_VID_QUATECH 0x061dU // Quatech, Inc.
#define UHS_VID_NISSEI_ELECTRIC 0x061eU // Nissei Electric Co.
#define UHS_VID_ALARIS 0x0620U // Alaris, Inc.
#define UHS_VID_ODU_STECKVERBINDUNGSSYSTEME_GMBH_AND_CO_KG 0x0621U // ODU-Steckverbindungssysteme GmbH & Co. KG
#define UHS_VID_IOTECH 0x0622U // Iotech, Inc.
#define UHS_VID_LITTELFUSE 0x0623U // Littelfuse, Inc.
#define UHS_VID_AVOCENT 0x0624U // Avocent Corp.
#define UHS_VID_TIMEDIA_TECHNOLOGY 0x0625U // TiMedia Technology Co., Ltd
#define UHS_VID_NIPPON_SYSTEMS_DEVELOPMENT 0x0626U // Nippon Systems Development Co., Ltd
#define UHS_VID_ADOMAX_TECHNOLOGY 0x0627U // Adomax Technology Co., Ltd
#define UHS_VID_TASKING_SOFTWARE 0x0628U // Tasking Software, Inc.
#define UHS_VID_ZIDA_TECHNOLOGIES 0x0629U // Zida Technologies, Ltd
#define UHS_VID_CREATIVE_LABS 0x062aU // Creative Labs
#define UHS_VID_GREATLINK_ELECTRONICS_TAIWAN 0x062bU // Greatlink Electronics Taiwan, Ltd
#define UHS_VID_INSTITUTE_FOR_INFORMATION_INDUSTRY 0x062cU // Institute for Information Industry
#define UHS_VID_TAIWAN_TAI_HAO_ENTERPRISES 0x062dU // Taiwan Tai-Hao Enterprises Co., Ltd
#define UHS_VID_MAINSUPER_ENTERPRISES 0x062eU // Mainsuper Enterprises Co., Ltd
#define UHS_VID_SIN_SHENG_TERMINAL_AND_MACHINE 0x062fU // Sin Sheng Terminal & Machine, Inc.
#define UHS_VID_JUJO_ELECTRONICS 0x0631U // JUJO Electronics Corp.
#define UHS_VID_CYRIX 0x0633U // Cyrix Corp.
#define UHS_VID_MICRON_TECHNOLOGY 0x0634U // Micron Technology, Inc.
#define UHS_VID_METHODE_ELECTRONICS 0x0635U // Methode Electronics, Inc.
#define UHS_VID_SIERRA_IMAGING 0x0636U // Sierra Imaging, Inc.
#define UHS_VID_AVISION 0x0638U // Avision, Inc.
#define UHS_VID_CHRONTEL 0x0639U // Chrontel, Inc.
#define UHS_VID_TECHWIN 0x063aU // Techwin Corp.
#define UHS_VID_TAUGAGREINING_HF_1 0x063bU // Taugagreining HF
#define UHS_VID_YAMAICHI_ELECTRONICS_CO_LTD_SAKURA 0x063cU // Yamaichi Electronics Co., Ltd (Sakura)
#define UHS_VID_FONG_KAI_INDUSTRIAL 0x063dU // Fong Kai Industrial Co., Ltd
#define UHS_VID_REALMEDIA_TECHNOLOGY 0x063eU // RealMedia Technology, Inc.
#define UHS_VID_NEW_TECHNOLOGY_CABLE 0x063fU // New Technology Cable, Ltd
#define UHS_VID_HITEX_DEVELOPMENT_TOOLS 0x0640U // Hitex Development Tools
#define UHS_VID_WOODS_INDUSTRIES 0x0641U // Woods Industries, Inc.
#define UHS_VID_VIA_MEDICAL 0x0642U // VIA Medical Corp.
#define UHS_VID_TEAC 0x0644U // TEAC Corp.
#define UHS_VID_WHO_UNKNOWN_VISION_SYSTEMS 0x0645U // Who? Vision Systems, Inc.
#define UHS_VID_UMAX 0x0646U // UMAX
#define UHS_VID_ACTON_RESEARCH 0x0647U // Acton Research Corp.
#define UHS_VID_INSIDE_OUT_NETWORKS 0x0648U // Inside Out Networks
#define UHS_VID_WELI_SCIENCE 0x0649U // Weli Science Co., Ltd
#define UHS_VID_ANALOG_DEVICES_INC_WHITE_MOUNTAIN_DSP 0x064bU // Analog Devices, Inc. (White Mountain DSP)
#define UHS_VID_JI_HAW_INDUSTRIAL 0x064cU // Ji-Haw Industrial Co., Ltd
#define UHS_VID_TRITECH_MICROELECTRONICS 0x064dU // TriTech Microelectronics, Ltd
#define UHS_VID_SUYIN 0x064eU // Suyin Corp.
#define UHS_VID_WIBU_SYSTEMS_AG 0x064fU // WIBU-Systems AG
#define UHS_VID_DYNAPRO_SYSTEMS 0x0650U // Dynapro Systems
#define UHS_VID_LIKOM_TECHNOLOGY_SDN_BHD 0x0651U // Likom Technology Sdn. Bhd.
#define UHS_VID_STARGATE_SOLUTIONS 0x0652U // Stargate Solutions, Inc.
#define UHS_VID_CNF 0x0653U // CNF, Inc.
#define UHS_VID_GRANITE_MICROSYSTEMS 0x0654U // Granite Microsystems, Inc.
#define UHS_VID_SPACE_SHUTTLE_HI_TECH 0x0655U // Space Shuttle Hi-Tech Co., Ltd
#define UHS_VID_GLORY_MARK_ELECTRONIC 0x0656U // Glory Mark Electronic, Ltd
#define UHS_VID_TEKCON_ELECTRONICS 0x0657U // Tekcon Electronics Corp.
#define UHS_VID_SIGMA_DESIGNS 0x0658U // Sigma Designs, Inc.
#define UHS_VID_AETHRA 0x0659U // Aethra
#define UHS_VID_OPTOELECTRONICS 0x065aU // Optoelectronics Co., Ltd
#define UHS_VID_TRACEWELL_SYSTEMS 0x065bU // Tracewell Systems
#define UHS_VID_SILICON_GRAPHICS_1 0x065eU // Silicon Graphics
#define UHS_VID_GOOD_WAY_TECHNOLOGY_CO_LTD_AND_GWC_TECHNOLOGY 0x065fU // Good Way Technology Co., Ltd & GWC technology Inc.
#define UHS_VID_TSAY_E_BVI_INTERNATIONAL 0x0660U // TSAY-E (BVI) International, Inc.
#define UHS_VID_HAMAMATSU_PHOTONICS_KK 0x0661U // Hamamatsu Photonics K.K.
#define UHS_VID_KANSAI_ELECTRIC 0x0662U // Kansai Electric Co., Ltd
#define UHS_VID_TOPMAX_ELECTRONIC 0x0663U // Topmax Electronic Co., Ltd
#define UHS_VID_ETANDT_TECHNOLOGY 0x0664U // ET&T Technology Co., Ltd.
#define UHS_VID_CYPRESS_SEMICONDUCTOR_1 0x0665U // Cypress Semiconductor
#define UHS_VID_AIWA 0x0667U // Aiwa Co., Ltd
#define UHS_VID_WORDWAND 0x0668U // WordWand
#define UHS_VID_OCE_PRINTING_SYSTEMS 0x0669U // Oce' Printing Systems GmbH
#define UHS_VID_TOTAL_TECHNOLOGIES 0x066aU // Total Technologies, Ltd
#define UHS_VID_LINKSYS 0x066bU // Linksys, Inc.
#define UHS_VID_ENTREGA 0x066dU // Entrega, Inc.
#define UHS_VID_ACER_SEMICONDUCTOR_AMERICA 0x066eU // Acer Semiconductor America, Inc.
#define UHS_VID_SIGMATEL 0x066fU // SigmaTel, Inc.
#define UHS_VID_SEQUEL_IMAGING 0x0670U // Sequel Imaging
#define UHS_VID_LABTEC 0x0672U // Labtec, Inc.
#define UHS_VID_HCL 0x0673U // HCL
#define UHS_VID_KEY_MOUSE_ELECTRONIC_ENTERPRISE 0x0674U // Key Mouse Electronic Enterprise Co., Ltd
#define UHS_VID_DRAYTEK 0x0675U // DrayTek Corp.
#define UHS_VID_TELES_AG 0x0676U // Teles AG
#define UHS_VID_AIWA_1 0x0677U // Aiwa Co., Ltd
#define UHS_VID_ACARD_TECHNOLOGY 0x0678U // ACard Technology Corp.
#define UHS_VID_PROLIFIC_TECHNOLOGY 0x067bU // Prolific Technology, Inc.
#define UHS_VID_EFFICIENT_NETWORKS 0x067cU // Efficient Networks, Inc.
#define UHS_VID_HOHNER 0x067dU // Hohner Corp.
#define UHS_VID_INTERMEC_TECHNOLOGIES 0x067eU // Intermec Technologies Corp.
#define UHS_VID_VIRATA 0x067fU // Virata, Ltd
#define UHS_VID_REALTEK_SEMICONDUCTOR_CORP_CPP_DIV_AVANCE_LOGIC 0x0680U // Realtek Semiconductor Corp., CPP Div. (Avance Logic)
#define UHS_VID_SIEMENS_INFORMATION_AND_COMMUNICATION_PRODUCTS 0x0681U // Siemens Information and Communication Products
#define UHS_VID_VICTOR_COMPANY_OF_JAPAN_1 0x0682U // Victor Company of Japan, Ltd
#define UHS_VID_ACTIONTEC_ELECTRONICS 0x0684U // Actiontec Electronics, Inc.
#define UHS_VID_ZD_INCORPORATED 0x0685U // ZD Incorporated
#define UHS_VID_MINOLTA 0x0686U // Minolta Co., Ltd
#define UHS_VID_PERTECH 0x068aU // Pertech, Inc.
#define UHS_VID_POTRANS_INTERNATIONAL 0x068bU // Potrans International, Inc.
#define UHS_VID_CH_PRODUCTS 0x068eU // CH Products, Inc.
#define UHS_VID_GOLDEN_BRIDGE_ELECTECH 0x0690U // Golden Bridge Electech, Inc.
#define UHS_VID_HAGIWARA_SYS_COM 0x0693U // Hagiwara Sys-Com Co., Ltd
#define UHS_VID_LEGO_GROUP 0x0694U // Lego Group
#define UHS_VID_CHUNTEX_CTX 0x0698U // Chuntex (CTX)
#define UHS_VID_TEKTRONIX 0x0699U // Tektronix, Inc.
#define UHS_VID_ASKEY_COMPUTER 0x069aU // Askey Computer Corp.
#define UHS_VID_THOMSON 0x069bU // Thomson, Inc.
#define UHS_VID_HUGHES_NETWORK_SYSTEMS_HNS 0x069dU // Hughes Network Systems (HNS)
#define UHS_VID_WELCAT 0x069eU // Welcat Inc.
#define UHS_VID_ALLIED_DATA_TECHNOLOGIES_BV 0x069fU // Allied Data Technologies BV
#define UHS_VID_TOPRO_TECHNOLOGY 0x06a2U // Topro Technology, Inc.
#define UHS_VID_SAITEK_PLC 0x06a3U // Saitek PLC
#define UHS_VID_XIAMEN_DOOWELL_ELECTRON 0x06a4U // Xiamen Doowell Electron Co., Ltd
#define UHS_VID_DIVIO 0x06a5U // Divio
#define UHS_VID_MICROSTORE 0x06a7U // MicroStore, Inc.
#define UHS_VID_TOPAZ_SYSTEMS 0x06a8U // Topaz Systems, Inc.
#define UHS_VID_WESTELL 0x06a9U // Westell
#define UHS_VID_SYSGRATION 0x06aaU // Sysgration, Ltd
#define UHS_VID_FUJITSU_LABORATORIES_OF_AMERICA 0x06acU // Fujitsu Laboratories of America, Inc.
#define UHS_VID_GREATLAND_ELECTRONICS_TAIWAN 0x06adU // Greatland Electronics Taiwan, Ltd
#define UHS_VID_PROFESSIONAL_MULTIMEDIA_TESTING_CENTRE 0x06aeU // Professional Multimedia Testing Centre
#define UHS_VID_HARTING_INC_OF_NORTH_AMERICA 0x06afU // Harting, Inc. of North America
#define UHS_VID_PIXELA 0x06b8U // Pixela Corp.
#define UHS_VID_ALCATEL_TELECOM 0x06b9U // Alcatel Telecom
#define UHS_VID_SMOOTH_CORD_AND_CONNECTOR 0x06baU // Smooth Cord & Connector Co., Ltd
#define UHS_VID_EDA 0x06bbU // EDA, Inc.
#define UHS_VID_OKI_DATA 0x06bcU // Oki Data Corp.
#define UHS_VID_AGFA_GEVAERT_NV 0x06bdU // AGFA-Gevaert NV
#define UHS_VID_AME_OPTIMEDIA_TECHNOLOGY 0x06beU // AME Optimedia Technology Co., Ltd
#define UHS_VID_LEOCO 0x06bfU // Leoco Corp.
#define UHS_VID_PHIDGETS_INC_FORMERLY_GLAB 0x06c2U // Phidgets Inc. (formerly GLAB)
#define UHS_VID_BIZLINK_INTERNATIONAL 0x06c4U // Bizlink International Corp.
#define UHS_VID_HAGENUK 0x06c5U // Hagenuk, GmbH
#define UHS_VID_INFOWAVE_SOFTWARE 0x06c6U // Infowave Software, Inc.
#define UHS_VID_SIIG 0x06c8U // SIIG, Inc.
#define UHS_VID_TAXAN_EUROPE 0x06c9U // Taxan (Europe), Ltd
#define UHS_VID_NEWER_TECHNOLOGY 0x06caU // Newer Technology, Inc.
#define UHS_VID_SYNAPTICS 0x06cbU // Synaptics, Inc.
#define UHS_VID_TERAYON_COMMUNICATION_SYSTEMS 0x06ccU // Terayon Communication Systems
#define UHS_VID_KEYSPAN 0x06cdU // Keyspan
#define UHS_VID_CONTEC 0x06ceU // Contec
#define UHS_VID_SPHERONVR_AG 0x06cfU // SpheronVR AG
#define UHS_VID_LAPLINK 0x06d0U // LapLink, Inc.
#define UHS_VID_DAEWOO_ELECTRONICS_1 0x06d1U // Daewoo Electronics Co., Ltd
#define UHS_VID_MITSUBISHI_ELECTRIC 0x06d3U // Mitsubishi Electric Corp.
#define UHS_VID_CISCO_SYSTEMS_1 0x06d4U // Cisco Systems
#define UHS_VID_TOSHIBA 0x06d5U // Toshiba
#define UHS_VID_AASHIMA_TECHNOLOGY_BV 0x06d6U // Aashima Technology B.V.
#define UHS_VID_NETWORK_COMPUTING_DEVICES_NCD 0x06d7U // Network Computing Devices (NCD)
#define UHS_VID_TECHNICAL_MARKETING_RESEARCH 0x06d8U // Technical Marketing Research, Inc.
#define UHS_VID_PHOENIXTEC_POWER 0x06daU // Phoenixtec Power Co., Ltd
#define UHS_VID_PARADYNE 0x06dbU // Paradyne
#define UHS_VID_FOXLINK_IMAGE_TECHNOLOGY 0x06dcU // Foxlink Image Technology Co., Ltd
#define UHS_VID_HEISEI_ELECTRONICS 0x06deU // Heisei Electronics Co., Ltd
#define UHS_VID_MULTI_TECH_SYSTEMS 0x06e0U // Multi-Tech Systems, Inc.
#define UHS_VID_ADS_TECHNOLOGIES 0x06e1U // ADS Technologies, Inc.
#define UHS_VID_ALCATEL_MICROELECTRONICS 0x06e4U // Alcatel Microelectronics
#define UHS_VID_TIGER_JET_NETWORK 0x06e6U // Tiger Jet Network, Inc.
#define UHS_VID_SIRIUS_TECHNOLOGIES 0x06eaU // Sirius Technologies
#define UHS_VID_PC_EXPERT_TECH 0x06ebU // PC Expert Tech. Co., Ltd
#define UHS_VID_IAC_GEOMETRISCHE_INGENIEURS_BV 0x06efU // I.A.C. Geometrische Ingenieurs B.V.
#define UHS_VID_TNC_INDUSTRIAL 0x06f0U // T.N.C Industrial Co., Ltd
#define UHS_VID_OPCODE_SYSTEMS 0x06f1U // Opcode Systems, Inc.
#define UHS_VID_EMINE_TECHNOLOGY 0x06f2U // Emine Technology Co.
#define UHS_VID_WINTREND_TECHNOLOGY 0x06f6U // Wintrend Technology Co., Ltd
#define UHS_VID_WAILLY_TECHNOLOGY 0x06f7U // Wailly Technology Ltd
#define UHS_VID_GUILLEMOT 0x06f8U // Guillemot Corp.
#define UHS_VID_ASYST_ELECTRONIC_DOO 0x06f9U // ASYST electronic d.o.o.
#define UHS_VID_HSD_SRL 0x06faU // HSD S.r.L
#define UHS_VID_MOTOROLA_SEMICONDUCTOR_PRODUCTS_SECTOR 0x06fcU // Motorola Semiconductor Products Sector
#define UHS_VID_BOSTON_ACOUSTICS 0x06fdU // Boston Acoustics
#define UHS_VID_GALLANT_COMPUTER 0x06feU // Gallant Computer, Inc.
#define UHS_VID_SUPERCOMAL_WIRE_AND_CABLE_SDN_BHD 0x0701U // Supercomal Wire & Cable SDN. BHD.
#define UHS_VID_BVTECH_INDUSTRY 0x0703U // Bvtech Industry, Inc.
#define UHS_VID_NKK 0x0705U // NKK Corp.
#define UHS_VID_ARIEL 0x0706U // Ariel Corp.
#define UHS_VID_STANDARD_MICROSYSTEMS_2 0x0707U // Standard Microsystems Corp.
#define UHS_VID_PUTERCOM 0x0708U // Putercom Co., Ltd
#define UHS_VID_SILICON_SYSTEMS_LTD_SSL 0x0709U // Silicon Systems, Ltd (SSL)
#define UHS_VID_OKI_ELECTRIC_INDUSTRY 0x070aU // Oki Electric Industry Co., Ltd
#define UHS_VID_COMOSS_ELECTRONIC 0x070dU // Comoss Electronic Co., Ltd
#define UHS_VID_EXCEL_CELL_ELECTRONIC 0x070eU // Excel Cell Electronic Co., Ltd
#define UHS_VID_CONNECT_TECH 0x0710U // Connect Tech, Inc.
#define UHS_VID_MAGIC_CONTROL_TECHNOLOGY 0x0711U // Magic Control Technology Corp.
#define UHS_VID_INTERVAL_RESEARCH 0x0713U // Interval Research Corp.
#define UHS_VID_NEWMOTION 0x0714U // NewMotion, Inc.
#define UHS_VID_ZNK 0x0717U // ZNK Corp.
#define UHS_VID_IMATION 0x0718U // Imation Corp.
#define UHS_VID_TREMON_ENTERPRISES 0x0719U // Tremon Enterprises Co., Ltd
#define UHS_VID_DOMAIN_TECHNOLOGIES 0x071bU // Domain Technologies, Inc.
#define UHS_VID_XIONICS_DOCUMENT_TECHNOLOGIES 0x071cU // Xionics Document Technologies, Inc.
#define UHS_VID_EICON_NETWORKS 0x071dU // Eicon Networks Corp.
#define UHS_VID_ARISTON_TECHNOLOGIES 0x071eU // Ariston Technologies
#define UHS_VID_CENTILLIUM_COMMUNICATIONS 0x0723U // Centillium Communications Corp.
#define UHS_VID_VANGUARD_INTERNATIONAL_SEMICONDUCTOR_AMERICA 0x0726U // Vanguard International Semiconductor-America
#define UHS_VID_AMITM 0x0729U // Amitm
#define UHS_VID_SUNIX 0x072eU // Sunix Co., Ltd
#define UHS_VID_ADVANCED_CARD_SYSTEMS 0x072fU // Advanced Card Systems, Ltd
#define UHS_VID_SUSTEEN 0x0731U // Susteen, Inc.
#define UHS_VID_GOLDFULL_ELECTRONICS_AND_TELECOMMUNICATIONS 0x0732U // Goldfull Electronics & Telecommunications Corp.
#define UHS_VID_VIEWQUEST_TECHNOLOGIES 0x0733U // ViewQuest Technologies, Inc.
#define UHS_VID_LASAT_COMMUNICATIONS_AS 0x0734U // Lasat Communications A/S
#define UHS_VID_ASUSCOM_NETWORK 0x0735U // Asuscom Network
#define UHS_VID_LOROM_INDUSTRIAL 0x0736U // Lorom Industrial Co., Ltd
#define UHS_VID_MAD_CATZ 0x0738U // Mad Catz, Inc.
#define UHS_VID_CHAPLET_SYSTEMS 0x073aU // Chaplet Systems, Inc.
#define UHS_VID_SUNCOM_TECHNOLOGIES 0x073bU // Suncom Technologies
#define UHS_VID_INDUSTRIAL_ELECTRONIC_ENGINEERS 0x073cU // Industrial Electronic Engineers, Inc.
#define UHS_VID_EUTRON_SPA 0x073dU // Eutron S.p.a.
#define UHS_VID_NEC_1 0x073eU // NEC, Inc.
#define UHS_VID_STOLLMANN 0x0742U // Stollmann
#define UHS_VID_SYNTECH_INFORMATION 0x0745U // Syntech Information Co., Ltd
#define UHS_VID_ONKYO 0x0746U // Onkyo Corp.
#define UHS_VID_LABWAY 0x0747U // Labway Corp.
#define UHS_VID_STRONG_MAN_ENTERPRISE 0x0748U // Strong Man Enterprise Co., Ltd
#define UHS_VID_EVER_ELECTRONICS 0x0749U // EVer Electronics Corp.
#define UHS_VID_MING_FORTUNE_INDUSTRY 0x074aU // Ming Fortune Industry Co., Ltd
#define UHS_VID_POLESTAR_TECH 0x074bU // Polestar Tech. Corp.
#define UHS_VID_C_C_C_GROUP_PLC 0x074cU // C-C-C Group PLC
#define UHS_VID_MICRONAS 0x074dU // Micronas GmbH
#define UHS_VID_DIGITAL_STREAM 0x074eU // Digital Stream Corp.
#define UHS_VID_AUREAL_SEMICONDUCTOR 0x0755U // Aureal Semiconductor
#define UHS_VID_NETWORK_TECHNOLOGIES 0x0757U // Network Technologies, Inc.
#define UHS_VID_SOPHISTICATED_CIRCUITS 0x075bU // Sophisticated Circuits, Inc.
#define UHS_VID_MIDIMAN 0x0763U // Midiman
#define UHS_VID_CYBER_POWER_SYSTEM 0x0764U // Cyber Power System, Inc.
#define UHS_VID_X_RITE 0x0765U // X-Rite, Inc.
#define UHS_VID_JESS_LINK_PRODUCTS 0x0766U // Jess-Link Products Co., Ltd
#define UHS_VID_TOKHEIM 0x0767U // Tokheim Corp.
#define UHS_VID_CAMTEL_TECHNOLOGY 0x0768U // Camtel Technology Corp.
#define UHS_VID_SURECOM_TECHNOLOGY 0x0769U // Surecom Technology Corp.
#define UHS_VID_SMART_TECHNOLOGY_ENABLERS 0x076aU // Smart Technology Enablers, Inc.
#define UHS_VID_OMNIKEY_AG 0x076bU // OmniKey AG
#define UHS_VID_PARTNER_TECH 0x076cU // Partner Tech
#define UHS_VID_DENSO 0x076dU // Denso Corp.
#define UHS_VID_KUAN_TECH_ENTERPRISE 0x076eU // Kuan Tech Enterprise Co., Ltd
#define UHS_VID_JHEN_VEI_ELECTRONIC 0x076fU // Jhen Vei Electronic Co., Ltd
#define UHS_VID_WELCH_ALLYN_INC__MEDICAL_DIVISION 0x0770U // Welch Allyn, Inc - Medical Division
#define UHS_VID_OBSERVATOR_INSTRUMENTS_BV 0x0771U // Observator Instruments BV
#define UHS_VID_YOUR_DATA_OUR_CARE 0x0772U // Your data Our Care
#define UHS_VID_AMTRAN_TECHNOLOGY 0x0774U // AmTRAN Technology Co., Ltd
#define UHS_VID_LONGSHINE_ELECTRONICS 0x0775U // Longshine Electronics Corp.
#define UHS_VID_INALWAYS 0x0776U // Inalways Corp.
#define UHS_VID_COMDA_ENTERPRISE 0x0777U // Comda Enterprise Corp.
#define UHS_VID_VOLEX 0x0778U // Volex, Inc.
#define UHS_VID_FAIRCHILD_SEMICONDUCTOR 0x0779U // Fairchild Semiconductor
#define UHS_VID_SANKYO_SEIKI_MFG 0x077aU // Sankyo Seiki Mfg. Co., Ltd
#define UHS_VID_LINKSYS_1 0x077bU // Linksys
#define UHS_VID_FORWARD_ELECTRONICS 0x077cU // Forward Electronics Co., Ltd
#define UHS_VID_GRIFFIN_TECHNOLOGY 0x077dU // Griffin Technology
#define UHS_VID_WELL_EXCELLENT_AND_MOST 0x077fU // Well Excellent & Most Corp.
#define UHS_VID_SAGEM_MONETEL 0x0780U // Sagem Monetel GmbH
#define UHS_VID_SANDISK 0x0781U // SanDisk Corp.
#define UHS_VID_TRACKERBALL 0x0782U // Trackerball
#define UHS_VID_C3PO 0x0783U // C3PO
#define UHS_VID_VIVITAR 0x0784U // Vivitar, Inc.
#define UHS_VID_NTT_ME 0x0785U // NTT-ME
#define UHS_VID_LOGITEC 0x0789U // Logitec Corp.
#define UHS_VID_HAPP_CONTROLS 0x078bU // Happ Controls, Inc.
#define UHS_VID_GTCOCALCOMP 0x078cU // GTCO/CalComp
#define UHS_VID_BRINCOM 0x078eU // Brincom, Inc.
#define UHS_VID_PRO_IMAGE_MANUFACTURING 0x0790U // Pro-Image Manufacturing Co., Ltd
#define UHS_VID_COPARTNER_WIRE_AND_CABLE_MFG 0x0791U // Copartner Wire and Cable Mfg. Corp.
#define UHS_VID_AXIS_COMMUNICATIONS 0x0792U // Axis Communications AB
#define UHS_VID_WHA_YU_INDUSTRIAL 0x0793U // Wha Yu Industrial Co., Ltd
#define UHS_VID_ABL_ELECTRONICS 0x0794U // ABL Electronics Corp.
#define UHS_VID_REALCHIP 0x0795U // RealChip, Inc.
#define UHS_VID_CERTICOM 0x0796U // Certicom Corp.
#define UHS_VID_GRANDTECH_SEMICONDUCTOR 0x0797U // Grandtech Semiconductor Corp.
#define UHS_VID_OPTELEC 0x0798U // Optelec
#define UHS_VID_ALTERA 0x0799U // Altera
#define UHS_VID_SAGEM 0x079bU // Sagem
#define UHS_VID_ALFADATA_COMPUTER 0x079dU // Alfadata Computer Corp.
#define UHS_VID_DIGICOM_SPA 0x07a1U // Digicom S.p.A.
#define UHS_VID_NATIONAL_TECHNICAL_SYSTEMS 0x07a2U // National Technical Systems
#define UHS_VID_ONNTO 0x07a3U // Onnto Corp.
#define UHS_VID_BE 0x07a4U // Be, Inc.
#define UHS_VID_ADMTEK 0x07a6U // ADMtek, Inc.
#define UHS_VID_COREGA_KK 0x07aaU // Corega K.K.
#define UHS_VID_FREECOM_TECHNOLOGIES 0x07abU // Freecom Technologies
#define UHS_VID_MICROTECH 0x07afU // Microtech
#define UHS_VID_TRUST_TECHNOLOGIES 0x07b0U // Trust Technologies
#define UHS_VID_IMP 0x07b1U // IMP, Inc.
#define UHS_VID_MOTOROLA_BCS 0x07b2U // Motorola BCS, Inc.
#define UHS_VID_PLUSTEK 0x07b3U // Plustek, Inc.
#define UHS_VID_OLYMPUS_OPTICAL 0x07b4U // Olympus Optical Co., Ltd
#define UHS_VID_MEGA_WORLD_INTERNATIONAL 0x07b5U // Mega World International, Ltd
#define UHS_VID_MARUBUN 0x07b6U // Marubun Corp.
#define UHS_VID_TIME_INTERCONNECT 0x07b7U // TIME Interconnect, Ltd
#define UHS_VID_ABOCOM_SYSTEMS 0x07b8U // AboCom Systems Inc
#define UHS_VID_CANON_COMPUTER_SYSTEMS 0x07bcU // Canon Computer Systems, Inc.
#define UHS_VID_WEBGEAR 0x07bdU // Webgear, Inc.
#define UHS_VID_VERIDICOM 0x07beU // Veridicom
#define UHS_VID_CODE_MERCENARIES_HARD_UND_SOFTWARE 0x07c0U // Code Mercenaries Hard- und Software GmbH
#define UHS_VID_KEISOKUGIKEN 0x07c1U // Keisokugiken
#define UHS_VID_DATAFAB_SYSTEMS 0x07c4U // Datafab Systems, Inc.
#define UHS_VID_APG_CASH_DRAWER 0x07c5U // APG Cash Drawer
#define UHS_VID_SHAREWAVE 0x07c6U // ShareWave, Inc.
#define UHS_VID_POWERTECH_INDUSTRIAL 0x07c7U // Powertech Industrial Co., Ltd
#define UHS_VID_BUG 0x07c8U // B.U.G., Inc.
#define UHS_VID_ALLIED_TELESYN_INTERNATIONAL 0x07c9U // Allied Telesyn International
#define UHS_VID_AVERMEDIA_TECHNOLOGIES 0x07caU // AVerMedia Technologies, Inc.
#define UHS_VID_KINGMAX_TECHNOLOGY 0x07cbU // Kingmax Technology, Inc.
#define UHS_VID_CARRY_COMPUTER_ENG 0x07ccU // Carry Computer Eng., Co., Ltd
#define UHS_VID_ELEKTOR 0x07cdU // Elektor
#define UHS_VID_CASIO_COMPUTER 0x07cfU // Casio Computer Co., Ltd
#define UHS_VID_DAZZLE 0x07d0U // Dazzle
#define UHS_VID_D_LINK_SYSTEM 0x07d1U // D-Link System
#define UHS_VID_APTIO_PRODUCTS 0x07d2U // Aptio Products, Inc.
#define UHS_VID_CYBERDATA 0x07d3U // Cyberdata Corp.
#define UHS_VID_RADIANT_SYSTEMS 0x07d5U // Radiant Systems
#define UHS_VID_GCC_TECHNOLOGIES 0x07d7U // GCC Technologies, Inc.
#define UHS_VID_ARASAN_CHIP_SYSTEMS 0x07daU // Arasan Chip Systems
#define UHS_VID_DIAMOND_MULTIMEDIA 0x07deU // Diamond Multimedia
#define UHS_VID_DAVID_ELECTRONICS 0x07dfU // David Electronics Co., Ltd
#define UHS_VID_AMBIENT_TECHNOLOGIES 0x07e1U // Ambient Technologies, Inc.
#define UHS_VID_ELMEG_GMBH_AND 0x07e2U // Elmeg GmbH & Co., Ltd
#define UHS_VID_PLANEX_COMMUNICATIONS 0x07e3U // Planex Communications, Inc.
#define UHS_VID_MOVADO_ENTERPRISE 0x07e4U // Movado Enterprise Co., Ltd
#define UHS_VID_QPS 0x07e5U // QPS, Inc.
#define UHS_VID_ALLIED_CABLE 0x07e6U // Allied Cable Corp.
#define UHS_VID_MIRVO_TOYS 0x07e7U // Mirvo Toys, Inc.
#define UHS_VID_LABSYSTEMS 0x07e8U // Labsystems
#define UHS_VID_IWATSU_ELECTRIC 0x07eaU // Iwatsu Electric Co., Ltd
#define UHS_VID_DOUBLE_H_TECHNOLOGY 0x07ebU // Double-H Technology Co., Ltd
#define UHS_VID_TAIYO_ELECTRIC_WIRE_AND_CABLE 0x07ecU // Taiyo Electric Wire & Cable Co., Ltd
#define UHS_VID_TOREX_RETAIL_FORMERLY_LOGWARE 0x07eeU // Torex Retail (formerly Logware)
#define UHS_VID_STSN 0x07efU // STSN
#define UHS_VID_MICROCOMPUTER_APPLICATIONS 0x07f2U // Microcomputer Applications, Inc.
#define UHS_VID_CIRCUIT_ASSEMBLY 0x07f6U // Circuit Assembly Corp.
#define UHS_VID_CENTURY 0x07f7U // Century Corp.
#define UHS_VID_DOTOP_TECHNOLOGY 0x07f9U // Dotop Technology, Inc.
#define UHS_VID_DRAYTEK_1 0x07faU // DrayTek Corp.
#define UHS_VID_MARK_OF_THE_UNICORN 0x07fdU // Mark of the Unicorn
#define UHS_VID_UNKNOWN_2 0x07ffU // Unknown
#define UHS_VID_MAGTEK 0x0801U // MagTek
#define UHS_VID_MAKO_TECHNOLOGIES 0x0802U // Mako Technologies, LLC
#define UHS_VID_ZOOM_TELEPHONICS 0x0803U // Zoom Telephonics, Inc.
#define UHS_VID_GENICOM_TECHNOLOGY 0x0809U // Genicom Technology, Inc.
#define UHS_VID_EVERMUCH_TECHNOLOGY 0x080aU // Evermuch Technology Co., Ltd
#define UHS_VID_CROSS_MATCH_TECHNOLOGIES 0x080bU // Cross Match Technologies
#define UHS_VID_DATALOGIC_SPA 0x080cU // Datalogic S.p.A.
#define UHS_VID_TECO_IMAGE_SYSTEMS 0x080dU // Teco Image Systems Co., Ltd
#define UHS_VID_PERSONAL_COMMUNICATION_SYSTEMS 0x0810U // Personal Communication Systems, Inc.
#define UHS_VID_MATTEL 0x0813U // Mattel, Inc.
#define UHS_VID_ELICENSER 0x0819U // eLicenser
#define UHS_VID_MG_LOGIC 0x081aU // MG Logic
#define UHS_VID_INDIGITA 0x081bU // Indigita Corp.
#define UHS_VID_MIPSYS 0x081cU // Mipsys
#define UHS_VID_ALPHASMART 0x081eU // AlphaSmart, Inc.
#define UHS_VID_REUDO 0x0822U // Reudo Corp.
#define UHS_VID_GC_PROTRONICS 0x0825U // GC Protronics
#define UHS_VID_DATA_TRANSIT 0x0826U // Data Transit
#define UHS_VID_BROADLOGIC 0x0827U // BroadLogic, Inc.
#define UHS_VID_SATO 0x0828U // Sato Corp.
#define UHS_VID_DIRECTV_BROADBAND_INC_TELOCITY 0x0829U // DirecTV Broadband, Inc. (Telocity)
#define UHS_VID_HANDSPRING 0x082dU // Handspring
#define UHS_VID_PALM 0x0830U // Palm, Inc.
#define UHS_VID_KOUWELL_ELECTRONICS 0x0832U // Kouwell Electronics Corp.
#define UHS_VID_SOURCENEXT 0x0833U // Sourcenext Corp.
#define UHS_VID_ACTION_STAR_ENTERPRISE 0x0835U // Action Star Enterprise Co., Ltd
#define UHS_VID_TREKSTOR 0x0836U // TrekStor
#define UHS_VID_SAMSUNG_TECHWIN 0x0839U // Samsung Techwin Co., Ltd
#define UHS_VID_ACCTON_TECHNOLOGY 0x083aU // Accton Technology Corp.
#define UHS_VID_GLOBAL_VILLAGE 0x083fU // Global Village
#define UHS_VID_ARGOSY_RESEARCH 0x0840U // Argosy Research, Inc.
#define UHS_VID_RIOPORTCOM 0x0841U // Rioport.com, Inc.
#define UHS_VID_WELLAND_INDUSTRIAL 0x0844U // Welland Industrial Co., Ltd
#define UHS_VID_NETGEAR 0x0846U // NetGear, Inc.
#define UHS_VID_MINTON_OPTIC_INDUSTRY 0x084dU // Minton Optic Industry Co., Inc.
#define UHS_VID_KB_GEAR 0x084eU // KB Gear
#define UHS_VID_EMPEG 0x084fU // Empeg
#define UHS_VID_FAST_POINT_TECHNOLOGIES 0x0850U // Fast Point Technologies, Inc.
#define UHS_VID_MACRONIX_INTERNATIONAL 0x0851U // Macronix International Co., Ltd
#define UHS_VID_CSEM 0x0852U // CSEM
#define UHS_VID_TOPRE_CORPORATION 0x0853U // Topre Corporation
#define UHS_VID_ACTIVEWIRE 0x0854U // ActiveWire, Inc.
#define UHS_VID_BANDB_ELECTRONICS 0x0856U // B&B Electronics
#define UHS_VID_HITACHI_MAXELL 0x0858U // Hitachi Maxell, Ltd
#define UHS_VID_MINOLTA_SYSTEMS_LABORATORY 0x0859U // Minolta Systems Laboratory, Inc.
#define UHS_VID_XIRCOM 0x085aU // Xircom
#define UHS_VID_COLORVISION 0x085cU // ColorVision, Inc.
#define UHS_VID_TELETROL_SYSTEMS 0x0862U // Teletrol Systems, Inc.
#define UHS_VID_FILANET 0x0863U // Filanet Corp.
#define UHS_VID_NETGEAR_1 0x0864U // NetGear, Inc.
#define UHS_VID_DATA_TRANSLATION 0x0867U // Data Translation, Inc.
#define UHS_VID_EMAGIC_SOFT_UND_HARDWARE 0x086aU // Emagic Soft- und Hardware GmbH
#define UHS_VID_DETEWE__DEUTSCHE_TELEPHONWERKE_AG_AND 0x086cU // DeTeWe - Deutsche Telephonwerke AG & Co.
#define UHS_VID_SYSTEM_TALKS 0x086eU // System TALKS, Inc.
#define UHS_VID_MEC_IMEX 0x086fU // MEC IMEX, Inc.
#define UHS_VID_METRICOM 0x0870U // Metricom
#define UHS_VID_SANDISK_1 0x0871U // SanDisk, Inc.
#define UHS_VID_XPEED 0x0873U // Xpeed, Inc.
#define UHS_VID_A_TEC_SUBSYSTEM 0x0874U // A-Tec Subsystem, Inc.
#define UHS_VID_COMTROL 0x0879U // Comtrol Corp.
#define UHS_VID_ADESSOKBTEK_AMERICA 0x087cU // Adesso/Kbtek America, Inc.
#define UHS_VID_JATON 0x087dU // Jaton Corp.
#define UHS_VID_FUJITSU_COMPUTER_PRODUCTS_OF_AMERICA 0x087eU // Fujitsu Computer Products of America
#define UHS_VID_QUALCORE_LOGIC 0x087fU // QualCore Logic Inc.
#define UHS_VID_APT_TECHNOLOGIES 0x0880U // APT Technologies, Inc.
#define UHS_VID_RECORDING_INDUSTRY_ASSOCIATION_OF_AMERICA_RIAA 0x0883U // Recording Industry Association of America (RIAA)
#define UHS_VID_BOCA_RESEARCH 0x0885U // Boca Research, Inc.
#define UHS_VID_XAC_AUTOMATION 0x0886U // XAC Automation Corp.
#define UHS_VID_HANNSTAR_ELECTRONICS 0x0887U // Hannstar Electronics Corp.
#define UHS_VID_TECHTOOLS 0x088aU // TechTools
#define UHS_VID_MASSWORKS 0x088bU // MassWorks, Inc.
#define UHS_VID_SWECOIN 0x088cU // Swecoin AB
#define UHS_VID_ILOK 0x088eU // iLok
#define UHS_VID_DIOGRAPHY 0x0892U // DioGraphy, Inc.
#define UHS_VID_TSI_INCORPORATED 0x0894U // TSI Incorporated
#define UHS_VID_LAUTERBACH 0x0897U // Lauterbach
#define UHS_VID_UNITED_TECHNOLOGIES_RESEARCH_CNTR 0x089cU // United Technologies Research Cntr.
#define UHS_VID_ICRON_TECHNOLOGIES 0x089dU // Icron Technologies Corp.
#define UHS_VID_NST 0x089eU // NST Co., Ltd
#define UHS_VID_PRIMEX_AEROSPACE 0x089fU // Primex Aerospace Co.
#define UHS_VID_E9 0x08a5U // e9, Inc.
#define UHS_VID_TOSHIBA_TEC 0x08a6U // Toshiba TEC
#define UHS_VID_ANDREA_ELECTRONICS 0x08a8U // Andrea Electronics
#define UHS_VID_CWAV 0x08a9U // CWAV Inc.
#define UHS_VID_MACRAIGOR_SYSTEMS 0x08acU // Macraigor Systems LLC
#define UHS_VID_MACALLY_MACE_GROUP 0x08aeU // Macally (Mace Group, Inc.)
#define UHS_VID_METROHM 0x08b0U // Metrohm
#define UHS_VID_SORENSON_VISION 0x08b4U // Sorenson Vision, Inc.
#define UHS_VID_NATSU 0x08b7U // NATSU
#define UHS_VID_J_GORDON_ELECTRONIC_DESIGN 0x08b8U // J. Gordon Electronic Design, Inc.
#define UHS_VID_RADIOSHACK_CORP_TANDY 0x08b9U // RadioShack Corp. (Tandy)
#define UHS_VID_TEXAS_INSTRUMENTS_1 0x08bbU // Texas Instruments
#define UHS_VID_CITIZEN_WATCH 0x08bdU // Citizen Watch Co., Ltd
#define UHS_VID_PRECISE_BIOMETRICS 0x08c3U // Precise Biometrics
#define UHS_VID_PROXIM 0x08c4U // Proxim, Inc.
#define UHS_VID_KEY_NICE_ENTERPRISE 0x08c7U // Key Nice Enterprise Co., Ltd
#define UHS_VID_2WIRE 0x08c8U // 2Wire, Inc.
#define UHS_VID_NIPPON_TELEGRAPH_AND_TELEPHONE 0x08c9U // Nippon Telegraph and Telephone Corp.
#define UHS_VID_AIPTEK_INTERNATIONAL 0x08caU // Aiptek International, Inc.
#define UHS_VID_JUE_HSUN_IND 0x08cdU // Jue Hsun Ind. Corp.
#define UHS_VID_LONG_WELL_ELECTRONICS 0x08ceU // Long Well Electronics Corp.
#define UHS_VID_PRODUCTIVITY_ENHANCEMENT_PRODUCTS 0x08cfU // Productivity Enhancement Products
#define UHS_VID_SMARTBRIDGES 0x08d1U // smartBridges, Inc.
#define UHS_VID_VIRTUAL_INK 0x08d3U // Virtual Ink
#define UHS_VID_FUJITSU_SIEMENS_COMPUTERS 0x08d4U // Fujitsu Siemens Computers
#define UHS_VID_IXXAT_AUTOMATION 0x08d8U // IXXAT Automation GmbH
#define UHS_VID_INCREMENT_P 0x08d9U // Increment P Corp.
#define UHS_VID_BILLIONTON_SYSTEMS 0x08ddU // Billionton Systems, Inc.
#define UHS_VID__UNKNOWN 0x08deU // ?
#define UHS_VID_SPYRUS 0x08dfU // Spyrus, Inc.
#define UHS_VID_OLITEC 0x08e3U // Olitec, Inc.
#define UHS_VID_PIONEER 0x08e4U // Pioneer Corp.
#define UHS_VID_LITRONIC 0x08e5U // Litronic
#define UHS_VID_GEMALTO_WAS_GEMPLUS 0x08e6U // Gemalto (was Gemplus)
#define UHS_VID_PAN_INTERNATIONAL_WIRE_AND_CABLE 0x08e7U // Pan-International Wire & Cable
#define UHS_VID_INTEGRATED_MEMORY_LOGIC 0x08e8U // Integrated Memory Logic
#define UHS_VID_EXTENDED_SYSTEMS 0x08e9U // Extended Systems, Inc.
#define UHS_VID_ERICSSON_INC_BLUE_RIDGE_LABS 0x08eaU // Ericsson, Inc., Blue Ridge Labs
#define UHS_VID_M_SYSTEMS_FLASH_DISK_PIONEERS 0x08ecU // M-Systems Flash Disk Pioneers
#define UHS_VID_MEDIATEK 0x08edU // MediaTek Inc.
#define UHS_VID_CCSIHESSO 0x08eeU // CCSI/Hesso
#define UHS_VID_COREX_TECHNOLOGIES 0x08f0U // Corex Technologies
#define UHS_VID_CTI_ELECTRONICS 0x08f1U // CTI Electronics Corp.
#define UHS_VID_GOTOP_INFORMATION 0x08f2U // Gotop Information Inc.
#define UHS_VID_SYSTEC 0x08f5U // SysTec Co., Ltd
#define UHS_VID_LOGIC_3_INTERNATIONAL 0x08f6U // Logic 3 International, Ltd
#define UHS_VID_VERNIER 0x08f7U // Vernier
#define UHS_VID_KEEN_TOP_INTERNATIONAL_ENTERPRISE 0x08f8U // Keen Top International Enterprise Co., Ltd
#define UHS_VID_WIPRO_TECHNOLOGIES 0x08f9U // Wipro Technologies
#define UHS_VID_CAERE 0x08faU // Caere
#define UHS_VID_SOCKET_COMMUNICATIONS 0x08fbU // Socket Communications
#define UHS_VID_SICON_CABLE_TECHNOLOGY 0x08fcU // Sicon Cable Technology Co., Ltd
#define UHS_VID_DIGIANSWER_AS 0x08fdU // Digianswer A/S
#define UHS_VID_AUTHENTEC 0x08ffU // AuthenTec, Inc.
#define UHS_VID_PINNACLE_SYSTEMS 0x0900U // Pinnacle Systems, Inc.
#define UHS_VID_VST_TECHNOLOGIES 0x0901U // VST Technologies
#define UHS_VID_FARADAY_TECHNOLOGY 0x0906U // Faraday Technology Corp.
#define UHS_VID_SIEMENS_AG 0x0908U // Siemens AG
#define UHS_VID_AUDIO_TECHNICA 0x0909U // Audio-Technica Corp.
#define UHS_VID_TRUMPION_MICROELECTRONICS 0x090aU // Trumpion Microelectronics, Inc.
#define UHS_VID_NEUROSMITH 0x090bU // Neurosmith
#define UHS_VID_SILICON_MOTION_INC__TAIWAN_FORMERLY_FEIYA_TECHNOLOGY 0x090cU // Silicon Motion, Inc. - Taiwan (formerly Feiya Technology Corp.)
#define UHS_VID_MULTIPORT_COMPUTER_VERTRIEBS 0x090dU // Multiport Computer Vertriebs GmbH
#define UHS_VID_SHINING_TECHNOLOGY 0x090eU // Shining Technology, Inc.
#define UHS_VID_FUJITSU_DEVICES 0x090fU // Fujitsu Devices, Inc.
#define UHS_VID_ALATION_SYSTEMS 0x0910U // Alation Systems, Inc.
#define UHS_VID_PHILIPS_SPEECH_PROCESSING 0x0911U // Philips Speech Processing
#define UHS_VID_VOQUETTE 0x0912U // Voquette, Inc.
#define UHS_VID_GLOBESPAN 0x0915U // GlobeSpan, Inc.
#define UHS_VID_SMARTDISK 0x0917U // SmartDisk Corp.
#define UHS_VID_TIGER_ELECTRONICS 0x0919U // Tiger Electronics
#define UHS_VID_GARMIN_INTERNATIONAL 0x091eU // Garmin International
#define UHS_VID_ECHELON 0x0920U // Echelon Co.
#define UHS_VID_GOHUBS 0x0921U // GoHubs, Inc.
#define UHS_VID_DYMO_COSTAR 0x0922U // Dymo-CoStar Corp.
#define UHS_VID_IC_MEDIA 0x0923U // IC Media Corp.
#define UHS_VID_XEROX 0x0924U // Xerox
#define UHS_VID_LAKEVIEW_RESEARCH 0x0925U // Lakeview Research
#define UHS_VID_SUMMUS 0x0927U // Summus, Ltd
#define UHS_VID_PLX_TECHNOLOGY_INC_FORMERLY_OXFORD_SEMICONDUCTOR 0x0928U // PLX Technology, Inc. (formerly Oxford Semiconductor, Ltd)
#define UHS_VID_AMERICAN_BIOMETRIC 0x0929U // American Biometric Co.
#define UHS_VID_TOSHIBA_INFORMATION_AND_INDUSTRIAL_SYS_AND_SERVICES 0x092aU // Toshiba Information & Industrial Sys. And Services
#define UHS_VID_SENA_TECHNOLOGIES 0x092bU // Sena Technologies, Inc.
#define UHS_VID_NORTHERN_EMBEDDED_SCIENCECAVNEX 0x092fU // Northern Embedded Science/CAVNEX
#define UHS_VID_TOSHIBA_1 0x0930U // Toshiba Corp.
#define UHS_VID_HARMONIC_DATA_SYSTEMS 0x0931U // Harmonic Data Systems, Ltd
#define UHS_VID_CRESCENTEC 0x0932U // Crescentec Corp.
#define UHS_VID_QUANTUM 0x0933U // Quantum Corp.
#define UHS_VID_SPIRENT_COMMUNICATIONS 0x0934U // Spirent Communications
#define UHS_VID_NUTESLA 0x0936U // NuTesla
#define UHS_VID_LUMBERG 0x0939U // Lumberg, Inc.
#define UHS_VID_PIXART_IMAGING 0x093aU // Pixart Imaging, Inc.
#define UHS_VID_PLEXTOR 0x093bU // Plextor Corp.
#define UHS_VID_INTREPID_CONTROL_SYSTEMS 0x093cU // Intrepid Control Systems, Inc.
#define UHS_VID_INNOSYNC 0x093dU // InnoSync, Inc.
#define UHS_VID_JST_MFG 0x093eU // J.S.T. Mfg. Co., Ltd
#define UHS_VID_OLYMPIA_TELECOM_VERTRIEBS 0x093fU // Olympia Telecom Vertriebs GmbH
#define UHS_VID_JAPAN_STORAGE_BATTERY 0x0940U // Japan Storage Battery Co., Ltd
#define UHS_VID_PHOTOBIT 0x0941U // Photobit Corp.
#define UHS_VID_I2GOCOM 0x0942U // i2Go.com, LLC
#define UHS_VID_HCL_TECHNOLOGIES_INDIA_PRIVATE 0x0943U // HCL Technologies India Private, Ltd
#define UHS_VID_KORG 0x0944U // KORG, Inc.
#define UHS_VID_PASCO_SCIENTIFIC 0x0945U // Pasco Scientific
#define UHS_VID_KRONAUER_MUSIC_IN_DIGITAL 0x0948U // Kronauer music in digital
#define UHS_VID_LINKUP_SYSTEMS 0x094bU // Linkup Systems Corp.
#define UHS_VID_CABLE_TELEVISION_LABORATORIES 0x094dU // Cable Television Laboratories
#define UHS_VID_YANO 0x094fU // Yano
#define UHS_VID_KINGSTON_TECHNOLOGY 0x0951U // Kingston Technology
#define UHS_VID_RPM_SYSTEMS 0x0954U // RPM Systems Corp.
#define UHS_VID_NVIDIA 0x0955U // NVidia Corp.
#define UHS_VID_BSQUARE 0x0956U // BSquare Corp.
#define UHS_VID_AGILENT_TECHNOLOGIES 0x0957U // Agilent Technologies, Inc.
#define UHS_VID_COMPULINK_RESEARCH 0x0958U // CompuLink Research, Inc.
#define UHS_VID_COLOGNE_CHIP_AG 0x0959U // Cologne Chip AG
#define UHS_VID_PORTSMITH 0x095aU // Portsmith
#define UHS_VID_MEDIALOGIC 0x095bU // Medialogic Corp.
#define UHS_VID_K_TEC_ELECTRONICS 0x095cU // K-Tec Electronics
#define UHS_VID_POLYCOM 0x095dU // Polycom, Inc.
#define UHS_VID_ACER_NEWEB 0x0967U // Acer NeWeb Corp.
#define UHS_VID_CATALYST_ENTERPRISES 0x0968U // Catalyst Enterprises, Inc.
#define UHS_VID_FEITIAN_TECHNOLOGIES 0x096eU // Feitian Technologies, Inc.
#define UHS_VID_GRETAG_MACBETH_AG 0x0971U // Gretag-Macbeth AG
#define UHS_VID_SCHLUMBERGER 0x0973U // Schlumberger
#define UHS_VID_DATAGRAPHIX_A_BUSINESS_UNIT_OF_ANACOMP 0x0974U // Datagraphix, a business unit of Anacomp
#define UHS_VID_OLE_COMMUNICATIONS 0x0975U // OL'E Communications, Inc.
#define UHS_VID_ADIRONDACK_WIRE_AND_CABLE 0x0976U // Adirondack Wire & Cable
#define UHS_VID_LIGHTSURF_TECHNOLOGIES 0x0977U // Lightsurf Technologies
#define UHS_VID_BECKHOFF 0x0978U // Beckhoff GmbH
#define UHS_VID_JEILIN_TECHNOLOGY 0x0979U // Jeilin Technology Corp., Ltd
#define UHS_VID_MINDS_AT_WORK 0x097aU // Minds At Work LLC
#define UHS_VID_KNUDSEN_ENGINEERING 0x097bU // Knudsen Engineering, Ltd
#define UHS_VID_MARUNIX 0x097cU // Marunix Co., Ltd
#define UHS_VID_ROSUN_TECHNOLOGIES 0x097dU // Rosun Technologies, Inc.
#define UHS_VID_BIOPAC_SYSTEMS 0x097eU // Biopac Systems Inc.
#define UHS_VID_BARUN_ELECTRONICS 0x097fU // Barun Electronics Co., Ltd
#define UHS_VID_OAK_TECHNOLOGY_1 0x0981U // Oak Technology, Ltd
#define UHS_VID_APRICORN 0x0984U // Apricorn
#define UHS_VID_CAB_PRODUKTTECHNIK_GMBH_AND_CO_KG 0x0985U // cab Produkttechnik GmbH & Co KG
#define UHS_VID_MATSUSHITA_ELECTRIC_WORKS 0x0986U // Matsushita Electric Works, Ltd.
#define UHS_VID_VITANA 0x098cU // Vitana Corp.
#define UHS_VID_INDESIGN 0x098dU // INDesign
#define UHS_VID_INTEGRATED_INTELLECTUAL_PROPERTY 0x098eU // Integrated Intellectual Property, Inc.
#define UHS_VID_KENWOOD_TMI 0x098fU // Kenwood TMI Corp.
#define UHS_VID_GEMSTAR_EBOOK_GROUP 0x0993U // Gemstar eBook Group, Ltd
#define UHS_VID_INTEGRATED_TELECOM_EXPRESS 0x0996U // Integrated Telecom Express, Inc.
#define UHS_VID_ZIPPY_TECHNOLOGY 0x099aU // Zippy Technology Corp.
#define UHS_VID_PAIRGAIN_TECHNOLOGIES 0x09a3U // PairGain Technologies
#define UHS_VID_CONTECH_RESEARCH 0x09a4U // Contech Research, Inc.
#define UHS_VID_VCON_TELECOMMUNICATIONS 0x09a5U // VCON Telecommunications
#define UHS_VID_POINCHIPS 0x09a6U // Poinchips
#define UHS_VID_DATA_TRANSMISSION_NETWORK 0x09a7U // Data Transmission Network Corp.
#define UHS_VID_LIN_SHIUNG_ENTERPRISE 0x09a8U // Lin Shiung Enterprise Co., Ltd
#define UHS_VID_SMART_CARD_TECHNOLOGIES 0x09a9U // Smart Card Technologies Co., Ltd
#define UHS_VID_INTERSIL 0x09aaU // Intersil Corp.
#define UHS_VID_JAPAN_CASH_MACHINE 0x09abU // Japan Cash Machine Co., Ltd.
#define UHS_VID_TRIPP_LITE 0x09aeU // Tripp Lite
#define UHS_VID_FRANKLIN_ELECTRONIC_PUBLISHERS 0x09b2U // Franklin Electronic Publishers, Inc.
#define UHS_VID_ALTIUS_SOLUTIONS 0x09b3U // Altius Solutions, Inc.
#define UHS_VID_MDS_TELEPHONE_SYSTEMS 0x09b4U // MDS Telephone Systems
#define UHS_VID_CELLTRIX_TECHNOLOGY 0x09b5U // Celltrix Technology Co., Ltd
#define UHS_VID_GRUNDIG 0x09bcU // Grundig
#define UHS_VID_MYSMARTCOM 0x09beU // MySmart.Com
#define UHS_VID_AUERSWALD_GMBH_AND_CO_KG 0x09bfU // Auerswald GmbH & Co. KG
#define UHS_VID_GENPIX_ELECTRONICS 0x09c0U // Genpix Electronics, LLC
#define UHS_VID_ARRIS_INTERACTIVE 0x09c1U // Arris Interactive LLC
#define UHS_VID_NISCA 0x09c2U // Nisca Corp.
#define UHS_VID_ACTIVCARD 0x09c3U // ActivCard, Inc.
#define UHS_VID_ACTISYS 0x09c4U // ACTiSYS Corp.
#define UHS_VID_MEMORY 0x09c5U // Memory Corp.
#define UHS_VID_BMC_MESSSYSTEME 0x09caU // BMC Messsysteme GmbH
#define UHS_VID_WORKBIT 0x09ccU // Workbit Corp.
#define UHS_VID_PSION_DACOM_HOME_NETWORKS 0x09cdU // Psion Dacom Home Networks, Ltd
#define UHS_VID_CITY_ELECTRONICS 0x09ceU // City Electronics, Ltd
#define UHS_VID_ELECTRONICS_TESTING_CENTER_TAIWAN 0x09cfU // Electronics Testing Center, Taiwan
#define UHS_VID_NEOMAGIC 0x09d1U // NeoMagic, Inc.
#define UHS_VID_VREELIN_ENGINEERING 0x09d2U // Vreelin Engineering, Inc.
#define UHS_VID_COM_ONE 0x09d3U // Com One
#define UHS_VID_NOVATEL_WIRELESS 0x09d7U // Novatel Wireless
#define UHS_VID_KRF_TECH 0x09d9U // KRF Tech, Ltd
#define UHS_VID_A4TECH 0x09daU // A4Tech Co., Ltd.
#define UHS_VID_MEASUREMENT_COMPUTING 0x09dbU // Measurement Computing Corp.
#define UHS_VID_AIMEX 0x09dcU // Aimex Corp.
#define UHS_VID_FELLOWES 0x09ddU // Fellowes, Inc.
#define UHS_VID_ADDONICS_TECHNOLOGIES 0x09dfU // Addonics Technologies Corp.
#define UHS_VID_INTELLON 0x09e1U // Intellon Corp.
#define UHS_VID_JO_DAN_INTERNATIONAL 0x09e5U // Jo-Dan International, Inc.
#define UHS_VID_SILUTIA 0x09e6U // Silutia, Inc.
#define UHS_VID_REAL_3D 0x09e7U // Real 3D, Inc.
#define UHS_VID_AKAI_PROFESSIONAL_MI 0x09e8U // AKAI  Professional M.I. Corp.
#define UHS_VID_CHEN_SOURCE 0x09e9U // Chen-Source, Inc.
#define UHS_VID_IM_NETWORKS 0x09ebU // IM Networks, Inc.
#define UHS_VID_XITEL 0x09efU // Xitel
#define UHS_VID_GOFLIGHT 0x09f3U // GoFlight, Inc.
#define UHS_VID_ARESCOM 0x09f5U // AresCom
#define UHS_VID_ROCKETCHIPS 0x09f6U // RocketChips, Inc.
#define UHS_VID_EDU_SCIENCE_HK 0x09f7U // Edu-Science (H.K.), Ltd
#define UHS_VID_SOFTCONNEX_TECHNOLOGIES 0x09f8U // SoftConnex Technologies, Inc.
#define UHS_VID_BAY_ASSOCIATES 0x09f9U // Bay Associates
#define UHS_VID_MTEK_VISION 0x09faU // Mtek Vision
#define UHS_VID_ALTERA_1 0x09fbU // Altera
#define UHS_VID_GAIN_TECHNOLOGY 0x09ffU // Gain Technology Corp.
#define UHS_VID_LIQUID_AUDIO 0x0a00U // Liquid Audio
#define UHS_VID_VIA 0x0a01U // ViA, Inc.
#define UHS_VID_UNKNOWN_MANUFACTURER 0x0a05U // Unknown Manufacturer
#define UHS_VID_ONTRAK_CONTROL_SYSTEMS 0x0a07U // Ontrak Control Systems Inc.
#define UHS_VID_CYBEX_COMPUTER_PRODUCTS 0x0a0bU // Cybex Computer Products Co.
#define UHS_VID_SERVERGY 0x0a0dU // Servergy, Inc
#define UHS_VID_XENTEC 0x0a11U // Xentec, Inc.
#define UHS_VID_CAMBRIDGE_SILICON_RADIO 0x0a12U // Cambridge Silicon Radio, Ltd
#define UHS_VID_TELEBYTE 0x0a13U // Telebyte, Inc.
#define UHS_VID_SPACELABS_MEDICAL 0x0a14U // Spacelabs Medical, Inc.
#define UHS_VID_SCALAR 0x0a15U // Scalar Corp.
#define UHS_VID_TREK_TECHNOLOGY_S_PTE 0x0a16U // Trek Technology (S) PTE, Ltd
#define UHS_VID_PENTAX 0x0a17U // Pentax Corp.
#define UHS_VID_HEIDELBERGER_DRUCKMASCHINEN_AG 0x0a18U // Heidelberger Druckmaschinen AG
#define UHS_VID_HUA_GENG_TECHNOLOGIES 0x0a19U // Hua Geng Technologies, Inc.
#define UHS_VID_MEDTRONIC_PHYSIO_CONTROL 0x0a21U // Medtronic Physio Control Corp.
#define UHS_VID_CENTURY_SEMICONDUCTOR_USA 0x0a22U // Century Semiconductor USA, Inc.
#define UHS_VID_DATACARD_GROUP 0x0a27U // Datacard Group
#define UHS_VID_AK_MODUL_BUS_COMPUTER 0x0a2cU // AK-Modul-Bus Computer GmbH
#define UHS_VID_TG3_ELECTRONICS 0x0a34U // TG3 Electronics, Inc.
#define UHS_VID_RADIKAL_TECHNOLOGIES 0x0a35U // Radikal Technologies
#define UHS_VID_GILAT_SATELLITE_NETWORKS 0x0a39U // Gilat Satellite Networks, Ltd
#define UHS_VID_PENTAMEDIA 0x0a3aU // PentaMedia Co., Ltd
#define UHS_VID_NTT_DOCOMO 0x0a3cU // NTT DoCoMo, Inc.
#define UHS_VID_VARO_VISION 0x0a3dU // Varo Vision
#define UHS_VID_SWISSONIC_AG 0x0a3fU // Swissonic AG
#define UHS_VID_BOCA_SYSTEMS 0x0a43U // Boca Systems, Inc.
#define UHS_VID_DAVICOM_SEMICONDUCTOR 0x0a46U // Davicom Semiconductor, Inc.
#define UHS_VID_HIROSE_ELECTRIC 0x0a47U // Hirose Electric
#define UHS_VID_IO_INTERCONNECT 0x0a48U // I/O Interconnect
#define UHS_VID_PLOYTEC 0x0a4aU // Ploytec GmbH
#define UHS_VID_FUJITSU_MEDIA_DEVICES 0x0a4bU // Fujitsu Media Devices, Ltd
#define UHS_VID_COMPUTEX 0x0a4cU // Computex Co., Ltd
#define UHS_VID_EVOLUTION_ELECTRONICS 0x0a4dU // Evolution Electronics, Ltd
#define UHS_VID_STEINBERG_SOFT_UND_HARDWARE 0x0a4eU // Steinberg Soft-und Hardware GmbH
#define UHS_VID_LITTON_SYSTEMS 0x0a4fU // Litton Systems, Inc.
#define UHS_VID_MIMAKI_ENGINEERING 0x0a50U // Mimaki Engineering Co., Ltd
#define UHS_VID_SONY_ELECTRONICS 0x0a51U // Sony Electronics, Inc.
#define UHS_VID_JEBSEE_ELECTRONICS 0x0a52U // Jebsee Electronics Co., Ltd
#define UHS_VID_PORTABLE_PERIPHERAL 0x0a53U // Portable Peripheral Co., Ltd
#define UHS_VID_ELECTRONICS_FOR_IMAGING 0x0a5aU // Electronics For Imaging, Inc.
#define UHS_VID_EASICS_NV 0x0a5bU // EAsics NV
#define UHS_VID_BROADCOM 0x0a5cU // Broadcom Corp.
#define UHS_VID_DIATREND 0x0a5dU // Diatrend Corp.
#define UHS_VID_ZEBRA 0x0a5fU // Zebra
#define UHS_VID_MPMAN 0x0a62U // MPMan
#define UHS_VID_CLEARCUBE_TECHNOLOGY 0x0a66U // ClearCube Technology
#define UHS_VID_MEDELI_ELECTRONICS 0x0a67U // Medeli Electronics Co., Ltd
#define UHS_VID_COMAIDE 0x0a68U // Comaide Corp.
#define UHS_VID_CHROMA_ATE 0x0a69U // Chroma ate, Inc.
#define UHS_VID_GREEN_HOUSE 0x0a6bU // Green House Co., Ltd
#define UHS_VID_INTEGRATED_CIRCUIT_SYSTEMS 0x0a6cU // Integrated Circuit Systems, Inc.
#define UHS_VID_UPS_MANUFACTURING 0x0a6dU // UPS Manufacturing
#define UHS_VID_BENWIN 0x0a6eU // Benwin
#define UHS_VID_CORE_TECHNOLOGY 0x0a6fU // Core Technology, Inc.
#define UHS_VID_INTERNATIONAL_GAME_TECHNOLOGY 0x0a70U // International Game Technology
#define UHS_VID_VIPCOLOR_TECHNOLOGIES_USA 0x0a71U // VIPColor Technologies USA, Inc.
#define UHS_VID_SANWA_DENSHI 0x0a72U // Sanwa Denshi
#define UHS_VID_MACKIE_DESIGNS 0x0a73U // Mackie Designs
#define UHS_VID_NSTL 0x0a7dU // NSTL, Inc.
#define UHS_VID_OCTAGON_SYSTEMS 0x0a7eU // Octagon Systems Corp.
#define UHS_VID_REXON_TECHNOLOGY 0x0a80U // Rexon Technology Corp., Ltd
#define UHS_VID_CHESEN_ELECTRONICS 0x0a81U // Chesen Electronics Corp.
#define UHS_VID_SYSCAN 0x0a82U // Syscan
#define UHS_VID_NEXTCOMM 0x0a83U // NextComm, Inc.
#define UHS_VID_MAUI_INNOVATIVE_PERIPHERALS 0x0a84U // Maui Innovative Peripherals
#define UHS_VID_IDEXX_LABS 0x0a85U // Idexx Labs
#define UHS_VID_NITGEN 0x0a86U // NITGen Co., Ltd
#define UHS_VID_AKTIV 0x0a89U // Aktiv
#define UHS_VID_PICTURETEL 0x0a8dU // Picturetel
#define UHS_VID_JAPAN_AVIATION_ELECTRONICS_INDUSTRY 0x0a8eU // Japan Aviation Electronics Industry, Ltd
#define UHS_VID_CANDY_TECHNOLOGY 0x0a90U // Candy Technology Co., Ltd
#define UHS_VID_GLOBLINK_TECHNOLOGY 0x0a91U // Globlink Technology, Inc.
#define UHS_VID_EGO_SYSTEMS 0x0a92U // EGO SYStems, Inc.
#define UHS_VID_C_TECHNOLOGIES 0x0a93U // C Technologies AB
#define UHS_VID_INTERSENSE 0x0a94U // Intersense
#define UHS_VID_LAVA_COMPUTER_MFG 0x0aa3U // Lava Computer Mfg., Inc.
#define UHS_VID_DEVELCO_ELEKTRONIK 0x0aa4U // Develco Elektronik
#define UHS_VID_FIRST_INTERNATIONAL_DIGITAL 0x0aa5U // First International Digital
#define UHS_VID_PERCEPTION_DIGITAL 0x0aa6U // Perception Digital, Ltd
#define UHS_VID_WINCOR_NIXDORF_INTERNATIONAL 0x0aa7U // Wincor Nixdorf International GmbH
#define UHS_VID_TRIGEM_COMPUTER 0x0aa8U // TriGem Computer, Inc.
#define UHS_VID_BAROMTEC 0x0aa9U // Baromtec Co.
#define UHS_VID_JAPAN_CBM 0x0aaaU // Japan CBM Corp.
#define UHS_VID_VISION_SHAPE_EUROPE 0x0aabU // Vision Shape Europe SA
#define UHS_VID_ICOMPRESSION 0x0aacU // iCompression, Inc.
#define UHS_VID_ROHDE_AND_SCHWARZ_GMBH_AND_CO_KG 0x0aadU // Rohde & Schwarz GmbH & Co. KG
#define UHS_VID_NEC_INFRONTIA_CORP_NITSUKO 0x0aaeU // NEC infrontia Corp. (Nitsuko)
#define UHS_VID_DIGITALWAY 0x0aafU // Digitalway Co., Ltd
#define UHS_VID_ARROW_STRONG_ELECTRONICS 0x0ab0U // Arrow Strong Electronics Co., Ltd
#define UHS_VID_FEIG_ELECTRONIC 0x0ab1U // FEIG ELECTRONIC GmbH
#define UHS_VID_ELLISYS 0x0abaU // Ellisys
#define UHS_VID_STEREO_LINK 0x0abeU // Stereo-Link
#define UHS_VID_DIOLAN 0x0abfU // Diolan
#define UHS_VID_SANYO_SEMICONDUCTOR_COMPANY_MICRO 0x0ac3U // Sanyo Semiconductor Company Micro
#define UHS_VID_LECO 0x0ac4U // Leco Corp.
#define UHS_VID_I_AND_C 0x0ac5U // I & C Corp.
#define UHS_VID_SINGING_ELECTRONS 0x0ac6U // Singing Electrons, Inc.
#define UHS_VID_PANWEST 0x0ac7U // Panwest Corp.
#define UHS_VID_Z_STAR_MICROELECTRONICS 0x0ac8U // Z-Star Microelectronics Corp.
#define UHS_VID_MICRO_SOLUTIONS 0x0ac9U // Micro Solutions, Inc.
#define UHS_VID_OPEN_NETWORKS 0x0acaU // OPEN Networks Ltd
#define UHS_VID_KOGA_ELECTRONICS 0x0accU // Koga Electronics Co.
#define UHS_VID_ID_TECH 0x0acdU // ID Tech
#define UHS_VID_ZYDAS 0x0aceU // ZyDAS
#define UHS_VID_INTOTO 0x0acfU // Intoto, Inc.
#define UHS_VID_INTELLIX 0x0ad0U // Intellix Corp.
#define UHS_VID_REMOTEC_TECHNOLOGY 0x0ad1U // Remotec Technology, Ltd
#define UHS_VID_SERVICE_AND_QUALITY_TECHNOLOGY 0x0ad2U // Service & Quality Technology Co., Ltd
#define UHS_VID_DATA_ENCRYPTION_SYSTEMS 0x0adaU // Data Encryption Systems Ltd.
#define UHS_VID_ALLION_COMPUTER 0x0ae3U // Allion Computer, Inc.
#define UHS_VID_TAITO 0x0ae4U // Taito Corp.
#define UHS_VID_NEODYM_SYSTEMS 0x0ae7U // Neodym Systems, Inc.
#define UHS_VID_SYSTEM_SUPPORT 0x0ae8U // System Support Co., Ltd
#define UHS_VID_NORTH_SHORE_CIRCUIT_DESIGN_LLP 0x0ae9U // North Shore Circuit Design L.L.P.
#define UHS_VID_SCIESSENCE 0x0aeaU // SciEssence, LLC
#define UHS_VID_TTP_COMMUNICATIONS 0x0aebU // TTP Communications, Ltd
#define UHS_VID_NEODIO_TECHNOLOGIES 0x0aecU // Neodio Technologies Corp.
#define UHS_VID_OPTION 0x0af0U // Option
#define UHS_VID_SILVER_I 0x0af6U // Silver I Co., Ltd
#define UHS_VID_B2C2 0x0af7U // B2C2, Inc.
#define UHS_VID_HAMA 0x0af9U // Hama, Inc.
#define UHS_VID_DMC 0x0afaU // DMC Co., Ltd.
#define UHS_VID_ZAPTRONIX 0x0afcU // Zaptronix Ltd
#define UHS_VID_TATENO_DENNOU 0x0afdU // Tateno Dennou, Inc.
#define UHS_VID_CUMMINS_ENGINE 0x0afeU // Cummins Engine Co.
#define UHS_VID_JUMP_ZONE_NETWORK_PRODUCTS 0x0affU // Jump Zone Network Products, Inc.
#define UHS_VID_INGENICO 0x0b00U // INGENICO
#define UHS_VID_ASUSTEK_COMPUTER 0x0b05U // ASUSTek Computer, Inc.
#define UHS_VID_DATAMAX_ONEIL 0x0b0bU // Datamax-O'Neil
#define UHS_VID_TODOS 0x0b0cU // Todos AB
#define UHS_VID_PROJECTLAB 0x0b0dU // ProjectLab
#define UHS_VID_GN_NETCOM 0x0b0eU // GN Netcom
#define UHS_VID_AVID_TECHNOLOGY 0x0b0fU // AVID Technology
#define UHS_VID_PCALLY 0x0b10U // Pcally
#define UHS_VID_I_TECH_SOLUTIONS 0x0b11U // I Tech Solutions Co., Ltd
#define UHS_VID_ELECTRONIC_WARFARE_ASSOC_INC_EWA 0x0b1eU // Electronic Warfare Assoc., Inc. (EWA)
#define UHS_VID_INSYDE_SOFTWARE 0x0b1fU // Insyde Software Corp.
#define UHS_VID_TRANSDIMENSION 0x0b20U // TransDimension, Inc.
#define UHS_VID_YOKOGAWA_ELECTRIC 0x0b21U // Yokogawa Electric Corp.
#define UHS_VID_JAPAN_SYSTEM_DEVELOPMENT 0x0b22U // Japan System Development Co., Ltd
#define UHS_VID_PAN_ASIA_ELECTRONICS 0x0b23U // Pan-Asia Electronics Co., Ltd
#define UHS_VID_LINK_EVOLUTION 0x0b24U // Link Evolution Corp.
#define UHS_VID_RITEK 0x0b27U // Ritek Corp.
#define UHS_VID_KENWOOD 0x0b28U // Kenwood Corp.
#define UHS_VID_VILLAGE_CENTER 0x0b2cU // Village Center, Inc.
#define UHS_VID_PNY_TECHNOLOGIES 0x0b30U // PNY Technologies, Inc.
#define UHS_VID_CONTOUR_DESIGN 0x0b33U // Contour Design, Inc.
#define UHS_VID_HITACHI_ULSI_SYSTEMS 0x0b37U // Hitachi ULSI Systems Co., Ltd
#define UHS_VID_GEAR_HEAD 0x0b38U // Gear Head
#define UHS_VID_OMNIDIRECTIONAL_CONTROL_TECHNOLOGY 0x0b39U // Omnidirectional Control Technology, Inc.
#define UHS_VID_IPAXESS 0x0b3aU // IPaxess
#define UHS_VID_TEKRAM_TECHNOLOGY 0x0b3bU // Tekram Technology Co., Ltd
#define UHS_VID_OLIVETTI_TECHCENTER 0x0b3cU // Olivetti Techcenter
#define UHS_VID_KIKUSUI_ELECTRONICS 0x0b3eU // Kikusui Electronics Corp.
#define UHS_VID_HAL 0x0b41U // Hal Corp.
#define UHS_VID_PLAYCOM 0x0b43U // Play.com, Inc.
#define UHS_VID_SPORTBUGCOM 0x0b47U // Sportbug.com, Inc.
#define UHS_VID_TECHNOTREND_AG 0x0b48U // TechnoTrend AG
#define UHS_VID_ASCII 0x0b49U // ASCII Corp.
#define UHS_VID_PINE 0x0b4bU // Pine Corp. Ltd.
#define UHS_VID_GRAPHTEC_AMERICA 0x0b4dU // Graphtec America, Inc.
#define UHS_VID_MUSICAL_ELECTRONICS 0x0b4eU // Musical Electronics, Ltd
#define UHS_VID_DUMPRIES 0x0b50U // Dumpries Co., Ltd
#define UHS_VID_COMFORT_KEYBOARD 0x0b51U // Comfort Keyboard Co.
#define UHS_VID_COLORADO_MICRODISPLAY 0x0b52U // Colorado MicroDisplay, Inc.
#define UHS_VID_SINBON_ELECTRONICS 0x0b54U // Sinbon Electronics Co., Ltd
#define UHS_VID_TYI_SYSTEMS 0x0b56U // TYI Systems, Ltd
#define UHS_VID_BEIJING_HANWANGTECHNOLOGY 0x0b57U // Beijing HanwangTechnology Co., Ltd
#define UHS_VID_LAKE_COMMUNICATIONS 0x0b59U // Lake Communications, Ltd
#define UHS_VID_COREL 0x0b5aU // Corel Corp.
#define UHS_VID_GREEN_ELECTRONICS 0x0b5fU // Green Electronics Co., Ltd
#define UHS_VID_NSINE 0x0b60U // Nsine, Ltd
#define UHS_VID_NEC_VIEWTECHNOLOGY 0x0b61U // NEC Viewtechnology, Ltd
#define UHS_VID_ORANGE_MICRO 0x0b62U // Orange Micro, Inc.
#define UHS_VID_ADLINK_TECHNOLOGY 0x0b63U // ADLink Technology, Inc.
#define UHS_VID_WONDERFUL_WIRE_CABLE 0x0b64U // Wonderful Wire Cable Co., Ltd
#define UHS_VID_EXPERT_MAGNETICS 0x0b65U // Expert Magnetics Corp.
#define UHS_VID_CYBIKO 0x0b66U // Cybiko Inc.
#define UHS_VID_FAIRBANKS_SCALES 0x0b67U // Fairbanks Scales
#define UHS_VID_CACHEVISION 0x0b69U // CacheVision
#define UHS_VID_MAXIM_INTEGRATED_PRODUCTS 0x0b6aU // Maxim Integrated Products
#define UHS_VID_NAGANO_JAPAN_RADIO 0x0b6fU // Nagano Japan Radio Co., Ltd
#define UHS_VID_PORTALPLAYER 0x0b70U // PortalPlayer, Inc.
#define UHS_VID_SHIN_EI_SANGYO 0x0b71U // SHIN-EI Sangyo Co., Ltd
#define UHS_VID_EMBEDDED_WIRELESS_TECHNOLOGY 0x0b72U // Embedded Wireless Technology Co., Ltd
#define UHS_VID_COMPUTONE 0x0b73U // Computone Corp.
#define UHS_VID_ROLAND_DG 0x0b75U // Roland DG Corp.
#define UHS_VID_SUNRISE_TELECOM 0x0b79U // Sunrise Telecom, Inc.
#define UHS_VID_ZEEVO 0x0b7aU // Zeevo, Inc.
#define UHS_VID_TAIKO_DENKI 0x0b7bU // Taiko Denki Co., Ltd
#define UHS_VID_ITRAN_COMMUNICATIONS 0x0b7cU // ITRAN Communications, Ltd
#define UHS_VID_ASTRODESIGN 0x0b7dU // Astrodesign, Inc.
#define UHS_VID_ID3_TECHNOLOGIES 0x0b81U // id3 Technologies
#define UHS_VID_REXTRON_TECHNOLOGY 0x0b84U // Rextron Technology, Inc.
#define UHS_VID_ELKAT_ELECTRONICS_SDN_BHD 0x0b85U // Elkat Electronics, Sdn., Bhd.
#define UHS_VID_EXPUTER_SYSTEMS 0x0b86U // Exputer Systems, Inc.
#define UHS_VID_PLUS_ONE_I_AND_T 0x0b87U // Plus-One I & T, Inc.
#define UHS_VID_SIGMA_KOKI_CO_LTD_TECHNOLOGY_CENTER 0x0b88U // Sigma Koki Co., Ltd, Technology Center
#define UHS_VID_ADVANCED_DIGITAL_BROADCAST 0x0b89U // Advanced Digital Broadcast, Ltd
#define UHS_VID_SMART_TECHNOLOGIES 0x0b8cU // SMART Technologies Inc.
#define UHS_VID_ASIX_ELECTRONICS 0x0b95U // ASIX Electronics Corp.
#define UHS_VID_SEWON_TELECOM 0x0b96U // Sewon Telecom
#define UHS_VID_O2_MICRO 0x0b97U // O2 Micro, Inc.
#define UHS_VID_PLAYMATES_TOYS 0x0b98U // Playmates Toys, Inc.
#define UHS_VID_AUDIO_INTERNATIONAL 0x0b99U // Audio International, Inc.
#define UHS_VID_DIPL_ING_STEFAN_KUNDE 0x0b9bU // Dipl.-Ing. Stefan Kunde
#define UHS_VID_SOFTPROTEC 0x0b9dU // Softprotec Co.
#define UHS_VID_CHIPPO_TECHNOLOGIES 0x0b9fU // Chippo Technologies
#define UHS_VID_US_ROBOTICS 0x0bafU // U.S. Robotics
#define UHS_VID_CONCORD_CAMERA 0x0bb0U // Concord Camera Corp.
#define UHS_VID_INFINILINK 0x0bb1U // Infinilink Corp.
#define UHS_VID_AMBIT_MICROSYSTEMS 0x0bb2U // Ambit Microsystems Corp.
#define UHS_VID_OFUJI_TECHNOLOGY 0x0bb3U // Ofuji Technology
#define UHS_VID_HTC_HIGH_TECH_COMPUTER 0x0bb4U // HTC (High Tech Computer Corp.)
#define UHS_VID_MURATA_MANUFACTURING 0x0bb5U // Murata Manufacturing Co., Ltd
#define UHS_VID_NETWORK_ALCHEMY 0x0bb6U // Network Alchemy
#define UHS_VID_JOYTECH_COMPUTER 0x0bb7U // Joytech Computer Co., Ltd
#define UHS_VID_HITACHI_SEMICONDUCTOR_AND_DEVICES_SALES 0x0bb8U // Hitachi Semiconductor and Devices Sales Co., Ltd
#define UHS_VID_EIGER_MANDC 0x0bb9U // Eiger M&C Co., Ltd
#define UHS_VID_ZACCESS_SYSTEMS 0x0bbaU // ZAccess Systems
#define UHS_VID_GENERAL_METERS 0x0bbbU // General Meters Corp.
#define UHS_VID_ASSISTIVE_TECHNOLOGY 0x0bbcU // Assistive Technology, Inc.
#define UHS_VID_SYSTEM_CONNECTION 0x0bbdU // System Connection, Inc.
#define UHS_VID_KNILINK_TECHNOLOGY 0x0bc0U // Knilink Technology, Inc.
#define UHS_VID_FUW_YNG_ELECTRONICS 0x0bc1U // Fuw Yng Electronics Co., Ltd
#define UHS_VID_SEAGATE_RSS 0x0bc2U // Seagate RSS LLC
#define UHS_VID_IPWIRELESS 0x0bc3U // IPWireless, Inc.
#define UHS_VID_MICROCUBE 0x0bc4U // Microcube Corp.
#define UHS_VID_JCN 0x0bc5U // JCN Co., Ltd
#define UHS_VID_EXWAY 0x0bc6U // ExWAY, Inc.
#define UHS_VID_X10_WIRELESS_TECHNOLOGY 0x0bc7U // X10 Wireless Technology, Inc.
#define UHS_VID_TELMAX_COMMUNICATIONS 0x0bc8U // Telmax Communications
#define UHS_VID_ECI_TELECOM 0x0bc9U // ECI Telecom, Ltd
#define UHS_VID_STARTEK_ENGINEERING 0x0bcaU // Startek Engineering, Inc.
#define UHS_VID_PERFECT_TECHNIC_ENTERPRISE 0x0bcbU // Perfect Technic Enterprise Co., Ltd
#define UHS_VID_ANDREW_PARGETER_AND_ASSOCIATES 0x0bd7U // Andrew Pargeter & Associates
#define UHS_VID_REALTEK_SEMICONDUCTOR 0x0bdaU // Realtek Semiconductor Corp.
#define UHS_VID_ERICSSON_BUSINESS_MOBILE_NETWORKS_BV 0x0bdbU // Ericsson Business Mobile Networks BV
#define UHS_VID_Y_MEDIA 0x0bdcU // Y Media Corp.
#define UHS_VID_ORANGE_PCS 0x0bddU // Orange PCS
#define UHS_VID_KANDA_TSUSHIN_KOGYO 0x0be2U // Kanda Tsushin Kogyo Co., Ltd
#define UHS_VID_TOYO 0x0be3U // TOYO Corp.
#define UHS_VID_ELKA_INTERNATIONAL 0x0be4U // Elka International, Ltd
#define UHS_VID_DOME_IMAGING_SYSTEMS 0x0be5U // DOME imaging systems, Inc.
#define UHS_VID_DONG_GUAN_HUMEN_WONDERFUL_WIRE_CABLE_FACTORY 0x0be6U // Dong Guan Humen Wonderful Wire Cable Factory
#define UHS_VID_MEI 0x0bedU // MEI
#define UHS_VID_LTK_INDUSTRIES 0x0beeU // LTK Industries, Ltd
#define UHS_VID_WAY2CALL_COMMUNICATIONS 0x0befU // Way2Call Communications
#define UHS_VID_PACE_MICRO_TECHNOLOGY_PLC 0x0bf0U // Pace Micro Technology PLC
#define UHS_VID_INTRACOM 0x0bf1U // Intracom S.A.
#define UHS_VID_KONEXX 0x0bf2U // Konexx
#define UHS_VID_ADDONICS_TECHNOLOGIES_1 0x0bf6U // Addonics Technologies, Inc.
#define UHS_VID_SUNNY_GIKEN 0x0bf7U // Sunny Giken, Inc.
#define UHS_VID_FUJITSU_SIEMENS_COMPUTERS_1 0x0bf8U // Fujitsu Siemens Computers
#define UHS_VID_KVASER 0x0bfdU // Kvaser AB
#define UHS_VID_MOTO_DEVELOPMENT_GROUP 0x0c04U // MOTO Development Group, Inc.
#define UHS_VID_APPIAN_GRAPHICS 0x0c05U // Appian Graphics
#define UHS_VID_HASBRO_GAMES 0x0c06U // Hasbro Games, Inc.
#define UHS_VID_INFINITE_DATA_STORAGE 0x0c07U // Infinite Data Storage, Ltd
#define UHS_VID_AGATE 0x0c08U // Agate
#define UHS_VID_COMJET_INFORMATION_SYSTEM 0x0c09U // Comjet Information System
#define UHS_VID_HIGHPOINT_TECHNOLOGIES 0x0c0aU // Highpoint Technologies, Inc.
#define UHS_VID_DURA_MICRO_INC_ACOMDATA 0x0c0bU // Dura Micro, Inc. (Acomdata)
#define UHS_VID_ZEROPLUS 0x0c12U // Zeroplus
#define UHS_VID_IRIS_GRAPHICS 0x0c15U // Iris Graphics
#define UHS_VID_GYRATION 0x0c16U // Gyration, Inc.
#define UHS_VID_CYBERBOARD_AS 0x0c17U // Cyberboard A/S
#define UHS_VID_SYNERTEK_KOREA 0x0c18U // SynerTek Korea, Inc.
#define UHS_VID_CYBERPIXIE 0x0c19U // cyberPIXIE, Inc.
#define UHS_VID_SILICON_MOTION 0x0c1aU // Silicon Motion, Inc.
#define UHS_VID_MIPS_TECHNOLOGIES 0x0c1bU // MIPS Technologies
#define UHS_VID_HANG_ZHOU_SILAN_ELECTRONICS 0x0c1cU // Hang Zhou Silan Electronics Co., Ltd
#define UHS_VID_TALLY_PRINTER 0x0c22U // Tally Printer Corp.
#define UHS_VID_LERNOUT__HAUSPIE 0x0c23U // Lernout + Hauspie
#define UHS_VID_TAIYO_YUDEN 0x0c24U // Taiyo Yuden
#define UHS_VID_SAMPO 0x0c25U // Sampo Corp.
#define UHS_VID_PROLIFIC_TECHNOLOGY_1 0x0c26U // Prolific Technology Inc.
#define UHS_VID_RFIDEAS 0x0c27U // RFIDeas, Inc
#define UHS_VID_METROLOGIC_INSTRUMENTS 0x0c2eU // Metrologic Instruments
#define UHS_VID_EAGLETRON 0x0c35U // Eagletron, Inc.
#define UHS_VID_E_INK 0x0c36U // E Ink Corp.
#define UHS_VID_EDIGITAL 0x0c37U // e.Digital
#define UHS_VID_DER_AN_ELECTRIC_WIRE_AND_CABLE 0x0c38U // Der An Electric Wire & Cable Co., Ltd
#define UHS_VID_IFR 0x0c39U // IFR
#define UHS_VID_FURUI_PRECISE_COMPONENT_KUNSHAN 0x0c3aU // Furui Precise Component (Kunshan) Co., Ltd
#define UHS_VID_KOMATSU 0x0c3bU // Komatsu, Ltd
#define UHS_VID_RADIUS 0x0c3cU // Radius Co., Ltd
#define UHS_VID_INNOCOM 0x0c3dU // Innocom, Inc.
#define UHS_VID_NEXTCELL 0x0c3eU // Nextcell, Inc.
#define UHS_VID_MOTOROLA_IDEN 0x0c44U // Motorola iDEN
#define UHS_VID_MICRODIA 0x0c45U // Microdia
#define UHS_VID_WAVERIDER_COMMUNICATIONS 0x0c46U // WaveRider Communications, Inc.
#define UHS_VID_ALGE_TIMING 0x0c4aU // ALGE-TIMING GmbH
#define UHS_VID_REINER_SCT_KARTENSYSTEME 0x0c4bU // Reiner SCT Kartensysteme GmbH
#define UHS_VID_NEEDHAMS_ELECTRONICS 0x0c4cU // Needham's Electronics
#define UHS_VID_SEALEVEL_SYSTEMS 0x0c52U // Sealevel Systems, Inc.
#define UHS_VID_VIEWPLUS 0x0c53U // ViewPLUS, Inc.
#define UHS_VID_GLORY 0x0c54U // Glory, Ltd
#define UHS_VID_SPECTRUM_DIGITAL 0x0c55U // Spectrum Digital, Inc.
#define UHS_VID_BILLION_BRIGHT 0x0c56U // Billion Bright, Ltd
#define UHS_VID_IMAGINATIVE_DESIGN_OPERATION 0x0c57U // Imaginative Design Operation Co., Ltd
#define UHS_VID_VIDAR_SYSTEMS 0x0c58U // Vidar Systems Corp.
#define UHS_VID_DONG_GUAN_SHINKO_WIRE 0x0c59U // Dong Guan Shinko Wire Co., Ltd
#define UHS_VID_TRS_INTERNATIONAL_MFG 0x0c5aU // TRS International Mfg., Inc.
#define UHS_VID_XYTRONIX_RESEARCH_AND_DESIGN 0x0c5eU // Xytronix Research & Design
#define UHS_VID_APOGEE_ELECTRONICS 0x0c60U // Apogee Electronics Corp.
#define UHS_VID_CHANT_SINCERE 0x0c62U // Chant Sincere Co., Ltd
#define UHS_VID_TOKO 0x0c63U // Toko, Inc.
#define UHS_VID_SIGNALITY_SYSTEM_ENGINEERING 0x0c64U // Signality System Engineering Co., Ltd
#define UHS_VID_EMINENCE_ENTERPRISE 0x0c65U // Eminence Enterprise Co., Ltd
#define UHS_VID_REXON_ELECTRONICS 0x0c66U // Rexon Electronics Corp.
#define UHS_VID_CONCEPT_TELECOM 0x0c67U // Concept Telecom, Ltd
#define UHS_VID_ACS 0x0c6aU // ACS
#define UHS_VID_JETI_TECHNISCHE_INSTRUMENTE 0x0c6cU // JETI Technische Instrumente GmbH
#define UHS_VID_MCT_ELEKTRONIKLADEN 0x0c70U // MCT Elektronikladen
#define UHS_VID_PEAK_SYSTEM 0x0c72U // PEAK System
#define UHS_VID_OPTRONIC_LABORATORIES 0x0c74U // Optronic Laboratories Inc.
#define UHS_VID_JMTEK 0x0c76U // JMTek, LLC.
#define UHS_VID_SIPIX_GROUP 0x0c77U // Sipix Group, Ltd
#define UHS_VID_DETTO 0x0c78U // Detto Corp.
#define UHS_VID_NUCONNEX_TECHNOLOGIES_PTE 0x0c79U // NuConnex Technologies Pte., Ltd
#define UHS_VID_WING_SPAN_ENTERPRISE 0x0c7aU // Wing-Span Enterprise Co., Ltd
#define UHS_VID_NDA_TECHNOLOGIES 0x0c86U // NDA Technologies, Inc.
#define UHS_VID_KYOCERA_WIRELESS 0x0c88U // Kyocera Wireless Corp.
#define UHS_VID_HONDA_TSUSHIN_KOGYO 0x0c89U // Honda Tsushin Kogyo Co., Ltd
#define UHS_VID_PATHWAY_CONNECTIVITY 0x0c8aU // Pathway Connectivity, Inc.
#define UHS_VID_WAVEFLY 0x0c8bU // Wavefly Corp.
#define UHS_VID_COACTIVE_NETWORKS 0x0c8cU // Coactive Networks
#define UHS_VID_TEMPO 0x0c8dU // Tempo
#define UHS_VID_CESSCOM 0x0c8eU // Cesscom Co., Ltd
#define UHS_VID_APPLIED_MICROSYSTEMS 0x0c8fU // Applied Microsystems
#define UHS_VID_CRYPTERA 0x0c94U // Cryptera
#define UHS_VID_BERKSHIRE_PRODUCTS 0x0c98U // Berkshire Products, Inc.
#define UHS_VID_INNOCHIPS 0x0c99U // Innochips Co., Ltd
#define UHS_VID_HANWOOL_ROBOTICS 0x0c9aU // Hanwool Robotics Corp.
#define UHS_VID_JOBIN_YVON 0x0c9bU // Jobin Yvon, Inc.
#define UHS_VID_SEMTEK 0x0c9dU // SemTek
#define UHS_VID_ZYFER 0x0ca2U // Zyfer
#define UHS_VID_SEGA 0x0ca3U // Sega Corp.
#define UHS_VID_STANDT_INSTRUMENT 0x0ca4U // ST&T Instrument Corp.
#define UHS_VID_BAE_SYSTEMS_CANADA 0x0ca5U // BAE Systems Canada, Inc.
#define UHS_VID_CASTLES_TECHNOLOGY 0x0ca6U // Castles Technology Co., Ltd
#define UHS_VID_INFORMATION_SYSTEMS_LABORATORIES 0x0ca7U // Information Systems Laboratories
#define UHS_VID_MOTOROLA_CGISS 0x0cadU // Motorola CGISS
#define UHS_VID_ASCOM_BUSINESS_SYSTEMS 0x0caeU // Ascom Business Systems, Ltd
#define UHS_VID_BUSLINK 0x0cafU // Buslink
#define UHS_VID_FLYING_PIG_SYSTEMS 0x0cb0U // Flying Pig Systems
#define UHS_VID_INNOVONICS 0x0cb1U // Innovonics, Inc.
#define UHS_VID_CELESTIX_NETWORKS_PTE 0x0cb6U // Celestix Networks, Pte., Ltd
#define UHS_VID_SINGATRON_ENTERPRISE 0x0cb7U // Singatron Enterprise Co., Ltd
#define UHS_VID_OPTICIS 0x0cb8U // Opticis Co., Ltd
#define UHS_VID_TRUST_ELECTRONIC_SHANGHAI 0x0cbaU // Trust Electronic (Shanghai) Co., Ltd
#define UHS_VID_SHANGHAI_DARONG_ELECTRONICS 0x0cbbU // Shanghai Darong Electronics Co., Ltd
#define UHS_VID_PALMAX_TECHNOLOGY 0x0cbcU // Palmax Technology Co., Ltd
#define UHS_VID_PENTEL_CO_LTD_ELECTRONICS_EQUIPMENT_DIV 0x0cbdU // Pentel Co., Ltd (Electronics Equipment Div.)
#define UHS_VID_KERYX_TECHNOLOGIES 0x0cbeU // Keryx Technologies, Inc.
#define UHS_VID_UNION_GENIUS_COMPUTER 0x0cbfU // Union Genius Computer Co., Ltd
#define UHS_VID_KUON_YI_INDUSTRIAL 0x0cc0U // Kuon Yi Industrial Corp.
#define UHS_VID_GIVEN_IMAGING 0x0cc1U // Given Imaging, Ltd
#define UHS_VID_TIMEX 0x0cc2U // Timex Corp.
#define UHS_VID_RIMAGE 0x0cc3U // Rimage Corp.
#define UHS_VID_EMSYS 0x0cc4U // emsys GmbH
#define UHS_VID_SENDO 0x0cc5U // Sendo
#define UHS_VID_INTERMAGIC 0x0cc6U // Intermagic Corp.
#define UHS_VID_KONTRON_MEDICAL_AG 0x0cc7U // Kontron Medical AG
#define UHS_VID_TECHNOTOOLS 0x0cc8U // Technotools Corp.
#define UHS_VID_BROADMAX_TECHNOLOGIES 0x0cc9U // BroadMAX Technologies, Inc.
#define UHS_VID_AMPHENOL 0x0ccaU // Amphenol
#define UHS_VID_SKNET 0x0ccbU // SKNet Co., Ltd
#define UHS_VID_DOMEX_TECHNOLOGY 0x0cccU // Domex Technology Corp.
#define UHS_VID_TERRATEC_ELECTRONIC 0x0ccdU // TerraTec Electronic GmbH
#define UHS_VID_BANG_OLUFSEN 0x0cd4U // Bang Olufsen
#define UHS_VID_LABJACK_CORPORATION 0x0cd5U // LabJack Corporation
#define UHS_VID_NEWCHIP_SRL 0x0cd7U // NewChip S.r.l.
#define UHS_VID_JS_DIGITECH 0x0cd8U // JS Digitech, Inc.
#define UHS_VID_HITACHI_SHIN_DIN_CABLE 0x0cd9U // Hitachi Shin Din Cable, Ltd
#define UHS_VID_Z_COM 0x0cdeU // Z-Com
#define UHS_VID_VALIDATION_TECHNOLOGIES_INTERNATIONAL 0x0ce5U // Validation Technologies International
#define UHS_VID_PICO_TECHNOLOGY 0x0ce9U // Pico Technology
#define UHS_VID_E_CONN_ELECTRONIC 0x0cf1U // e-Conn Electronic Co., Ltd
#define UHS_VID_ENE_TECHNOLOGY 0x0cf2U // ENE Technology, Inc.
#define UHS_VID_ATHEROS_COMMUNICATIONS 0x0cf3U // Atheros Communications, Inc.
#define UHS_VID_FOMTEX 0x0cf4U // Fomtex Corp.
#define UHS_VID_CELLINK 0x0cf5U // Cellink Co., Ltd
#define UHS_VID_COMPUCABLE 0x0cf6U // Compucable Corp.
#define UHS_VID_ISHONI_NETWORKS 0x0cf7U // ishoni Networks
#define UHS_VID_CLARISYS 0x0cf8U // Clarisys, Inc.
#define UHS_VID_CENTRAL_SYSTEM_RESEARCH 0x0cf9U // Central System Research Co., Ltd
#define UHS_VID_INVISO 0x0cfaU // Inviso, Inc.
#define UHS_VID_MINOLTA_QMS 0x0cfcU // Minolta-QMS, Inc.
#define UHS_VID_SAFA_MEDIA 0x0cffU // SAFA MEDIA Co., Ltd.
#define UHS_VID_TELOS_EDV_SYSTEMENTWICKLUNG 0x0d06U // telos EDV Systementwicklung GmbH
#define UHS_VID_UTSTARCOM 0x0d08U // UTStarcom
#define UHS_VID_CONTEMPORARY_CONTROLS 0x0d0bU // Contemporary Controls
#define UHS_VID_ASTRON_ELECTRONICS 0x0d0cU // Astron Electronics Co., Ltd
#define UHS_VID_MKNET 0x0d0dU // MKNet Corp.
#define UHS_VID_HYBRID_NETWORKS 0x0d0eU // Hybrid Networks, Inc.
#define UHS_VID_FENG_SHIN_CABLE 0x0d0fU // Feng Shin Cable Co., Ltd
#define UHS_VID_ELASTIC_NETWORKS 0x0d10U // Elastic Networks
#define UHS_VID_MASPRO_DENKOH 0x0d11U // Maspro Denkoh Corp.
#define UHS_VID_HANSOL_ELECTRONICS 0x0d12U // Hansol Electronics, Inc.
#define UHS_VID_BMF 0x0d13U // BMF Corp.
#define UHS_VID_ARRAY_COMM 0x0d14U // Array Comm, Inc.
#define UHS_VID_ONSTREAM_BV 0x0d15U // OnStream b.v.
#define UHS_VID_HI_TOUCH_IMAGING_TECHNOLOGIES 0x0d16U // Hi-Touch Imaging Technologies Co., Ltd
#define UHS_VID_NALTEC 0x0d17U // NALTEC, Inc.
#define UHS_VID_COAXMEDIA 0x0d18U // coaXmedia
#define UHS_VID_HANK_CONNECTION_INDUSTRIAL 0x0d19U // Hank Connection Industrial Co., Ltd
#define UHS_VID_NXP 0x0d28U // NXP
#define UHS_VID_LEO_HUI_ELECTRIC_WIRE_AND_CABLE 0x0d32U // Leo Hui Electric Wire & Cable Co., Ltd
#define UHS_VID_AIRSPEAK 0x0d33U // AirSpeak, Inc.
#define UHS_VID_REARDEN_STEEL_TECHNOLOGIES 0x0d34U // Rearden Steel Technologies
#define UHS_VID_DAH_KUN 0x0d35U // Dah Kun Co., Ltd
#define UHS_VID_POSIFLEX_TECHNOLOGIES 0x0d3aU // Posiflex Technologies, Inc.
#define UHS_VID_SRI_CABLE_TECHNOLOGY 0x0d3cU // Sri Cable Technology, Ltd
#define UHS_VID_TANGTOP_TECHNOLOGY 0x0d3dU // Tangtop Technology Co., Ltd
#define UHS_VID_FITCOM 0x0d3eU // Fitcom, inc.
#define UHS_VID_MTS_SYSTEMS 0x0d3fU // MTS Systems Corp.
#define UHS_VID_ASCOR 0x0d40U // Ascor, Inc.
#define UHS_VID_TA_YUN_TERMINALS_INDUSTRIAL 0x0d41U // Ta Yun Terminals Industrial Co., Ltd
#define UHS_VID_FULL_DER 0x0d42U // Full Der Co., Ltd
#define UHS_VID_KOBIL_SYSTEMS 0x0d46U // Kobil Systems GmbH
#define UHS_VID_PROMETHEAN_LIMITED 0x0d48U // Promethean Limited
#define UHS_VID_MAXTOR 0x0d49U // Maxtor
#define UHS_VID_NF 0x0d4aU // NF Corp.
#define UHS_VID_GRAPE_SYSTEMS 0x0d4bU // Grape Systems, Inc.
#define UHS_VID_TEDAS_AG 0x0d4cU // Tedas AG
#define UHS_VID_COHERENT 0x0d4dU // Coherent, Inc.
#define UHS_VID_AGERE_SYSTEMS_NETHERLAND_BV 0x0d4eU // Agere Systems Netherland BV
#define UHS_VID_EADS_AIRBUS_FRANCE 0x0d4fU // EADS Airbus France
#define UHS_VID_CLEWARE 0x0d50U // Cleware GmbH
#define UHS_VID_VOLEX_ASIA_PTE 0x0d51U // Volex (Asia) Pte., Ltd
#define UHS_VID_HMI 0x0d53U // HMI Co., Ltd
#define UHS_VID_HOLON 0x0d54U // Holon Corp.
#define UHS_VID_ASKA_TECHNOLOGIES 0x0d55U // ASKA Technologies, Inc.
#define UHS_VID_AVLAB_TECHNOLOGY 0x0d56U // AVLAB Technology, Inc.
#define UHS_VID_SOLOMON_MICROTECH 0x0d57U // Solomon Microtech, Ltd
#define UHS_VID_SMC_NETWORKS 0x0d5cU // SMC Networks, Inc.
#define UHS_VID_MYACOM 0x0d5eU // Myacom, Ltd
#define UHS_VID_CSI 0x0d5fU // CSI, Inc.
#define UHS_VID_IVL_TECHNOLOGIES 0x0d60U // IVL Technologies, Ltd
#define UHS_VID_MEILU_ELECTRONICS_SHENZHEN 0x0d61U // Meilu Electronics (Shenzhen) Co., Ltd
#define UHS_VID_DARFON_ELECTRONICS 0x0d62U // Darfon Electronics Corp.
#define UHS_VID_FRITZ_GEGAUF_AG 0x0d63U // Fritz Gegauf AG
#define UHS_VID_DXG_TECHNOLOGY 0x0d64U // DXG Technology Corp.
#define UHS_VID_KMJP 0x0d65U // KMJP Co., Ltd
#define UHS_VID_TMT 0x0d66U // TMT
#define UHS_VID_ADVANET 0x0d67U // Advanet, Inc.
#define UHS_VID_SUPER_LINK_ELECTRONICS 0x0d68U // Super Link Electronics Co., Ltd
#define UHS_VID_NSI 0x0d69U // NSI
#define UHS_VID_MEGAPOWER_INTERNATIONAL 0x0d6aU // Megapower International Corp.
#define UHS_VID_AND_OR_LOGIC 0x0d6bU // And-Or Logic
#define UHS_VID_TRY_COMPUTER 0x0d70U // Try Computer Co., Ltd
#define UHS_VID_HIRAKAWA_HEWTECH 0x0d71U // Hirakawa Hewtech Corp.
#define UHS_VID_WINMATE_COMMUNICATION 0x0d72U // Winmate Communication, Inc.
#define UHS_VID_HITS_COMMUNICATIONS 0x0d73U // Hit's Communications, Inc.
#define UHS_VID_MFP_KOREA 0x0d76U // MFP Korea, Inc.
#define UHS_VID_POWER_SENTRYNEWPOINT 0x0d77U // Power Sentry/Newpoint
#define UHS_VID_JAPAN_DISTRIBUTOR 0x0d78U // Japan Distributor Corp.
#define UHS_VID_MARX_DATENTECHNIK 0x0d7aU // MARX Datentechnik GmbH
#define UHS_VID_WELLCO_TECHNOLOGY 0x0d7bU // Wellco Technology Co., Ltd
#define UHS_VID_TAIWAN_LINE_TEK_ELECTRONIC 0x0d7cU // Taiwan Line Tek Electronic Co., Ltd
#define UHS_VID_PHISON_ELECTRONICS 0x0d7dU // Phison Electronics Corp.
#define UHS_VID_AMERICAN_COMPUTER_AND_DIGITAL_COMPONENTS 0x0d7eU // American Computer & Digital Components
#define UHS_VID_ESSENTIAL_REALITY 0x0d7fU // Essential Reality LLC
#define UHS_VID_HR_SILVINE_ELECTRONICS 0x0d80U // H.R. Silvine Electronics, Inc.
#define UHS_VID_TECHNOVISION 0x0d81U // TechnoVision
#define UHS_VID_THINK_OUTSIDE 0x0d83U // Think Outside, Inc.
#define UHS_VID_DOLBY_LABORATORIES 0x0d87U // Dolby Laboratories Inc.
#define UHS_VID_OZ_SOFTWARE 0x0d89U // Oz Software
#define UHS_VID_KING_JIM 0x0d8aU // King Jim Co., Ltd
#define UHS_VID_ASCOM_TELECOMMUNICATIONS 0x0d8bU // Ascom Telecommunications, Ltd
#define UHS_VID_C_MEDIA_ELECTRONICS 0x0d8cU // C-Media Electronics, Inc.
#define UHS_VID_PROMOTION_AND_DISPLAY_TECHNOLOGY 0x0d8dU // Promotion & Display Technology, Ltd
#define UHS_VID_GLOBAL_SUN_TECHNOLOGY 0x0d8eU // Global Sun Technology, Inc.
#define UHS_VID_PITNEY_BOWES 0x0d8fU // Pitney Bowes
#define UHS_VID_SURE_FIRE_ELECTRICAL 0x0d90U // Sure-Fire Electrical Corp.
#define UHS_VID_SKANHEX_TECHNOLOGY 0x0d96U // Skanhex Technology, Inc.
#define UHS_VID_SANTA_BARBARA_INSTRUMENT_GROUP 0x0d97U // Santa Barbara Instrument Group
#define UHS_VID_MARS_SEMICONDUCTOR 0x0d98U // Mars Semiconductor Corp.
#define UHS_VID_TRAZER_TECHNOLOGIES 0x0d99U // Trazer Technologies, Inc.
#define UHS_VID_RTX_TELECOM_AS 0x0d9aU // RTX Telecom AS
#define UHS_VID_TAT_SHING_ELECTRICAL 0x0d9bU // Tat Shing Electrical Co.
#define UHS_VID_CHEE_CHEN_HI_TECHNOLOGY 0x0d9cU // Chee Chen Hi-Technology Co., Ltd
#define UHS_VID_SANWA_SUPPLY 0x0d9dU // Sanwa Supply, Inc.
#define UHS_VID_AVAYA 0x0d9eU // Avaya
#define UHS_VID_POWERCOM 0x0d9fU // Powercom Co., Ltd
#define UHS_VID_DANGER_RESEARCH 0x0da0U // Danger Research
#define UHS_VID_SUZHOU_PETERS_PRECISE_INDUSTRIAL 0x0da1U // Suzhou Peter's Precise Industrial Co., Ltd
#define UHS_VID_LAND_INSTRUMENTS_INTERNATIONAL 0x0da2U // Land Instruments International, Ltd
#define UHS_VID_NIPPON_ELECTRO_SENSORY_DEVICES 0x0da3U // Nippon Electro-Sensory Devices Corp.
#define UHS_VID_POLAR_ELECTRO_OY 0x0da4U // Polar Electro Oy
#define UHS_VID_IOGEAR 0x0da7U // IOGear, Inc.
#define UHS_VID_SOFTDSP 0x0da8U // softDSP Co., Ltd
#define UHS_VID_CUBIG_GROUP 0x0dabU // Cubig Group
#define UHS_VID_WESTOVER_SCIENTIFIC 0x0dadU // Westover Scientific
#define UHS_VID_MICRO_STAR_INTERNATIONAL 0x0db0U // Micro Star International
#define UHS_VID_WEN_TE_ELECTRONICS 0x0db1U // Wen Te Electronics Co., Ltd
#define UHS_VID_SHIAN_HWI_PLUG_PARTS_PLASTIC_FACTORY 0x0db2U // Shian Hwi Plug Parts, Plastic Factory
#define UHS_VID_TEKRAM_TECHNOLOGY_1 0x0db3U // Tekram Technology Co., Ltd
#define UHS_VID_CHUNG_FU_CHEN_YEH_ENTERPRISE 0x0db4U // Chung Fu Chen Yeh Enterprise Corp.
#define UHS_VID_ACCESS_IS 0x0db5U // Access IS
#define UHS_VID_ELCON_SYSTEMTECHNIK 0x0db7U // ELCON Systemtechnik
#define UHS_VID_DIGIDESIGN 0x0dbaU // Digidesign
#define UHS_VID_AANDD_MEDICAL 0x0dbcU // A&D Medical
#define UHS_VID_JIUH_SHIUH_PRECISION_INDUSTRY 0x0dbeU // Jiuh Shiuh Precision Industry Co., Ltd
#define UHS_VID_JESS_LINK_INTERNATIONAL 0x0dbfU // Jess-Link International
#define UHS_VID_G7_SOLUTIONS_FORMERLY_GREAT_NOTIONS 0x0dc0U // G7 Solutions (formerly Great Notions)
#define UHS_VID_TAMAGAWA_SEIKI 0x0dc1U // Tamagawa Seiki Co., Ltd
#define UHS_VID_ATHENA_SMARTCARD_SOLUTIONS 0x0dc3U // Athena Smartcard Solutions, Inc.
#define UHS_VID_MACPOWER_PERIPHERALS 0x0dc4U // Macpower Peripherals, Ltd
#define UHS_VID_SDK 0x0dc5U // SDK Co., Ltd
#define UHS_VID_PRECISION_SQUARED_TECHNOLOGY 0x0dc6U // Precision Squared Technology Corp.
#define UHS_VID_FIRST_CABLE_LINE 0x0dc7U // First Cable Line, Inc.
#define UHS_VID_NETWORKFAB 0x0dcdU // NetworkFab Corp.
#define UHS_VID_ACCESS_SOLUTIONS 0x0dd0U // Access Solutions
#define UHS_VID_CONTEK_ELECTRONICS 0x0dd1U // Contek Electronics Co., Ltd
#define UHS_VID_POWER_QUOTIENT_INTERNATIONAL 0x0dd2U // Power Quotient International Co., Ltd
#define UHS_VID_MEDIAQ 0x0dd3U // MediaQ
#define UHS_VID_CUSTOM_ENGINEERING_SPA 0x0dd4U // Custom Engineering SPA
#define UHS_VID_CALIFORNIA_MICRO_DEVICES 0x0dd5U // California Micro Devices
#define UHS_VID_KOCOM 0x0dd7U // Kocom Co., Ltd
#define UHS_VID_NETAC_TECHNOLOGY 0x0dd8U // Netac Technology Co., Ltd
#define UHS_VID_HIGHSPEED_SURFING 0x0dd9U // HighSpeed Surfing
#define UHS_VID_INTEGRATED_CIRCUIT_SOLUTION 0x0ddaU // Integrated Circuit Solution, Inc.
#define UHS_VID_TAMARACK 0x0ddbU // Tamarack, Inc.
#define UHS_VID_DATELINK_TECHNOLOGY 0x0dddU // Datelink Technology Co., Ltd
#define UHS_VID_UBICOM 0x0ddeU // Ubicom, Inc.
#define UHS_VID_BD_CONSUMER_HEALTHCARE 0x0de0U // BD Consumer Healthcare
#define UHS_VID_USBMICRO 0x0de7U // USBmicro
#define UHS_VID_UTECH_ELECTRONIC_DG 0x0deaU // UTECH Electronic (D.G.) Co., Ltd.
#define UHS_VID_NOVASONICS 0x0dedU // Novasonics
#define UHS_VID_LIFETIME_MEMORY_PRODUCTS 0x0deeU // Lifetime Memory Products
#define UHS_VID_FULL_RISE_ELECTRONIC 0x0defU // Full Rise Electronic Co., Ltd
#define UHS_VID_NETANDSYS 0x0df4U // NET&SYS
#define UHS_VID_SITECOM_EUROPE_BV 0x0df6U // Sitecom Europe B.V.
#define UHS_VID_MOBILE_ACTION_TECHNOLOGY 0x0df7U // Mobile Action Technology, Inc.
#define UHS_VID_TOYO_COMMUNICATION_EQUIPMENT 0x0dfaU // Toyo Communication Equipment Co., Ltd
#define UHS_VID_GENERALTOUCH_TECHNOLOGY 0x0dfcU // GeneralTouch Technology Co., Ltd
#define UHS_VID_NIPPON_SYSTEMWARE 0x0e03U // Nippon Systemware Co., Ltd
#define UHS_VID_WINBEST_TECHNOLOGY 0x0e08U // Winbest Technology Co., Ltd
#define UHS_VID_AMIGO_TECHNOLOGY 0x0e0bU // Amigo Technology Inc.
#define UHS_VID_GESYTEC 0x0e0cU // Gesytec
#define UHS_VID_PICOQUANT 0x0e0dU // PicoQuant GmbH
#define UHS_VID_VMWARE 0x0e0fU // VMware, Inc.
#define UHS_VID_JMTEK_1 0x0e16U // JMTek, LLC
#define UHS_VID_WALEX_ELECTRONIC 0x0e17U // Walex Electronic, Ltd
#define UHS_VID_UNISYS_1 0x0e1aU // Unisys
#define UHS_VID_CREWAVE 0x0e1bU // Crewave
#define UHS_VID_PEGASUS_TECHNOLOGIES 0x0e20U // Pegasus Technologies Ltd.
#define UHS_VID_COWON_SYSTEMS 0x0e21U // Cowon Systems, Inc.
#define UHS_VID_SYMBIAN 0x0e22U // Symbian Ltd.
#define UHS_VID_LIOU_YUANE_ENTERPRISE 0x0e23U // Liou Yuane Enterprise Co., Ltd
#define UHS_VID_VINCHIP_SYSTEMS 0x0e25U // VinChip Systems, Inc.
#define UHS_VID_J_PHONE_EAST 0x0e26U // J-Phone East Co., Ltd
#define UHS_VID_HEARTMATH 0x0e30U // HeartMath LLC
#define UHS_VID_MICRO_COMPUTER_CONTROL 0x0e34U // Micro Computer Control Corp.
#define UHS_VID_3PEA_TECHNOLOGIES 0x0e35U // 3Pea Technologies, Inc.
#define UHS_VID_TIEPIE_ENGINEERING 0x0e36U // TiePie engineering
#define UHS_VID_STRATITEC 0x0e38U // Stratitec, Inc.
#define UHS_VID_SMART_MODULAR_TECHNOLOGIES 0x0e39U // Smart Modular Technologies, Inc.
#define UHS_VID_NEOSTAR_TECHNOLOGY 0x0e3aU // Neostar Technology Co., Ltd
#define UHS_VID_MANSELLA 0x0e3bU // Mansella, Ltd
#define UHS_VID_LINE6 0x0e41U // Line6, Inc.
#define UHS_VID_SUN_RISEFUL_TECHNOLOGY 0x0e44U // Sun-Riseful Technology Co., Ltd.
#define UHS_VID_JULIA 0x0e48U // Julia Corp., Ltd
#define UHS_VID_SHENZHEN_BAO_HING_ELECTRIC_WIRE_AND_CABLE_MFR 0x0e4aU // Shenzhen Bao Hing Electric Wire & Cable Mfr. Co.
#define UHS_VID_RADICA_GAMES 0x0e4cU // Radica Games, Ltd
#define UHS_VID_TECHNODATA_INTERWARE 0x0e50U // TechnoData Interware
#define UHS_VID_SPEED_DRAGON_MULTIMEDIA 0x0e55U // Speed Dragon Multimedia, Ltd
#define UHS_VID_KINGSTON_TECHNOLOGY_COMPANY 0x0e56U // Kingston Technology Company, Inc.
#define UHS_VID_ACTIVE 0x0e5aU // Active Co., Ltd
#define UHS_VID_UNION_POWER_INFORMATION_INDUSTRIAL 0x0e5bU // Union Power Information Industrial Co., Ltd
#define UHS_VID_BITLAND_INFORMATION_TECHNOLOGY 0x0e5cU // Bitland Information Technology Co., Ltd
#define UHS_VID_NELTRON_INDUSTRIAL 0x0e5dU // Neltron Industrial Co., Ltd
#define UHS_VID_CONWISE_TECHNOLOGY 0x0e5eU // Conwise Technology Co., Ltd.
#define UHS_VID_HAWKING_TECHNOLOGIES 0x0e66U // Hawking Technologies
#define UHS_VID_FOSSIL 0x0e67U // Fossil, Inc.
#define UHS_VID_MEGAWIN_TECHNOLOGY 0x0e6aU // Megawin Technology Co., Ltd
#define UHS_VID_LOGIC3 0x0e6fU // Logic3
#define UHS_VID_TOKYO_ELECTRONIC_INDUSTRY 0x0e70U // Tokyo Electronic Industry Co., Ltd
#define UHS_VID_HSI_CHIN_ELECTRONICS 0x0e72U // Hsi-Chin Electronics Co., Ltd
#define UHS_VID_TVS_ELECTRONICS 0x0e75U // TVS Electronics, Ltd
#define UHS_VID_ARCHOS 0x0e79U // Archos, Inc.
#define UHS_VID_ON_TECH_INDUSTRY 0x0e7bU // On-Tech Industry Co., Ltd
#define UHS_VID_GMATE 0x0e7eU // Gmate, Inc.
#define UHS_VID_CHING_TAI_ELECTRIC_WIRE_AND_CABLE 0x0e82U // Ching Tai Electric Wire & Cable Co., Ltd
#define UHS_VID_SHIN_AN_WIRE_AND_CABLE 0x0e83U // Shin An Wire & Cable Co.
#define UHS_VID_WELL_FORCE_ELECTRONIC 0x0e8cU // Well Force Electronic Co., Ltd
#define UHS_VID_MEDIATEK_1 0x0e8dU // MediaTek Inc.
#define UHS_VID_GREENASIA 0x0e8fU // GreenAsia Inc.
#define UHS_VID_WIEBETECH 0x0e90U // WiebeTech, LLC
#define UHS_VID_VTECH_ENGINEERING_CANADA 0x0e91U // VTech Engineering Canada, Ltd
#define UHS_VID_CS_GLORY_ENTERPRISE 0x0e92U // C's Glory Enterprise Co., Ltd
#define UHS_VID_EM_TECHNICS 0x0e93U // eM Technics Co., Ltd
#define UHS_VID_FUTURE_TECHNOLOGY 0x0e95U // Future Technology Co., Ltd
#define UHS_VID_APLUX_COMMUNICATIONS 0x0e96U // Aplux Communications, Ltd
#define UHS_VID_FINGERWORKS 0x0e97U // Fingerworks, Inc.
#define UHS_VID_ADVANCED_ANALOGIC_TECHNOLOGIES 0x0e98U // Advanced Analogic Technologies, Inc.
#define UHS_VID_PARALLEL_DICE 0x0e99U // Parallel Dice Co., Ltd
#define UHS_VID_TA_HSING_INDUSTRIES 0x0e9aU // TA HSING Industries, Ltd
#define UHS_VID_ADTEC 0x0e9bU // ADTEC Corp.
#define UHS_VID_STREAMZAP 0x0e9cU // Streamzap, Inc.
#define UHS_VID_TAMURA 0x0e9fU // Tamura Corp.
#define UHS_VID_OURS_TECHNOLOGY 0x0ea0U // Ours Technology, Inc.
#define UHS_VID_NIHON_COMPUTER 0x0ea6U // Nihon Computer Co., Ltd
#define UHS_VID_MSL_ENTERPRISES 0x0ea7U // MSL Enterprises Corp.
#define UHS_VID_CENDYNE 0x0ea8U // CenDyne, Inc.
#define UHS_VID_HUMAX_1 0x0eadU // Humax Co., Ltd
#define UHS_VID_NOVATECH 0x0eb0U // NovaTech
#define UHS_VID_WIS_TECHNOLOGIES 0x0eb1U // WIS Technologies, Inc.
#define UHS_VID_Y_S_ELECTRONIC 0x0eb2U // Y-S Electronic Co., Ltd
#define UHS_VID_SAINT_TECHNOLOGY 0x0eb3U // Saint Technology Corp.
#define UHS_VID_ENDOR_AG 0x0eb7U // Endor AG
#define UHS_VID_METTLER_TOLEDO 0x0eb8U // Mettler Toledo
#define UHS_VID_THERMO_FISHER_SCIENTIFIC 0x0ebbU // Thermo Fisher Scientific
#define UHS_VID_VWEB 0x0ebeU // VWeb Corp.
#define UHS_VID_OMEGA_TECHNOLOGY_OF_TAIWAN 0x0ebfU // Omega Technology of Taiwan, Inc.
#define UHS_VID_LHI_TECHNOLOGY_CHINA 0x0ec0U // LHI Technology (China) Co., Ltd
#define UHS_VID_ABIT_COMPUTER 0x0ec1U // Abit Computer Corp.
#define UHS_VID_SWEETRAY_INDUSTRIAL 0x0ec2U // Sweetray Industrial, Ltd
#define UHS_VID_AXELL 0x0ec3U // Axell Co., Ltd
#define UHS_VID_BALLRACING_DEVELOPMENTS 0x0ec4U // Ballracing Developments, Ltd
#define UHS_VID_GT_INFORMATION_SYSTEM 0x0ec5U // GT Information System Co., Ltd
#define UHS_VID_INNOVISION_MULTIMEDIA 0x0ec6U // InnoVISION Multimedia, Ltd
#define UHS_VID_THETA_LINK 0x0ec7U // Theta Link Corp.
#define UHS_VID_LITE_ON_IT 0x0ecdU // Lite-On IT Corp.
#define UHS_VID_TAISOL_ELECTRONICS 0x0eceU // TaiSol Electronics Co., Ltd
#define UHS_VID_PHOGENIX_IMAGING 0x0ecfU // Phogenix Imaging, LLC
#define UHS_VID_WINMAXGROUP 0x0ed1U // WinMaxGroup
#define UHS_VID_KYOTO_MICRO_COMPUTER 0x0ed2U // Kyoto Micro Computer Co., Ltd
#define UHS_VID_WING_TECH_ENTERPRISE 0x0ed3U // Wing-Tech Enterprise Co., Ltd
#define UHS_VID_FIBERBYTE 0x0ed5U // Fiberbyte
#define UHS_VID_NORIAKE_ITRON 0x0edaU // Noriake Itron Corp.
#define UHS_VID_E_MDT 0x0edfU // e-MDT Co., Ltd
#define UHS_VID_SHIMA_SEIKI_MFG 0x0ee0U // Shima Seiki Mfg., Ltd
#define UHS_VID_SAROTECH 0x0ee1U // Sarotech Co., Ltd
#define UHS_VID_AMI_SEMICONDUCTOR 0x0ee2U // AMI Semiconductor, Inc.
#define UHS_VID_COMTRUE_TECHNOLOGY 0x0ee3U // ComTrue Technology Corp.
#define UHS_VID_SUNRICH_TECHNOLOGY 0x0ee4U // Sunrich Technology, Ltd
#define UHS_VID_DIGITAL_STREAM_TECHNOLOGY 0x0eeeU // Digital Stream Technology, Inc.
#define UHS_VID_D_WAV_SCIENTIFIC 0x0eefU // D-WAV Scientific Co., Ltd
#define UHS_VID_HITACHI_CABLE 0x0ef0U // Hitachi Cable, Ltd
#define UHS_VID_AICHI_MICRO_INTELLIGENT 0x0ef1U // Aichi Micro Intelligent Corp.
#define UHS_VID_IO_MAGIC 0x0ef2U // I/O Magic Corp.
#define UHS_VID_LYNN_PRODUCTS 0x0ef3U // Lynn Products, Inc.
#define UHS_VID_DSI_DATOTECH 0x0ef4U // DSI Datotech
#define UHS_VID_POINTCHIPS 0x0ef5U // PointChips
#define UHS_VID_YIELD_MICROELECTRONICS 0x0ef6U // Yield Microelectronics Corp.
#define UHS_VID_SM_TECH_CO_LTD_TULIP 0x0ef7U // SM Tech Co., Ltd (Tulip)
#define UHS_VID_OASIS_SEMICONDUCTOR 0x0efdU // Oasis Semiconductor
#define UHS_VID_WEM_TECHNOLOGY 0x0efeU // Wem Technology, Inc.
#define UHS_VID_UNITEK_UPS_SYSTEMS 0x0f03U // Unitek UPS Systems
#define UHS_VID_VISUAL_FRONTIER_ENTERPRISE 0x0f06U // Visual Frontier Enterprise Co., Ltd
#define UHS_VID_CSL_WIRE_AND_PLUG_SHEN_ZHEN 0x0f08U // CSL Wire & Plug (Shen Zhen) Co.
#define UHS_VID_CAS 0x0f0cU // CAS Corp.
#define UHS_VID_HORI 0x0f0dU // Hori Co., Ltd
#define UHS_VID_ENERGY_FULL 0x0f0eU // Energy Full Corp.
#define UHS_VID_LD_DIDACTIC 0x0f11U // LD Didactic GmbH
#define UHS_VID_MARS_ENGINEERING 0x0f12U // Mars Engineering Corp.
#define UHS_VID_ACETEK_TECHNOLOGY 0x0f13U // Acetek Technology Co., Ltd
#define UHS_VID_INGENICO_1 0x0f14U // Ingenico
#define UHS_VID_FINGER_LAKES_INSTRUMENTATION 0x0f18U // Finger Lakes Instrumentation
#define UHS_VID_ORACOM 0x0f19U // Oracom Co., Ltd
#define UHS_VID_ONSET_COMPUTER 0x0f1bU // Onset Computer Corp.
#define UHS_VID_FUNAI_ELECTRIC 0x0f1cU // Funai Electric Co., Ltd
#define UHS_VID_IWILL 0x0f1dU // Iwill Corp.
#define UHS_VID_IOI_TECHNOLOGY 0x0f21U // IOI Technology Corp.
#define UHS_VID_SENIOR_INDUSTRIES 0x0f22U // Senior Industries, Inc.
#define UHS_VID_LEADER_TECH_MANUFACTURER 0x0f23U // Leader Tech Manufacturer Co., Ltd
#define UHS_VID_FLEX_P_INDUSTRIES_SND_BHD 0x0f24U // Flex-P Industries, Snd., Bhd.
#define UHS_VID_VIPOWER 0x0f2dU // ViPower, Inc.
#define UHS_VID_GENIALITY_MAPLE_TECHNOLOGY 0x0f2eU // Geniality Maple Technology Co., Ltd
#define UHS_VID_PRIVA_DESIGN_SERVICES 0x0f2fU // Priva Design Services
#define UHS_VID_JESS_TECHNOLOGY 0x0f30U // Jess Technology Co., Ltd
#define UHS_VID_CHRYSALIS_DEVELOPMENT 0x0f31U // Chrysalis Development
#define UHS_VID_YFC_BONEAGLE_ELECTRIC 0x0f32U // YFC-BonEagle Electric Co., Ltd
#define UHS_VID_KOKUYO 0x0f37U // Kokuyo Co., Ltd
#define UHS_VID_NIEN_YI_INDUSTRIAL 0x0f38U // Nien-Yi Industrial Corp.
#define UHS_VID_TG3_ELECTRONICS_1 0x0f39U // TG3 Electronics
#define UHS_VID_AIRPRIME_INCORPORATED 0x0f3dU // Airprime, Incorporated
#define UHS_VID_RDC_SEMICONDUCTOR 0x0f41U // RDC Semiconductor Co., Ltd
#define UHS_VID_NITAL_CONSULTING_SERVICES 0x0f42U // Nital Consulting Services, Inc.
#define UHS_VID_POLHEMUS 0x0f44U // Polhemus
#define UHS_VID_ST_JOHN_TECHNOLOGY 0x0f4bU // St. John Technology Co., Ltd
#define UHS_VID_WORLDWIDE_CABLE_OPTO 0x0f4cU // WorldWide Cable Opto Corp.
#define UHS_VID_MICROTUNE 0x0f4dU // Microtune, Inc.
#define UHS_VID_FREEDOM_SCIENTIFIC 0x0f4eU // Freedom Scientific
#define UHS_VID_WING_KEY_ELECTRICAL 0x0f52U // Wing Key Electrical Co., Ltd
#define UHS_VID_DONGGUAN_WHITE_HORSE_CABLE_FACTORY 0x0f53U // Dongguan White Horse Cable Factory, Ltd
#define UHS_VID_KAWAI_MUSICAL_INSTRUMENTS_MFG 0x0f54U // Kawai Musical Instruments Mfg. Co., Ltd
#define UHS_VID_AMBICOM 0x0f55U // AmbiCom, Inc.
#define UHS_VID_PRAIRIECOMM 0x0f5cU // Prairiecomm, Inc.
#define UHS_VID_NEWAGE_INTERNATIONAL 0x0f5dU // NewAge International, LLC
#define UHS_VID_KEY_TECHNOLOGY 0x0f5fU // Key Technology Corp.
#define UHS_VID_NTK 0x0f60U // NTK, Ltd
#define UHS_VID_VARIAN 0x0f61U // Varian, Inc.
#define UHS_VID_ACROX_TECHNOLOGIES 0x0f62U // Acrox Technologies Co., Ltd
#define UHS_VID_LEAPFROG_ENTERPRISES 0x0f63U // LeapFrog Enterprises
#define UHS_VID_KOBE_STEEL 0x0f68U // Kobe Steel, Ltd
#define UHS_VID_DIONEX 0x0f69U // Dionex Corp.
#define UHS_VID_VIBREN_TECHNOLOGIES 0x0f6aU // Vibren Technologies, Inc.
#define UHS_VID_INTELLIGENT_SYSTEMS 0x0f6eU // INTELLIGENT SYSTEMS
#define UHS_VID_DFI_1 0x0f73U // DFI
#define UHS_VID_GUNTERMANN_AND_DRUNCK 0x0f78U // Guntermann & Drunck GmbH
#define UHS_VID_DQ_TECHNOLOGY 0x0f7cU // DQ Technology, Inc.
#define UHS_VID_NETBOTZ 0x0f7dU // NetBotz, Inc.
#define UHS_VID_FLUKE 0x0f7eU // Fluke Corp.
#define UHS_VID_VTECH_HOLDINGS 0x0f88U // VTech Holdings, Ltd
#define UHS_VID_YAZAKI 0x0f8bU // Yazaki Corp.
#define UHS_VID_YOUNG_GENERATION_INTERNATIONAL 0x0f8cU // Young Generation International Corp.
#define UHS_VID_UNIWILL_COMPUTER 0x0f8dU // Uniwill Computer Corp.
#define UHS_VID_KINGNET_TECHNOLOGY 0x0f8eU // Kingnet Technology Co., Ltd
#define UHS_VID_SOMA_NETWORKS 0x0f8fU // Soma Networks
#define UHS_VID_CVILUX 0x0f97U // CviLux Corp.
#define UHS_VID_CYBERBANK 0x0f98U // CyberBank Corp.
#define UHS_VID_HYUN_WON 0x0f9cU // Hyun Won, Inc.
#define UHS_VID_LUCENT_TECHNOLOGIES_1 0x0f9eU // Lucent Technologies
#define UHS_VID_STARCONN_ELECTRONIC 0x0fa3U // Starconn Electronic Co., Ltd
#define UHS_VID_ATL_TECHNOLOGY 0x0fa4U // ATL Technology
#define UHS_VID_SOTEC 0x0fa5U // Sotec Co., Ltd
#define UHS_VID_EPOX_COMPUTER 0x0fa7U // Epox Computer Co., Ltd
#define UHS_VID_LOGIC_CONTROLS 0x0fa8U // Logic Controls, Inc.
#define UHS_VID_WINPOINT_ELECTRONIC 0x0fafU // Winpoint Electronic Corp.
#define UHS_VID_HAURTIAN_WIRE_AND_CABLE 0x0fb0U // Haurtian Wire & Cable Co., Ltd
#define UHS_VID_INCLOSE_DESIGN 0x0fb1U // Inclose Design, Inc.
#define UHS_VID_JUAN_CHERN_INDUSTRIAL 0x0fb2U // Juan-Chern Industrial Co., Ltd
#define UHS_VID_HEBER 0x0fb6U // Heber Ltd
#define UHS_VID_WISTRON 0x0fb8U // Wistron Corp.
#define UHS_VID_AACOM 0x0fb9U // AACom Corp.
#define UHS_VID_SAN_SHING_ELECTRONICS 0x0fbaU // San Shing Electronics Co., Ltd
#define UHS_VID_BITWISE_SYSTEMS 0x0fbbU // Bitwise Systems, Inc.
#define UHS_VID_MITAC_INTERNATINAL 0x0fc1U // Mitac Internatinal Corp.
#define UHS_VID_PLUG_AND_JACK_INDUSTRIAL 0x0fc2U // Plug and Jack Industrial, Inc.
#define UHS_VID_DELCOM_ENGINEERING 0x0fc5U // Delcom Engineering
#define UHS_VID_DATAPLUS_SUPPLIES 0x0fc6U // Dataplus Supplies, Inc.
#define UHS_VID_RESEARCH_IN_MOTION 0x0fcaU // Research In Motion, Ltd.
#define UHS_VID_SONY_ERICSSON_MOBILE_COMMUNICATIONS 0x0fceU // Sony Ericsson Mobile Communications AB
#define UHS_VID_DYNASTREAM_INNOVATIONS 0x0fcfU // Dynastream Innovations, Inc.
#define UHS_VID_TULIP_COMPUTERS_BV 0x0fd0U // Tulip Computers B.V.
#define UHS_VID_GIANT_ELECTRONICS 0x0fd1U // Giant Electronics Ltd.
#define UHS_VID_SEAC_BANCHE 0x0fd2U // Seac Banche
#define UHS_VID_TENOVIS_GMBH_AND_CO_KG 0x0fd4U // Tenovis GmbH & Co., KG
#define UHS_VID_DIRECT_ACCESS_TECHNOLOGY 0x0fd5U // Direct Access Technology, Inc.
#define UHS_VID_ELGATO_SYSTEMS 0x0fd9U // Elgato Systems GmbH
#define UHS_VID_QUANTEC_NETWORKS 0x0fdaU // Quantec Networks GmbH
#define UHS_VID_MICRO_PLUS 0x0fdcU // Micro Plus
#define UHS_VID_OREGON_SCIENTIFIC 0x0fdeU // Oregon Scientific
#define UHS_VID_OSTERHOUT_DESIGN_GROUP 0x0fe0U // Osterhout Design Group
#define UHS_VID_IN_TECH_ELECTRONICS 0x0fe4U // IN-Tech Electronics, Ltd
#define UHS_VID_GREENCONN_USA 0x0fe5U // Greenconn (U.S.A.), Inc.
#define UHS_VID_KONTRON_INDUSTRIAL_COMPUTER_SOURCE_ICS_ADVENT 0x0fe6U // Kontron (Industrial Computer Source / ICS Advent)
#define UHS_VID_DVICO 0x0fe9U // DVICO
#define UHS_VID_UNITED_COMPUTER_ACCESSORIES 0x0feaU // United Computer Accessories
#define UHS_VID_CRS_ELECTRONIC 0x0febU // CRS Electronic Co., Ltd
#define UHS_VID_UMC_ELECTRONICS 0x0fecU // UMC Electronics Co., Ltd
#define UHS_VID_ACCESS 0x0fedU // Access Co., Ltd
#define UHS_VID_XSIDO 0x0feeU // Xsido Corp.
#define UHS_VID_MJ_RESEARCH 0x0fefU // MJ Research, Inc.
#define UHS_VID_CORE_VALLEY 0x0ff6U // Core Valley Co., Ltd
#define UHS_VID_CHI_SHING_COMPUTER_ACCESSORIES 0x0ff7U // CHI SHING Computer Accessories Co., Ltd
#define UHS_VID_CLAVIA_DMI 0x0ffcU // Clavia DMI AB
#define UHS_VID_EARLYSENSE 0x0ffdU // EarlySense
#define UHS_VID_AOPEN 0x0fffU // Aopen, Inc.
#define UHS_VID_SPEED_TECH 0x1000U // Speed Tech Corp.
#define UHS_VID_RITRONICS_COMPONENTS_S_PTE 0x1001U // Ritronics Components (S) Pte., Ltd
#define UHS_VID_SIGMA 0x1003U // Sigma Corp.
#define UHS_VID_LG_ELECTRONICS 0x1004U // LG Electronics, Inc.
#define UHS_VID_APACER_TECHNOLOGY 0x1005U // Apacer Technology, Inc.
#define UHS_VID_IRIVER 0x1006U // iRiver, Ltd.
#define UHS_VID_EMUZED 0x1009U // Emuzed, Inc.
#define UHS_VID_AV_CHASEWAY 0x100aU // AV Chaseway, Ltd
#define UHS_VID_CHOU_CHIN_INDUSTRIAL 0x100bU // Chou Chin Industrial Co., Ltd
#define UHS_VID_NETOPIA 0x100dU // Netopia, Inc.
#define UHS_VID_FUKUDA_DENSHI 0x1010U // Fukuda Denshi Co., Ltd
#define UHS_VID_MOBILE_MEDIA_TECH 0x1011U // Mobile Media Tech.
#define UHS_VID_SDKM_FIBRES_WIRES_AND_CABLES_BERHAD 0x1012U // SDKM Fibres, Wires & Cables Berhad
#define UHS_VID_TST_TOUCHLESS_SENSOR_TECHNOLOGY_AG 0x1013U // TST-Touchless Sensor Technology AG
#define UHS_VID_DENSITRON_TECHNOLOGIES_PLC 0x1014U // Densitron Technologies PLC
#define UHS_VID_SOFTRONICS_PTY 0x1015U // Softronics Pty., Ltd
#define UHS_VID_XIAMEN_HUNGS_ENTERPRISE 0x1016U // Xiamen Hung's Enterprise Co., Ltd
#define UHS_VID_SPEEDY_INDUSTRIAL_SUPPLIES_PTE 0x1017U // Speedy Industrial Supplies, Pte., Ltd
#define UHS_VID_ELITEGROUP_COMPUTER_SYSTEMS_ECS 0x1019U // Elitegroup Computer Systems (ECS)
#define UHS_VID_LABTEC_1 0x1020U // Labtec
#define UHS_VID_SHINKO_SHOJI 0x1022U // Shinko Shoji Co., Ltd
#define UHS_VID_HYPER_PALTEK 0x1025U // Hyper-Paltek
#define UHS_VID_NEWLY 0x1026U // Newly Corp.
#define UHS_VID_TIME_DOMAIN 0x1027U // Time Domain
#define UHS_VID_INOVYS 0x1028U // Inovys Corp.
#define UHS_VID_ATLANTIC_COAST_TELESYS 0x1029U // Atlantic Coast Telesys
#define UHS_VID_RAMOS_TECHNOLOGY 0x102aU // Ramos Technology Co., Ltd
#define UHS_VID_INFOTRONIC_AMERICA 0x102bU // Infotronic America, Inc.
#define UHS_VID_ETOMS_ELECTRONICS 0x102cU // Etoms Electronics Corp.
#define UHS_VID_WINIC 0x102dU // Winic Corp.
#define UHS_VID_COMAX_TECHNOLOGY 0x1031U // Comax Technology, Inc.
#define UHS_VID_C_ONE_TECHNOLOGY 0x1032U // C-One Technology Corp.
#define UHS_VID_NUCAM 0x1033U // Nucam Corp.
#define UHS_VID_STEELSERIES_APS 0x1038U // SteelSeries ApS
#define UHS_VID_DEVOLO_AG 0x1039U // devolo AG
#define UHS_VID_PSA 0x103aU // PSA
#define UHS_VID_STANTON 0x103dU // Stanton
#define UHS_VID_ICREATE_TECHNOLOGIES 0x1043U // iCreate Technologies Corp.
#define UHS_VID_CHU_YUEN_ENTERPRISE 0x1044U // Chu Yuen Enterprise Co., Ltd
#define UHS_VID_WINBOND_ELECTRONICS_CORP_HEX_ 0x1046U // Winbond Electronics Corp. [hex]
#define UHS_VID_TARGUS_GROUP_INTERNATIONAL 0x1048U // Targus Group International
#define UHS_VID_MYLEX_BUSLOGIC 0x104bU // Mylex / Buslogic
#define UHS_VID_AMCO_TEC_INTERNATIONAL 0x104cU // AMCO TEC International, Inc.
#define UHS_VID_NEWPORT_CORPORATION 0x104dU // Newport Corporation
#define UHS_VID_WB_ELECTRONICS 0x104fU // WB Electronics
#define UHS_VID_YUBICOCOM 0x1050U // Yubico.com
#define UHS_VID_IMMANUEL_ELECTRONICS 0x1053U // Immanuel Electronics Co., Ltd
#define UHS_VID_BMS_INTERNATIONAL_BEHEER_NV 0x1054U // BMS International Beheer N.V.
#define UHS_VID_COMPLEX_MICRO_INTERCONNECTION 0x1055U // Complex Micro Interconnection Co., Ltd
#define UHS_VID_HSIN_CHEN_ENT 0x1056U // Hsin Chen Ent Co., Ltd
#define UHS_VID_ON_SEMICONDUCTOR 0x1057U // ON Semiconductor
#define UHS_VID_WESTERN_DIGITAL_TECHNOLOGIES 0x1058U // Western Digital Technologies, Inc.
#define UHS_VID_GIESECKE_AND_DEVRIENT 0x1059U // Giesecke & Devrient GmbH
#define UHS_VID_FOXCONN_INTERNATIONAL 0x105bU // Foxconn International, Inc.
#define UHS_VID_HONG_JI_ELECTRIC_WIRE_AND_CABLE_DONGGUAN 0x105cU // Hong Ji Electric Wire & Cable (Dongguan) Co., Ltd
#define UHS_VID_DELKIN_DEVICES 0x105dU // Delkin Devices, Inc.
#define UHS_VID_VALENCE_SEMICONDUCTOR_DESIGN 0x105eU // Valence Semiconductor Design, Ltd
#define UHS_VID_CHIN_SHONG_ENTERPRISE 0x105fU // Chin Shong Enterprise Co., Ltd
#define UHS_VID_EASTHOME_INDUSTRIAL 0x1060U // Easthome Industrial Co., Ltd
#define UHS_VID_MOTOROLA_ELECTRONICS_TAIWAN_LTD_HEX_ 0x1063U // Motorola Electronics Taiwan, Ltd [hex]
#define UHS_VID_CCYU_TECHNOLOGY 0x1065U // CCYU Technology
#define UHS_VID_LOYAL_LEGEND 0x106aU // Loyal Legend, Ltd
#define UHS_VID_CURITEL_COMMUNICATIONS 0x106cU // Curitel Communications, Inc.
#define UHS_VID_SAN_CHIEH_MANUFACTURING 0x106dU // San Chieh Manufacturing, Ltd
#define UHS_VID_CONECTL 0x106eU // ConectL
#define UHS_VID_MONEY_CONTROLS 0x106fU // Money Controls
#define UHS_VID_GCT_SEMICONDUCTOR 0x1076U // GCT Semiconductor, Inc.
#define UHS_VID_GATEWAY_1 0x107bU // Gateway, Inc.
#define UHS_VID_ARLEC_AUSTRALIA 0x107dU // Arlec Australia, Ltd
#define UHS_VID_MIDORIYA_ELECTRIC 0x107eU // Midoriya Electric Co., Ltd
#define UHS_VID_KIDZMOUSE 0x107fU // KidzMouse, Inc.
#define UHS_VID_SHIN_ETSUKAKEN 0x1082U // Shin-Etsukaken Co., Ltd
#define UHS_VID_CANON_ELECTRONICS 0x1083U // Canon Electronics, Inc.
#define UHS_VID_PANTECH 0x1084U // Pantech Co., Ltd
#define UHS_VID_CHLORIDE_POWER_PROTECTION 0x108aU // Chloride Power Protection
#define UHS_VID_GRAND_TEK_TECHNOLOGY 0x108bU // Grand-tek Technology Co., Ltd
#define UHS_VID_ROBERT_BOSCH 0x108cU // Robert Bosch GmbH
#define UHS_VID_LOTES 0x108eU // Lotes Co., Ltd.
#define UHS_VID_SURFACE_OPTICS 0x1099U // Surface Optics Corp.
#define UHS_VID_DATASOFT_SYSTEMS 0x109aU // DATASOFT Systems GmbH
#define UHS_VID_HISENSE 0x109bU // Hisense
#define UHS_VID_ESOL 0x109fU // eSOL Co., Ltd
#define UHS_VID_HIROTECH 0x10a0U // Hirotech, Inc.
#define UHS_VID_MITSUBISHI_MATERIALS 0x10a3U // Mitsubishi Materials Corp.
#define UHS_VID_SK_TELETECH 0x10a9U // SK Teletech Co., Ltd
#define UHS_VID_CABLES_TO_GO 0x10aaU // Cables To Go
#define UHS_VID_USI 0x10abU // USI Co., Ltd
#define UHS_VID_HONEYWELL 0x10acU // Honeywell, Inc.
#define UHS_VID_PRINCETON_TECHNOLOGY 0x10aeU // Princeton Technology Corp.
#define UHS_VID_LIEBERT 0x10afU // Liebert Corp.
#define UHS_VID_COMODO_PLX_UNKNOWN 0x10b5U // Comodo (PLX?)
#define UHS_VID_DIBCOM 0x10b8U // DiBcom
#define UHS_VID_TM_TECHNOLOGY 0x10bbU // TM Technology, Inc.
#define UHS_VID_DINGING_TECHNOLOGY 0x10bcU // Dinging Technology Co., Ltd
#define UHS_VID_TMT_TECHNOLOGY 0x10bdU // TMT Technology, Inc.
#define UHS_VID_SMARTHOME 0x10bfU // SmartHome
#define UHS_VID_UNIVERSAL_LASER_SYSTEMS 0x10c3U // Universal Laser Systems, Inc.
#define UHS_VID_CYGNAL_INTEGRATED_PRODUCTS 0x10c4U // Cygnal Integrated Products, Inc.
#define UHS_VID_SANEI_ELECTRIC 0x10c5U // Sanei Electric, Inc.
#define UHS_VID_INTEC 0x10c6U // Intec, Inc.
#define UHS_VID_ERATECH 0x10cbU // Eratech
#define UHS_VID_GBM_CONNECTOR 0x10ccU // GBM Connector Co., Ltd
#define UHS_VID_KYCON 0x10cdU // Kycon, Inc.
#define UHS_VID_SILICON_LABS 0x10ceU // Silicon Labs
#define UHS_VID_VELLEMAN_COMPONENTS 0x10cfU // Velleman Components, Inc.
#define UHS_VID_HOTTINGER_BALDWIN_MEASUREMENT 0x10d1U // Hottinger Baldwin Measurement
#define UHS_VID_RAYCOMPOSER__R_ADAMS 0x10d2U // RayComposer - R. Adams
#define UHS_VID_MAN_BOON_MANUFACTORY 0x10d4U // Man Boon Manufactory, Ltd
#define UHS_VID_UNI_CLASS_TECHNOLOGY 0x10d5U // Uni Class Technology Co., Ltd
#define UHS_VID_ACTIONS_SEMICONDUCTOR 0x10d6U // Actions Semiconductor Co., Ltd
#define UHS_VID_AUTHENEX 0x10deU // Authenex, Inc.
#define UHS_VID_IN_WIN_DEVELOPMENT 0x10dfU // In-Win Development, Inc.
#define UHS_VID_POST_OP_VIDEO 0x10e0U // Post-Op Video, Inc.
#define UHS_VID_CABLEPLUS 0x10e1U // CablePlus, Ltd
#define UHS_VID_NADA_ELECTRONICS 0x10e2U // Nada Electronics, Ltd
#define UHS_VID_VAST_TECHNOLOGIES 0x10ecU // Vast Technologies, Inc.
#define UHS_VID_NEXIO 0x10f0U // Nexio Co., Ltd
#define UHS_VID_IMPORTEK 0x10f1U // Importek
#define UHS_VID_TURTLE_BEACH 0x10f5U // Turtle Beach
#define UHS_VID_PICTOS_TECHNOLOGIES 0x10fbU // Pictos Technologies, Inc.
#define UHS_VID_ANUBIS_ELECTRONICS 0x10fdU // Anubis Electronics, Ltd
#define UHS_VID_THRANE_AND_THRANE 0x10feU // Thrane & Thrane
#define UHS_VID_VIRTOUCH 0x1100U // VirTouch, Ltd
#define UHS_VID_EASYPASS_INDUSTRIAL 0x1101U // EasyPass Industrial Co., Ltd
#define UHS_VID_BRIGHTCOM_TECHNOLOGIES 0x1108U // Brightcom Technologies, Ltd
#define UHS_VID_MOXA_TECHNOLOGIES 0x110aU // Moxa Technologies Co., Ltd.
#define UHS_VID_ANALOG_DEVICES_CANADA_LTD_ALLIED_TELESYN 0x1110U // Analog Devices Canada, Ltd (Allied Telesyn)
#define UHS_VID_PANDORA_INTERNATIONAL 0x1111U // Pandora International Ltd.
#define UHS_VID_YM_ELECTRIC 0x1112U // YM ELECTRIC CO., Ltd
#define UHS_VID_MEDION_AG 0x1113U // Medion AG
#define UHS_VID_VSO_ELECTRIC 0x111eU // VSO Electric Co., Ltd
#define UHS_VID_REDRAT 0x112aU // RedRat
#define UHS_VID_MASTER_HILL_ELECTRIC_WIRE_AND_CABLE 0x112eU // Master Hill Electric Wire and Cable Co., Ltd
#define UHS_VID_CELLON_INTERNATIONAL 0x112fU // Cellon International, Inc.
#define UHS_VID_TENX_TECHNOLOGY 0x1130U // Tenx Technology, Inc.
#define UHS_VID_INTEGRATED_SYSTEM_SOLUTION 0x1131U // Integrated System Solution Corp.
#define UHS_VID_TOSHIBA_CORP_DIGITAL_MEDIA_EQUIPMENT_HEX_ 0x1132U // Toshiba Corp., Digital Media Equipment [hex]
#define UHS_VID_CTS_ELECTRONINCS 0x1136U // CTS Electronincs
#define UHS_VID_ARIN_TECH 0x113cU // Arin Tech Co., Ltd
#define UHS_VID_MAPOWER_ELECTRONICS 0x113dU // Mapower Electronics Co., Ltd
#define UHS_VID_V_ONE_MULTIMEDIA_PTE 0x1141U // V One Multimedia, Pte., Ltd
#define UHS_VID_CYBERSCAN_TECHNOLOGIES 0x1142U // CyberScan Technologies, Inc.
#define UHS_VID_JAPAN_RADIO_COMPANY 0x1145U // Japan Radio Company
#define UHS_VID_SHIMANE_SANYO_ELECTRIC 0x1146U // Shimane SANYO Electric Co., Ltd.
#define UHS_VID_EVER_GREAT_ELECTRIC_WIRE_AND_CABLE 0x1147U // Ever Great Electric Wire and Cable Co., Ltd
#define UHS_VID_SPHAIRON_ACCESS_SYSTEMS 0x114bU // Sphairon Access Systems GmbH
#define UHS_VID_TINIUS_OLSEN_TESTING_MACHINE 0x114cU // Tinius Olsen Testing Machine Co., Inc.
#define UHS_VID_ALPHA_IMAGING_TECHNOLOGY 0x114dU // Alpha Imaging Technology Corp.
#define UHS_VID_WAVECOM 0x114fU // Wavecom
#define UHS_VID_SALIX_TECHNOLOGY 0x115bU // Salix Technology Co., Ltd.
#define UHS_VID_SECUGEN 0x1162U // Secugen Corp.
#define UHS_VID_DELORME_PUBLISHING 0x1163U // DeLorme Publishing, Inc.
#define UHS_VID_YUAN_HIGH_TECH_DEVELOPMENT 0x1164U // YUAN High-Tech Development Co., Ltd
#define UHS_VID_TELSON_ELECTRONICS 0x1165U // Telson Electronics Co., Ltd
#define UHS_VID_BANTAM_INTERACTIVE_TECHNOLOGIES 0x1166U // Bantam Interactive Technologies
#define UHS_VID_SALIENT_SYSTEMS 0x1167U // Salient Systems Corp.
#define UHS_VID_BIZCONN_INTERNATIONAL 0x1168U // BizConn International Corp.
#define UHS_VID_GIGASTORAGE 0x116eU // Gigastorage Corp.
#define UHS_VID_SILICON_10_TECHNOLOGY 0x116fU // Silicon 10 Technology Corp.
#define UHS_VID_SHENGYIH_STEEL_MOLD 0x1175U // Shengyih Steel Mold Co., Ltd
#define UHS_VID_SANTA_ELECTRONIC 0x117dU // Santa Electronic, Inc.
#define UHS_VID_JNC 0x117eU // JNC, Inc.
#define UHS_VID_VENTURE 0x1182U // Venture Corp., Ltd
#define UHS_VID_COMPAQ_COMPUTER_CORP_HEX_DIGITAL_DREAM_UNKNOWN 0x1183U // Compaq Computer Corp. [hex] (Digital Dream ?)
#define UHS_VID_KYOCERA_ELCO 0x1184U // Kyocera Elco Corp.
#define UHS_VID_BLOOMBERG_LP 0x1188U // Bloomberg L.P.
#define UHS_VID_ACER_COMMUNICATIONS_AND_MULTIMEDIA 0x1189U // Acer Communications & Multimedia
#define UHS_VID_YOU_YANG_TECHNOLOGY 0x118fU // You Yang Technology Co., Ltd
#define UHS_VID_TRIPACE 0x1190U // Tripace
#define UHS_VID_LOYALTY_FOUNDER_ENTERPRISE 0x1191U // Loyalty Founder Enterprise Co., Ltd
#define UHS_VID_YANKEE_ROBOTICS 0x1196U // Yankee Robotics, LLC
#define UHS_VID_TECHNOIMAGIA 0x1197U // Technoimagia Co., Ltd
#define UHS_VID_STARSHINE_TECHNOLOGY 0x1198U // StarShine Technology Corp.
#define UHS_VID_SIERRA_WIRELESS 0x1199U // Sierra Wireless, Inc.
#define UHS_VID_ZHAN_QI_TECHNOLOGY 0x119aU // ZHAN QI Technology Co., Ltd
#define UHS_VID_RUWIDO_AUSTRIA 0x119bU // ruwido austria GmbH
#define UHS_VID_CHIPCON_AS 0x11a0U // Chipcon AS
#define UHS_VID_TECHNOVAS 0x11a3U // Technovas Co., Ltd
#define UHS_VID_GLOBALMEDIA_GROUP 0x11aaU // GlobalMedia Group, LLC
#define UHS_VID_EXITO_ELECTRONICS 0x11abU // Exito Electronics Co., Ltd
#define UHS_VID_NIKE 0x11acU // Nike
#define UHS_VID_ATECH_FLASH_TECHNOLOGY 0x11b0U // ATECH FLASH TECHNOLOGY
#define UHS_VID_RANDD_INTERNATIONAL_NV 0x11beU // R&D International NV
#define UHS_VID_INMAX 0x11c5U // Inmax
#define UHS_VID_VERIFONE 0x11caU // VeriFone Inc
#define UHS_VID_TOPFIELD 0x11dbU // Topfield Co., Ltd.
#define UHS_VID_KI_TECHNOLOGY 0x11e6U // K.I. Technology Co. Ltd.
#define UHS_VID_SIEMENS_AG_1 0x11f5U // Siemens AG
#define UHS_VID_PROLIFIC 0x11f6U // Prolific
#define UHS_VID_ALCATEL_UNKNOWN 0x11f7U // Alcatel (?)
#define UHS_VID_TSC_AUTO_ID_TECHNOLOGY 0x1203U // TSC Auto ID Technology Co., Ltd
#define UHS_VID_INTERBIOMETRICS 0x1209U // InterBiometrics
#define UHS_VID_HUDSON_SOFT 0x120eU // Hudson Soft Co., Ltd
#define UHS_VID_MAGELLAN 0x120fU // Magellan
#define UHS_VID_DIGITECH 0x1210U // DigiTech
#define UHS_VID_JUNGSOFT 0x121eU // Jungsoft Co., Ltd
#define UHS_VID_UNKNOWN_MANUFACTURER_1 0x1221U // Unknown manufacturer
#define UHS_VID_SKYCABLE_ENTERPRISE 0x1223U // SKYCABLE ENTERPRISE. CO., LTD.
#define UHS_VID_DATAPAQ_LIMITED 0x1228U // Datapaq Limited
#define UHS_VID_CHIPIDEA_MICROELECTRONICA 0x1230U // Chipidea-Microelectronica, S.A.
#define UHS_VID_DENVER_ELECTRONICS 0x1233U // Denver Electronics
#define UHS_VID_BRAIN_ACTUATED_TECHNOLOGIES 0x1234U // Brain Actuated Technologies
#define UHS_VID_FOCUSRITE_NOVATION 0x1235U // Focusrite-Novation
#define UHS_VID_BELKIN 0x1241U // Belkin
#define UHS_VID_AIRVAST 0x124aU // AirVast
#define UHS_VID_NYKO_HONEY_BEE 0x124bU // Nyko (Honey Bee)
#define UHS_VID_MXI__MEMORY_EXPERTS_INTERNATIONAL 0x124cU // MXI - Memory Experts International, Inc.
#define UHS_VID_APOGEE 0x125cU // Apogee Inc.
#define UHS_VID_A_DATA_TECHNOLOGY 0x125fU // A-DATA Technology Co., Ltd.
#define UHS_VID_STANDARD_MICROSYSTEMS_3 0x1260U // Standard Microsystems Corp.
#define UHS_VID_COVIDIEN_ENERGY_BASED_DEVICES 0x1264U // Covidien Energy-based Devices
#define UHS_VID_PIRELLI_BROADBAND_SOLUTIONS 0x1266U // Pirelli Broadband Solutions
#define UHS_VID_LOGIC3_SPECTRAVIDEO_PLC 0x1267U // Logic3 / SpectraVideo plc
#define UHS_VID_ARISTOCRAT_TECHNOLOGIES 0x126cU // Aristocrat Technologies
#define UHS_VID_BEL_STEWART 0x126dU // Bel Stewart
#define UHS_VID_STROBE_DATA 0x126eU // Strobe Data, Inc.
#define UHS_VID_TWINMOS 0x126fU // TwinMOS
#define UHS_VID_ENSONIQ 0x1274U // Ensoniq
#define UHS_VID_XAXERO_MARINE_SOFTWARE_ENGINEERING 0x1275U // Xaxero Marine Software Engineering, Ltd.
#define UHS_VID_STARLIGHT_XPRESS 0x1278U // Starlight Xpress
#define UHS_VID_ZEBRIS_MEDICAL 0x1283U // zebris Medical GmbH
#define UHS_VID_MARVELL_SEMICONDUCTOR 0x1286U // Marvell Semiconductor, Inc.
#define UHS_VID_QUALCOMM_FLARION_TECHNOLOGIES_INC_LEADTEK_RESEARCH 0x1291U // Qualcomm Flarion Technologies, Inc. / Leadtek Research, Inc.
#define UHS_VID_INNOMEDIA_1 0x1292U // Innomedia
#define UHS_VID_BELKIN_COMPONENTS_HEX_ 0x1293U // Belkin Components [hex]
#define UHS_VID_RISO_KAGAKU 0x1294U // RISO KAGAKU CORP.
#define UHS_VID_CYBERTAN_TECHNOLOGY 0x129bU // CyberTAN Technology
#define UHS_VID_TRENDCHIP_TECHNOLOGIES 0x12a7U // Trendchip Technologies Corp.
#define UHS_VID_HONEY_BEE_ELECTRONIC_INTERNATIONAL 0x12abU // Honey Bee Electronic International Ltd.
#define UHS_VID_ZHEJIANG_XINYA_ELECTRONIC_TECHNOLOGY 0x12b8U // Zhejiang Xinya Electronic Technology Co., Ltd.
#define UHS_VID_E28 0x12b9U // E28
#define UHS_VID_LICENSED_BY_SONY_COMPUTER_ENTERTAINMENT_AMERICA 0x12baU // Licensed by Sony Computer Entertainment America
#define UHS_VID_GEMBIRD 0x12bdU // Gembird
#define UHS_VID_AUTOCUE_GROUP 0x12c4U // Autocue Group Ltd
#define UHS_VID_DEXIN_1 0x12cfU // DEXIN
#define UHS_VID_HUAWEI_TECHNOLOGIES 0x12d1U // Huawei Technologies Co., Ltd.
#define UHS_VID_LINE_TECH_INDUSTRIAL 0x12d2U // LINE TECH INDUSTRIAL CO., LTD.
#define UHS_VID_EMS_DR_THOMAS_WUENSCHE 0x12d6U // EMS Dr. Thomas Wuensche
#define UHS_VID_BETTER_WIRE_FACTORY 0x12d7U // BETTER WIRE FACTORY CO., LTD.
#define UHS_VID_ARANEUS_INFORMATION_SYSTEMS_OY 0x12d8U // Araneus Information Systems Oy
#define UHS_VID_WALDORF_MUSIC 0x12e6U // Waldorf Music GmbH
#define UHS_VID_TAPWAVE 0x12efU // Tapwave, Inc.
#define UHS_VID_DYNAMIC_SYSTEM_ELECTRONICS 0x12f5U // Dynamic System Electronics Corp.
#define UHS_VID_MEMOREX_PRODUCTS 0x12f7U // Memorex Products, Inc.
#define UHS_VID_AIN_COMM_TECHNOLOGY 0x12fdU // AIN Comm. Technology Co., Ltd
#define UHS_VID_FASCINATING_ELECTRONICS 0x12ffU // Fascinating Electronics, Inc.
#define UHS_VID_TRANSCEND_INFORMATION 0x1307U // Transcend Information, Inc.
#define UHS_VID_SHUTTLE_1 0x1308U // Shuttle, Inc.
#define UHS_VID_ROPER 0x1310U // Roper
#define UHS_VID_ICS_ELECTRONICS 0x1312U // ICS Electronics
#define UHS_VID_THORLABS 0x1313U // ThorLabs
#define UHS_VID_NATURAL_POINT 0x131dU // Natural Point
#define UHS_VID_ENVARA 0x132aU // Envara Inc.
#define UHS_VID_KONICA_MINOLTA 0x132bU // Konica Minolta
#define UHS_VID_KEMPER_DIGITAL 0x133eU // Kemper Digital GmbH
#define UHS_VID_MOBILITY 0x1342U // Mobility
#define UHS_VID_CITIZEN_SYSTEMS 0x1343U // Citizen Systems
#define UHS_VID_SINO_LITE_TECHNOLOGY 0x1345U // Sino Lite Technology Corp.
#define UHS_VID_MORAVIAN_INSTRUMENTS 0x1347U // Moravian Instruments
#define UHS_VID_KATSURAGAWA_ELECTRIC 0x1348U // Katsuragawa Electric Co., Ltd.
#define UHS_VID_PANJIT_INTERNATIONAL 0x134cU // PanJit International Inc.
#define UHS_VID_DIGBYS_BITPILE_INC_DBA_D_BIT 0x134eU // Digby's Bitpile, Inc. DBA D Bit
#define UHS_VID_PANDE_MICROCOMPUTER_SYSTEMS 0x1357U // P&E Microcomputer Systems
#define UHS_VID_CONTROL_DEVELOPMENT 0x135fU // Control Development Inc.
#define UHS_VID_SEGGER 0x1366U // SEGGER
#define UHS_VID_STEC 0x136bU // STEC
#define UHS_VID_ANDOR_TECHNOLOGY 0x136eU // Andor Technology Ltd.
#define UHS_VID_SWISSBIT 0x1370U // Swissbit
#define UHS_VID_CNET_TECHNOLOGY 0x1371U // CNet Technology Inc.
#define UHS_VID_VIMTRON_ELECTRONICS 0x1376U // Vimtron Electronics Co., Ltd.
#define UHS_VID_SCAPS 0x137bU // SCAPS GmbH
#define UHS_VID_NETGEAR_2 0x1385U // Netgear, Inc
#define UHS_VID_VALIDITY_SENSORS 0x138aU // Validity Sensors, Inc.
#define UHS_VID_JUNGO 0x138eU // Jungo LTD
#define UHS_VID_TOMTOM_BV 0x1390U // TOMTOM B.V.
#define UHS_VID_IDEALTEK 0x1391U // IdealTEK, Inc.
#define UHS_VID_SENNHEISER_COMMUNICATIONS 0x1395U // Sennheiser Communications
#define UHS_VID_BEHRINGER_INTERNATIONAL 0x1397U // BEHRINGER International GmbH
#define UHS_VID_Q_TEC 0x1398U // Q-tec
#define UHS_VID_BALTECH 0x13adU // Baltech
#define UHS_VID_PERKINELMER_OPTOELECTRONICS 0x13b0U // PerkinElmer Optoelectronics
#define UHS_VID_LINKSYS_2 0x13b1U // Linksys
#define UHS_VID_ALESIS 0x13b2U // Alesis
#define UHS_VID_NIPPON_DICS 0x13b3U // Nippon Dics Co., Ltd.
#define UHS_VID_PCPLAY 0x13baU // PCPlay
#define UHS_VID_RICOH_PRINTING_SYSTEMS 0x13beU // Ricoh Printing Systems, Ltd.
#define UHS_VID_JYETAI_PRECISION_INDUSTRIAL 0x13caU // JyeTai Precision Industrial Co., Ltd.
#define UHS_VID_WISAIR 0x13cfU // Wisair Ltd.
#define UHS_VID_TECHSAN_ELECTRONICS 0x13d0U // Techsan Electronics Co., Ltd.
#define UHS_VID_A_MAX_TECHNOLOGY_MACAO_COMMERCIAL_OFFSHORE 0x13d1U // A-Max Technology Macao Commercial Offshore Co. Ltd.
#define UHS_VID_SHARK_MULTIMEDIA_1 0x13d2U // Shark Multimedia
#define UHS_VID_IMC_NETWORKS 0x13d3U // IMC Networks
#define UHS_VID_GUIDANCE_SOFTWARE 0x13d7U // Guidance Software, Inc.
#define UHS_VID_ALEREON 0x13dcU // ALEREON, INC.
#define UHS_VID_ITECH_DYNAMIC_LIMITED 0x13ddU // i.Tech Dynamic Limited
#define UHS_VID_KAIBO_WIRE_AND_CABLE_SHENZHEN 0x13e1U // Kaibo Wire & Cable (Shenzhen) Co., Ltd.
#define UHS_VID_RANE 0x13e5U // Rane
#define UHS_VID_TECHNOSCOPE 0x13e6U // TechnoScope Co., Ltd.
#define UHS_VID_HENGSTLER 0x13eaU // Hengstler
#define UHS_VID_ZYDACRON 0x13ecU // Zydacron
#define UHS_VID_MOSART 0x13eeU // MosArt
#define UHS_VID_INITIO_CORPORATION 0x13fdU // Initio Corporation
#define UHS_VID_KINGSTON_TECHNOLOGY_COMPANY_1 0x13feU // Kingston Technology Company Inc.
#define UHS_VID_AXXION_GROUP 0x1400U // Axxion Group Corp.
#define UHS_VID_BOWE_BELL_AND_HOWELL 0x1402U // Bowe Bell & Howell
#define UHS_VID_SITRONIX 0x1403U // Sitronix
#define UHS_VID_IDS_IMAGING_DEVELOPMENT_SYSTEMS 0x1409U // IDS Imaging Development Systems GmbH
#define UHS_VID_TELECHIPS 0x140eU // Telechips, Inc.
#define UHS_VID_NOVATEL_WIRELESS_1 0x1410U // Novatel Wireless
#define UHS_VID_NAM_TAI_EANDE_PRODUCTS_LTD_OR_OMNIVISION_TECHNOLOGIES 0x1415U // Nam Tai E&E Products Ltd. or OmniVision Technologies, Inc.
#define UHS_VID_ABILITY_ENTERPRISE 0x1419U // ABILITY ENTERPRISE CO., LTD.
#define UHS_VID_SENSOR_TECHNOLOGY 0x1421U // Sensor Technology
#define UHS_VID_VEGA_TECHNOLOGIES_INDUSTRIAL_AUSTRIA 0x1429U // Vega Technologies Industrial (Austria) Co.
#define UHS_VID_THALES_E_TRANSACTIONS 0x142aU // Thales E-Transactions
#define UHS_VID_ARBITER_SYSTEMS 0x142bU // Arbiter Systems, Inc.
#define UHS_VID_REDOCTANE 0x1430U // RedOctane
#define UHS_VID_PERTECH_RESOURCES 0x1431U // Pertech Resources, Inc.
#define UHS_VID_WISTRON_NEWEB 0x1435U // Wistron NeWeb
#define UHS_VID_DENALI_SOFTWARE 0x1436U // Denali Software, Inc.
#define UHS_VID_ALTEK_CORPORATION 0x143cU // Altek Corporation
#define UHS_VID_DIGILENT 0x1443U // Digilent
#define UHS_VID_XJGROUP 0x1446U // X.J.GROUP
#define UHS_VID_RADIO_SHACK 0x1453U // Radio Shack
#define UHS_VID_EXTENDING_WIRE_AND_CABLE 0x1456U // Extending Wire & Cable Co., Ltd.
#define UHS_VID_FIRST_INTERNATIONAL_COMPUTER_1 0x1457U // First International Computer, Inc.
#define UHS_VID_TRUST 0x145fU // Trust
#define UHS_VID_TATUNG 0x1460U // Tatung Co.
#define UHS_VID_STACCATO_COMMUNICATIONS 0x1461U // Staccato Communications
#define UHS_VID_MICRO_STAR_INTERNATIONAL_1 0x1462U // Micro Star International
#define UHS_VID_HUAWEI_3COM 0x1472U // Huawei-3Com
#define UHS_VID_FORMOSA_INDUSTRIAL_COMPUTING 0x147aU // Formosa Industrial Computing, Inc.
#define UHS_VID_UPEK 0x147eU // Upek
#define UHS_VID_HAMA_GMBH_AND_CO_KG 0x147fU // Hama GmbH & Co., KG
#define UHS_VID_VAILLANT 0x1482U // Vaillant
#define UHS_VID_ELSA_AG_HEX_ 0x1484U // Elsa AG [hex]
#define UHS_VID_SILICOM_1 0x1485U // Silicom
#define UHS_VID_DSP_GROUP 0x1487U // DSP Group, Ltd.
#define UHS_VID_EVATRONIX 0x148eU // EVATRONIX SA
#define UHS_VID_RALINK_TECHNOLOGY 0x148fU // Ralink Technology, Corp.
#define UHS_VID_FUTRONIC_TECHNOLOGY 0x1491U // Futronic Technology Co. Ltd.
#define UHS_VID_SUUNTO 0x1493U // Suunto
#define UHS_VID_PANSTRONG_COMPANY 0x1497U // Panstrong Company Ltd.
#define UHS_VID_MICROTEK_INTERNATIONAL_1 0x1498U // Microtek International Inc.
#define UHS_VID_IMAGINATION_TECHNOLOGIES 0x149aU // Imagination Technologies
#define UHS_VID_WIDEVIEW_TECHNOLOGY 0x14aaU // WideView Technology Inc.
#define UHS_VID_CTK_CORPORATION 0x14adU // CTK Corporation
#define UHS_VID_PRINTRONIX 0x14aeU // Printronix Inc.
#define UHS_VID_ATP_ELECTRONICS 0x14afU // ATP Electronics Inc.
#define UHS_VID_STARTECHCOM 0x14b0U // StarTech.com Ltd.
#define UHS_VID_RALINK_TECHNOLOGY_1 0x14b2U // Ralink Technology, Corp.
#define UHS_VID_ROCKWELL_AUTOMATION 0x14c0U // Rockwell Automation, Inc.
#define UHS_VID_GEMLIGHT_COMPUTER 0x14c2U // Gemlight Computer, Ltd
#define UHS_VID_ZYTRONIC 0x14c8U // Zytronic
#define UHS_VID_SUPER_TOP 0x14cdU // Super Top
#define UHS_VID_JAMER_INDUSTRIES 0x14d8U // JAMER INDUSTRIES CO., LTD.
#define UHS_VID_RARITAN_COMPUTER 0x14ddU // Raritan Computer, Inc.
#define UHS_VID_WINRADIO_COMMUNICATIONS 0x14e0U // WiNRADiO Communications
#define UHS_VID_DIALOGUE_TECHNOLOGY 0x14e1U // Dialogue Technology Corp.
#define UHS_VID_SAIN_INFORMATION_AND_COMMUNICATIONS 0x14e5U // SAIN Information & Communications Co., Ltd.
#define UHS_VID_PLANEX_COMMUNICATIONS_1 0x14eaU // Planex Communications
#define UHS_VID_SHURE 0x14edU // Shure Inc.
#define UHS_VID_TECHNISAT_DIGITAL 0x14f7U // TechniSat Digital GmbH
#define UHS_VID_ELLISYS_1 0x1500U // Ellisys
#define UHS_VID_PINE_TUM_ENTERPRISE 0x1501U // Pine-Tum Enterprise Co., Ltd.
#define UHS_VID_FIRST_INTERNATIONAL_COMPUTER_2 0x1509U // First International Computer, Inc.
#define UHS_VID_MEDMOBILE 0x1513U // medMobile
#define UHS_VID_ACTEL 0x1514U // Actel
#define UHS_VID_COMPUSA 0x1516U // CompUSA
#define UHS_VID_CHESHIRE_ENGINEERING 0x1518U // Cheshire Engineering Corp.
#define UHS_VID_COMNEON 0x1519U // Comneon
#define UHS_VID_BITWIRE 0x1520U // Bitwire Corp.
#define UHS_VID_ENE_TECHNOLOGY_1 0x1524U // ENE Technology Inc
#define UHS_VID_SILICON_PORTALS 0x1527U // Silicon Portals
#define UHS_VID_UBIQUAM 0x1529U // UBIQUAM Co., Ltd.
#define UHS_VID_THESYCON_SYSTEMSOFTWARE_AND_CONSULTING 0x152aU // Thesycon Systemsoftware & Consulting GmbH
#define UHS_VID_MIR_SRL 0x152bU // MIR Srl
#define UHS_VID_JMICRON_TECHNOLOGY_CORP_JMICRON_USA_TECHNOLOGY 0x152dU // JMicron Technology Corp. / JMicron USA Technology Corp.
#define UHS_VID_LG_HLDS 0x152eU // LG (HLDS)
#define UHS_VID_RAZER_USA 0x1532U // Razer USA, Ltd
#define UHS_VID_TERRATEC_ELECTRONIC_1 0x153bU // TerraTec Electronic GmbH
#define UHS_VID_U_BLOX_AG 0x1546U // U-Blox AG
#define UHS_VID_SG_INTEC_LTD_AND_CO_KG 0x1547U // SG Intec Ltd & Co KG
#define UHS_VID_CELECTRONIC 0x154aU // Celectronic GmbH
#define UHS_VID_PNY 0x154bU // PNY
#define UHS_VID_CONNECTCOUNTY_HOLDINGS_BERHAD 0x154dU // ConnectCounty Holdings Berhad
#define UHS_VID_DANDM_HOLDINGS_INC_DENONMARANTZ 0x154eU // D&M Holdings, Inc. (Denon/Marantz)
#define UHS_VID_SNBC 0x154fU // SNBC CO., Ltd
#define UHS_VID_PROLINK_MICROSYSTEMS 0x1554U // Prolink Microsystems Corp.
#define UHS_VID_OQO 0x1557U // OQO
#define UHS_VID_SUNF_PU_TECHNOLOGY 0x1568U // Sunf Pu Technology Co., Ltd
#define UHS_VID_QUANTUM_CORPORATION 0x156fU // Quantum Corporation
#define UHS_VID_ALLTOP_TECHNOLOGY 0x1570U // ALLTOP TECHNOLOGY CO., LTD.
#define UHS_VID_KETRON_SRL 0x157bU // Ketron SRL
#define UHS_VID_TRENDNET 0x157eU // TRENDnet
#define UHS_VID_FIBERLINE 0x1582U // Fiberline
#define UHS_VID_SMA_TECHNOLOGIE_AG 0x1587U // SMA Technologie AG
#define UHS_VID_OAKLEY 0x158dU // Oakley Inc.
#define UHS_VID_JDS_UNIPHASE_CORPORATION_JDSU 0x158eU // JDS Uniphase Corporation (JDSU)
#define UHS_VID_KUNSHAN_GUOJI_ELECTRONICS 0x1598U // Kunshan Guoji Electronics Co., Ltd.
#define UHS_VID_FREESCALE_SEMICONDUCTOR 0x15a2U // Freescale Semiconductor, Inc.
#define UHS_VID_AFATECH_TECHNOLOGIES 0x15a4U // Afatech Technologies, Inc.
#define UHS_VID_TEAMS_POWER_LIMITED 0x15a8U // Teams Power Limited
#define UHS_VID_GEMTEK 0x15a9U // Gemtek
#define UHS_VID_GEARWAY_ELECTRONICS_DONG_GUAN 0x15aaU // Gearway Electronics (Dong Guan) Co., Ltd.
#define UHS_VID_VMWARE_1 0x15adU // VMware Inc.
#define UHS_VID_OLIMEX 0x15baU // Olimex Ltd.
#define UHS_VID_XL_IMAGING 0x15c0U // XL Imaging
#define UHS_VID_SOUNDGRAPH 0x15c2U // SoundGraph Inc.
#define UHS_VID_ADVANCE_MULTIMEDIA_INTERNET_TECHNOLOGY_INC_AMIT 0x15c5U // Advance Multimedia Internet Technology Inc. (AMIT)
#define UHS_VID_LABORATOIRES_MXM 0x15c6U // Laboratoires MXM
#define UHS_VID_KTF_TECHNOLOGIES 0x15c8U // KTF Technologies
#define UHS_VID_D_BOX_TECHNOLOGIES 0x15c9U // D-Box Technologies
#define UHS_VID_TEXTECH_INTERNATIONAL 0x15caU // Textech International Ltd.
#define UHS_VID_COULOMB_ELECTRONICS 0x15d5U // Coulomb Electronics Ltd.
#define UHS_VID_TRUST_INTERNATIONAL_BV_1 0x15d9U // Trust International B.V.
#define UHS_VID_HYNIX_SEMICONDUCTOR 0x15dcU // Hynix Semiconductor Inc.
#define UHS_VID_SEONG_JI_INDUSTRIAL 0x15e0U // Seong Ji Industrial Co., Ltd.
#define UHS_VID_RSA 0x15e1U // RSA
#define UHS_VID_NUMARK 0x15e4U // Numark
#define UHS_VID_SOHOWARE 0x15e8U // SohoWare
#define UHS_VID_PACIFIC_DIGITAL 0x15e9U // Pacific Digital Corp.
#define UHS_VID_BELCARRA_TECHNOLOGIES 0x15ecU // Belcarra Technologies Corp.
#define UHS_VID_HANFTEK 0x15f4U // HanfTek
#define UHS_VID_TASCAM 0x1604U // Tascam
#define UHS_VID_UMAX_1 0x1606U // Umax
#define UHS_VID_INSIDE_OUT_NETWORKS_HEX_ 0x1608U // Inside Out Networks [hex]
#define UHS_VID_VIA_TECHNOLOGIES_1 0x160aU // VIA Technologies, Inc.
#define UHS_VID_INRO 0x160eU // INRO
#define UHS_VID_AMOI_ELECTRONICS 0x1614U // Amoi Electronics
#define UHS_VID_SONY_1 0x1617U // Sony Corp.
#define UHS_VID_L_AND_K_PRECISION_TECHNOLOGY 0x1619U // L & K Precision Technology Co., Ltd.
#define UHS_VID_WIONICS_RESEARCH 0x1621U // Wionics Research
#define UHS_VID_STONESTREET_ONE 0x1628U // Stonestreet One, Inc.
#define UHS_VID_AIRGO_NETWORKS 0x162aU // Airgo Networks Inc.
#define UHS_VID_WIQUEST_COMMUNICATIONS 0x162fU // WiQuest Communications, Inc.
#define UHS_VID_2WIRE_1 0x1630U // 2Wire, Inc.
#define UHS_VID_GOOD_WAY_TECHNOLOGY 0x1631U // Good Way Technology
#define UHS_VID_ENTREGA_HEX_ 0x1645U // Entrega [hex]
#define UHS_VID_SOFTEC_MICROSYSTEMS 0x1649U // SofTec Microsystems
#define UHS_VID_CHIPX 0x164aU // ChipX
#define UHS_VID_MATRIX_VISION 0x164cU // Matrix Vision GmbH
#define UHS_VID_STRUCK_INNOVATIVE_SYSTEME 0x1657U // Struck Innovative Systeme GmbH
#define UHS_VID_FRONTIER_DESIGN_GROUP 0x165bU // Frontier Design Group
#define UHS_VID_KONDO_KAGAKU 0x165cU // Kondo Kagaku
#define UHS_VID_CREATIX_POLYMEDIA 0x1660U // Creatix Polymedia GmbH
#define UHS_VID_GIGA_TMS 0x1667U // GIGA-TMS INC.
#define UHS_VID_ACTIONTEC_ELECTRONICS_INC_HEX_ 0x1668U // Actiontec Electronics, Inc. [hex]
#define UHS_VID_PIKRON_LTD_HEX_ 0x1669U // PiKRON Ltd. [hex]
#define UHS_VID_CLIPSAL 0x166aU // Clipsal
#define UHS_VID_CHINA_HUADA_INTEGRATED_CIRCUIT_DESIGN_GROUP_CO_LTD_CIDC_GROUP 0x1677U // China Huada Integrated Circuit Design (Group) Co., Ltd. (CIDC Group)
#define UHS_VID_TOTAL_PHASE 0x1679U // Total Phase
#define UHS_VID_GOLDEN_BRIDGE_ELECTECH_1 0x1680U // Golden Bridge Electech Inc.
#define UHS_VID_PREVO_TECHNOLOGIES 0x1681U // Prevo Technologies, Inc.
#define UHS_VID_MAXWISE_PRODUCTION_ENTERPRISE 0x1682U // Maxwise Production Enterprise Ltd.
#define UHS_VID_GODSPEED_COMPUTER 0x1684U // Godspeed Computer Corp.
#define UHS_VID_DELOCK 0x1685U // Delock
#define UHS_VID_ZOOM_CORPORATION 0x1686U // ZOOM Corporation
#define UHS_VID_KINGMAX_DIGITAL 0x1687U // Kingmax Digital Inc.
#define UHS_VID_SAAB 0x1688U // Saab AB
#define UHS_VID_RAZER_USA_1 0x1689U // Razer USA, Ltd
#define UHS_VID_ATHEROS_COMMUNICATIONS_1 0x168cU // Atheros Communications
#define UHS_VID_ASKEY_COMPUTER_CORP_HEX_ 0x1690U // Askey Computer Corp. [hex]
#define UHS_VID_HITACHI_VIDEO_AND_INFORMATION_SYSTEM 0x1696U // Hitachi Video and Information System, Inc.
#define UHS_VID_VTEC_TEST 0x1697U // VTec Test, Inc.
#define UHS_VID_SHENZHEN_ZHENGERYA_CABLE 0x16a5U // Shenzhen Zhengerya Cable Co., Ltd.
#define UHS_VID_UNIGRAF 0x16a6U // Unigraf
#define UHS_VID_GLOBAL_SUN_TECHNOLOGY_1 0x16abU // Global Sun Technology
#define UHS_VID_DONGGUAN_CHINGLUNG_WIRE_AND_CABLE 0x16acU // Dongguan ChingLung Wire & Cable Co., Ltd.
#define UHS_VID_ISTATION 0x16b4U // iStation
#define UHS_VID_PERSENTEC 0x16b5U // Persentec, Inc.
#define UHS_VID_VAN_OOIJEN_TECHNISCHE_INFORMATICA 0x16c0U // Van Ooijen Technische Informatica
#define UHS_VID_WIRELESS_CABLES 0x16caU // Wireless Cables, Inc.
#define UHS_VID_SILEX_TECHNOLOGY 0x16ccU // silex technology, Inc.
#define UHS_VID_MCS 0x16d0U // MCS
#define UHS_VID_SUPREMA 0x16d1U // Suprema Inc.
#define UHS_VID_FRONTLINE_TEST_EQUIPMENT 0x16d3U // Frontline Test Equipment, Inc.
#define UHS_VID_ANYDATA_CORPORATION 0x16d5U // AnyDATA Corporation
#define UHS_VID_JABLOCOM_SRO 0x16d6U // JABLOCOM s.r.o.
#define UHS_VID_CMOTECH 0x16d8U // CMOTECH Co., Ltd.
#define UHS_VID_WIENER_PLEIN_AND_BAUS 0x16dcU // Wiener, Plein & Baus
#define UHS_VID_KING_BILLION_ELECTRONICS 0x16dfU // King Billion Electronics Co., Ltd.
#define UHS_VID_GN_RESOUND_AS 0x16f0U // GN ReSound A/S
#define UHS_VID_FUTURELOGIC 0x16f5U // Futurelogic Inc.
#define UHS_VID_BLUEVIEW_TECHNOLOGIES 0x1706U // BlueView Technologies, Inc.
#define UHS_VID_ARTIMI 0x1707U // ARTIMI
#define UHS_VID_SWISSONIC 0x170bU // Swissonic
#define UHS_VID_AVNERA 0x170dU // Avnera
#define UHS_VID_LEICA_MICROSYSTEMS 0x1711U // Leica Microsystems
#define UHS_VID_MEYER_INSTRUMENTS_MIS 0x1724U // Meyer Instruments (MIS)
#define UHS_VID_VITESSE_SEMICONDUCTOR 0x1725U // Vitesse Semiconductor
#define UHS_VID_AXESSTEL 0x1726U // Axesstel, Inc.
#define UHS_VID_WALTOP_INTERNATIONAL 0x172fU // Waltop International Corp.
#define UHS_VID_CELLINK_TECHNOLOGY 0x1733U // Cellink Technology Co., Ltd
#define UHS_VID_CANON_IMAGING_SYSTEM_TECHNOLOGIES 0x1736U // CANON IMAGING SYSTEM TECHNOLOGIES INC.
#define UHS_VID_LINKSYS_3 0x1737U // Linksys
#define UHS_VID_QSENN 0x173dU // QSENN
#define UHS_VID_SENAO 0x1740U // Senao
#define UHS_VID_GENERAL_ATOMICS 0x1743U // General Atomics
#define UHS_VID_MQP_ELECTRONICS 0x1748U // MQP Electronics
#define UHS_VID_ASMEDIA_TECHNOLOGY 0x174cU // ASMedia Technology Inc.
#define UHS_VID_SYNTEK 0x174fU // Syntek
#define UHS_VID_GERTEC_TELECOMUNICACOES_LTDA 0x1753U // GERTEC Telecomunicacoes Ltda.
#define UHS_VID_ENENSYS_TECHNOLOGIES 0x1756U // ENENSYS Technologies
#define UHS_VID_LUCIDPORT_TECHNOLOGY 0x1759U // LucidPort Technology, Inc.
#define UHS_VID_ASUSTEK_COMPUTER_INC_WRONG_ID 0x1761U // ASUSTek Computer, Inc. (wrong ID)
#define UHS_VID_SYSTEM_LEVEL_SOLUTIONS 0x1772U // System Level Solutions, Inc.
#define UHS_VID_AROWANA 0x1776U // Arowana
#define UHS_VID_SWEEX 0x177fU // Sweex
#define UHS_VID_MULTIPLE_VENDORS 0x1781U // Multiple Vendors
#define UHS_VID_SPREADTRUM_COMMUNICATIONS 0x1782U // Spreadtrum Communications Inc.
#define UHS_VID_TOPSEED_TECHNOLOGY 0x1784U // TopSeed Technology Corp.
#define UHS_VID_ATI_AIB 0x1787U // ATI AIB
#define UHS_VID_SHENZHEN_LITKCONN_TECHNOLOGY 0x1788U // ShenZhen Litkconn Technology Co., Ltd.
#define UHS_VID_PRINTREX 0x1796U // Printrex, Inc.
#define UHS_VID_JALCO 0x1797U // JALCO CO., LTD.
#define UHS_VID_THALES_NORWAY_AS 0x1799U // Thales Norway A/S
#define UHS_VID_RICAVISION_INTERNATIONAL 0x179dU // Ricavision International, Inc.
#define UHS_VID_SAMSON_TECHNOLOGIES 0x17a0U // Samson Technologies Corp.
#define UHS_VID_CONCEPT2 0x17a4U // Concept2
#define UHS_VID_ADVANCED_CONNECTION_TECHNOLOGY 0x17a5U // Advanced Connection Technology Inc.
#define UHS_VID_MICOMSOFT 0x17a7U // MICOMSOFT CO., LTD.
#define UHS_VID_KAMSTRUP_AS 0x17a8U // Kamstrup A/S
#define UHS_VID_GREY_INNOVATION 0x17b3U // Grey Innovation
#define UHS_VID_LUNATONE 0x17b5U // Lunatone
#define UHS_VID_SAURIS 0x17baU // SAURIS GmbH
#define UHS_VID_SINGIM_INTERNATIONAL 0x17c3U // Singim International Corp.
#define UHS_VID_NATIVE_INSTRUMENTS 0x17ccU // Native Instruments
#define UHS_VID_HIP_HING_CABLE_AND_PLUG_MFY 0x17cfU // Hip Hing Cable & Plug Mfy. Ltd.
#define UHS_VID_SANFORD_LP 0x17d0U // Sanford L.P.
#define UHS_VID_KOREA_TECHTRON 0x17d3U // Korea Techtron Co., Ltd.
#define UHS_VID_DISPLAYLINK 0x17e9U // DisplayLink
#define UHS_VID_CORNICE 0x17ebU // Cornice, Inc.
#define UHS_VID_LENOVO 0x17efU // Lenovo
#define UHS_VID_WAVESENSE 0x17f4U // WaveSense
#define UHS_VID_KK_ROCKY 0x17f5U // K.K. Rocky
#define UHS_VID_UNICOMP 0x17f6U // Unicomp, Inc
#define UHS_VID_ADVANTECH 0x1809U // Advantech
#define UHS_VID_TWINHAN 0x1822U // Twinhan
#define UHS_VID_GWO_JINN_INDUSTRIES 0x1831U // Gwo Jinn Industries Co., Ltd.
#define UHS_VID_HUIZHOU_SHENGHUA_INDUSTRIAL 0x1832U // Huizhou Shenghua Industrial Co., Ltd.
#define UHS_VID_VIVOPHONE 0x183dU // VIVOphone
#define UHS_VID_VAISALA 0x1843U // Vaisala
#define UHS_VID_ASROCK_INCORPORATION 0x1849U // ASRock Incorporation
#define UHS_VID_GYROCOM_CANDC 0x1852U // GYROCOM C&C Co., LTD
#define UHS_VID_MEMORY_DEVICES 0x1854U // Memory Devices Ltd.
#define UHS_VID_COMPRO 0x185bU // Compro
#define UHS_VID_TECH_TECHNOLOGY_INDUSTRIAL_COMPANY 0x1861U // Tech Technology Industrial Company
#define UHS_VID_TERIDIAN_SEMICONDUCTOR 0x1862U // Teridian Semiconductor Corp.
#define UHS_VID_NEXIO_1 0x1870U // Nexio Co., Ltd
#define UHS_VID_AVEO_TECHNOLOGY 0x1871U // Aveo Technology Corp.
#define UHS_VID_NAVILOCK 0x1873U // Navilock
#define UHS_VID_ALIENWARE_CORPORATION 0x187cU // Alienware Corporation
#define UHS_VID_SIANO_MOBILE_SILICON 0x187fU // Siano Mobile Silicon
#define UHS_VID_VAST_TECHNOLOGIES_1 0x1892U // Vast Technologies, Inc.
#define UHS_VID_TOPSEED 0x1894U // Topseed
#define UHS_VID_EVERTOP_WIRE_CABLE 0x1897U // Evertop Wire Cable Co.
#define UHS_VID_3SHAPE_AS 0x189fU // 3Shape A/S
#define UHS_VID_CSSN 0x18a4U // CSSN
#define UHS_VID_VERBATIM 0x18a5U // Verbatim, Ltd
#define UHS_VID_PETALYNX 0x18b1U // Petalynx
#define UHS_VID_E3C_TECHNOLOGIES 0x18b4U // e3C Technologies
#define UHS_VID_MIKKON_TECHNOLOGY_LIMITED 0x18b6U // Mikkon Technology Limited
#define UHS_VID_ZOTEK_ELECTRONIC 0x18b7U // Zotek Electronic Co., Ltd.
#define UHS_VID_AMIT_TECHNOLOGY 0x18c5U // AMIT Technology, Inc.
#define UHS_VID_ECAMM 0x18cdU // Ecamm
#define UHS_VID_GOOGLE 0x18d1U // Google Inc.
#define UHS_VID_STARLINE_INTERNATIONAL_GROUP_LIMITED 0x18d5U // Starline International Group Limited
#define UHS_VID_KABA 0x18d9U // Kaba
#define UHS_VID_LKC_TECHNOLOGIES 0x18dcU // LKC Technologies, Inc.
#define UHS_VID_PLANON_SYSTEM_SOLUTIONS 0x18ddU // Planon System Solutions Inc.
#define UHS_VID_FITIPOWER_INTEGRATED_TECHNOLOGY 0x18e3U // Fitipower Integrated Technology Inc
#define UHS_VID_QCOM 0x18e8U // Qcom
#define UHS_VID_MATROX_GRAPHICS 0x18eaU // Matrox Graphics, Inc.
#define UHS_VID_ARKMICRO_TECHNOLOGIES 0x18ecU // Arkmicro Technologies Inc.
#define UHS_VID_FINEARCH 0x18fdU // FineArch Inc.
#define UHS_VID_GEMBIRD_1 0x1908U // GEMBIRD
#define UHS_VID_MOTOROLA_GSG 0x190dU // Motorola GSG
#define UHS_VID_ALCO_DIGITAL_DEVICES_LIMITED 0x1914U // Alco Digital Devices Limited
#define UHS_VID_NORDIC_SEMICONDUCTOR_ASA 0x1915U // Nordic Semiconductor ASA
#define UHS_VID_FITLINXX 0x1923U // FitLinxx
#define UHS_VID_NEXTWINDOW 0x1926U // NextWindow
#define UHS_VID_AVAGO_TECHNOLOGIES_PTE 0x192fU // Avago Technologies, Pte.
#define UHS_VID_SHENZHEN_XIANHE_TECHNOLOGY 0x1930U // Shenzhen Xianhe Technology Co., Ltd.
#define UHS_VID_NINGBO_BROAD_TELECOMMUNICATION 0x1931U // Ningbo Broad Telecommunication Co., Ltd.
#define UHS_VID_FEATURE_INTEGRATION_TECHNOLOGY_INC_FINTEK 0x1934U // Feature Integration Technology Inc. (Fintek)
#define UHS_VID_DREAM_LINK 0x1941U // Dream Link
#define UHS_VID_SENSORAY 0x1943U // Sensoray Co., Inc.
#define UHS_VID_LAB126 0x1949U // Lab126, Inc.
#define UHS_VID_PRESONUS_AUDIO_ELECTRONICS 0x194fU // PreSonus Audio Electronics, Inc.
#define UHS_VID_HYPERSTONE_AG 0x1951U // Hyperstone AG
#define UHS_VID_IRONKEY 0x1953U // Ironkey Inc.
#define UHS_VID_RADIIENT_TECHNOLOGIES 0x1954U // Radiient Technologies
#define UHS_VID_ITRON_TECHNOLOGY_IONE 0x195dU // Itron Technology iONE
#define UHS_VID_UNIDEN_CORPORATION 0x1965U // Uniden Corporation
#define UHS_VID_CASIO_HITACHI_MOBILE_COMMUNICATIONS 0x1967U // CASIO HITACHI Mobile Communications Co., Ltd.
#define UHS_VID_WISPRO_TECHNOLOGY 0x196bU // Wispro Technology Inc.
#define UHS_VID_DANE_ELEC_CORP_USA 0x1970U // Dane-Elec Corp. USA
#define UHS_VID_DONGGUAN_GUNEETAL_WIRE_AND_CABLE 0x1975U // Dongguan Guneetal Wire & Cable Co., Ltd.
#define UHS_VID_CHIPSBRAND_MICROELECTRONICS_HK 0x1976U // Chipsbrand Microelectronics (HK) Co., Ltd.
#define UHS_VID_T_LOGIC 0x1977U // T-Logic
#define UHS_VID_LEUZE_ELECTRONIC 0x197dU // Leuze electronic
#define UHS_VID_NUCONN_TECHNOLOGY 0x1989U // Nuconn Technology Corp.
#define UHS_VID_BECEEM_COMMUNICATIONS 0x198fU // Beceem Communications Inc.
#define UHS_VID_ACRON_PRECISION_INDUSTRIAL 0x1990U // Acron Precision Industrial Co., Ltd.
#define UHS_VID_TRILLIUM_TECHNOLOGY_PTY 0x1995U // Trillium Technology Pty. Ltd.
#define UHS_VID_PIXELINK 0x1996U // PixeLINK
#define UHS_VID_MICROSTRAIN 0x199bU // MicroStrain, Inc.
#define UHS_VID_THE_IMAGING_SOURCE_EUROPE 0x199eU // The Imaging Source Europe GmbH
#define UHS_VID_BENICA_CORPORATION 0x199fU // Benica Corporation
#define UHS_VID_BIFORST_TECHNOLOGY 0x19a8U // Biforst Technology Inc.
#define UHS_VID_BODELIN 0x19abU // Bodelin
#define UHS_VID_S_LIFE 0x19afU // S Life
#define UHS_VID_BATRONIX 0x19b2U // Batronix
#define UHS_VID_CELESTRON 0x19b4U // Celestron
#define UHS_VID_B_AND_W_GROUP 0x19b5U // B & W Group
#define UHS_VID_INFOTECH_LOGISTIC 0x19b6U // Infotech Logistic, LLC
#define UHS_VID_DATA_ROBOTICS 0x19b9U // Data Robotics
#define UHS_VID_FUTUBA 0x19c2U // Futuba
#define UHS_VID_MINDTRIBE 0x19caU // Mindtribe
#define UHS_VID_PARROT 0x19cfU // Parrot SA
#define UHS_VID_ZTE_WCDMA_TECHNOLOGIES_MSM 0x19d2U // ZTE WCDMA Technologies MSM
#define UHS_VID_KFI_PRINTERS 0x19dbU // KFI Printers
#define UHS_VID_WEIDUAN_ELECTRONIC_ACCESSORY_SZ 0x19e1U // WeiDuan Electronic Accessory (S.Z.) Co., Ltd.
#define UHS_VID_INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE 0x19e8U // Industrial Technology Research Institute
#define UHS_VID_PAK_HENG_TECHNOLOGY_SHENZHEN 0x19efU // Pak Heng Technology (Shenzhen) Co., Ltd.
#define UHS_VID_RODE_MICROPHONES 0x19f7U // RODE Microphones
#define UHS_VID_GAMPAQ_COLTD 0x19faU // Gampaq Co.Ltd
#define UHS_VID_DYNEX 0x19ffU // Dynex
#define UHS_VID_BELLWOOD_INTERNATIONAL 0x1a08U // Bellwood International, Inc.
#define UHS_VID_USB_IF_NON_WORKSHOP 0x1a0aU // USB-IF non-workshop
#define UHS_VID_KES 0x1a12U // KES Co., Ltd.
#define UHS_VID_VEHO 0x1a1dU // Veho
#define UHS_VID_AMPHENOL_EAST_ASIA 0x1a25U // Amphenol East Asia Ltd.
#define UHS_VID_SEAGATE_BRANDED_SOLUTIONS 0x1a2aU // Seagate Branded Solutions
#define UHS_VID_CHINA_RESOURCE_SEMICO 0x1a2cU // China Resource Semico Co., Ltd
#define UHS_VID_QUANTA_MICROSYSTEMS 0x1a32U // Quanta Microsystems, Inc.
#define UHS_VID_ACRUX 0x1a34U // ACRUX
#define UHS_VID_BIWIN_TECHNOLOGY 0x1a36U // Biwin Technology Ltd.
#define UHS_VID_TERMINUS_TECHNOLOGY 0x1a40U // Terminus Technology Inc.
#define UHS_VID_ACTION_ELECTRONICS 0x1a41U // Action Electronics Co., Ltd.
#define UHS_VID_VASCO_DATA_SECURITY_INTERNATIONAL 0x1a44U // VASCO Data Security International
#define UHS_VID_SILICON_IMAGE 0x1a4aU // Silicon Image
#define UHS_VID_SAFEBOOT_INTERNATIONAL_BV 0x1a4bU // SafeBoot International B.V.
#define UHS_VID_TANDBERG_DATA 0x1a5aU // Tandberg Data
#define UHS_VID_ABBOTT_DIABETES_CARE 0x1a61U // Abbott Diabetes Care
#define UHS_VID_SPANSION 0x1a6aU // Spansion Inc.
#define UHS_VID_SAMYOUNG_ELECTRONICS 0x1a6dU // SamYoung Electronics Co., Ltd
#define UHS_VID_GLOBAL_UNICHIP 0x1a6eU // Global Unichip Corp.
#define UHS_VID_SAGEM_ORGA 0x1a6fU // Sagem Orga GmbH
#define UHS_VID_PHYSIK_INSTRUMENTE 0x1a72U // Physik Instrumente
#define UHS_VID_BAYER_HEALTH_CARE 0x1a79U // Bayer Health Care LLC
#define UHS_VID_LUMBERG_CONNECT_GMBH_AND_CO_KG 0x1a7bU // Lumberg Connect  GmbH & Co. KG
#define UHS_VID_EVOLUENT 0x1a7cU // Evoluent
#define UHS_VID_HOLTEK_SEMICONDUCTOR_1 0x1a81U // Holtek Semiconductor, Inc.
#define UHS_VID_QINHENG_ELECTRONICS 0x1a86U // QinHeng Electronics
#define UHS_VID_DYNALITH_SYSTEMS 0x1a89U // Dynalith Systems Co., Ltd.
#define UHS_VID_SGS_TAIWAN 0x1a8bU // SGS Taiwan Ltd.
#define UHS_VID_BANDRICH 0x1a8dU // BandRich, Inc.
#define UHS_VID_LEICA_CAMERA_AG 0x1a98U // Leica Camera AG
#define UHS_VID_DATA_DRIVE_THRU 0x1aa4U // Data Drive Thru, Inc.
#define UHS_VID_UBEACON_TECHNOLOGIES 0x1aa5U // UBeacon Technologies, Inc.
#define UHS_VID_EFORTUNE_TECHNOLOGY 0x1aa6U // eFortune Technology Corp.
#define UHS_VID_KEETOUCH 0x1aadU // KeeTouch
#define UHS_VID_RIGOL_TECHNOLOGIES 0x1ab1U // Rigol Technologies
#define UHS_VID_SALCOMP_PLC 0x1acbU // Salcomp Plc
#define UHS_VID_MIDIPLUS 0x1accU // Midiplus Co, Ltd.
#define UHS_VID_DESAY_WIRE 0x1ad1U // Desay Wire Co., Ltd.
#define UHS_VID_APS 0x1ad4U // APS
#define UHS_VID_SEL_C662_SERIAL_CABLE 0x1adbU // SEL C662 Serial Cable
#define UHS_VID_IC_DESIGN_REINHARD_GOTTINGER 0x1ae4U // ic-design Reinhard Gottinger GmbH
#define UHS_VID_X_TENSIONS 0x1ae7U // X-TENSIONS
#define UHS_VID_HIGH_TOP_PRECISION_ELECTRONIC 0x1aedU // High Top Precision Electronic Co., Ltd.
#define UHS_VID_CONNTECH_ELECTRONIC_SUZHOU_CORPORATION 0x1aefU // Conntech Electronic (Suzhou) Corporation
#define UHS_VID_CONNECT_ONE 0x1af1U // Connect One Ltd.
#define UHS_VID_A_EBERLE_GMBH_AND_CO_KG 0x1afeU // A. Eberle GmbH & Co. KG
#define UHS_VID_MEILHAUS_ELECTRONIC 0x1b04U // Meilhaus Electronic GmbH
#define UHS_VID_BLUTRONICS_SRL 0x1b0eU // BLUTRONICS S.r.l.
#define UHS_VID_CORSAIR 0x1b1cU // Corsair
#define UHS_VID_MSTAR_SEMICONDUCTOR 0x1b20U // MStar Semiconductor, Inc.
#define UHS_VID_WILINX 0x1b22U // WiLinx Corp.
#define UHS_VID_CELLEX_POWER_PRODUCTS 0x1b26U // Cellex Power Products, Inc.
#define UHS_VID_CURRENT_ELECTRONICS 0x1b27U // Current Electronics Inc.
#define UHS_VID_NAVISIS 0x1b28U // NAVIsis Inc.
#define UHS_VID_UGOBE_LIFE_FORMS 0x1b32U // Ugobe Life Forms, Inc.
#define UHS_VID_VIXS_SYSTEMS 0x1b36U // ViXS Systems, Inc.
#define UHS_VID_IPASSION_TECHNOLOGY 0x1b3bU // iPassion Technology Inc.
#define UHS_VID_GENERALPLUS_TECHNOLOGY 0x1b3fU // Generalplus Technology Inc.
#define UHS_VID_ENERGIZER_HOLDINGS 0x1b47U // Energizer Holdings, Inc.
#define UHS_VID_PLASTRON_PRECISION 0x1b48U // Plastron Precision Co., Ltd.
#define UHS_VID_ARH 0x1b52U // ARH Inc.
#define UHS_VID_KS_TERMINALS 0x1b59U // K.S. Terminals Inc.
#define UHS_VID_CHAO_ZHOU_KAI_YUAN_ELECTRIC 0x1b5aU // Chao Zhou Kai Yuan Electric Co., Ltd.
#define UHS_VID_THE_HONG_KONG_STANDARDS_AND_TESTING_CENTRE 0x1b65U // The Hong Kong Standards and Testing Centre Ltd.
#define UHS_VID_FUSHICAI 0x1b71U // Fushicai
#define UHS_VID_ATERGI_TECHNOLOGY 0x1b72U // ATERGI TECHNOLOGY CO., LTD.
#define UHS_VID_FRESCO_LOGIC 0x1b73U // Fresco Logic
#define UHS_VID_OVISLINK 0x1b75U // Ovislink Corp.
#define UHS_VID_LEGEND_SILICON 0x1b76U // Legend Silicon Corp.
#define UHS_VID_AFATECH 0x1b80U // Afatech
#define UHS_VID_DONGGUAN_GUANSHANG_ELECTRONICS 0x1b86U // Dongguan Guanshang Electronics Co., Ltd.
#define UHS_VID_SHENMING_ELECTRON_DONG_GUAN 0x1b88U // ShenMing Electron (Dong Guan) Co., Ltd.
#define UHS_VID_ALTIUM_LIMITED 0x1b8cU // Altium Limited
#define UHS_VID_E_MOVE_TECHNOLOGY 0x1b8dU // e-MOVE Technology Co., Ltd.
#define UHS_VID_AMLOGIC 0x1b8eU // Amlogic, Inc.
#define UHS_VID_MA_LABS 0x1b8fU // MA LABS, Inc.
#define UHS_VID_N_TRIG 0x1b96U // N-Trig
#define UHS_VID_YMAX_COMMUNICATIONS 0x1b98U // YMax Communications Corp.
#define UHS_VID_SHENZHEN_YUANCHUAN_ELECTRONIC 0x1b99U // Shenzhen Yuanchuan Electronic
#define UHS_VID_JINQ_CHERN_ENTERPRISE 0x1ba1U // JINQ CHERN ENTERPRISE CO., LTD.
#define UHS_VID_LITE_METALS_AND_PLASTIC_SHENZHEN 0x1ba2U // Lite Metals & Plastic (Shenzhen) Co., Ltd.
#define UHS_VID_EMBER_CORPORATION 0x1ba4U // Ember Corporation
#define UHS_VID_ABILIS_SYSTEMS 0x1ba6U // Abilis Systems
#define UHS_VID_CHINA_TELECOMMUNICATION_TECHNOLOGY_LABS 0x1ba8U // China Telecommunication Technology Labs
#define UHS_VID_HARMONIX_MUSIC 0x1badU // Harmonix Music
#define UHS_VID_VUZIX_CORPORATION 0x1baeU // Vuzix Corporation
#define UHS_VID_T_AND_A_MOBILE_PHONES 0x1bbbU // T & A Mobile Phones
#define UHS_VID_FORD_MOTOR 0x1bc4U // Ford Motor Co.
#define UHS_VID_AVIXE_TECHNOLOGY_CHINA 0x1bc5U // AVIXE Technology (China) Ltd.
#define UHS_VID_TELIT_WIRELESS_SOLUTIONS 0x1bc7U // Telit Wireless Solutions
#define UHS_VID_CONTAC_CABLE_INDUSTRIAL_LIMITED 0x1bceU // Contac Cable Industrial Limited
#define UHS_VID_SUNPLUS_INNOVATION_TECHNOLOGY 0x1bcfU // Sunplus Innovation Technology Inc.
#define UHS_VID_HANGZHOU_RIYUE_ELECTRONIC 0x1bd0U // Hangzhou Riyue Electronic Co., Ltd.
#define UHS_VID_BG_SYSTEMS 0x1bd5U // BG Systems, Inc.
#define UHS_VID_P_TWO_INDUSTRIES 0x1bdeU // P-TWO INDUSTRIES, INC.
#define UHS_VID_SHENZHEN_TONGYUAN_NETWORK_COMMUNICATION_CABLES 0x1befU // Shenzhen Tongyuan Network-Communication Cables Co., Ltd
#define UHS_VID_REALVISION 0x1bf0U // RealVision Inc.
#define UHS_VID_EXTRANET_SYSTEMS 0x1bf5U // Extranet Systems Inc.
#define UHS_VID_ORIENT_SEMICONDUCTOR_ELECTRONICS 0x1bf6U // Orient Semiconductor Electronics, Ltd.
#define UHS_VID_TOUCHPACK 0x1bfdU // TouchPack
#define UHS_VID_KRETON_CORPORATION 0x1c02U // Kreton Corporation
#define UHS_VID_QNAP_SYSTEM 0x1c04U // QNAP System Inc.
#define UHS_VID_IONICS_EMS 0x1c0cU // Ionics EMS, Inc.
#define UHS_VID_RELM_WIRELESS 0x1c0dU // Relm Wireless
#define UHS_VID_LANTERRA_INDUSTRIAL 0x1c10U // Lanterra Industrial Co., Ltd.
#define UHS_VID_ALECTRONIC_LIMITED 0x1c13U // ALECTRONIC LIMITED
#define UHS_VID_DATEL_ELECTRONICS 0x1c1aU // Datel Electronics Ltd.
#define UHS_VID_VOLKSWAGEN_OF_AMERICA 0x1c1bU // Volkswagen of America, Inc.
#define UHS_VID_GOLDVISH 0x1c1fU // Goldvish S.A.
#define UHS_VID_FUJI_ELECTRIC_DEVICE_TECHNOLOGY 0x1c20U // Fuji Electric Device Technology Co., Ltd.
#define UHS_VID_ADDMM 0x1c21U // ADDMM LLC
#define UHS_VID_ZHONGSHAN_CHIANG_YU_ELECTRIC 0x1c22U // ZHONGSHAN CHIANG YU ELECTRIC CO., LTD.
#define UHS_VID_SHANGHAI_HAIYING_ELECTRONICS 0x1c26U // Shanghai Haiying Electronics Co., Ltd.
#define UHS_VID_HUIYANG_D_AND_S_CABLE 0x1c27U // HuiYang D & S Cable Co., Ltd.
#define UHS_VID_ELSTER 0x1c29U // Elster GmbH
#define UHS_VID_LS_CABLE 0x1c31U // LS Cable Ltd.
#define UHS_VID_SPRINGCARD 0x1c34U // SpringCard
#define UHS_VID_AUTHORIZER_TECHNOLOGIES 0x1c37U // Authorizer Technologies, Inc.
#define UHS_VID_NONIN_MEDICAL 0x1c3dU // NONIN MEDICAL INC.
#define UHS_VID_WEP_PERIPHERALS 0x1c3eU // Wep Peripherals
#define UHS_VID_EZPROTOTYPES 0x1c40U // EZPrototypes
#define UHS_VID_CHERNG_WEEI_TECHNOLOGY 0x1c49U // Cherng Weei Technology Corp.
#define UHS_VID_SIGMA_MICRO 0x1c4fU // SiGma Micro
#define UHS_VID_PHILIPS_AND_LITE_ON_DIGITAL_SOLUTIONS_CORPORATION 0x1c6bU // Philips & Lite-ON Digital Solutions Corporation
#define UHS_VID_SKYDIGITAL 0x1c6cU // Skydigital Inc.
#define UHS_VID_AMT 0x1c73U // AMT
#define UHS_VID_KAETAT_INDUSTRIAL 0x1c77U // Kaetat Industrial Co., Ltd.
#define UHS_VID_DATASCOPE 0x1c78U // Datascope Corp.
#define UHS_VID_UNIGEN_CORPORATION 0x1c79U // Unigen Corporation
#define UHS_VID_LIGHTUNING_TECHNOLOGY 0x1c7aU // LighTuning Technology Inc.
#define UHS_VID_LUXSHARE_PRECISION_INDUSTRY_SHENZHEN 0x1c7bU // LUXSHARE PRECISION INDUSTRY (SHENZHEN) CO., LTD.
#define UHS_VID_SCHOMAECKER 0x1c83U // Schomaecker GmbH
#define UHS_VID_2N_TELEKOMUNIKACE_AS 0x1c87U // 2N TELEKOMUNIKACE a.s.
#define UHS_VID_SOMAGIC 0x1c88U // Somagic, Inc.
#define UHS_VID_HONGKONG_WEIDIDA_ELECTRON_LIMITED 0x1c89U // HONGKONG WEIDIDA ELECTRON LIMITED
#define UHS_VID_ASTRON_INTERNATIONAL 0x1c8eU // ASTRON INTERNATIONAL CORP.
#define UHS_VID_ALPINE_ELECTRONICS 0x1c98U // ALPINE ELECTRONICS, INC.
#define UHS_VID_OMEGA_TECHNOLOGY 0x1c9eU // OMEGA TECHNOLOGY
#define UHS_VID_ACCARIO 0x1ca0U // ACCARIO Inc.
#define UHS_VID_SYMWAVE 0x1ca1U // Symwave
#define UHS_VID_KINSTONE 0x1cacU // Kinstone
#define UHS_VID_ACES_ELECTRONIC 0x1cb3U // Aces Electronic Co., Ltd.
#define UHS_VID_OPEX_CORPORATION 0x1cb4U // OPEX CORPORATION
#define UHS_VID_IDEACOM_TECHNOLOGY 0x1cb6U // IdeaCom Technology Inc.
#define UHS_VID_LUMINARY_MICRO 0x1cbeU // Luminary Micro Inc.
#define UHS_VID_FORTAT_SKYMARK_INDUSTRIAL_COMPANY 0x1cbfU // FORTAT SKYMARK INDUSTRIAL COMPANY
#define UHS_VID_PLANTSENSE 0x1cc0U // PlantSense
#define UHS_VID_NEXTWAVE_BROADBAND 0x1ccaU // NextWave Broadband Inc.
#define UHS_VID_BODATONG_TECHNOLOGY_SHENZHEN 0x1ccdU // Bodatong Technology (Shenzhen) Co., Ltd.
#define UHS_VID_ADP_CORPORATION 0x1cd4U // adp corporation
#define UHS_VID_FIRECOMMS 0x1cd5U // Firecomms Ltd.
#define UHS_VID_ANTONIO_PRECISE_PRODUCTS_MANUFACTORY 0x1cd6U // Antonio Precise Products Manufactory Ltd.
#define UHS_VID_TELECOMMUNICATIONS_TECHNOLOGY_ASSOCIATION_TTA 0x1cdeU // Telecommunications Technology Association (TTA)
#define UHS_VID_WONTEN_TECHNOLOGY 0x1cdfU // WonTen Technology Co., Ltd.
#define UHS_VID_EDIMAX_TECHNOLOGY 0x1ce0U // EDIMAX TECHNOLOGY CO., LTD.
#define UHS_VID_AMPHENOL_KAE 0x1ce1U // Amphenol KAE
#define UHS_VID_DRESDEN_ELEKTRONIK 0x1cf1U // Dresden Elektronik
#define UHS_VID_ANDES_TECHNOLOGY_CORPORATION 0x1cfcU // ANDES TECHNOLOGY CORPORATION
#define UHS_VID_FLEXTRONICS_DIGITAL_DESIGN_JAPAN 0x1cfdU // Flextronics Digital Design Japan, LTD.
#define UHS_VID_ICON 0x1d03U // iCON
#define UHS_VID_SOLID_MOTION 0x1d07U // Solid-Motion
#define UHS_VID_NINGBO_HENTEK_DRAGON_ELECTRONICS 0x1d08U // NINGBO HENTEK DRAGON ELECTRONICS CO., LTD.
#define UHS_VID_TECHFAITH_WIRELESS_TECHNOLOGY_LIMITED 0x1d09U // TechFaith Wireless Technology Limited
#define UHS_VID_JOHNSON_CONTROLS_INC_THE_AUTOMOTIVE_BUSINESS_UNIT 0x1d0aU // Johnson Controls, Inc. The Automotive Business Unit
#define UHS_VID_HAN_HUA_CABLE_AND_WIRE_TECHNOLOGY_JX 0x1d0bU // HAN HUA CABLE & WIRE TECHNOLOGY (J.X.) CO., LTD.
#define UHS_VID_SONIX_TECHNOLOGY 0x1d0fU // Sonix Technology Co., Ltd.
#define UHS_VID_ALPHA_SAT_TECHNOLOGY_LIMITED 0x1d14U // ALPHA-SAT TECHNOLOGY LIMITED
#define UHS_VID_C_THRU_MUSIC 0x1d17U // C-Thru Music Ltd.
#define UHS_VID_DEXATEK_TECHNOLOGY 0x1d19U // Dexatek Technology Ltd.
#define UHS_VID_DIOSTECH 0x1d1fU // Diostech Co., Ltd.
#define UHS_VID_SAMTACK 0x1d20U // SAMTACK INC.
#define UHS_VID_ASUS 0x1d27U // ASUS
#define UHS_VID_DREAM_CHEEKY 0x1d34U // Dream Cheeky
#define UHS_VID_TOUCH 0x1d45U // Touch
#define UHS_VID_PEGATRON_CORPORATION 0x1d4dU // PEGATRON CORPORATION
#define UHS_VID_OPENMOKO 0x1d50U // OpenMoko, Inc.
#define UHS_VID_XENTA 0x1d57U // Xenta
#define UHS_VID_SMARTRONIX 0x1d5bU // Smartronix, Inc.
#define UHS_VID_LINUX_FOUNDATION 0x1d6bU // Linux Foundation
#define UHS_VID_CITIZEN 0x1d90U // Citizen
#define UHS_VID_ACTIONS_MICROELECTRONICS 0x1de1U // Actions Microelectronics Co.
#define UHS_VID_QUALCOMM_OPTION 0x1e0eU // Qualcomm / Option
#define UHS_VID_POINT_GREY_RESEARCH 0x1e10U // Point Grey Research, Inc.
#define UHS_VID_MIRION_TECHNOLOGIES_DOSIMETRY_SERVICES_DIVISION 0x1e17U // Mirion Technologies Dosimetry Services Division
#define UHS_VID_LUMENSION_SECURITY 0x1e1dU // Lumension Security
#define UHS_VID_INVIA 0x1e1fU // INVIA
#define UHS_VID_FESTO_AG_AND_CO_KG 0x1e29U // Festo AG & Co. KG
#define UHS_VID_CHIPSBANK_MICROELECTRONICS_1 0x1e3dU // Chipsbank Microelectronics Co., Ltd
#define UHS_VID_CLEVERSCOPE 0x1e41U // Cleverscope
#define UHS_VID_CUBETERNET 0x1e4eU // Cubeternet
#define UHS_VID_TYPEMATRIX 0x1e54U // TypeMatrix
#define UHS_VID_TREKSTOR_GMBH_AND_CO_KG 0x1e68U // TrekStor GmbH & Co. KG
#define UHS_VID_NZXT 0x1e71U // NZXT
#define UHS_VID_COBY_ELECTRONICS_CORPORATION 0x1e74U // Coby Electronics Corporation
#define UHS_VID_ROCCAT 0x1e7dU // ROCCAT
#define UHS_VID_NUCORE_TECHNOLOGY 0x1ebbU // NuCORE Technology, Inc.
#define UHS_VID_AIRTIES_WIRELESS_NETWORKS 0x1edaU // AirTies Wireless Networks
#define UHS_VID_BLACKMAGIC_DESIGN 0x1edbU // Blackmagic design
#define UHS_VID_ONDA_COMMUNICATION_SPA 0x1ee8U // ONDA COMMUNICATION S.p.a.
#define UHS_VID_EADS_DEUTSCHLAND 0x1ef6U // EADS Deutschland GmbH
#define UHS_VID_CAL_COMP 0x1f28U // Cal-Comp
#define UHS_VID_ONDA_UNVERIFIED 0x1f3aU // Onda (unverified)
#define UHS_VID_THE_NEAT_COMPANY 0x1f44U // The Neat Company
#define UHS_VID_H_TRONIC 0x1f48U // H-TRONIC GmbH
#define UHS_VID_G_TEK_ELECTRONICS_GROUP 0x1f4dU // G-Tek Electronics Group
#define UHS_VID_ALIPH 0x1f6fU // Aliph
#define UHS_VID_INNOSTOR_TECHNOLOGY_CORPORATION 0x1f75U // Innostor Technology Corporation
#define UHS_VID_TANDBERG 0x1f82U // TANDBERG
#define UHS_VID_ALERE 0x1f84U // Alere, Inc.
#define UHS_VID_STANTUM 0x1f87U // Stantum
#define UHS_VID_UBIQUITI_NETWORKS 0x1f9bU // Ubiquiti Networks, Inc.
#define UHS_VID_SAMSUNG_OPTO_ELECTRONCS 0x1fabU // Samsung Opto-Electroncs Co., Ltd.
#define UHS_VID_DELPHIN_TECHNOLOGY_AG 0x1fbdU // Delphin Technology AG
#define UHS_VID_NXP_SEMICONDUCTORS 0x1fc9U // NXP Semiconductors
#define UHS_VID_ILX_LIGHTWAVE_CORPORATION 0x1fdeU // ILX Lightwave Corporation
#define UHS_VID_VERTEX_WIRELESS 0x1fe7U // Vertex Wireless Co., Ltd.
#define UHS_VID_CVT_ELECTRONICSCOLTD 0x1ff7U // CVT Electronics.Co.,Ltd
#define UHS_VID_IDEOFY 0x1fffU // Ideofy Inc.
#define UHS_VID_D_LINK 0x2001U // D-Link Corp.
#define UHS_VID_DAP_TECHNOLOGIES 0x2002U // DAP Technologies
#define UHS_VID_DETECTOMAT 0x2003U // detectomat
#define UHS_VID_RELOOP 0x200cU // Reloop
#define UHS_VID_PCTV_SYSTEMS 0x2013U // PCTV Systems
#define UHS_VID_PLANEX_1 0x2019U // PLANEX
#define UHS_VID_ENCORE_ELECTRONICS 0x203dU // Encore Electronics Inc.
#define UHS_VID_HAUPPAUGE 0x2040U // Hauppauge
#define UHS_VID_TEXAS_INSTRUMENTS_2 0x2047U // Texas Instruments
#define UHS_VID_NANO_RIVER_TECHNOLOGY 0x2058U // Nano River Technology
#define UHS_VID_TAICANG_TANDW_ELECTRONICS 0x2077U // Taicang T&W Electronics Co. Ltd
#define UHS_VID_BARNES_AND_NOBLE 0x2080U // Barnes & Noble
#define UHS_VID_SIMPASS 0x2086U // SIMPASS
#define UHS_VID_CANDO 0x2087U // Cando
#define UHS_VID_CLAY_LOGIC 0x20a0U // Clay Logic
#define UHS_VID_XMOS 0x20b1U // XMOS Ltd
#define UHS_VID_HANVON 0x20b3U // Hanvon
#define UHS_VID_QI_HARDWARE 0x20b7U // Qi Hardware
#define UHS_VID_MINICIRCUITS 0x20ceU // Minicircuits
#define UHS_VID_SIMTEC_ELECTRONICS 0x20dfU // Simtec Electronics
#define UHS_VID_NET_NEW_ELECTRONIC_TECHNOLOGY 0x20f1U // NET New Electronic Technology GmbH
#define UHS_VID_TRENDNET_1 0x20f4U // TRENDnet
#define UHS_VID_XIMEA 0x20f7U // XIMEA
#define UHS_VID_RT_SYSTEMS 0x2100U // RT Systems
#define UHS_VID_ACTIONSTAR 0x2101U // ActionStar
#define UHS_VID_VIA_LABS 0x2109U // VIA Labs, Inc.
#define UHS_VID_SOFTKINETIC 0x2113U // Softkinetic
#define UHS_VID_ADVANCED_SILICON 0x2149U // Advanced Silicon S.A.
#define UHS_VID_CREATIVE_UNKNOWN 0x2162U // Creative (?)
#define UHS_VID_GW_INSTEK 0x2184U // GW Instek
#define UHS_VID_EMOTIV_SYSTEMS_PTY 0x21a1U // Emotiv Systems Pty. Ltd.
#define UHS_VID_AGECODAGIS_SARL 0x21d6U // Agecodagis SARL
#define UHS_VID_MACALLY_1 0x2222U // MacAlly
#define UHS_VID_SAMWOO_ENTERPRISE 0x2227U // SAMWOO Enterprise
#define UHS_VID_SILICON_MOTION_1 0x2232U // Silicon Motion
#define UHS_VID_RADIOSHACK_CORPORATION 0x2233U // RadioShack Corporation
#define UHS_VID_KOBO 0x2237U // Kobo Inc.
#define UHS_VID_MORPHO 0x225dU // Morpho
#define UHS_VID_8D_TECHNOLOGIES 0x228dU // 8D Technologies inc.
#define UHS_VID_PIE_DIGITAL 0x22a6U // Pie Digital, Inc.
#define UHS_VID_MOTOROLA_PCS 0x22b8U // Motorola PCS
#define UHS_VID_ETURBOTOUCH_TECHNOLOGY 0x22b9U // eTurboTouch Technology, Inc.
#define UHS_VID_TECHNOLOGY_INNOVATION_HOLDINGS 0x22baU // Technology Innovation Holdings, Ltd
#define UHS_VID_PINNACLE_SYSTEMS_1 0x2304U // Pinnacle Systems, Inc.
#define UHS_VID_SHINING_TECHNOLOGIES_INC_HEX_ 0x2318U // Shining Technologies, Inc. [hex]
#define UHS_VID_ARDUINO 0x2341U // Arduino SA
#define UHS_VID_PUMATRONIX_LTDA 0x2373U // Pumatronix Ltda
#define UHS_VID_DIGITALWAY_1 0x2375U // Digit@lway, Inc.
#define UHS_VID_SANHO_DIGITAL_ELECTRONICS 0x2406U // SANHO Digital Electronics Co., Ltd.
#define UHS_VID_AESSENT_TECHNOLOGY 0x2443U // Aessent Technology Ltd
#define UHS_VID_TRIPP_LITE_1 0x2478U // Tripp-Lite
#define UHS_VID_MAXXTER 0x248aU // Maxxter
#define UHS_VID_M2TECH_SRL 0x249cU // M2Tech s.r.l.
#define UHS_VID_PARATRONIC 0x24e1U // Paratronic
#define UHS_VID_TWINMOS_1 0x2632U // TwinMOS
#define UHS_VID_XSENS 0x2639U // Xsens
#define UHS_VID_ELECTRONICS_FOR_IMAGING_INC_HEX_ 0x2650U // Electronics For Imaging, Inc. [hex]
#define UHS_VID_SUNDTEK 0x2659U // Sundtek
#define UHS_VID_BASLER_AG 0x2676U // Basler AG
#define UHS_VID_CITIZEN_1 0x2730U // Citizen
#define UHS_VID_DIGITALWAY_2 0x2735U // DigitalWay
#define UHS_VID_NHJ 0x2770U // NHJ, Ltd
#define UHS_VID_THINGM 0x27b8U // ThingM
#define UHS_VID_ASUSTEK_COMPUTER_1 0x2821U // ASUSTek Computer Inc.
#define UHS_VID_TOPTRONIC_INDUSTRIAL 0x2899U // Toptronic Industrial Co., Ltd
#define UHS_VID_DRACALRAPHNET_TECHNOLOGIES 0x289bU // Dracal/Raphnet technologies
#define UHS_VID_JOLLA_OY 0x2931U // Jolla Oy
#define UHS_VID_DOG_HUNTER_AG 0x2a03U // dog hunter AG
#define UHS_VID_RTD_EMBEDDED_TECHNOLOGIES 0x2a37U // RTD Embedded Technologies, Inc.
#define UHS_VID_MEIZU 0x2a45U // Meizu Corp.
#define UHS_VID_PLANEX_COMMUNICATIONS_2 0x2c02U // Planex Communications
#define UHS_VID_DOLPHIN_PERIPHERALS 0x2c1aU // Dolphin Peripherals
#define UHS_VID_FUJITSU_1 0x2fb2U // Fujitsu, Ltd
#define UHS_VID_EAGLETRON_1 0x3125U // Eagletron
#define UHS_VID_NAVINI_NETWORKS 0x3136U // Navini Networks
#define UHS_VID_WHANAM_ELECTRONICS 0x3176U // Whanam Electronics Co., Ltd
#define UHS_VID_LINK_INSTRUMENTS 0x3195U // Link Instruments
#define UHS_VID_VIDZMEDIA_PTE 0x3275U // VidzMedia Pte Ltd
#define UHS_VID_INLINE 0x3333U // InLine
#define UHS_VID_AEI 0x3334U // AEI
#define UHS_VID_YAKUMO 0x3340U // Yakumo
#define UHS_VID_LEAGUER_MICROELECTRONICS_LME 0x3344U // Leaguer Microelectronics (LME)
#define UHS_VID_MICRO_STAR 0x3504U // Micro Star
#define UHS_VID_POWER_QUOTIENT_INTERNATIONAL_1 0x3538U // Power Quotient International Co., Ltd
#define UHS_VID_DIVA 0x3579U // DIVA
#define UHS_VID_SHARKOON 0x357dU // Sharkoon
#define UHS_VID_INVIBRO 0x3636U // InVibro
#define UHS_VID_WEM 0x3838U // WEM
#define UHS_VID_NATIONAL_INSTRUMENTS 0x3923U // National Instruments Corp.
#define UHS_VID_I_O_DATA 0x40bbU // I-O Data
#define UHS_VID_I_ROCKS 0x4101U // i-rocks
#define UHS_VID_IRIVER_1 0x4102U // iRiver, Ltd.
#define UHS_VID_DELL_COMPUTER_1 0x413cU // Dell Computer Corp.
#define UHS_VID_USBEST_TECHNOLOGY 0x4146U // USBest Technology
#define UHS_VID_TARGUS 0x4168U // Targus
#define UHS_VID_USB_DESIGN_BY_EXAMPLE 0x4242U // USB Design by Example
#define UHS_VID_GOPRO 0x4255U // GoPro
#define UHS_VID_BROADCOM_1 0x4317U // Broadcom Corp.
#define UHS_VID_WINCHIPHEAD 0x4348U // WinChipHead
#define UHS_VID_SHUTTLE_2 0x4572U // Shuttle, Inc.
#define UHS_VID_PANRAM 0x4586U // Panram
#define UHS_VID_EMS_PRODUCTION 0x4670U // EMS Production
#define UHS_VID_MIDITECH 0x4752U // Miditech
#define UHS_VID_GW_INSTEK_1 0x4757U // GW Instek
#define UHS_VID_ACEECA 0x4766U // Aceeca
#define UHS_VID_MEMOREX 0x4855U // Memorex
#define UHS_VID_SIMPLETECH 0x4971U // SimpleTech
#define UHS_VID_MUSICAL_FIDELITY 0x4d46U // Musical Fidelity
#define UHS_VID_GRANDTEC 0x5032U // Grandtec
#define UHS_VID_LINKSYS_UNKNOWN 0x5041U // Linksys (?)
#define UHS_VID_AVERATEC_UNKNOWN 0x50c2U // Averatec (?)
#define UHS_VID_SWEEX_1 0x5173U // Sweex
#define UHS_VID_I_TETRA 0x5219U // I-Tetra
#define UHS_VID_OWON 0x5345U // Owon
#define UHS_VID_SATOSHILABS 0x534cU // SatoshiLabs
#define UHS_VID_MEYER_INSTRUMENTS_MIS_1 0x5354U // Meyer Instruments (MIS)
#define UHS_VID_TRANSMETA 0x544dU // Transmeta Corp.
#define UHS_VID_UC_LOGIC_TECHNOLOGY 0x5543U // UC-Logic Technology Corp.
#define UHS_VID_EPIPHAN_SYSTEMS 0x5555U // Epiphan Systems Inc.
#define UHS_VID_ONSPEC_ELECTRONIC 0x55aaU // OnSpec Electronic, Inc.
#define UHS_VID_GOTVIEW 0x5654U // Gotview
#define UHS_VID_UNI_TREND_GROUP_LIMITED 0x5656U // Uni-Trend Group Limited
#define UHS_VID_IRTOUCHSYSTEMS 0x595aU // IRTOUCHSYSTEMS Co. Ltd.
#define UHS_VID_ACER_2 0x5986U // Acer, Inc
#define UHS_VID_NONOLITH_LABS 0x59e3U // Nonolith Labs
#define UHS_VID_ZINWELL 0x5a57U // Zinwell
#define UHS_VID_BEHOLDER_INTERNATIONAL 0x6000U // Beholder International Ltd.
#define UHS_VID_INGENIC_SEMICONDUCTOR 0x601aU // Ingenic Semiconductor Ltd.
#define UHS_VID_SITECOM 0x6189U // Sitecom
#define UHS_VID_LIGHTINGSOFT_AG 0x6244U // LightingSoft AG
#define UHS_VID_TWINHAN_TECHNOLOGY 0x6253U // TwinHan Technology Co., Ltd
#define UHS_VID_CORELOGIC 0x636cU // CoreLogic, Inc.
#define UHS_VID_UNKNOWN_SONY_UNKNOWN 0x6472U // Unknown (Sony?)
#define UHS_VID_ARKMICRO_TECHNOLOGIES_1 0x6547U // Arkmicro Technologies Inc.
#define UHS_VID_IRTOUCHSYSTEMS_1 0x6615U // IRTOUCHSYSTEMS Co. Ltd.
#define UHS_VID_PROTOTYPE_PRODUCT_VENDOR_ID 0x6666U // Prototype product Vendor ID
#define UHS_VID_WISEGROUP 0x6677U // WiseGroup, Ltd.
#define UHS_VID_3COM_1 0x6891U // 3Com
#define UHS_VID_OPERA1 0x695cU // Opera1
#define UHS_VID_YEALINK_NETWORK_TECHNOLOGY 0x6993U // Yealink Network Technology Co., Ltd.
#define UHS_VID_SHANGHAI_JUJO_ELECTRONICS 0x6a75U // Shanghai Jujo Electronics Co., Ltd
#define UHS_VID_CME_CENTRAL_MUSIC 0x7104U // CME (Central Music Co.)
#define UHS_VID_STACKFOUNDRY 0x726cU // StackFoundry LLC
#define UHS_VID_TBS_TECHNOLOGIES_CHINA 0x734cU // TBS Technologies China
#define UHS_VID_BEIJING_STONE_TECHNOLOGY 0x7373U // Beijing STONE Technology Co. Ltd.
#define UHS_VID_EDIMAX_TECHNOLOGY_1 0x7392U // Edimax Technology Co., Ltd
#define UHS_VID_INTEL_1 0x8086U // Intel Corp.
#define UHS_VID_INTEL_2 0x8087U // Intel Corp.
#define UHS_VID_VIRTUALBOX 0x80eeU // VirtualBox
#define UHS_VID_KEIO 0x8282U // Keio
#define UHS_VID_EGO_SYSTEMS_1 0x8341U // EGO Systems, Inc.
#define UHS_VID_TRANSCEND_INFORMATION_1 0x8564U // Transcend Information, Inc.
#define UHS_VID_INTENSO_GMBG 0x8644U // Intenso GmbG
#define UHS_VID_CH_PRODUCTS_1 0x8e06U // CH Products, Inc.
#define UHS_VID_SITECOM_1 0x9016U // Sitecom
#define UHS_VID_TEVII_TECHNOLOGY 0x9022U // TeVii Technology Ltd.
#define UHS_VID_GEOLAB 0x9148U // GeoLab, Ltd
#define UHS_VID_MOSCHIP_SEMICONDUCTOR 0x9710U // MosChip Semiconductor
#define UHS_VID_BESTMEDIA_CD_RECORDABLE_GMBH_AND_CO_KG 0x9849U // Bestmedia CD Recordable GmbH & Co. KG
#define UHS_VID_ODEON 0x9999U // Odeon
#define UHS_VID_GRANDTEC_1 0x99faU // Grandtec
#define UHS_VID_J_WESTHUES 0x9ac4U // J. Westhues
#define UHS_VID_MARVELL_SEMICONDUCTOR_1 0x9e88U // Marvell Semiconductor, Inc.
#define UHS_VID_ANMO_ELECTRONICS_CORP_DINO_LITE_UNKNOWN 0xa128U // AnMo Electronics Corp. / Dino-Lite (?)
#define UHS_VID_ANMO_ELECTRONICS_CORPORATION 0xa168U // AnMo Electronics Corporation
#define UHS_VID_ASIX 0xa600U // Asix
#define UHS_VID_3COM_2 0xa727U // 3Com
#define UHS_VID_MXT 0xaaaaU // MXT
#define UHS_VID_UNKNOWN_3 0xabcdU // Unknown
#define UHS_VID_BLUE_MICROPHONES 0xb58eU // Blue Microphones
#define UHS_VID_CARD_DEVICE_EXPERT 0xc216U // Card Device Expert Co., LTD
#define UHS_VID_KEIL_SOFTWARE_1 0xc251U // Keil Software, Inc.
#define UHS_VID_CACE_TECHNOLOGIES 0xcaceU // CACE Technologies Inc.
#define UHS_VID_SMART_TECHNOLOGY_INDUSTRIAL 0xcd12U // SMART TECHNOLOGY INDUSTRIAL LTD.
#define UHS_VID_ULTIMARC 0xd208U // Ultimarc
#define UHS_VID_ULTIMARC_1 0xd209U // Ultimarc
#define UHS_VID_LOGILINK 0xd904U // LogiLink
#define UHS_VID_XORCOM 0xe4e4U // Xorcom Ltd.
#define UHS_VID_MAKINGTHINGS 0xeb03U // MakingThings
#define UHS_VID_EMPIA_TECHNOLOGY 0xeb1aU // eMPIA Technology, Inc.
#define UHS_VID_KWORLD 0xeb2aU // KWorld
#define UHS_VID_SMART_TECHNOLOGY_INDUSTRIAL_1 0xef18U // SMART TECHNOLOGY INDUSTRIAL LTD.
#define UHS_VID_HEWLETT_PACKARD_1 0xf003U // Hewlett Packard
#define UHS_VID_LEAP_MOTION 0xf182U // Leap Motion
#define UHS_VID_ATTEN_ELECTRONICS_SIGLENT_TECHNOLOGIES 0xf4ecU // Atten Electronics / Siglent Technologies
#define UHS_VID_SHENZHEN_SIGLENT 0xf4edU // Shenzhen Siglent Co., Ltd.
#define UHS_VID_HAMA_1 0xf766U // Hama
#define UHS_VID_CONRAD_ELECTRONIC_SE 0xfc08U // Conrad Electronic SE
#define UHS_VID_FNK_TECH 0xffeeU // FNK Tech

#endif
