/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2020 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#pragma once

//
// lcd/dogm/status/cooler.h - Status Screen Laser Cooler bitmaps
//
#if HAS_COOLER

  #define STATUS_COOLER_WIDTH 22

  const unsigned char status_cooler_bmp2[] PROGMEM = {
    B00000100,B00000010,B00000000,
    B00000100,B10010010,B01000000,
    B00010101,B00001010,B10000000,
    B00001110,B00000111,B00000000,
    B00111111,B10111111,B11000000,
    B00001110,B00000111,B00000000,
    B00010101,B00001010,B10000000,
    B00100100,B00100010,B01000000,
    B00000100,B00100000,B00000000,
    B00000001,B00100100,B00000000,
    B00000000,B10101000,B00000000,
    B00000000,B01110000,B00000000,
    B00000111,B11111111,B00000000,
    B00000000,B01110000,B00000000,
    B00000000,B10101000,B00000000,
    B00000001,B00100100,B00000000
  };
  const unsigned char status_cooler_bmp1[] PROGMEM = {
    B00000100,B00000010,B00000000,
    B00000100,B10010010,B01000000,
    B00010101,B00001010,B10000000,
    B00001010,B00000101,B00000000,
    B00110001,B11011000,B11000000,
    B00001010,B00000101,B00000000,
    B00010101,B00001010,B10000000,
    B00100100,B00100010,B01000000,
    B00000100,B00100000,B00000000,
    B00000001,B00100100,B00000000,
    B00000000,B10101000,B00000000,
    B00000000,B01010000,B00000000,
    B00000111,B10001111,B00000000,
    B00000000,B01010000,B00000000,
    B00000000,B10101000,B00000000,
    B00000001,B00100100,B00000000
  };

#endif

#if ENABLED(LASER_COOLANT_FLOW_METER)

  #define STATUS_FLOWMETER_WIDTH 24

  const unsigned char status_flowmeter_bmp2[] PROGMEM = {
    B00000000,B01111110,B00000000,
    B00000001,B10000001,B10000000,
    B00000010,B00011000,B01000000,
    B00000100,B00011000,B00100000,
    B00001000,B00011000,B00010000,
    B00001000,B00011000,B00010000,
    B00010000,B00011000,B00001000,
    B00010000,B00011000,B00001000,
    B00010111,B11111111,B11101000,
    B00010111,B11111111,B11101000,
    B00010000,B00011000,B00001000,
    B00010000,B00011000,B00001000,
    B00001000,B00011000,B00010000,
    B00001000,B00011000,B00010000,
    B00000100,B00011000,B00100000,
    B00000010,B00011000,B01000000,
    B00000001,B10000001,B10000000,
    B00000000,B01111110,B00000000,
    B00000000,B00011000,B00000000,
    B00000111,B11111111,B11100000
  };
  const unsigned char status_flowmeter_bmp1[] PROGMEM = {
    B00000000,B01111110,B00000000,
    B00000001,B10000001,B10000000,
    B00000010,B00000000,B01000000,
    B00000101,B00000000,B10100000,
    B00001011,B10000001,B11010000,
    B00001001,B11000011,B10010000,
    B00010000,B11100111,B00001000,
    B00010000,B01111110,B00001000,
    B00010000,B00111100,B00001000,
    B00010000,B00111100,B00001000,
    B00010000,B01111110,B00001000,
    B00010000,B11100111,B00001000,
    B00001001,B11000011,B10010000,
    B00001011,B10000001,B11010000,
    B00000101,B00000000,B10100000,
    B00000010,B00000000,B01000000,
    B00000001,B10000001,B10000000,
    B00000000,B01111110,B00000000,
    B00000000,B00011000,B00000000,
    B00000111,B11111111,B11100000
  };

#endif
