#!/bin/bash 
# 
# copstart.sh script will install
# the firmware and device defaults
#
# SYNOPSIS
# copstart.sh <context>
#
# turn it on for debug
# set x
#
# Checking parameters
#
if [ $# -lt 1 ]
then
   CONTEXT="options"
else
   CONTEXT=$1
fi
#
# Set some env variables
#
# Context will be either 'install', 'L2',
# or 'options'
LOGFILE=`pwd`/install.log
TFTPDIR=/usr/local/cm/tftp
LOADINFODIR=/usr/local/cm/db/loadinfo
INSTALLDB=/usr/local/cm/bin/installdb
TMPDIR=`pwd`

LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/cm/lib
export LD_LIBRARY_PATH


# Context will equal 'L2', 'options' or 'install'

# Copy files and change permissions
echo "Installing *.sbn, *.sb2 *.loads *.bin and load info files" > ${LOGFILE}
chmod 770 ${TMPDIR}/*.txt ${TMPDIR}/*.sbn ${TMPDIR}/*.sb2 ${TMPDIR}/*.loads ${TMPDIR}/*.bin
chown ctftp ${TMPDIR}/*.sbn ${TMPDIR}/*.sb2 ${TMPDIR}/*.loads ${TMPDIR}/*.bin
chown database ${TMPDIR}/*.txt
chgrp ccmbase ${TMPDIR}/*.txt ${TMPDIR}/*.loads ${TMPDIR}/*.sbn ${TMPDIR}/*.sb2 ${TMPDIR}/*.bin

cp -fp ${TMPDIR}/*.txt ${LOADINFODIR}/
cp -fp ${TMPDIR}/*.sbn ${TFTPDIR}/
cp -fp ${TMPDIR}/*.sb2 ${TFTPDIR}/
cp -fp ${TMPDIR}/*.loads ${TFTPDIR}/
cp -fp ${TMPDIR}/*.bin ${TFTPDIR}/

#
# Update the device defaults
#
echo "Updating device defaults..." >> ${LOGFILE}
load_file1=${LOADINFODIR}/sccp_load7.txt
load_file2=${LOADINFODIR}/sccp_load8.txt
if [ ${CONTEXT} != "L2" ]
then 
 echo "Updating device defaults for non-L2" >> ${LOGFILE}
 su -l informix -s /bin/sh -c "source /usr/local/cm/db/dblenv.bash /usr/local/cm ; source /usr/local/cm/db/informix/local/ids.env ; $INSTALLDB -l $load_file1" >> ${LOGFILE}
 su -l informix -s /bin/sh -c "source /usr/local/cm/db/dblenv.bash /usr/local/cm ; source /usr/local/cm/db/informix/local/ids.env ; $INSTALLDB -l $load_file2" >> ${LOGFILE}
else
 echo "Updating device defaults for L2" >> ${LOGFILE}
 su -l informix -s /bin/sh -c "source /usr/local/cm/db/dblenv.bash /usr/local/cm ; source /usr/local/cm/db/informix/local/ids.env L2; $INSTALLDB -l $load_file1" >> ${LOGFILE}
 su -l informix -s /bin/sh -c "source /usr/local/cm/db/dblenv.bash /usr/local/cm ; source /usr/local/cm/db/informix/local/ids.env L2; $INSTALLDB -l $load_file2" >> ${LOGFILE}
fi
exit 0
