/**************************************************************************
*       Copyright  2006, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    ProtocolInfo.h
*  Date:    12/2006
*
***************************************************************************
*
*   Protocol info class implementation for the Client API.
*
***************************************************************************/
#ifndef _PROTOCOL_INFO_
#define _PROTOCOL_INFO_


#include "api.h"
#include <iostream>


class VPNStatsBase;

/**
 * Use this class to retrieve details regarding the protocol in use for the
 * VPN tunnel.  These details include State, Protocol, Cipher and Compression.
 *
 * It's possible multiple ProtocolInfo objects (for example, one each for TLS
 * and DTLS protocol) are available.  To check whether the Protocol for a given
 * instance of ProtocolInfo is the currently active one, use the
 * ProtocolInfo::isActive method.
 */

class VPN_VPNAPI ProtocolInfo
{
    public:

        static tstring State;       /**< Use ProtocolInfo::getProtocolValue
                                         with this tag to get the current
                                         state of the referenced protocol.  The
                                         returned state is a localized
                                         string. */ 
        static tstring Protocol;    /**< Use ProtocolInfo::getProtocolValue
                                         with this tag to get the protocol
                                         value (for example, DTLS). */
        static tstring Cipher;      /**< Use ProtocolInfo::getProtocolValue
                                         with this tag to get the Cipher
                                         value (for example, RSA_AES_256_SHA1). */
        static tstring Compression; /**< Use ProtocolInfo::getProtocolValue
                                         with this tag to get the Compression
                                         value (for example, Deflate).  The returned
                                         compression value is a localized
                                         string. */

        /**
         * Use this method to retrieve various protocol related values.
         * The valid labels or tags to use in this retrieval include: State,
         * Protocol, Cipher and Compression.
         * (for example, getProtocolValue(State), getProtocolValue(Protocol), etc.)
         */
        const tstring &getProtocolValue(tstring &label);

        /**
         * Return true if this is the active protocol.
         */
        bool isActive();

        ProtocolInfo(const ProtocolInfo *pInfo);
        ProtocolInfo(STATE tunnelState,
                     ProtocolVersion protocolVersion,
                     ProtocolCipher  protocolCipher,
                     COMPR_ALGORITHM comprAlgorithm,
                     bool bIsActive);

        ~ProtocolInfo();


        //This method is not intended to be used by a consumers of the API.
        //
        static const tstring::value_type* const* getProtocolInfoStringTable();

protected:
        static const tstring::value_type* const sm_pProtocolInfoStringTable[];

private:

        static tstring EmptyString;

        bool mb_isActive;

        ApiStringMap mo_ProtocolNameValue;

        ApiStringMap &getProtocolMap();
    
        friend VPN_VPNAPI tostream& operator<<(tostream &outStream,
                                               VPNStatsBase& stats);
};


#endif // _PROTOCOL_INFO_
