#ifndef _ROUTE_INFO_
#define _ROUTE_INFO_


#include "api.h"
#include <iostream>

/**
 * The RouteInfo class can be used to retrieve the network and subnet mask
 * for the secure and non-secure routes associated with the VPN.
 */


class VPN_VPNAPI RouteInfo
{
    public:

        /**
         * Constructor used to create a route instance.  This method is not
         * intended for public use.
         */
        RouteInfo(tstring &network, tstring &subnet);

        /**
         * Constructor used to copy a route instance.  This method is not
         * intended for public use.
         */
        RouteInfo(const RouteInfo *routeInfo);

        ~RouteInfo();

        /**
         * Retrieve the destination network address for this route.
         */
        tstring &getNetwork();

        /**
         * Retrieve the subnet mask for this route.
         */
        tstring &getSubnet();

    private:

        tstring ms_network;
        tstring ms_subnet;

};

tostream& operator <<(tostream &outStream, RouteInfo &route);

#endif // _ROUTE_INFO_
