
/**************************************************************************
*       Copyright (c) 2009, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    FirewallInfo.h
*  Author:  Vishwa Krishnamurthy
*  Date:    12/06/2009
*
***************************************************************************/


#ifndef _FIREWALLINFO_
#define _FIREWALLINFO_

#include <iostream>
#include "GlobalEnums.h"
#include "api.h"

#ifdef _WIN32
typedef unsigned short  uint16_t;
typedef unsigned long   uint32_t;
#else
#include <stdint.h>
#endif

class VPN_VPNAPI FirewallInfo
{
public:
    /**
     * Constructor used to create a firewall instance.  This method is not
     * intended for public use.
     */
    FirewallInfo(FW_Interface fwInterface,
                 FW_Permission fwPermission,
                 FW_Protocol fwProtocol,
                 uint16_t fwSrcPortLowerBound,
                 uint16_t fwSrcPortUpperBound,
                 uint16_t fwDstPortLowerBound,
                 uint16_t fwDstPortUpperBound,
                 tstring  fwDstAddress,
                 uint32_t fwDstAddressPrefixLength);

    /**
     * Constructor used to copy a firewall instance.  This method is not
     * intended for public use.
     */
    FirewallInfo(const FirewallInfo &fwInfo);
    ~FirewallInfo() {}

    tstring getPermission();
    tstring getProtocol();
    tstring getInterface();
    tstring getSrcPortRange();
    tstring getDstPortRange();
    tstring getDstAddr();

private:
    FW_Interface  nInterface;
    FW_Permission nPermission;
    FW_Protocol   nProtocol;
    uint32_t      nSrcPortLowerBound;
    uint32_t      nSrcPortUpperBound;
    uint32_t      nDstPortLowerBound;
    uint32_t      nDstPortUpperBound;
    tstring       szDstAddress;
    uint32_t      nPrefixLength;

};

tostream& operator <<(tostream &outStream, FirewallInfo &fwRule);

#endif // _FIREWALLINFO_

