#!/bin/sh
#

BASH_BASE_SIZE=0x00000000
CISCO_AC_TIMESTAMP=0x0000000000000000
CISCO_AC_OBJNAME=1234567890123456789012345678901234567890123456789012345678901234
# BASH_BASE_SIZE=0x00000000 is required for signing
# CISCO_AC_TIMESTAMP is also required for signing
# comment is after BASH_BASE_SIZE or else sign tool will find the comment

LEGACY_INSTPREFIX=/opt/cisco/vpn
LEGACY_BINDIR=${LEGACY_INSTPREFIX}/bin
LEGACY_UNINST=${LEGACY_BINDIR}/vpn_uninstall.sh

TARROOT="vpn"
INSTPREFIX=/opt/cisco/anyconnect
ROOTCERTSTORE=/opt/.cisco/certificates/ca
ROOTCACERT="VeriSignClass3PublicPrimaryCertificationAuthority-G5.pem"
INIT_SRC="vpnagentd_init"
INIT="vpnagentd"
BINDIR=${INSTPREFIX}/bin
LIBDIR=${INSTPREFIX}/lib
PROFILEDIR=${INSTPREFIX}/profile
SCRIPTDIR=${INSTPREFIX}/script
HELPDIR=${INSTPREFIX}/help
PLUGINDIR=${BINDIR}/plugins
UNINST=${BINDIR}/vpn_uninstall.sh
INSTALL=install
SYSVSTART="S85"
SYSVSTOP="K25"
SYSVLEVELS="2 3 4 5"
PREVDIR=`pwd`
MARKER=$((`grep -an "[B]EGIN\ ARCHIVE" $0 | cut -d ":" -f 1` + 1))
MARKER_END=$((`grep -an "[E]ND\ ARCHIVE" $0 | cut -d ":" -f 1` - 1))
LOGFNAME=`date "+anyconnect-linux-3.1.11004-k9-%H%M%S%d%m%Y.log"`
CLIENTNAME="Cisco AnyConnect Secure Mobility Client"
FEEDBACK_DIR="${INSTPREFIX}/CustomerExperienceFeedback"

echo "Installing ${CLIENTNAME}..."
echo "Installing ${CLIENTNAME}..." > /tmp/${LOGFNAME}
echo `whoami` "invoked $0 from " `pwd` " at " `date` >> /tmp/${LOGFNAME}

# Make sure we are root
if [ `id | sed -e 's/(.*//'` != "uid=0" ]; then
  echo "Sorry, you need super user privileges to run this script."
  exit 1
fi
## The web-based installer used for VPN client installation and upgrades does
## not have the license.txt in the current directory, intentionally skipping
## the license agreement. Bug CSCtc45589 has been filed for this behavior.   
if [ -f "license.txt" ]; then
    cat ./license.txt
    echo
    echo -n "Do you accept the terms in the license agreement? [y/n] "
    read LICENSEAGREEMENT
    while : 
    do
      case ${LICENSEAGREEMENT} in
           [Yy][Ee][Ss])
                   echo "You have accepted the license agreement."
                   echo "Please wait while ${CLIENTNAME} is being installed..."
                   break
                   ;;
           [Yy])
                   echo "You have accepted the license agreement."
                   echo "Please wait while ${CLIENTNAME} is being installed..."
                   break
                   ;;
           [Nn][Oo])
                   echo "The installation was cancelled because you did not accept the license agreement."
                   exit 1
                   ;;
           [Nn])
                   echo "The installation was cancelled because you did not accept the license agreement."
                   exit 1
                   ;;
           *)    
                   echo "Please enter either \"y\" or \"n\"."
                   read LICENSEAGREEMENT
                   ;;
      esac
    done
fi
if [ "`basename $0`" != "vpn_install.sh" ]; then
  if which mktemp >/dev/null 2>&1; then
    TEMPDIR=`mktemp -d /tmp/vpn.XXXXXX`
    RMTEMP="yes"
  else
    TEMPDIR="/tmp"
    RMTEMP="no"
  fi
else
  TEMPDIR="."
fi

#
# Check for and uninstall any previous version.
#
if [ -x "${LEGACY_UNINST}" ]; then
  echo "Removing previous installation..."
  echo "Removing previous installation: "${LEGACY_UNINST} >> /tmp/${LOGFNAME}
  STATUS=`${LEGACY_UNINST}`
  if [ "${STATUS}" ]; then
    echo "Error removing previous installation!  Continuing..." >> /tmp/${LOGFNAME}
  fi

  # migrate the /opt/cisco/vpn directory to /opt/cisco/anyconnect directory
  echo "Migrating ${LEGACY_INSTPREFIX} directory to ${INSTPREFIX} directory" >> /tmp/${LOGFNAME}

  ${INSTALL} -d ${INSTPREFIX}

  # local policy file
  if [ -f "${LEGACY_INSTPREFIX}/AnyConnectLocalPolicy.xml" ]; then
    mv -f ${LEGACY_INSTPREFIX}/AnyConnectLocalPolicy.xml ${INSTPREFIX}/ >/dev/null 2>&1
  fi

  # global preferences
  if [ -f "${LEGACY_INSTPREFIX}/.anyconnect_global" ]; then
    mv -f ${LEGACY_INSTPREFIX}/.anyconnect_global ${INSTPREFIX}/ >/dev/null 2>&1
  fi

  # logs
  mv -f ${LEGACY_INSTPREFIX}/*.log ${INSTPREFIX}/ >/dev/null 2>&1

  # VPN profiles
  if [ -d "${LEGACY_INSTPREFIX}/profile" ]; then
    ${INSTALL} -d ${INSTPREFIX}/profile
    tar cf - -C ${LEGACY_INSTPREFIX}/profile . | (cd ${INSTPREFIX}/profile; tar xf -)
    rm -rf ${LEGACY_INSTPREFIX}/profile
  fi

  # VPN scripts
  if [ -d "${LEGACY_INSTPREFIX}/script" ]; then
    ${INSTALL} -d ${INSTPREFIX}/script
    tar cf - -C ${LEGACY_INSTPREFIX}/script . | (cd ${INSTPREFIX}/script; tar xf -)
    rm -rf ${LEGACY_INSTPREFIX}/script
  fi

  # localization
  if [ -d "${LEGACY_INSTPREFIX}/l10n" ]; then
    ${INSTALL} -d ${INSTPREFIX}/l10n
    tar cf - -C ${LEGACY_INSTPREFIX}/l10n . | (cd ${INSTPREFIX}/l10n; tar xf -)
    rm -rf ${LEGACY_INSTPREFIX}/l10n
  fi
elif [ -x "${UNINST}" ]; then
  echo "Removing previous installation..."
  echo "Removing previous installation: "${UNINST} >> /tmp/${LOGFNAME}
  STATUS=`${UNINST}`
  if [ "${STATUS}" ]; then
    echo "Error removing previous installation!  Continuing..." >> /tmp/${LOGFNAME}
  fi
fi

if [ "${TEMPDIR}" != "." ]; then
  TARNAME=`date +%N`
  TARFILE=${TEMPDIR}/vpninst${TARNAME}.tgz

  echo "Extracting installation files to ${TARFILE}..."
  echo "Extracting installation files to ${TARFILE}..." >> /tmp/${LOGFNAME}
  # "head --bytes=-1" used to remove '\n' prior to MARKER_END
  head -n ${MARKER_END} $0 | tail -n +${MARKER} | head --bytes=-1 2>> /tmp/${LOGFNAME} > ${TARFILE} || exit 1

  echo "Unarchiving installation files to ${TEMPDIR}..."
  echo "Unarchiving installation files to ${TEMPDIR}..." >> /tmp/${LOGFNAME}
  tar xvzf ${TARFILE} -C ${TEMPDIR} >> /tmp/${LOGFNAME} 2>&1 || exit 1

  rm -f ${TARFILE}

  NEWTEMP="${TEMPDIR}/${TARROOT}"
else
  NEWTEMP="."
fi

# Make sure destination directories exist
echo "Installing "${BINDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${BINDIR} || exit 1
echo "Installing "${LIBDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${LIBDIR} || exit 1
echo "Installing "${PROFILEDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${PROFILEDIR} || exit 1
echo "Installing "${SCRIPTDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${SCRIPTDIR} || exit 1
echo "Installing "${HELPDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${HELPDIR} || exit 1
echo "Installing "${PLUGINDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${PLUGINDIR} || exit 1
echo "Installing "${ROOTCERTSTORE} >> /tmp/${LOGFNAME}
${INSTALL} -d ${ROOTCERTSTORE} || exit 1

# Copy files to their home
echo "Installing "${NEWTEMP}/${ROOTCACERT} >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 444 ${NEWTEMP}/${ROOTCACERT} ${ROOTCERTSTORE} || exit 1

echo "Installing "${NEWTEMP}/vpn_uninstall.sh >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/vpn_uninstall.sh ${BINDIR} || exit 1

echo "Creating symlink "${BINDIR}/vpn_uninstall.sh >> /tmp/${LOGFNAME}
mkdir -p ${LEGACY_BINDIR}
ln -s ${BINDIR}/vpn_uninstall.sh ${LEGACY_BINDIR}/vpn_uninstall.sh || exit 1
chmod 755 ${LEGACY_BINDIR}/vpn_uninstall.sh

echo "Installing "${NEWTEMP}/anyconnect_uninstall.sh >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/anyconnect_uninstall.sh ${BINDIR} || exit 1

echo "Installing "${NEWTEMP}/vpnagentd >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/vpnagentd ${BINDIR} || exit 1

echo "Installing "${NEWTEMP}/libvpnagentutilities.so >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libvpnagentutilities.so ${LIBDIR} || exit 1

echo "Installing "${NEWTEMP}/libvpncommon.so >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libvpncommon.so ${LIBDIR} || exit 1

echo "Installing "${NEWTEMP}/libvpncommoncrypt.so >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libvpncommoncrypt.so ${LIBDIR} || exit 1

echo "Installing "${NEWTEMP}/libvpnapi.so >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libvpnapi.so ${LIBDIR} || exit 1

echo "Installing "${NEWTEMP}/libacciscossl.so >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libacciscossl.so ${LIBDIR} || exit 1

echo "Installing "${NEWTEMP}/libacciscocrypto.so >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libacciscocrypto.so ${LIBDIR} || exit 1

echo "Installing "${NEWTEMP}/libaccurl.so.4.3.0 >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/libaccurl.so.4.3.0 ${LIBDIR} || exit 1

echo "Creating symlink "${NEWTEMP}/libaccurl.so.4 >> /tmp/${LOGFNAME}
ln -s ${LIBDIR}/libaccurl.so.4.3.0 ${LIBDIR}/libaccurl.so.4 || exit 1

if [ -f "${NEWTEMP}/libvpnipsec.so" ]; then
    echo "Installing "${NEWTEMP}/libvpnipsec.so >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${NEWTEMP}/libvpnipsec.so ${PLUGINDIR} || exit 1
else
    echo "${NEWTEMP}/libvpnipsec.so does not exist. It will not be installed."
fi 

if [ -f "${NEWTEMP}/libacfeedback.so" ]; then
    echo "Installing "${NEWTEMP}/libacfeedback.so >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${NEWTEMP}/libacfeedback.so ${PLUGINDIR} || exit 1
else
    echo "${NEWTEMP}/libacfeedback.so does not exist. It will not be installed."
fi 

if [ -f "${NEWTEMP}/vpnui" ]; then
    echo "Installing "${NEWTEMP}/vpnui >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${NEWTEMP}/vpnui ${BINDIR} || exit 1
else
    echo "${NEWTEMP}/vpnui does not exist. It will not be installed."
fi 

echo "Installing "${NEWTEMP}/vpn >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 755 ${NEWTEMP}/vpn ${BINDIR} || exit 1

if [ -d "${NEWTEMP}/pixmaps" ]; then
    echo "Copying pixmaps" >> /tmp/${LOGFNAME}
    cp -R ${NEWTEMP}/pixmaps ${INSTPREFIX}
else
    echo "pixmaps not found... Continuing with the install."
fi

if [ -f "${NEWTEMP}/cisco-anyconnect.menu" ]; then
    echo "Installing ${NEWTEMP}/cisco-anyconnect.menu" >> /tmp/${LOGFNAME}
    mkdir -p /etc/xdg/menus/applications-merged || exit
    # there may be an issue where the panel menu doesn't get updated when the applications-merged 
    # folder gets created for the first time.
    # This is an ubuntu bug. https://bugs.launchpad.net/ubuntu/+source/gnome-panel/+bug/369405

    ${INSTALL} -o root -m 644 ${NEWTEMP}/cisco-anyconnect.menu /etc/xdg/menus/applications-merged/
else
    echo "${NEWTEMP}/anyconnect.menu does not exist. It will not be installed."
fi


if [ -f "${NEWTEMP}/cisco-anyconnect.directory" ]; then
    echo "Installing ${NEWTEMP}/cisco-anyconnect.directory" >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 644 ${NEWTEMP}/cisco-anyconnect.directory /usr/share/desktop-directories/
else
    echo "${NEWTEMP}/anyconnect.directory does not exist. It will not be installed."
fi

# if the update cache utility exists then update the menu cache
# otherwise on some gnome systems, the short cut will disappear
# after user logoff or reboot. This is neccessary on some
# gnome desktops(Ubuntu 10.04)
if [ -f "${NEWTEMP}/cisco-anyconnect.desktop" ]; then
    echo "Installing ${NEWTEMP}/cisco-anyconnect.desktop" >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 644 ${NEWTEMP}/cisco-anyconnect.desktop /usr/share/applications/
    if [ -x "/usr/share/gnome-menus/update-gnome-menus-cache" ]; then
        for CACHE_FILE in $(ls /usr/share/applications/desktop.*.cache); do
            echo "updating ${CACHE_FILE}" >> /tmp/${LOGFNAME}
            /usr/share/gnome-menus/update-gnome-menus-cache /usr/share/applications/ > ${CACHE_FILE}
        done
    fi
else
    echo "${NEWTEMP}/anyconnect.desktop does not exist. It will not be installed."
fi

if [ -f "${NEWTEMP}/ACManifestVPN.xml" ]; then
    echo "Installing "${NEWTEMP}/ACManifestVPN.xml >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 444 ${NEWTEMP}/ACManifestVPN.xml ${INSTPREFIX} || exit 1
else
    echo "${NEWTEMP}/ACManifestVPN.xml does not exist. It will not be installed."
fi

if [ -f "${NEWTEMP}/manifesttool" ]; then
    echo "Installing "${NEWTEMP}/manifesttool >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${NEWTEMP}/manifesttool ${BINDIR} || exit 1

    # create symlinks for legacy install compatibility
    ${INSTALL} -d ${LEGACY_BINDIR}

    echo "Creating manifesttool symlink for legacy install compatibility." >> /tmp/${LOGFNAME}
    ln -f -s ${BINDIR}/manifesttool ${LEGACY_BINDIR}/manifesttool
else
    echo "${NEWTEMP}/manifesttool does not exist. It will not be installed."
fi


if [ -f "${NEWTEMP}/update.txt" ]; then
    echo "Installing "${NEWTEMP}/update.txt >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 444 ${NEWTEMP}/update.txt ${INSTPREFIX} || exit 1

    # create symlinks for legacy weblaunch compatibility
    ${INSTALL} -d ${LEGACY_INSTPREFIX}

    echo "Creating update.txt symlink for legacy weblaunch compatibility." >> /tmp/${LOGFNAME}
    ln -s ${INSTPREFIX}/update.txt ${LEGACY_INSTPREFIX}/update.txt
else
    echo "${NEWTEMP}/update.txt does not exist. It will not be installed."
fi


if [ -f "${NEWTEMP}/vpndownloader" ]; then
    # cached downloader
    echo "Installing "${NEWTEMP}/vpndownloader >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${NEWTEMP}/vpndownloader ${BINDIR} || exit 1

    # create symlinks for legacy weblaunch compatibility
    ${INSTALL} -d ${LEGACY_BINDIR}

    echo "Creating vpndownloader.sh script for legacy weblaunch compatibility." >> /tmp/${LOGFNAME}
    echo "ERRVAL=0" > ${LEGACY_BINDIR}/vpndownloader.sh
    echo ${BINDIR}/"vpndownloader \"\$*\" || ERRVAL=\$?" >> ${LEGACY_BINDIR}/vpndownloader.sh
    echo "exit \${ERRVAL}" >> ${LEGACY_BINDIR}/vpndownloader.sh
    chmod 444 ${LEGACY_BINDIR}/vpndownloader.sh

    echo "Creating vpndownloader symlink for legacy weblaunch compatibility." >> /tmp/${LOGFNAME}
    ln -s ${BINDIR}/vpndownloader ${LEGACY_BINDIR}/vpndownloader
else
    echo "${NEWTEMP}/vpndownloader does not exist. It will not be installed."
fi

if [ -f "${NEWTEMP}/vpndownloader-cli" ]; then
    # cached downloader (cli)
    echo "Installing "${NEWTEMP}/vpndownloader-cli >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${NEWTEMP}/vpndownloader-cli ${BINDIR} || exit 1
else
    echo "${NEWTEMP}/vpndownloader-cli does not exist. It will not be installed."
fi


# Open source information
echo "Installing "${NEWTEMP}/OpenSource.html >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 444 ${NEWTEMP}/OpenSource.html ${INSTPREFIX} || exit 1

# Profile schema
echo "Installing "${NEWTEMP}/AnyConnectProfile.xsd >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 444 ${NEWTEMP}/AnyConnectProfile.xsd ${PROFILEDIR} || exit 1

echo "Installing "${NEWTEMP}/AnyConnectLocalPolicy.xsd >> /tmp/${LOGFNAME}
${INSTALL} -o root -m 444 ${NEWTEMP}/AnyConnectLocalPolicy.xsd ${INSTPREFIX} || exit 1

# Import any AnyConnect XML profiles side by side vpn install directory (in well known Profiles/vpn directory)
# Also import the AnyConnectLocalPolicy.xml file (if present)
# If failure occurs here then no big deal, don't exit with error code
# only copy these files if tempdir is . which indicates predeploy

INSTALLER_FILE_DIR=$(dirname "$0")

IS_PRE_DEPLOY=true

if [ "${TEMPDIR}" != "." ]; then
    IS_PRE_DEPLOY=false;
fi

if $IS_PRE_DEPLOY; then
  PROFILE_IMPORT_DIR="${INSTALLER_FILE_DIR}/../Profiles"
  VPN_PROFILE_IMPORT_DIR="${INSTALLER_FILE_DIR}/../Profiles/vpn"

  if [ -d ${PROFILE_IMPORT_DIR} ]; then
    find ${PROFILE_IMPORT_DIR} -maxdepth 1 -name "AnyConnectLocalPolicy.xml" -type f -exec ${INSTALL} -o root -m 644 {} ${INSTPREFIX} \;
  fi

  if [ -d ${VPN_PROFILE_IMPORT_DIR} ]; then
    find ${VPN_PROFILE_IMPORT_DIR} -maxdepth 1 -name "*.xml" -type f -exec ${INSTALL} -o root -m 644 {} ${PROFILEDIR} \;
  fi
fi

# Process transforms
# API to get the value of the tag from the transforms file 
# The Third argument will be used to check if the tag value needs to converted to lowercase 
getProperty()
{
    FILE=${1}
    TAG=${2}
    TAG_FROM_FILE=$(grep ${TAG} "${FILE}" | sed "s/\(.*\)\(<${TAG}>\)\(.*\)\(<\/${TAG}>\)\(.*\)/\3/")
    if [ "${3}" = "true" ]; then
        TAG_FROM_FILE=`echo ${TAG_FROM_FILE} | tr '[:upper:]' '[:lower:]'`    
    fi
    echo $TAG_FROM_FILE;
}

DISABLE_FEEDBACK_TAG="DisableCustomerExperienceFeedback"

if $IS_PRE_DEPLOY; then
    if [ -d "${PROFILE_IMPORT_DIR}" ]; then
        TRANSFORM_FILE="${PROFILE_IMPORT_DIR}/ACTransforms.xml"
    fi
else
    TRANSFORM_FILE="${INSTALLER_FILE_DIR}/ACTransforms.xml"
fi

#get the tag values from the transform file  
if [ -f "${TRANSFORM_FILE}" ] ; then
    echo "Processing transform file in ${TRANSFORM_FILE}"
    DISABLE_FEEDBACK=$(getProperty "${TRANSFORM_FILE}" ${DISABLE_FEEDBACK_TAG} "true" )
fi

# if disable phone home is specified, remove the phone home plugin and any data folder
# note: this will remove the customer feedback profile if it was imported above
FEEDBACK_PLUGIN="${PLUGINDIR}/libacfeedback.so"

if [ "x${DISABLE_FEEDBACK}" = "xtrue" ] ; then
    echo "Disabling Customer Experience Feedback plugin"
    rm -f ${FEEDBACK_PLUGIN}
    rm -rf ${FEEDBACK_DIR}
fi


# Attempt to install the init script in the proper place

# Find out if we are using chkconfig
if [ -e "/sbin/chkconfig" ]; then
  CHKCONFIG="/sbin/chkconfig"
elif [ -e "/usr/sbin/chkconfig" ]; then
  CHKCONFIG="/usr/sbin/chkconfig"
else
  CHKCONFIG="chkconfig"
fi
if [ `${CHKCONFIG} --list 2> /dev/null | wc -l` -lt 1 ]; then
  CHKCONFIG=""
  echo "(chkconfig not found or not used)" >> /tmp/${LOGFNAME}
fi

# Locate the init script directory
if [ -d "/etc/init.d" ]; then
  INITD="/etc/init.d"
elif [ -d "/etc/rc.d/init.d" ]; then
  INITD="/etc/rc.d/init.d"
else
  INITD="/etc/rc.d"
fi

# BSD-style init scripts on some distributions will emulate SysV-style.
if [ "x${CHKCONFIG}" = "x" ]; then
  if [ -d "/etc/rc.d" -o -d "/etc/rc0.d" ]; then
    BSDINIT=1
    if [ -d "/etc/rc.d" ]; then
      RCD="/etc/rc.d"
    else
      RCD="/etc"
    fi
  fi
fi

if [ "x${INITD}" != "x" ]; then
  echo "Installing "${NEWTEMP}/${INIT_SRC} >> /tmp/${LOGFNAME}
  echo ${INSTALL} -o root -m 755 ${NEWTEMP}/${INIT_SRC} ${INITD}/${INIT} >> /tmp/${LOGFNAME}
  ${INSTALL} -o root -m 755 ${NEWTEMP}/${INIT_SRC} ${INITD}/${INIT} || exit 1
  if [ "x${CHKCONFIG}" != "x" ]; then
    echo ${CHKCONFIG} --add ${INIT} >> /tmp/${LOGFNAME}
    ${CHKCONFIG} --add ${INIT}
  else
    if [ "x${BSDINIT}" != "x" ]; then
      for LEVEL in ${SYSVLEVELS}; do
        DIR="rc${LEVEL}.d"
        if [ ! -d "${RCD}/${DIR}" ]; then
          mkdir ${RCD}/${DIR}
          chmod 755 ${RCD}/${DIR}
        fi
        ln -sf ${INITD}/${INIT} ${RCD}/${DIR}/${SYSVSTART}${INIT}
        ln -sf ${INITD}/${INIT} ${RCD}/${DIR}/${SYSVSTOP}${INIT}
      done
    fi
  fi

  echo "Starting ${CLIENTNAME} Agent..."
  echo "Starting ${CLIENTNAME} Agent..." >> /tmp/${LOGFNAME}
  # Attempt to start up the agent
  echo ${INITD}/${INIT} start >> /tmp/${LOGFNAME}
  logger "Starting ${CLIENTNAME} Agent..."
  ${INITD}/${INIT} start >> /tmp/${LOGFNAME} || exit 1

fi

# Generate/update the VPNManifest.dat file
if [ -f ${BINDIR}/manifesttool ]; then	
   ${BINDIR}/manifesttool -i ${INSTPREFIX} ${INSTPREFIX}/ACManifestVPN.xml
fi


if [ "${RMTEMP}" = "yes" ]; then
  echo rm -rf ${TEMPDIR} >> /tmp/${LOGFNAME}
  rm -rf ${TEMPDIR}
fi

echo "Done!"
echo "Done!" >> /tmp/${LOGFNAME}

# move the logfile out of the tmp directory
mv /tmp/${LOGFNAME} ${INSTPREFIX}/.

exit 0

--BEGIN ARCHIVE--
