/**************************************************************************
*           Copyright (c) 2000, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    GenDefs.h
*  Date:    8/23/00
*
***************************************************************************
*  NOTE* This file is for PORTABILITY related defines ONLY.
***************************************************************************
*  defines base types to be used by all CVC client components
***************************************************************************/
#ifndef __GENDEFS_H
#define __GENDEFS_H

#ifndef _WIN32

#ifndef USES_CONVERSION
#define USES_CONVERSION
#endif

#define PRELIM_UNIX_PORT

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_STDINT_H
#ifndef CNI_LINUX_INTERFACE
#include <stdint.h>
#endif
#elif HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#ifndef CNI_LINUX_INTERFACE
#include <sys/types.h>
#else
#include <linux/types.h>
#undef _UINTPTR_T_DEFINED
#undef _INTPTR_T_DEFINED
#endif
#endif

#undef FAR
#define FAR
#undef PASCAL
#define PASCAL

#else //_WIN32

#undef HAVE_CONFIG_H
#undef HAVE_STDINT_H
#undef HAVE_SYS_TYPES_H
#define WORDS_BIGENDIAN 0

#endif //_WIN32


#undef TRUE
#define TRUE            1

#undef FALSE
#define FALSE           0

#ifdef DDKBUILD //building with the DDK as the source.
#include <crtdefs.h>
#endif

// it'd be nice if we could switch to the C99 standard types at some point...
#if defined(HAVE_STDINT_H) || defined(HAVE_INTTYPES_H)
typedef uint8_t		bool8;
typedef uint16_t	bool16;
typedef uint32_t	bool32;

typedef int8_t		int8;
typedef int16_t		int16;

#if (!defined(CNI_LINUX_INTERFACE) || !defined(CONFIG_ISDN_PPP) || !defined(CONFIG_ISDN_PPP_VJ) || !defined(_SLHC_H)) && !defined(PROTYPES_H)
typedef int32_t 	int32;
#endif

typedef uint8_t		uint8;
typedef uint16_t	uint16;

#if !defined(CSSMAPI) && !defined(PROTYPES_H)
typedef uint32_t	uint32;
#endif

typedef uint64_t	uint64;
#else
//original windows definitions (32 bit)
typedef unsigned char   bool8;
typedef unsigned short  bool16;
typedef unsigned long   bool32;
typedef unsigned char   bool8_t;
typedef unsigned short  bool16_t;
typedef unsigned long   bool32_t;

typedef signed char     int8;
typedef signed short    int16;
typedef signed long     int32;
typedef signed char     int8_t;
typedef signed short    int16_t;
#if defined(_WIN32) && !defined (HS_TYPES_H_)
typedef signed long     int32_t;
#endif

typedef unsigned char   uint8;
typedef unsigned short  uint16;
#ifndef CSSMAPI
typedef unsigned long   uint32;
#endif
typedef unsigned char   uint8_t;
typedef unsigned short  uint16_t;
#if defined(_WIN32) && !defined (HS_TYPES_H_)
typedef unsigned long   uint32_t;
#endif

#ifdef _WIN32
typedef __int64                    int64;
typedef unsigned __int64           uint64;
typedef __int64                    int64_t;
typedef unsigned __int64           uint64_t;
#else
typedef long long                  int64;
typedef unsigned long long int     uint64;
typedef long long                  int64_t;
typedef unsigned long long int     uint64_t;
#endif
#endif

// integer types for doing pointer arithmetic, they should be the
// same size as a pointer. Part of the C99 standard, but they aren't
// available everywhere yet.
// These defs should work with IA32 (x86), ILP32 (sparcv8) and LP64 (sparcv9).
// These types are protected with the WIN32 macros (_INTPTR_T_DEFINED), since
// some, but not all of the WIN32 SDK's define these types.
#ifdef _WIN32
#ifndef _INTPTR_T_DEFINED
#if defined(_LP64)
#warning 64 bit
typedef int64 intptr_t;
#else
typedef int32 intptr_t;
#endif
#define _INTPTR_T_DEFINED
#endif

#ifndef _UINTPTR_T_DEFINED
#if defined(_LP64)
#warning 64 bit
typedef uint64 uintptr_t;
#else
typedef uint32 uintptr_t;
#endif
#define _UINTPTR_T_DEFINED
#endif
#endif

#ifndef __OBJC__   /* Mac OS X defines this in ObjectiveC land... */
typedef int 	BOOL;
#endif

#ifndef _WIN32
typedef int 	BOOLEAN;
#endif

#ifdef _WIN32
typedef int mode_t;
#endif

typedef	unsigned char   uchar;
#ifndef HAVE_SYS_TYPES_H
typedef unsigned int    uint;
typedef unsigned short  ushort;
typedef unsigned long   ulong;
#endif

#ifndef PLATFORM_ANDROID
typedef ulong   ULONG;
typedef ulong*  PULONG;
#endif

typedef uint32  DWORD;
typedef uint32* PDWORD;
typedef long    LONG;
typedef long*   PLONG;
typedef int     INT;
typedef int*    PINT;
typedef uint    UINT;
typedef uint*   PUINT;
typedef uint16  USHORT;
typedef uint16* PUSHORT;
typedef int16   SHORT;
typedef int16*  PSHORT;
typedef uint16  WORD;
typedef uint16* PWORD;
typedef char    CHAR;
typedef uchar   UCHAR;
typedef char*   PCHAR;
typedef uint8   BYTE;
typedef uint8*  PBYTE;
#define         VOID  void
typedef void*   PVOID;
#ifdef _WIN32
typedef void*   HANDLE;
#else
typedef int     HANDLE;
typedef int     SOCKET;
typedef const char*   LPCTSTR;
typedef const char*   LPCSTR;
typedef const char*   PCTSTR;
typedef char*   LPTSTR;
typedef void*   LPVOID;
typedef char*   LPSTR;
typedef long*   LPLONG;
typedef DWORD*  LPDWORD;
typedef signed int INT32;


typedef struct __WSABUF
{
    unsigned long len;
    char *buf;
} WSABUF, *LPWSABUF;

typedef struct OVERLAPPED
{
    void *data;
    int fd;
} OVERLAPPED,*LPOVERLAPPED;

typedef struct sockaddr_in SOCKADDR_IN;
typedef struct sockaddr_in6 SOCKADDR_IN6;

#endif //!_WIN32

typedef HANDLE* PHANDLE;
typedef uint8   KIRQL;

typedef long STATUSCODE;

/* function parameter context */
#undef  IN
#define IN

#undef  OUT
#define OUT

#undef  INOUT
#define INOUT

#undef  packed
#define packed

#ifndef CLEAR
#define CLEAR(a)			memset(&a,0,sizeof(a))
#endif

#ifndef POINT_BEYOND
#define POINT_BEYOND(a,t)	(t) &((&a)[1])
#endif

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

#ifndef _WIN32
#define _ftime ftime
#define _timeb timeb
#define __cdecl
#define __stdcall
#define __fastcall
#ifndef WINAPI
#define WINAPI
#endif
#ifndef CALLBACK
#define CALLBACK
#endif
#endif

#ifndef _WIN32
#undef  INVALID_SOCKET
#define INVALID_SOCKET -1
#undef  INVALID_FD
#define INVALID_FD -1
#undef  SOCKET_ERROR
#define SOCKET_ERROR -1
#undef  SOCKADDR
#define SOCKADDR sockaddr
#undef  SOCKADDR_IN
#define SOCKADDR_IN sockaddr_in
#undef  SOCKADDR_IN6
#define SOCKADDR_IN6 sockaddr_in6

#if defined(PLATFORM_DARWIN) || defined(PLATFORM_APPLE_SSLVPN) || defined(APPLE_IOS)
#define s6_words __u6_addr.__u6_addr16
#elif defined(PLATFORM_LINUX)
#define s6_words s6_addr16
#endif

#endif

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif


#if !defined(_WIN32) && !defined(_WIN32_WCE)

#ifndef ZeroMemory
#define ZEROMEM(ptr,cnt) \
    if ( NULL != ptr ) { memset(ptr,0,cnt); }
#define ZeroMemory ZEROMEM
#endif  /* ZeroMemory */

#ifndef SecureZeroMemory
#define SECUREZEROMEM(ptr, cnt) \
    do { \
        size_t size = (size_t)cnt; \
        volatile char *vptr = (volatile char *)ptr; \
        while (size) { \
            *vptr = 0; \
            vptr++; \
            size--; \
        } \
    } while(0);
#define SecureZeroMemory SECUREZEROMEM
#endif  /* SecureZeroMemory */
#endif  /* Windows */



#ifndef _WIN32
#define _strnicmp strncasecmp
#define _stricmp  strcasecmp
#endif

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(a) (sizeof(a)/sizeof(a[0]))
#endif

#if !defined(TO_STR) && !defined(TO_TSTR) && !defined(SYMBOL_TO_STR) && !defined(SYMBOL_TO_TSTR)

// use TO_STR(x)/TO_TSTR(x) to stringize (put double quotes around) x
//  example:
//    std::string foo = TO_STR(15);
//    tstring bar = TO_TSTR(15);
//  becomes
//    std::string foo = "15";
//    tstring bar = _T("15");
#define TO_STR(x) #x
#define TO_TSTR(x) _T(#x)

// use SYMBOL_TO_STR(x)/SYMBOL_TO_TSTR(x) to stringize
// the definition of symbol x
//  example:
//    #define MAX_LEN 15
//    std::string foo = SYMBOL_TO_STR(MAX_LEN);
//    tstring bar = SYMBOL_TO_TSTR(MAX_LEN);
//  becomes
//    std::string foo = "15";
//    tstring bar = _T("15");
//
// Note that TO_STR(MAX_LEN) results in "MAX_LEN".  The double macro is required in
// order to strinigize the *definition* of a symbol (as opposed to the symbol itself)
#define SYMBOL_TO_STR(x)  TO_STR(x)
#define SYMBOL_TO_TSTR(x) TO_TSTR(x)

#endif

#ifdef _WIN32
#define systemtime_t __time64_t
#define getSystemTimeInSeconds()    _time64(NULL)
#else
#define systemtime_t time_t
#define getSystemTimeInSeconds()    time(NULL)
#endif

#ifndef _WIN32
#ifndef INFINITE
#define INFINITE 0xFFFFFFFF
#endif
#endif

#define ANY_PATHNAME_DELIMITER "/\\"
#ifdef _WIN32
#define PATHNAME_DELIMITER  '\\'
#define PATHNAME_DELIMITER_STR  "\\"
#else
#define PATHNAME_DELIMITER  '/'
#define PATHNAME_DELIMITER_STR  "/"
#endif
#define URL_URI_DELIMITER  '/'
#define URL_URI_DELIMITER_STR  "/"

#ifdef _WIN32
#define NEWLINE "\r\n"
#else
#define NEWLINE "\n"
#endif

#if defined(_WIN32)
#define HOSTSFILE_LOCATION _T("drivers\\etc\\hosts")
#else
#define HOSTSFILE_LOCATION _T("/etc/hosts")
#endif

#ifdef _WIN32
#define DebugWriteFile(_handle_,_buffer_,_length_,_refCharsWritten_)  \
        WriteFile((_handle_),(_buffer_),(_length_),(_refCharsWritten_),NULL)
#else
#ifndef INVALID_HANDLE_VALUE
#define INVALID_HANDLE_VALUE    NULL
#endif
#define DebugWriteFile(_handle_,_buffer_,_length_,_refCharsWritten_)  \
        fprintf((_handle_), "%s", (_buffer_)); \
        fflush((_handle_))
#endif

typedef uint8_t MAC_ADDR[6];

#if !defined(_WIN32) || defined(_WIN32_WCE)
#ifndef ADDRESS_FAMILY
typedef unsigned short ADDRESS_FAMILY;
#endif
#endif

#if ((defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX)) && !defined(ANYCONNECT_USE_SNAK) && !defined(PRODUCT_TYPE_SSA)
/*
 ** the FIREWALL_SUPPORTED define is used to track the platforms
 ** where the firewall feature is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 ** Also, when Firewall feature expands to other platforms, they only need to be added in
 ** one place.
 */
#define FIREWALL_SUPPORTED
#endif

#if !defined(PRODUCT_TYPE_SSA) && ((defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN))
/*
** the TRUSTED_NETWORK_DETECTION define is used to track the platforms
** where Trusted Network Detection is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
** Also, when TND support expands to other platforms, they only need to be added in
** one place.
*/
#define TRUSTED_NETWORK_DETECTION
#endif

#if ((defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || defined(TRUSTED_NETWORK_DETECTION)) && !defined(PRODUCT_TYPE_SSA)
/*
** the LOGIN_UTILITIES_SUPPORTED define is used to track the platforms
** that support AnyConnect action triggered by user login. This is to avoid
** repeating the platforms in #ifdef clauses in other files.
** Also, when login support expands to other platforms, they only need to be added in
** one place.
*/
#define LOGIN_UTILITIES_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PRODUCT_TYPE_SSA)
/*
** The DNS_PLUGIN_SUPPORTED define is used to track the platforms where the DNS KDF plugin is 
** available. This is to avoid repeating the platforms in #ifdef clauses in other files.
** Also, when support expands to other platforms, they only need to be added in one place.
*/
#define DNS_PLUGIN_SUPPORTED
#endif

#if !(defined(PLATFORM_APPLE_SSLVPN) && TARGET_CPU_ARMV6)
/*
** A bug was discovered in iPhone testing wherein virtual inline functions do
** not work correctly on ARMv6 processors. To work around this, virtual inline
** function need to be made standard virtual functions on ARMv6. To prevent
** differences in runtime behavior, the VIRTUAL_INLINES_SUPPORTED define is used
** to define some virtual inlines in the header files, letting the functions be
** defined without the inline type in the cpp file for non-supported platforms.
*/
#define VIRTUAL_INLINES_SUPPORTED
#endif

/*
 * When changing the SCRIPTING_SUPPORTED definition, you MUST also update the
 * ClientIfcBase.h!  We duplicate this definition there due to the manner in
 * which we distribute our code to partners; we cannot include this header from
 * ClientIfcBase.h.
 */
#if !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_ANDROID)
/*
** the SCRIPTING_SUPPORTED define is used to enable the script manager for launching
** customer provided scripts on events like connection establishment, completion of
** disconnect, and captive portal detection.
*/
#define SCRIPTING_SUPPORTED
#endif

#if !defined(PRODUCT_TYPE_SSA) && ((defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN))
/*
** the NETWORK_ENVIRONMENT_STATE define is used to track the platforms
** where NETWORK_ENVIRONMENT_STATE check is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
** Also, when NES support expands to other platforms, they only need to be added in
** one place.
*/
#define NETWORK_ENVIRONMENT_STATE
#endif


#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN)
/*
** The AUTOMATIC_HEADEND_SELECTION define is used to track the platforms
** where Automatic Headend Selection is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
** Also, when AHS support expands to other platforms, they only need to be added in
** one place.
*/
#define AUTOMATIC_HEADEND_SELECTION
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN)
/*
 ** the MUS_HOST_SERVICES define is used to track the platforms
 ** where MUS Host Status check is performed. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define MUS_HOST_SERVICES
#endif

// BUGBUG - initially only enable code signing for Windows
#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_LINUX_EMBEDDED_PPC) && !defined(PLATFORM_LINUX_EMBEDDED_ARM))
/*
 ** the CODE_SIGNING_SUPPORTED define is used to track the platforms 
 ** where code sign verification is support. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 **
 */
#define CODE_SIGNING_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE)
#define RSA_SECURID_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE)
#define SAFEWORD_SOFTOKEN_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || ( defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS) )
/*
 ** the IPSEC_SUPPORTED define is used to track the platforms 
 ** where the IPSec protocol is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define IPSEC_SUPPORTED
#endif

#if ((defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN)) && !defined(ANYCONNECT_USE_SNAK)
/*
 ** The IPV6_SUPPORTED define is used to track the platforms 
 ** where full IPv6 capability is supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 ** Note that this is further narrowed down by method CIPv6Util::IsIPv6FullCapabilitySupported.
 */
#define IPV6_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || ( defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS) )
/*
 ** the PLUGIN_PROTOCOL_SUPPORTED define is used to track the platforms 
 ** where modular protocol Plugins are supported. This is to avoid repeating the
 ** platforms in #ifdef clauses in other files.
 */
#define PLUGIN_PROTOCOL_SUPPORTED
#endif

#if defined(_WIN32) && !defined(_WIN32_WCE) && !defined(PRODUCT_TYPE_SSA)
/*
** The IPSEC_OVER_SSL define is used to track the platforms 
** where the feature "IPsec tunneling over SSL for Oracle" (EDCS-852737) is supported. 
** This is to avoid repeating the platforms in #ifdef clauses in other files.
** Also, when the support expands to other platforms, they only need to be added in
** one place.
*/
#define IPSEC_OVER_SSL
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE)) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX) || defined(APPLE_IOS)
/*
 ** the DATA_OBFUSCATING_SUPPORTED define is used to track the platforms 
 ** where data obfuscation using key exchanges are supported. This is to
 ** avoid repeating the platforms in #ifdef clauses in other files.
 */
#define DATA_OBFUSCATING_SUPPORTED
#endif


#if !defined(PLATFORM_APPLE_SSLVPN) && !defined(_WIN32_WCE) && !defined(PRODUCT_TYPE_SSA)
/*
** the HOSTFILE_MODIFICATION_SUPPORTED define is used to track the platforms
** where hosts file modification is performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define HOSTSFILE_MODIFICATION_SUPPORTED
#endif

#if defined(_WIN32) || defined(_WIN32_WCE) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX)
/*
** the SCEP_CERTIFICATE_ENROLLMENT_SUPPORTED define is used to track the platforms
** where SCEP enrollment can be performed. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define SCEP_CERTIFICATE_ENROLLMENT_SUPPORTED
#endif
#if !defined(_WIN32_WCE) && !defined(PLATFORM_ANDROID) && !defined(APPLE_IOS)
/*
** The SUITEB_SUPPORTED define is used to track the platforms where SuiteB
** algorithms and certififcates are supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#define SUITEB_SUPPORTED
#endif

#if (defined(_WIN32) && !defined(_WIN32_WCE))
/*
** these XXX_PROFILE_SUPPORTED defines are used to track the platforms where
** Service Profiles for optional modules are supported.
** All platforms: VPN
** Windows: NAM, Web Security, ISE Posture and FireAMP
 */
#define NAM_PROFILE_SUPPORTED
#define WEBSEC_PROFILE_SUPPORTED
#define ISEPOSTURE_PROFILE_SUPPORTED
#define FIREAMP_PROFILE_SUPPORTED
#elif defined(PLATFORM_DARWIN)
/*
** OS X: Web Security, ISE Posture, FireAMP
*/
#define WEBSEC_PROFILE_SUPPORTED
#define ISEPOSTURE_PROFILE_SUPPORTED
#define FIREAMP_PROFILE_SUPPORTED
#endif

#if defined(_WIN32) || defined(PLATFORM_DARWIN) || (defined(PLATFORM_LINUX) && !defined(PLATFORM_ANDROID))
/*
** The exportStats call is only supported on the Desktop Platforms,
** it should not be included or supported if it is not a Desktop Plat
*/
#define EXPORT_STATS_SUPPORTED
#endif

#if (defined(_WIN32) || defined(PLATFORM_DARWIN) || defined(PLATFORM_LINUX)) && !defined(PLATFORM_ANDRIOD) && !defined(PLATFORM_APPLE_SSLVPN)
#define AC_CERTIFICATE_POLICY_SUPPORTED
#endif

#ifndef _TRSTRING
#define _tr(String) String
#define _TRSTRING
#endif

#ifndef _C_MYASSERT
#define C_MYASSERT(e) typedef char __C_MYASSERT__[(e)?1:-1]
#define _C_MYASSERT
#endif

#if defined(PLATFORM_APPLE_SSLVPN) || defined(APPLE_IOS)
#define NETWORK_ORDER_LOOPBACK_INTF_ADDR    htonl(0x7f000001) // 127.0.0.1
#endif

#if !defined(BITS_PER_BYTE)
#define BITS_PER_BYTE   8
#endif

#if !defined(_WIN32_WCE) && !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_LINUX_EMBEDDED_PPC) && !defined(PLATFORM_WEBOS_ARM) && !defined(PLATFORM_WEBOS_X86) && !defined(PLATFORM_ANDROID) && !defined(APPLE_IOS)
#define FIPS_SUPPORTED
#endif

#if !defined(_WIN32_WCE) && !defined(PLATFORM_APPLE_SSLVPN) && !defined(PLATFORM_LINUX_EMBEDDED_PPC) && !defined(PLATFORM_WEBOS_ARM) && !defined(PLATFORM_WEBOS_X86) && !defined(PLATFORM_ANDROID) && !defined(APPLE_IOS) && !defined(PRODUCT_TYPE_SSA)
#define LEAF_SUPPORTED
#endif

#if !defined(PRODUCT_TYPE_SSA) && ( defined(_WIN32) || ( defined(PLATFORM_LINUX) && !defined(PLATFORM_ANDROID) ) || defined(PLATFORM_DARWIN) )
#define ENFORCE_MULTIPLE_LOGON
#endif

#if !defined(PLATFORM_ANDROID) // More platforms need to be added
#define WIDE_CHAR_SUPPORTED
#endif

#if defined(_WIN32) && !defined(PRODUCT_TYPE_SSA)
#define TUNNEL_PROXY_SETTINGS_SUPPORTED
#endif

/*
** Public Proxy support is only implemented on Windows and Linux and mac desktop platforms
*/
#if (defined(_WIN32) || defined(PLATFORM_LINUX) || defined(PLATFORM_DARWIN)) && !defined(PRODUCT_TYPE_SSA)
#define PUBLIC_PROXY_SUPPORTED
#endif

/*
** NTLM support is only implemented on Windows desktop platforms
*/
#if defined(_WIN32) && defined(PUBLIC_PROXY_SUPPORTED)
#define PROXYAUTH_NTLM_SUPPORTED
#endif

#if defined(PLATFORM_ANDROID) || (defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS))
#define IMPORT_API_SUPPORTED
#endif

#if defined(PRODUCT_TYPE_SSA) && !defined(PLATFORM_ANDROID)
/*
** This serves to tell the IPsec plugin interface to explicitly
** exclude it's global namespace entry points, leaving the only
** plugin interface as a set of static class methods, which the
** loading code will look for directly.
*/
#define IPSEC_AS_INTERNAL_MODULE
#endif

#if defined(PLATFORM_ANDROID) // More platforms need to be added
#define dynamic_cast reinterpret_cast
#endif

#if defined(PRODUCT_TYPE_SSA) && defined(APPLE_IOS) && !defined(PLATFORM_APPLE_SSLVPN)
#define CONFIGURE_REMOTE_WAKEUP_SUPPORTED
#endif

/*
** The SMARTCARD_REMOVAL_SUPPORTED define is used to track the platforms where smartcard
** removal monitoring is supported. This is to avoid repeating the
** platforms in #ifdef clauses in other files.
*/
#if defined(_WIN32)
#define SMARTCARD_REMOVAL_SUPPORTED
#endif

#if defined(PLATFORM_LINUX) && !defined(ANYCONNECT_USE_SNAK) && !defined(PRODUCT_TYPE_SSA)
/*
 ** The CIRCUMVENT_HOST_FILTERING_SUPPORTED define is used to track the platforms
 ** where AnyConnect can control whether or not pre-existing host filtering is
 ** circumvented upon applying AnyConnect filtering (only applicable to split-tunneling). 
 */
#define CIRCUMVENT_HOST_FILTERING_SUPPORTED
#endif

#if defined(PLUGIN_PROTOCOL_SUPPORTED) && !defined(PRODUCT_TYPE_SSA)
#if (defined(_WIN32) && !defined(_WIN32_WCE))
// support Service Control Plugins if defined
#define SERVICE_PLUGIN
// support PhoneHome Plugin if defined
#define PHONEHOME_PLUGIN
#elif defined(PLATFORM_DARWIN)
// support Service Control Plugins if defined
#define SERVICE_PLUGIN
// support PhoneHome Plugin if defined
#define PHONEHOME_PLUGIN
#elif defined(PLATFORM_LINUX)
#define PHONEHOME_PLUGIN
#endif

#endif
/*
 * Platforms that support ACIDEX.
 */
#if defined(_WIN32) || defined(PLATFORM_DARWIN)|| defined(PLATFORM_LINUX)
#define ACIDEX_SUPPORTED
#endif

/*
 * TLS 1.2 is not supported in 3.x versions of AnyConnect.  Support shall begin in the 4.0 release.
 */
#define TLS_1_2_SUPPORTED

/* END OF MACRO HELL */
#endif /*__GENDEFS_H*/
