/**************************************************************************
*       Copyright  2008, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    Preference.h
*  Date:    7/2008
*
***************************************************************************
*
*   Preference class declaration for the Client API.
*
***************************************************************************/

#ifndef _PREFERENCE_
#define _PREFERENCE_

/**
* The Preference class represents a single preference setting that is read
* from disk.  Some preferences can be controlled by the user, as specified
* by administrator policy.  In these instances, the UI layer will represent
* the controls/widgets used to modify a preference by rendering an associated
* PromptEntry object, accessible via the getPromptEntry() method, similar to
* the mechanism used to obtain user input in a ClientIfc::UserPromptCB call.
*/

#include "PreferenceBase.h"

class VPN_VPNAPI Preference : public PreferenceBase
{

    public:

        /**
        * Sets the value associated with this preference.  Returns true on 
        * success, false if the value is not in the range of allowed values
        * for this preference (e.g. setting a value of "fish" for a true/false
        * preference).
        */
        bool setPreferenceValue(const tstring& value);


        /**
        * Returns the current value of this preference as returned by
        * PromptEntry::getTrueValue(). The values "true" and "false" are 
        * returned for preferences represented by a checkbox.
        */
        const tstring& getPreferenceValue() const;


        /**
        * Returns the ID of this Preference. For a complete list of preference
        * ID's see the ::PreferenceId enum in api.h.
        */
        const PreferenceId& getPreferenceId() const;


        /**
        * Returns a reference to an internal list of child preferences for this
        * class.  Callers may modify the value of the Preference objects contained
        * within, but should not alter the list or delete individual objects.
        */
        const std::list<Preference*>& getChildren() const; 


        /**
        * Returns a pointer to an internal PromptEntry used to modify the value
        * of this Preference. By checking the type of the PromptEntry, an 
        * appropriate UI layer control/widget should be created that can be
        * used to update the value of the preference. The caller should not 
        * delete the returned pointer.
        *
        * From the ::PromptType enum in api.h, Prompt_Combo and Prompt_Checkbox
        * are used by this class.
        *
        * @see PromptEntry
        */
        PromptEntry* getPromptEntry() const;


        Preference(PreferenceId preferenceId,
                   const tstring& label,
                   PromptType prefType,
                   const tstring& initialValue,
                   ApiStringMap* pOptions = NULL,
                   Preference* pParent = NULL);

};

#endif // _PREFERENCE_
