/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* ----------------------------- Required Headers -------------------- */

#ifndef CASCMSG_H
#define CASCMSG_H

#include	<stdarg.h>

#ifndef STDTOOL_H
#include	<cogent/stdtool.h>
#endif

#ifndef UTIL_H
#include	<cogent/util.h>
#endif

#ifndef IPC_H
#include	<cogent/ipc.h>
#endif

extern ST_STATUS CM_LispMessage (IP_Task *myself, IP_Task *receiver,
								 IP_Msg *outmsg, IP_Msg *inmsg, int* argc,
								 char ** argv, int maxargs, char* format, ...);
extern ST_STATUS CM_VStrMessage (IP_Task *myself, IP_Task *receiver,
								 IP_Msg* outmsg, IP_Msg* inmsg, char* format,
								 va_list params);
extern ST_STATUS CM_VRawMessage (IP_Task *receiver, void *retbuf,
								 int bufsize, char* format, va_list params);
extern ST_STATUS CM_RawMessage (IP_Task *receiver, void *retbuf,
								int bufsize, char* format, ...);
extern ST_STATUS CM_SimpleCmd (IP_Task *receiver, char* retbuf, int buflen,
							   char* format, ...);
extern ST_STATUS CM_IntegerCmd (IP_Task *receiver, char* retbuf, int buflen,
								int* answer, char* format, ...);
extern ST_STATUS CM_StringCmd (IP_Task *receiver, char* retbuf, int buflen,
							   char* format, ...);

#endif /* CASCMSG_H */
