/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* ****************************************************************************
 *
 *  Filename:     cif_api.h
 *  Description:  Header file for protocol specific use of generic API driver:
 *				   for Hilscher CIF-series cards
 *
 *  Created:	  Sept 13, 1997
 *  Last Updated: July 21, 2000
 *  Author:		 Manuel Dias, Cogent Real-Time Systems Inc
 * 
 *
 *************************************************************************** */

#ifndef CIF_API_H
#define CIF_API_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 **********************************************************************
 * Data structures for use with DR_ApReadControl and DR_ApWriteControl
 **********************************************************************
 */
typedef struct 
{
	unsigned char	Mode;
	unsigned char	reserved1;
	unsigned char	Format;
	unsigned short	WatchdogTime;
	unsigned char	reserved5[3];
	unsigned char	reserved8[8];
}
#ifdef __GNUC__
__attribute__((packed))
#endif
cif_ApParms_t;

typedef cif_ApParms_t cif_ApParms_DNM_t;	/* DeviceNet Master */

typedef struct 
{
	unsigned char	Mode;
	unsigned char	reserved1;
	unsigned char	reserved2;
	unsigned short	WatchdogTime;
	unsigned char	OwnMacId;
	unsigned short	VendorId;
	unsigned char	BaudRate;
	unsigned short	ProducedSize;
	unsigned short	ConsumedSize;
	unsigned char	reserved13[3];
}
#ifdef __GNUC__
__attribute__((packed))
#endif
cif_ApParms_DNS_t;		/* DeviceNet Slave */

typedef cif_ApParms_t cif_ApParms_IBM_t;	/* Interbus Master */

typedef struct 
{
	unsigned char	Mode;
	unsigned char	CycleTime;
	unsigned char	Format;
	unsigned short	WatchdogTime;
	unsigned char	reserved5[3];
	unsigned char	reserved8[8];
}
#ifdef __GNUC__
__attribute__((packed))
#endif
cif_ApParms_DPM_t;	/* Profibus DP Master */

#define IOMODE_DEV_UNBUF	0	// CIF device controlled, unbufferred
#define IOMODE_DEV_BUF		1	// CIF device controlled, bufferred
#define IOMODE_NO_CTRL		2	// uncontrolled
#define IOMODE_HOST_BUF		3	// HOST controlled, bufferred
#define IOMODE_HOST_UNBUF	4	// HOST controlled, unbufferred
#define IOMODE_STR(mode)	\
            ((mode)==IOMODE_DEV_UNBUF?"Device controlled, bus synchronous" :\
			 ((mode)==IOMODE_DEV_BUF?"Device controlled, buffered" :\
			  ((mode)==IOMODE_HOST_BUF?"HOST controlled, buffered" :\
			   ((mode)==IOMODE_HOST_UNBUF?"HOST controlled, bus synchronous" :\
				((mode)==IOMODE_NO_CTRL ? "no handshake" :\
				 "undefined")))))

#define FORMAT_INTEL		0
#define FORMAT_MOTOROLA 	1
#define FORMAT_STR(format)		\
            ((format)==0 ? "INTEL" : \
			 ((format)==1 ? "MOTOROLA" : \
			  "undefinedFormat"))

/*
 **********************************************************************
 * Data structures and definitions for use with DR_ApReadStatus
 **********************************************************************
 */
typedef struct
{
	unsigned char GlobalBits;		/* [rsvd...rsvd||NData|AClr|Ctrl]		*/
	unsigned char DPMState;			/* main state of master system			*/
	unsigned char ErrorRemoteAddr;	/* remote address of faulty participant */
	                                /* or 255 if inside DEVICE 				*/
	unsigned char ErrorEvent;		/* error number if ErrorRemoteAddr = 255*/
	unsigned char reserved [28];	/* 										*/
	unsigned char SlaveState [16];	/* slave state (128 packed bits) 		*/
	                                /*	0=inactive, 1=active				*/
	unsigned char SlaveDiags [16];	/* slave diagnostic (128 packed bits)	*/
}
#ifdef __GNUC__
__attribute__((packed))
#endif
cif_ApState_t;

// Global bit definitions
#define	STATE_GLOBAL_CTRL	0x01	/* Parameterization error occurred 	*/
#define STATE_GLOBAL_ACLR	0x02	/* Device branched into mode		*/
                                    /* 	Auto_clear due to slave error	*/
#define STATE_GLOBAL_NDATA	0x04	/* At least one slave NOT in 		*/
                                    /* data_exchange_mode reports fatal error */

/* DPM master states defined */
#define STATE_OFFLINE	0x00
#define STATE_STOP		0x40
#define	STATE_CLEAR		0x80
#define STATE_OPERATE	0xC0
#define STATE_STR(state)	\
            ((state)==STATE_OFFLINE ? "OFFLINE" : \
			 ((state)==STATE_STOP ? "STOP" : \
			  ((state)==STATE_CLEAR ? "CLEAR" : \
			   ((state)==STATE_OPERATE ? "OPERATE" : \
				 "undefinedState"))))

/* Definition of status bits available in the driver status point
   (see defineStatusPnt command)
*/
/* The following card/device status bits are repeated for each device		*/
/*	in 8-bit fields (total 32 status bits)									*/
#define CIF_STATUS_NOTREADY		0x1	/* Power-Up initialization unsuccessful	*/
#define CIF_STATUS_NOTRUNNING	0x2	/* Card not fully operational 			*/
#define CIF_STATUS_NOCOMM		0x4	/* Fieldbus exchange inactive 			*/
#define CIF_STATUS_ERROR		0x8	/* Error detected			 			*/
#define CIF_STATUS_MAKE(status,card) 	(((status) & 0x0F)<<(8*(card)))
#define CIF_STATUS_GET(status,card) 	(((status)>>(8*(card))) && 0x0F)
#define CIF_STATUS_CARD_MASK(card) 		(0x0F<<(4*(card)))


#ifdef __cplusplus
};
#endif


#endif

/* ****************************************************************************
 *
 *  End of File:     cif_api.h
 *
 *************************************************************************** */


