/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* ---------------------------- DEFINITIONS ------------------------------ */

#define DH_NAME_PREFIX		"/dh/"

/* ------------------------- FUNCTION PROTOTYPES ------------------------- */

/* ------------------------------ dh_parse.c ----------------------------- */

extern ST_STATUS DH_ParsePointMsg (PT_pCPOINT ppoint, char* name,
								   IP_Msg* hmsg, ER_hLIST erlist);
extern ST_STATUS DH_ParsePointString (PT_pCPOINT ppoint, char* name,
									  char* msgdata, char** msgend,
									  ER_hLIST elist);

/* ------------------------------ dh_user.c ------------------------------ */

extern ST_STATUS DH_FindPointAddress (IP_Task* myself, PT_pCPOINT ppoint,
									  ER_hLIST elist);
extern ST_STATUS DH_SendPointMessage (IP_Task* myself, PT_pCPOINT ppoint,
									  IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_WritePoint (IP_Task* myself, PT_pCPOINT ppoint,
								IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_WriteExistingPoint (IP_Task* myself, PT_pCPOINT ppoint,
										IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_ReadPoint (IP_Task* myself, PT_pCPOINT ppoint,
							   IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_ReadExistingPoint (IP_Task* myself, PT_pCPOINT ppoint,
									   IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_CreatePoint (IP_Task* myself, PT_pCPOINT ppoint,
								 IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_RegisterPoint (IP_Task* myself, PT_pCPOINT ppoint,
								   IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_RegisterExistingPoint (IP_Task* myself, PT_pCPOINT ppoint,
										   IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_RegisterAllPoints (IP_Task* myself, char* domain,
									   int future, IP_Msg* hmsg,
									   ER_hLIST elist);
extern ST_STATUS DH_UnregisterPoint (IP_Task* myself, PT_pCPOINT ppoint,
									 IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_SetLock (IP_Task* myself, PT_pCPOINT ppoint,
							 IP_Msg* hmsg, ER_hLIST elist);
extern ST_STATUS DH_SetSecurity (IP_Task* myself, PT_pCPOINT ppoint,
								 IP_Msg* hmsg, ER_hLIST elist);
extern int DH_FormatPoint (char* command, IP_Task* myself,
						   PT_pCPOINT ppoint, char* buf, int len, int flags);
extern ST_STATUS DH_WriteExistingPoints (IP_Task* myself, PT_pCPOINT *ppoints,
										 int npoints, IP_Msg* hmsg,
										 ER_hLIST elist);
extern int DH_SetTransmitFormat (int flag);
extern ST_STATUS DH_SetReceiveFormat (IP_Task* myself, IP_Msg* hmsg,
									  char* domain, int flag, ER_hLIST elist);
extern ST_STATUS DH_AppendString (IP_Task* myself, PT_pCPOINT ppoint,
								  char* str, IP_Msg* hmsg,
								  ER_hLIST elist);
extern ST_STATUS DH_PointAdd (IP_Task* myself, PT_pCPOINT ppoint,
							  double value, IP_Msg* hmsg,
							  ER_hLIST elist);
extern ST_STATUS DH_PointMultiply (IP_Task* myself, PT_pCPOINT ppoint,
								   double value, IP_Msg* hmsg,
								   ER_hLIST elist);
extern ST_STATUS DH_PointDivide (IP_Task* myself, PT_pCPOINT ppoint,
								 double value, IP_Msg* hmsg,
								 ER_hLIST elist);
