/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* This file maps the exported Cascade DataHub API to the old
   names used for the Cascade Database.  It will not be kept up
   to date relative to any API changes in the Cascade DataHub. */

#define DB_ParsePointMsg DH_ParsePointMsg
#define DB_ParsePointString DH_ParsePointString
#define DB_FindPointAddress DH_FindPointAddress
#define DB_SendPointMessage DH_SendPointMessage
#define DB_WritePoint DH_WritePoint
#define DB_WriteExistingPoint DH_WriteExistingPoint
#define DB_ReadPoint DH_ReadPoint
#define DB_ReadExistingPoint DH_ReadExistingPoint
#define DB_CreatePoint DH_CreatePoint
#define DB_RegisterPoint DH_RegisterPoint
#define DB_RegisterExistingPoint DH_RegisterExistingPoint
#define DB_RegisterAllPoints DH_RegisterAllPoints
#define DB_UnregisterPoint DH_UnregisterPoint
#define DB_SetLock DH_SetLock
#define DB_SetSecurity DH_SetSecurity
#define DB_FormatPoint DH_FormatPoint
#define DB_WriteExistingPoints DH_WriteExistingPoints
#define DB_SetTransmitFormat DH_SetTransmitFormat
#define DB_SetReceiveFormat DH_SetReceiveFormat
#define DB_AppendString DH_AppendString
#define DB_PointAdd DH_PointAdd
#define DB_PointMultiply DH_PointMultiply
#define DB_PointDivide DH_PointDivide

typedef enum ST_DB_MSG
{
	ST_DB_CREATE = ST_DH_CREATE,
	ST_DB_READ = ST_DH_READ,
	ST_DB_WRITE = ST_DH_WRITE,
	ST_DB_REPORT = ST_DH_REPORT,
	ST_DB_DELETE = ST_DH_DELETE,
	ST_DB_UNREPORT = ST_DH_UNREPORT,
	ST_DB_FORGET = ST_DH_FORGET,
	ST_DB_EXCEPTION = ST_DH_EXCEPTION,
	ST_DB_ECHO = ST_DH_ECHO,
	ST_DB_REPORT_ALL = ST_DH_REPORT_ALL,
	ST_DB_COMMAND = ST_DH_COMMAND
} ST_DB_MSG;
