/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/*
// ******************************************************************************
//
//  Filename:     dr_api.h
//  Description:  Header for generic driver api
//
//  Created:	  July 24, 1997
//  Last Updated: March 3, 2000
//  Author:		  Manuel Dias, Cogent Real-Time Systems Inc
//
//
// ******************************************************************************
//
//	This module contains the api required by a user to interface to the
//	generic driver administrator.
*/

#ifndef DR_API_H
#define DR_API_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef IPC_H
#include <cogent/ipc.h>
#define IPC_H
#endif
	
/* **********************************************
 * Interface
 */
int DR_ApInitIPC (char *task_name, char *admin_name);
int DR_ApConnectIPC (char *task_name, IP_Task *my_task, IP_Msg *send_msg,
					 IP_Msg *reply_msg, char *admin_name);
int DR_ApCloseIPC (void);
int DR_ApCommand (char *cmd, char *response, int max_response_length,
				  char **error);

/* **********************************************
 * Point access definitions and prototypes
 */
enum DR_API_POINT_TYPE
{
	DR_API_NO_TYPE = 0, DR_API_STRING_TYPE, DR_API_DOUBLE_TYPE,
	DR_API_INT16_TYPE, DR_API_INT32_TYPE, DR_API_BIT_TYPE, DR_API_BYTE_TYPE,
	DR_API_POINT_NUM_TYPES
};

typedef union 
{
	char	c;
	short	s;
	int		i;
	double	d;
	char	*str;
}	DR_ApValue_t;

int DR_ApReadPoint (char *name, int *type_p, DR_ApValue_t *value, char **error);
int DR_ApWritePoint (char *name, int type, DR_ApValue_t *value, char **error);

int DR_ApListPoints (char *filter, int *num_names, char **names, int max_names,
					 char *data, int max_data_length, char **error);

int DR_ApDescribePoint (char *name, int *type,
						int *enabled, int *readable, int *writeable,
						char *address, int addr_length, char **error);

int DR_ApPointBufAddress (char *name, int *dev, int *buf_id,
						  unsigned short *offset, unsigned short *bit, char **error);

/* ***********************************************
 * Binary access mode definitions and prototypes
 */
#define DR_API_BLK_WR			0x91
#define DR_API_BLK_RD			0x92
#define DR_API_BLK_TELEGRAM		0x93
#define DR_API_BLK_CONTROL_WR	0xA1
#define DR_API_BLK_CONTROL_RD  	0xA2						  
#define DR_API_BLK_STATUS_RD  	0xA4						  
						  
typedef struct
{
	uint8_t			cmd;		/* a DR_API_BLK_xxx binary access mode def	*/
	uint8_t			dev;		/* the driver device/card id 				*/
	uint8_t			buffer;		/* the buffer designation within the device	*/
	uint16_t		buf_size;	/* message length available after header 	*/
	uint16_t		size;		/* size of requested datan (bytes)			*/
	uint16_t		offset;		/* offset into requested data (bytes)		*/
	int16_t			status;		/* response status 							*/
	uint8_t			data[1];	/* start of data for command or response	*/
}
#ifdef __GNUC__
__attribute__((packed))
#endif
DR_ApBlkHdr_t;

int	DR_ApReadBlock (int dev, int buffer, unsigned short ofs,
					unsigned short size, char *data, char **error);
int	DR_ApWriteBlock (int dev, int buffer, unsigned short ofs,
					 unsigned short size, char *data, char **error);

int	DR_ApTelegram (char dev, unsigned short size, char *data, char **error);

int	DR_ApReadStatus (int dev, int buffer, unsigned short ofs, unsigned short size,
					void *data, char **error);
int	DR_ApReadControl (int dev, int buffer, unsigned short ofs, unsigned short size,
					 void *data, char **error);
int	DR_ApWriteControl (int dev, int buffer, unsigned short ofs, unsigned short size,
					 void *data, char **error);

					 
typedef struct
{
	char			readable : 1;
	char			writeable : 1;
	char			buf_id;
	char			type;
	unsigned short 	offset;
	unsigned short 	size;
}
#ifdef __GNUC__
__attribute__((packed))
#endif
DR_ApSegAttributes_t;

int DR_ApListBuffers (int dev, int max_bufs, int *num_bufs,
					 unsigned short *size, char **error);
int DR_ApDescribeBuffer (int dev, int buffer, int initial_seg, int max_attr, int *num_attr,
						DR_ApSegAttributes_t *attr,	char **error);

int DR_ApUpdateBuffers ();


/* ***************************************************
 * Error definitions and functions
 */

#define DR_API_OK				0

#ifndef STDTOOL_H
typedef enum
{
	ST_OK = 0, ST_ERROR, ST_NO_TASK, ST_NO_MSG, ST_WOULDBLOCK, ST_INTR,
	ST_FULL, ST_LOCKED, ST_SECURITY, ST_NO_POINT, ST_INSIG, ST_UNKNOWN
} ST_STATUS;
#endif

#ifndef DRIVER_H
typedef enum 
{
	DR_ERRORS = 5000,
	DR_ERR_NO_USER_OBJECT, DR_ERR_BAD_LICENSE,
	DR_ERR_INSUF_PARMS, DR_ERR_CMD_INVALID,
	DR_ERR_NO_NAMESERVER, DR_ERR_ATTACH_TASKNAME, DR_ERR_ATTACH_NAMESERVER,
	DR_ERR_DEV_INVALID, DR_ERR_DEV_IO_FAILURE, DR_ERR_DEV_IO_FAILED,

	DR_ERR_PNT_ERRORS = DR_ERRORS + 100,
	DR_ERR_PNT_NOT_FOUND, DR_ERR_PNT_NOT_DISABLED, DR_ERR_PNT_NOT_ENABLED,	
	DR_ERR_PNT_NOT_READABLE, DR_ERR_PNT_NOT_WRITEABLE,
	DR_ERR_PNT_TYPE_UNKNOWN, DR_ERR_PNT_TYPE_NO_REP,	

	DR_ERR_BLK_ERRORS = DR_ERRORS + 200,
	DR_ERR_BLK_INVALID,	DR_ERR_BLK_NOT_FOUND,
	DR_ERR_BLK_OFS_INVALID, DR_ERR_BLK_SIZE_INVALID,
	DR_ERR_BLK_TYPE_INVALID, DR_ERR_BLK_TYPE_CREATE, DR_ERR_BLK_BUFFER_SMALL,
	DR_ERR_MSG_REQUEST_ERROR, DR_ERR_MSG_RESPONSE_ERROR,

	DR_ERR_NUM_TYPES
		
} DR_ERROR_TYPE;
#endif


#define DR_API_IPC_ERRORS		1000

#define DR_API_STATUS_ERRORS	2000

#define DR_API_ADMIN_ERRORS		DR_ERRORS

#define DR_API_ERRORS			10000
#define DR_API_ERR						DR_API_ERRORS + 0
#define DR_API_CMD_ERR					DR_API_ERRORS + 1

#define DR_API_PNT_ERRORS				DR_API_ERRORS + 100
#define DR_API_PNT_ERR					DR_API_PNT_ERRORS+1
#define DR_API_PNT_ACCESS_ERR			DR_API_PNT_ERRORS+2

#define DR_API_BLK_ERRORS				DR_API_ERRORS + 200
#define DR_API_BLK_ERR					DR_API_BLK_ERRORS+1
#define DR_API_BLK_OSIZE_ERR			DR_API_BLK_ERRORS+2
#define DR_API_BLK_DATAP_ERR			DR_API_BLK_ERRORS+3
#define DR_API_BLK_NO_DEV_ERR			DR_API_BLK_ERRORS+4


#ifdef __cplusplus
};
#endif


#endif

/* ***************************************************************************
 *
 *  End of file:     dr_api.h
 *
 *************************************************************************** */
