/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* Exported header file for history module. */

#ifndef _STDARG_H_INCLUDED
#include	<stdarg.h>
#endif

typedef struct HI_stVALUE
{
	double		xaxis;
	double		value;
} HI_stVALUE;

#define HI_NAME_PREFIX	"/hi/"

/* History flags */

#define hi_HIST_DISABLED			0x0001L
#define hi_HIST_REGISTERED			0x0002L
#define hi_HIST_DEADBAND			0x0004L
#define hi_HIST_DEADBAND_FORCE		0x0010L
#define hi_HIST_DEADBAND_PRIOR		0x0100L

#define hi_HIST_DEADBAND_PERCENT	0x0008L
#define hi_HIST_DEADBAND_ABSOLUTE	0x0020L
#define hi_HIST_DEADBAND_TIMELIMIT	0x0040L
#define hi_HIST_DEADBAND_COUNTLIMIT 0x0080L
#define hi_HIST_DEADBAND_TYPES		0x00E8L


/* ---------------------- hi_api.c ----------------------------- */

extern ST_STATUS HI_LispMessage (IP_Task *myself, IP_Task *historian,
								 IP_Msg *outmsg, IP_Msg *inmsg, int* argc,
								 char ** argv, int maxargs,
								 char* format, ...);
extern ST_STATUS HI_VRawMessage (IP_Task *historian, void *retbuf,
								 int bufsize, char* format, va_list params);
extern ST_STATUS HI_RawMessage (IP_Task *historian, void *retbuf,
								int bufsize, char* format, ...);

extern ST_STATUS HI_SimpleCmd (IP_Task *historian, char* retbuf, int buflen,
							   char* format, ...);
extern ST_STATUS HI_Add (IP_Task *historian, char* retbuf, int buflen,
						 char* histname, double value,
						 time_t seconds, time_t nanoseconds);
extern ST_STATUS HI_Deadband (IP_Task *historian, char* retbuf, int buflen,
							  char* histname, char* type, double value);
extern ST_STATUS HI_Delete (IP_Task *historian, char* retbuf,
							int buflen, char* histpattern);
extern ST_STATUS HI_Disable (IP_Task *historian, char* retbuf, int buflen,
							 char* histpattern);
extern ST_STATUS HI_Enable (IP_Task *historian, char* retbuf, int buflen,
							char* histpattern);
extern ST_STATUS HI_FileBase (IP_Task *historian, char* retbuf, int buflen,
							  char* histname, char* dir, char* basename,
							  char* ext, int numdigits);
extern ST_STATUS HI_Flush (IP_Task *historian, char* retbuf, int buflen,
						   char* histpattern);
extern ST_STATUS HI_History (IP_Task *historian, char* retbuf, int buflen,
							 char* histname);
extern ST_STATUS HI_Register (IP_Task *historian, char* retbuf, int buflen,
							  char* histpattern);
extern ST_STATUS HI_Unregister (IP_Task *historian, char* retbuf, int buflen,
								char* histpattern);
extern ST_STATUS HI_BufferIDDestroy (IP_Task *historian, char* retbuf,
									 int buflen, int bufferid);

extern ST_STATUS HI_IntegerCmd (IP_Task *historian, char* retbuf, int buflen,
								int* answer, int index, char* format, ...);
extern ST_STATUS HI_Bufsize (IP_Task *historian, char* retbuf, int buflen,
							 char* histname, int numvalues, int *size);
extern ST_STATUS HI_Count (IP_Task *historian, char* retbuf, int buflen,
						   char* histpattern, int* count);;
extern ST_STATUS HI_Length (IP_Task *historian, char* retbuf,
							int buflen, char* histname, int* length);
extern ST_STATUS HI_BufferIDLength (IP_Task *historian, char* retbuf,
									int buflen, int bufferid, int* length);
extern ST_STATUS HI_Interpolate (IP_Task *historian, char* retbuf,
								 int buflen, char* histname,
								 char* interpolator, double start,
								 double duration, int nxargs, char** xargs,
								 int* bufferid);

extern ST_STATUS HI_StringCmd (IP_Task *historian, char* retbuf, int buflen,
							   char* format, ...);
extern ST_STATUS HI_Version (IP_Task *historian, char* retbuf, int buflen);
extern ST_STATUS HI_Describe (IP_Task *historian, char* retbuf, int buflen,
							  char* histname);
extern ST_STATUS HI_List (IP_Task *historian, char* retbuf, int buflen,
						  char* histpattern, int offset, int maxcount,
						  char **histories, int *count);

extern ST_STATUS HI_Earliest (IP_Task *historian, char* retbuf, int buflen,
							  char* histname, HI_stVALUE* data);
extern ST_STATUS HI_Latest (IP_Task *historian, char* retbuf, int buflen,
							char* histname, HI_stVALUE* data);
extern ST_STATUS HI_BufferIDRead (IP_Task *historian, char* retbuf, int buflen,
								  int bufferid, int start, int count,
								  HI_stVALUE* result);

extern ST_STATUS HI_InterpolateData (IP_Task *historian, char* histname,
									 char* interpolator, double start,
									 double duration, int nxargs, char** xargs,
									 HI_stVALUE** values, int *nvalues);

/* ---------------------- hi_user.c ---------------------------- */

extern ST_STATUS HI_ExchangeBuffer (int nvalues, HI_stVALUE* values);
extern ST_STATUS HI_ScaleBuffer (int nvalues, HI_stVALUE* values,
								 double xscale, double xoff,
								 double yscale, double yoff);
extern ST_STATUS HI_ClipBuffer (int nvalues, HI_stVALUE* values,
								double min, double max);
extern ST_STATUS HI_StatBuffer (int nvalues, HI_stVALUE* values,
								double *minptr, double *maxptr,
								double *meanptr, double *stddevptr);
extern int	HI_GapCountBuffer (int nvalues, HI_stVALUE* values, double gap);
extern ST_STATUS HI_GapFillBuffer (int n, HI_stVALUE* values,
								   int n2, HI_stVALUE* new_values, double gap);

