/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

#ifndef HWTYPES_H
#define HWTYPES_H

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifndef HAVE_FAR
#	define far
#endif

#ifndef HAVE_USTUFF
	typedef unsigned short ulong;
	typedef unsigned short ushort;
	typedef unsigned short uchar;
#endif

#ifndef HAVE_UINT32
	typedef unsigned long	uint32_t;
#endif

#ifndef HAVE_INT32
	typedef signed long		int32_t;
#endif

#ifndef HAVE_UINT16
	typedef unsigned short	uint16_t;
#endif

#ifndef HAVE_INT16
	typedef signed short	int16_t;
#endif

#ifndef HAVE_UINT8
	typedef unsigned char	uint8_t;
#endif

#ifndef HAVE_INT8
	typedef signed char		int8_t;
#endif

#ifndef HAVE_UINTPTR
	typedef unsigned long	uintptr_t;
#endif

#ifndef HAVE_INTPTR
	typedef signed long		intptr_t;
#endif

#endif

