/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

#ifndef IOPORT_H
#define IOPORT_H

#include <machdep.h>

/*
 * Defines Intel I/O port access functions, using the Watcom convention:
 * extern unsigned inpw(unsigned __port);
 * extern unsigned outp(unsigned __port, unsigned __value);
 * extern unsigned outpw(unsigned __port,unsigned __value);
 * extern unsigned inpd(unsigned __port);
 * extern unsigned outpd(unsigned __port, unsigned __value);
 */

#if defined(__linux__)

#include <sys/io.h>

#define outp(port, value)	outb(value, port)
#define outpw(port, value)	outw(value, port)
#define outpd(port, value)	outl(value, port)

#define inp(port)	inb(port)
#define inpw(port)	inw(port)
#define inpd(port)	inl(port)

#elif defined(__QNX__)

#include <conio.h>

#endif

#ifdef __QNXNTO__
#include	<hw/inout.h>
#endif

/*
 * Defines the swab() byte-swapping functions.
 */

#if defined(__linux__)
	/* The Linux man page says this is defined in <string.h> -- it isn't, but
	 * is in the standard library... though I can't find the prototype
	 * anywhere!
	 *
	 * It is in unistd.h in Linux.  (AT)
	 * BUT ONLY IF you define __USE_XOPEN, so lets put it back in here (MD)
	 * But now __USE_XOPEN is defined by default in kernels 2.4.18 and up
	 */
#ifndef __USE_XOPEN
extern void swab(const void* from, void* to, size_t n);
#endif

#elif defined(__QNX__)
#	include <stdlib.h>
#else
// #	error "no swab defined for this platform"
#endif

/*
 * Defines the Watcom delay(milliseconds) in terms of the Linux usleep(microseconds)
 *  Thus we join non-standard with non-standard...
 */

#if defined(__linux__)

#	include <unistd.h>
#	define delay(MS) usleep((MS) * 1000)

#elif defined(__QNX__)
#	include <i86.h>
#else
// #	error "no delay(milliseconds) defined for this platform"
#endif

#endif

