/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

#ifndef _MACHDEP_H_INCLUDED
#	define _MACHDEP_H_INCLUDED
#	ifdef __linux__
#		include	<cogent/linux.h>
#	else
#		ifdef __QNXNTO__
#			include	<cogent/nto.h>
#			undef __QNX__
#		else
#			ifdef __QNX__
#				include	<cogent/qnx.h>
#			else
#				if defined(__MS_WINDOWS__) || defined(_WINDOWS)
#					include	<cogent/mswin.h>
#					undef NO_SIGNAL_HANDLERS
#					ifndef __MS_WINDOWS__
#						define __MS_WINDOWS__
#					endif
#				else
#					if defined(__MSDOS__) || defined (MSDOS) || defined (_MSC_VER)
#						include	<cogent/msdos.h>
#						ifndef __MSDOS__
#							define __MSDOS__
#						endif
#					else
#						include <cogent/cygwin.h>
#					endif /* __MS_WINDOWS__ */
#				endif /* __MSDOS__ */
#			endif /* __QNX__ */
#		endif /* __QNXNTO__ */
#	endif /* __LINUX__ */

#include <cogent/hwtypes.h>

#ifndef DllSym
#define DllSym		extern
#define MainSym		extern
#define DllImport
#define DllExport
#endif

#endif /* _MACHDEP_H_INCLUDED */
