/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* If the compiler/libraries support alloca */
#define HAVE_ALLOCA

/* We need a variety of header files.  See how close you can get. */
#undef	HAVE_CONIO_H
#define HAVE_DIRENT_H
#undef	HAVE_DIRECT_H
#undef	HAVE_DOS_H
#undef	HAVE_ENV_H
#define	HAVE_IOCTL_H
#define	HAVE_PROCESS_H
#define HAVE_TERMIOS_H
#undef  HAVE_SYS_FSYS_H
#undef	HAVE_SYS_KERNEL_H
#undef	HAVE_SYS_DEV_H
#undef	HAVE_SYS_LMF_H
#define	HAVE_SYS_TIME_H
#define	HAVE_SYS_TIMEB_H
#define	HAVE_SYS_IOCTL_H
#undef	HAVE_SYS_IO_H
#undef	HAVE_SYS_IRQINFO_H
#define	HAVE_SYS_TYPES_H
#define	HAVE_SYS_WAIT_H
#define	HAVE_TIMER_T
#define HAVE_INT32
#define HAVE_INT16
#define HAVE_INT8
#define HAVE_INTPTR
#define HAVE_UINT8
#define HAVE_UINT16
#define HAVE_UINT32
#define HAVE_UINTPTR
#define HAVE_UNISTD_H
#define HAVE_LIMITS_H
#define HAVE_ERRNO_H
#define HAVE_POSIX4_TIMEFNS
#define HAVE_DLFCN_H

/* Turn on or off trace(), notrace().  If we dont define NO_TRACE,
 * we can define USE_CODE_TRACE to allow trace into functions */
#undef	NO_TRACE
#undef	USE_CODE_TRACE

/* Turn on or off use of IP_* functions */
// #define	NO_IPC 1

/* Turn on or off use of rule sets */
#undef	USE_RULES

/* Turn on or off use of Comdale ProcessVision functions */
#undef	USE_COMDALE

/* Turn on or off use of the read access callback */
#undef	USE_WHENREAD

/* If the system supports proxies (directly or indirectly) for timers,
   define this */
#undef	HAVE_PROXY
#define	HAVE_PROXY_TIMER

/* If we are using TCP/IP for IPC, define this */
#undef	USE_TCP

/* If we are placing a serial number on each executable, use this */
#undef	USE_SERIALNO

/* If we are using the internalize function, use this */
#undef	USE_INTERNAL

/* If we are compiling for QNX Windows, use this.   Normally this is
   supplied by the makefile, not through this file. */
#undef	USE_QWIN

/* If we are compiling for Photon, use this.  Normally this is supplied
   by the makefile, not through this file.  If we want all of the
   Photon widgets, use FULL_PHOTON */
// #undef	USE_PHOTON
// #undef FULL_PHOTON

/* If we are supporting shared libraries, use this */
#undef	SHLIB

/* If we want to use the protected heap (faster, uses some space) use this */
#undef	USE_PROTECTED_HEAP

/* If we do not want to use gmalloc, use this.  Normally, we should not
   use gmalloc() */
#define	NO_GMALLOC

/* If events are protected from signals automatically, we can use this */
#undef	SAFE_EVENTS

/* If the GC is protected from signals automatically, we can use this */
#undef	SAFE_GC

/* If we want to include LISP stack debugging code, use this */
#undef	DEBUG_REGISTERS

/* If we want symbol values in a UT_pARRAY, use this.  Usually do not */
#undef	SYMVAL_PARRAY

/* If we want curses support (not implemented) use this */
// #undef	USE_CURSES

/* If we want to exclude class and structure code, use this */
#undef	NO_CLASSES

/* If we want to exclude signal handlers, use this */
#undef	NO_SIGNAL_HANDLERS

/* If malloc is re-entrant (signal-safe), use this */
#undef	UNSAFE_ALLOC

/* If we want to limit the size of the reader (making it non-reentrant),
   use this.  Normally you do not want this. */
#undef	STATIC_READER

/* If we have a nanosleep function, use this */
#define	HAVE_NANOSLEEP

/* If we have a gettimeofday function, use this */
#define HAVE_GETTIMEOFDAY

/* If we want to inhibit use of the Cascade DataHub, use this */
#undef NO_DATAHUB

/* If we want to use the fd_* functions, use this */
#define USE_DEV

/* If we want to inhibit the profiler, use this */
#define NO_PROFILER

/* If we want to inhibit QNX IPC (send/receive/reply), use this */
#define NO_QNX_IPC

/* If we have Neutrino IPC functions */
#define HAVE_NTO_IPC

/* If we want to include pipe and pty code, use this */
#undef USE_PIPE

/* If we want scopes stored in arrays instead of Cells, use this.  It is
   faster, so normally you should use it. */
#define	SCOPE_ARRAY

/* If we want to optimize some of the type checking functions, do this */
#define	OPTIMIZE

/* If the OS uses one-shot signals (signal handler is removed after the
   signal occurs) use this. */
#undef	ONE_SHOT_SIGNALS

/* If the OS allows a signal to occur while a handler on the same signal
   is being executed, use this */
#undef	REENTRANT_SIGNALS

/* If we want signal handlers to occur immediately instead of being
   deferred to a safe point, do this. */
#undef IMMEDIATE_SIGNALS

/* If we have clock_gettime(), use this */
#define	HAVE_CLOCK_GETTIME

/* If we have timer_settime(), use this */
#define	HAVE_TIMER_SETTIME

/* If we have *itimer functions, use this.  This is normal UNIX */
#undef	HAVE_ITIMER

/* If we have a qnx_spawn() function, use this. */
#undef	HAVE_QNX_SPAWN

/* If the compiler gives us extern void* _STACKLOW, use this */
#undef	HAVE_STACKLOW

/* If we want to compile a minimal test, use this. */
#undef	MINTEST

/* If the C lib has memmem(), use this */
#define	HAVE_MEMMEM

/* If we have inp, outp, inpw, outpw, use this. */
#undef	HAVE_INP

/* If we want to have shared memory functions (mmap, shm_open, shm_close),
   use this. */
#undef	HAVE_SHMEM

/* If we want to be nuts about argument checking, use this.  Normally you
   do not need to do this. */
#undef	ALWAYS_CHECK_ARGS

/* If the C library supplies strrev(), use this */
#undef	HAVE_STRREV

/* If we want to include fork() and exec(), use this */
#undef	NO_SUBPROCESS

/* Old stuff.  Just to be safe */
#undef	OLD_FUNCTIONS
#undef	OLD_HANDLE_TIMERS
#undef	OLD_CLASSES
#undef	OLD_WAY

/* QNX defines some max sizes.  Do you have them? */
//		#define	_MAX_PATH	256
// 		#define	NAME_MAX	64

/* We need a definition of stricmp and strincmp */
// 	#define stricmp		strcasecmp
//	#define stricmp		strncasecmp

#ifndef min
#define min(x,y)	((x)<(y)?(x):(y))
#define max(x,y)	((x)>(y)?(x):(y))
#endif

/* QNX defines getnid and getpid */
#define	getnid()	0
//		#define	getpid()	0

/* Some systems only take one arg to mkdir */
#define MKDIR(x,y)		mkdir(x,y)
//		#define MKDIR(x,y)	mkdir(x)

/* Some systems have no _fullpath */
//		#define _fullpath(n,f,l)	strncpy (n,f,l)

/* The directory separator character in a pathname */
#define DIRSEPCHAR	'/'

/* For Neutrino, sigset_t is a structure */
#define AGGREGATE_SIGSET_T

/* We have the sleep() clib function */
#define HAVE_SLEEP

/* We have a real standard input/output system */
#define HAVE_STDIN

/* We have asynchronous queues if we use QNX4 compatibility */
#define HAVE_ASYNC_QUEUES

/* Do we have QNX4 interrupts? */
#undef HAVE_QNX_INTERRUPTS

/* Do we have Neutrino interrupts? */
#define HAVE_NTO_INTERRUPTS

#define _MAX_PATH	PATH_MAX

/* If we have dlopen, dlclose, dlsym, dlerror */
#define HAVE_DL_FUNCTIONS

/* We have TCP/IP in Neutrino */
#define USE_IPTCP

#undef __QNX__

#include <inttypes.h>

/* Migration toolkit */

// #include <mig4nto.h>
// #define qnx_proxy_rem_attach(nid,pid)		pid
// #define qnx_proxy_rem_detach(nid,pid)		pid
// #define _QNX_PROXY_SIZE_MAX					100

#define inl			in32
#define outl(p,v)	out32(p,v)
#define inw			in16
#define outw(p,v)	out16(p,v)
#define inb			in8
#define outb(p,v)	out8(p,v)
#define outp(p,v)	out8(p,v)
#define inp			in8
#define outpw(p,v)	out16(p,v)
#define inpw		in16


#define GCC_PACKED __attribute__ ((packed))

#ifndef nid_t
#define		nid_t	long
#endif

#define TIMER_ADDREL	0

#define BROKEN_STRTOK
