/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

#ifndef POINT_H
#define POINT_H

#ifdef __cpluplus
extern "C" {
#endif

#ifndef CRSERROR_H
#include <cogent/crserror.h>
#endif

#ifndef UTIL_H
#include <cogent/util.h>
#endif
	
typedef double ptreal;

typedef union
{
	ptreal		r;
	int32_t		i;
	char		*s;
	void		*v;
} PT_uVALUE;

typedef PT_uVALUE		*PT_pVALUE;

#define	POINT_COMMON		\
	short		type;		\
	PT_uVALUE	value;		\
	short		conf;		\
	char 		*name;		\
	short		locked;		\
	short		security;	\
	void*		address;	\
	time_t		seconds;	\
	time_t		nanoseconds

typedef struct PT_stPOINT
{
	POINT_COMMON;

	short		clientlongs;
	int32_t		*clientmap;
	int32_t		*clientforeign;
	int32_t		*pendingmap;
	int32_t		*blockedmap;
	short		numpending;
	short		numblocked;
	short		nclients;
	short		priority;
	char		onpendinglist;
	char		onblockedlist;
} PT_stPOINT;

typedef PT_stPOINT	*PT_pPOINT;

typedef struct PT_stCPOINT
{
	POINT_COMMON;

	void		*userdata;
} PT_stCPOINT;

typedef PT_stCPOINT		*PT_pCPOINT;

enum PT_TYPE
{
	PT_TYPE_STRING,
	PT_TYPE_REAL,
	PT_TYPE_INT32,
	PT_TYPE_VOID,
	PT_TYPE_BINARY,
	PT_TYPE_HEX
};

typedef ST_STATUS (*PT_pfAPPLY)(PT_pCPOINT point, void* data);

/* ------------------------ MACRO DEFINITIONS ------------------------ */

#define	PT_CLIENTSET(p,c)	((p)->clientmap[(c)/32] & (1L << ((c) % 32)))
#define	PT_SET_CLIENT(p,c)	((p)->clientmap[(c)/32] |= (1L << ((c) % 32)))
#define	PT_RESET_CLIENT(p,c) ((p)->clientmap[(c)/32] &= ~(1L << ((c) % 32)))

#define	PT_FOREIGNSET(p,c)	((p)->clientforeign[(c)/32] & (1L << ((c) % 32)))
#define	PT_SET_FOREIGN(p,c)	((p)->clientforeign[(c)/32] |= (1L << ((c) % 32)))
#define	PT_RESET_FOREIGN(p,c) ((p)->clientforeign[(c)/32] &= ~(1L << ((c) % 32)))

#define	PT_PENDINGSET(p,c)	((p)->pendingmap[(c)/32] & (1L << ((c) % 32)))
#define	PT_SET_PENDING(p,c)	((p)->pendingmap[(c)/32] |= (1L << ((c) % 32)))
#define	PT_RESET_PENDING(p,c) ((p)->pendingmap[(c)/32] &= ~(1L << ((c) % 32)))

#define	PT_BLOCKEDSET(p,c)	((p)->blockedmap[(c)/32] & (1L << ((c) % 32)))
#define	PT_SET_BLOCKED(p,c)	((p)->blockedmap[(c)/32] |= (1L << ((c) % 32)))
#define	PT_RESET_BLOCKED(p,c) ((p)->blockedmap[(c)/32] &= ~(1L << ((c) % 32)))

/* ------------------------- DEFINITIONS ------------------------- */

#define PT_FMT_ASCII			0x01
#define PT_FMT_BINARY			0x02
#define PT_FMT_HEX				0x04
#define PT_FMT_POINT_SECURITY	0x08

/* ------------------------ FUNCTION PROTOTYPES ------------------------ */

/* ----------------------------- pt_clnt.c ----------------------------- */

ST_STATUS PT_InitClient (void);
PT_pCPOINT PT_FindCPoint (char* name);
ST_STATUS PT_ApplyPoints (PT_pfAPPLY pfn, void* data);

/* ----------------------------- pt_parse.c ----------------------------- */

extern void PT_RawCopy (PT_pPOINT point, PT_pCPOINT cpoint);
extern ST_STATUS PT_ReadBinaryPoint (PT_pCPOINT ppoint, char* name, char* msgdata,
									 char** msgend, ER_hLIST elist);
extern ST_STATUS PT_ReadPointCommand (PT_pCPOINT ppoint, char** name,
									  int margc, char*margv[], ER_hLIST elist);
extern ST_STATUS PT_ParsePointString (PT_pCPOINT ppoint, char* name,
									  char* msgdata, char** msgend,
									  ER_hLIST elist);
extern int PT_FormatPoint (char* command, int security, PT_pCPOINT ppoint,
						   char* buf, int len, int flags);
extern void PT_RawCopy (PT_pPOINT point, PT_pCPOINT cpoint);
extern void PT_SetCurrentTime (PT_pCPOINT cpoint, int force);
extern void PT_ClearPoint(PT_pPOINT point);
extern void PT_DestroyPoint(PT_pPOINT point);

/* ----------------------------- pt_point.c ----------------------------- */

char *PT_PointString (PT_pCPOINT point, char* format, char* buffer);
long PT_PointInt (PT_pCPOINT point);
double PT_PointReal (PT_pCPOINT point);
char *PT_PointFormat (PT_pCPOINT point, char* format, char* buffer);
void PT_PointCopyValue (PT_pCPOINT dest, PT_pCPOINT src);

/* ----------------------------- pt_table.c ----------------------------- */

UT_hHASHTABLE PT_CreatePointTable (ER_hLIST elist);
PT_pCPOINT PT_NewCPoint (void);

#ifdef __cpluplus
};
#endif

#endif /* POINT_H */
