/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

#include	<stdio.h>
#include    <cogent/machdep.h>

#ifdef __QNXNTO__
#undef __QNX__
#endif

#ifndef STDTOOL_H
#define STDTOOL_H

#ifdef NOTDEF
#define		INT16		short
#define		INT32		long
#endif

typedef enum
{
	ST_FALSE, ST_TRUE
} ST_BOOLEAN;

typedef enum
{
	ST_OK = 0, ST_ERROR, ST_NO_TASK, ST_NO_MSG, ST_WOULDBLOCK, ST_INTR,
	ST_FULL, ST_LOCKED, ST_SECURITY, ST_NO_POINT, ST_INSIG, ST_UNKNOWN,
	ST_NO_QUEUE, ST_CMD_SYNTAX_ERROR, ST_REPLIED, ST_WRONG_TYPE,
	ST_TOO_LARGE, ST_NO_MEMORY, ST_OLD_DATA, ST_TIMEOUT, ST_POINT_EXISTS
} ST_STATUS;

typedef int (*ST_pfWARNING)(char* format, ...);

extern ST_pfWARNING		ST_Errorf;

#if defined(HAVE_QNXTYPES_H)
#include <qnxtypes.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#if defined (__QNX__) && !defined (__TYPES_H_INCLUDED)
#include	<sys/types.h>
#endif

#if !defined (__QNX__) && !defined(__QNXNTO__) && !defined (HAVE_SYS_KERNEL_H)
typedef long nid_t;
#endif

#if defined (__QNX__)
#define strcasecmp(x,y)			stricmp (x,y)
#define strncasecmp(x,y,n)		strnicmp (x,y,n)
#endif

#if defined (__linux__)
#include <sys/types.h>
#endif

#ifdef BROKEN_STRTOK
#define strtok(c,d)	strtok_ok(c,d)
extern char* strtok_ok (char* c, const char* d);
#endif

/* ------------------------------ OS Tracing --------------------------- */
#ifdef __QNX__
#include <sys/trace.h>
#include <sys/tracecod.h>
#else
#define _TRACE_TEMPORARY	(0xfffffL << 21)
#define _TRACE_CRITICAL		0
#define _TRACE_SEVERE		1
#define _TRACE_TRANSIENT	2
#define _TRACE_EXPECTED		3
#define _TRACE_COMMON		6
#define _TRACE_TESTING		7
#define Trace0(a,b)
#define Trace0b(a,b,c,d)
#define Trace1(a,b,c)
#define Trace1b(a,b,c,d,e)
#define Trace2(a,b,c,d)
#define Trace2b(a,b,c,d,e,f)
#define Trace3(a,b,c,d,e)
#define Trace3b(a,b,c,d,e,f,g)
#define Trace4(a,b,c,d,e,f)
#define Trace4b(a,b,c,d,e,f,g,h)
#define Trace5(a,b,c,d,e,f,g)
#define Trace5b(a,b,c,d,e,f,g,h,i)
#define Trace6(a,b,c,d,e,f,g,h)
#define Trace6b(a,b,c,d,e,f,g,h,i,j)
#endif

#define COGENT_TRACE_TYPE		_TRACE_TEMPORARY
#define ST_TRCODE(x)			((unsigned long)(COGENT_TRACE_TYPE | (x)))

enum ST_TRACE_SUBCODE
{
	ST_TR_SPAWN_FAIL = 1, ST_TR_NAMEATTACH_FAIL = 2,
	ST_TR_INITIPC_FAIL = 3
};

/* ------------------- FUNCTION PROTOTYPES ---------------------------- */

DllSym char* 	ST_StatusName (ST_STATUS status);
DllSym int	 	ST_DefaultError (char* format, ...);
DllSym void 	ST_Copyright (FILE *output);
DllSym void 	ST_Version (char* name, int major, int minor, int build,
							char *date, char *time);
DllSym char*	ST_VersionStr (char *buf, int major, int minor, int build,
							   char *date, char *time);
DllSym char*	ST_VersionStrName (char *buf, int buflen, char *name,
								   int major, int minor, int build,
								   char *date, char *time);

DllSym int 		ST_LocateProcess (char *name);
DllSym ST_STATUS ST_StartProcess (char *name, char *exec_str, FILE *output);
DllSym ST_STATUS ST_CheckStartProcess (char *name, char *exec_str,
									   FILE *output);
DllSym ST_STATUS ST_StartNserve (FILE *output);

#endif
