/*
 * (C) Copyright Cogent Real-Time Systems Inc., 1997-2000.
 *     All rights reserved.
 *
 * This file constitutes a part of the Cascade (TM) C-Language
 * application programming interface.  It is not to be modified.  This
 * file is licensed for the purpose of creating programs that will
 * communicate with Cogent's products, and for no other purpose.
 * Cogent claims no rights in any program created by a party other than
 * Cogent by compiling this file, and accepts no responsibility or
 * liability in such a program.
 *
 * It is illegal for any party other than Cogent to sell the contents of
 * this file, or any part thereof, or to attempt to gain in any way from
 * the transmission of this file.  It is illegal to remove this notice
 * from this file.
 */

/* Exported header file for textlog module. */

/* ====================== Function Declarations ======================== */

/* ----------------------------- lg_api.c ------------------------------ */

extern ST_STATUS LG_Cache (IP_Task* myself, IP_Task* textlog, char* retbuf,
						   int buflen, int cached, int ntags, char** tags);
extern ST_STATUS LG_Collect (IP_Task* myself, IP_Task* textlog, char* retbuf,
							 int buflen, char* style, int ntags, char** tags);
extern ST_STATUS LG_Disable (IP_Task* myself, IP_Task* textlog, char* retbuf,
							 int buflen, int ntags, char** tags);
extern ST_STATUS LG_Empty (IP_Task* myself, IP_Task* textlog, char* retbuf,
						   int buflen, char* emptystring);
extern ST_STATUS LG_Enable (IP_Task* myself, IP_Task* textlog, char* retbuf,
							int buflen, int ntags, char** tags);
extern ST_STATUS LG_Exit (IP_Task* myself, IP_Task* textlog, char* retbuf,
						  int buflen, int exitstatus);
extern ST_STATUS LG_Fall (IP_Task* myself, IP_Task* textlog, char* retbuf,
						  int buflen, char* direction, int ntags, char** tags);
extern ST_STATUS LG_File (IP_Task* myself, IP_Task* textlog, char* retbuf,
						  int buflen, char* filename, int ntags, char** tags);
extern ST_STATUS LG_Flush (IP_Task* myself, IP_Task* textlog, char* retbuf,
						   int buflen, int ntags, char** tags);
extern ST_STATUS LG_Time (IP_Task* myself, IP_Task* textlog, char* retbuf,
						  int buflen, char* timespec, int ntags, char** tags);
extern ST_STATUS LG_Timestamp (IP_Task* myself, IP_Task* textlog, char* retbuf,
							   int buflen, char* timestamp, int ntags,
							   char** tags);
extern ST_STATUS LG_Tolerance (IP_Task* myself, IP_Task* textlog, char* retbuf,
							   int buflen, long seconds, long nanoseconds);
extern ST_STATUS LG_UseGMT (IP_Task* myself, IP_Task* textlog, char* retbuf,
							int buflen, int usegmt, int ntags, char** tags);
extern ST_STATUS LG_Group (IP_Task* myself, IP_Task* textlog, char* retbuf,
						   int buflen, char* groupname, int ntags,
						   char** tags);
extern ST_STATUS LG_Log (IP_Task* myself, IP_Task* textlog, char* retbuf,
						 int buflen, char* tagname, char* spec, int npoints,
						 char** pointnames);
extern ST_STATUS LG_Output (IP_Task* myself, IP_Task* textlog, char* retbuf,
							int buflen, char* filename, char* output);
