;;;
;;; Input mapping for QNX 4 and QNX Neutrino consoles, Photon pterms,
;;; and QNX-Windows wterms
;;;

;;;
;;; Set 8-bit input
;;;

(set-input-mode nil nil t)

;;;
;;; ANSI-mode mappings
;;;

(define-key function-key-map "\eNa" [?\M-a])
(define-key function-key-map "\eNb" [?\M-b])
(define-key function-key-map "\eNc" [?\M-c])
(define-key function-key-map "\eNd" [?\M-d])
(define-key function-key-map "\eNe" [?\M-e])
(define-key function-key-map "\eNf" [?\M-f])
(define-key function-key-map "\eNg" [?\M-g])
(define-key function-key-map "\eNh" [?\M-h])
(define-key function-key-map "\eNi" [?\M-i])
(define-key function-key-map "\eNj" [?\M-j])
(define-key function-key-map "\eNk" [?\M-k])
(define-key function-key-map "\eNl" [?\M-l])
(define-key function-key-map "\eNm" [?\M-m])
(define-key function-key-map "\eNn" [?\M-n])
(define-key function-key-map "\eNo" [?\M-o])
(define-key function-key-map "\eNp" [?\M-p])
(define-key function-key-map "\eNq" [?\M-q])
(define-key function-key-map "\eNr" [?\M-r])
(define-key function-key-map "\eNs" [?\M-s])
(define-key function-key-map "\eNt" [?\M-t])
(define-key function-key-map "\eNu" [?\M-u])
(define-key function-key-map "\eNv" [?\M-v])
(define-key function-key-map "\eNw" [?\M-w])
(define-key function-key-map "\eNx" [?\M-x])
(define-key function-key-map "\eNy" [?\M-y])
(define-key function-key-map "\eNz" [?\M-z])

(define-key function-key-map "\e[A" [up])
(define-key function-key-map "\e[B" [down])
(define-key function-key-map "\e[D" [left])
(define-key function-key-map "\e[C" [right])
(define-key function-key-map "\e[V" [prior])
(define-key function-key-map "\e[U" [next])
(define-key function-key-map "\e[@" [insert])
(define-key function-key-map "\e[H" [home])
(define-key function-key-map "\e[Y" [end])
(define-key function-key-map "\e[P" [deletechar])
(define-key function-key-map "\e[T" [kp-plus])
(define-key function-key-map "\e[S" [kp-minus])

(define-key function-key-map "\e[a" [C-up])
(define-key function-key-map "\e[b" [C-down])
(define-key function-key-map "\e[d" [C-left])
(define-key function-key-map "\e[c" [C-right])
(define-key function-key-map "\e[v" [C-prior])
(define-key function-key-map "\e[u" [C-next])
(define-key function-key-map "\e[`" [C-insert])
(define-key function-key-map "\e[h" [C-home])
(define-key function-key-map "\e[y" [C-end])
(define-key function-key-map "\e[p" [C-deletechar])
(define-key function-key-map "\e[t" [C-kp-plus])
(define-key function-key-map "\e[s" [C-kp-minus])
(define-key function-key-map "\e[z" [C-tab])

(define-key function-key-map "\eOP" [f1])
(define-key function-key-map "\eOQ" [f2])
(define-key function-key-map "\eOR" [f3])
(define-key function-key-map "\eOS" [f4])
(define-key function-key-map "\eOT" [f5])
(define-key function-key-map "\eOU" [f6])
(define-key function-key-map "\eOV" [f7])
(define-key function-key-map "\eOW" [f8])
(define-key function-key-map "\eOX" [f9])
(define-key function-key-map "\eOY" [f10])
(define-key function-key-map "\eOZ" [f11])
(define-key function-key-map "\eOA" [f12])

(define-key function-key-map "\eOp" [S-f1])
(define-key function-key-map "\eOq" [S-f2])
(define-key function-key-map "\eOr" [S-f3])
(define-key function-key-map "\eOs" [S-f4])
(define-key function-key-map "\eOt" [S-f5])
(define-key function-key-map "\eOu" [S-f6])
(define-key function-key-map "\eOv" [S-f7])
(define-key function-key-map "\eOw" [S-f8])
(define-key function-key-map "\eOx" [S-f9])
(define-key function-key-map "\eOy" [S-f10])
(define-key function-key-map "\eOz" [S-f11])
(define-key function-key-map "\eOa" [S-f12])

(define-key function-key-map "\e[1~" [C-f1])
(define-key function-key-map "\e[2~" [C-f2])
(define-key function-key-map "\e[3~" [C-f3])
(define-key function-key-map "\e[4~" [C-f4])
(define-key function-key-map "\e[5~" [C-f5])
(define-key function-key-map "\e[6~" [C-f6])
(define-key function-key-map "\e[7~" [C-f7])
(define-key function-key-map "\e[8~" [C-f8])
(define-key function-key-map "\e[9~" [C-f9])
(define-key function-key-map "\e[10~" [C-f10])
(define-key function-key-map "\e[11~" [C-f11])
(define-key function-key-map "\e[12~" [C-f12])

;;; We cannot get the following:
;;;
;;; Shift or Alt - prior, next, insert, deletechar, end, home 
;;;                (not differentiated from the unmodified case)
;;; Alt - F-keys (Photon grabs them)
;;; Alt - backspace (generates Ctl-H ... AAAGGGHHH!!!!)
;;; Alt - `[]\;',./-=1234567890  (generate no keystroke at all)
;;; Ctl - space (generates no keystroke)
;;; Alt - space (Photon grabs it)
;;;
