;;;
;;; Input mapping for QNX 4 and QNX Neutrino consoles, Photon pterms,
;;; and QNX-Windows wterms
;;;

;;;
;;; Set 8-bit input
;;;

(set-input-mode nil nil t)

;;;
;;; QNX-M Mode mappings
;;;

(defvar qnx-extended-map (make-sparse-keymap))
(define-key global-map "\e\^?" nil)

(define-key function-key-map "\e\^?" qnx-extended-map)
(define-key qnx-extended-map "\M-!" [up])
(define-key qnx-extended-map "\M-)" [down])
(define-key qnx-extended-map "\M-$" [left])
(define-key qnx-extended-map "\M-&" [right])
(define-key qnx-extended-map "\M-\"" [prior])
(define-key qnx-extended-map "\M-*" [next])
(define-key qnx-extended-map "\M-+" [insert])
(define-key qnx-extended-map "\M- " [home])
(define-key qnx-extended-map "\M-(" [end])
(define-key qnx-extended-map "\M-," [deletechar])

(define-key qnx-extended-map "\M-\C-a" [f1])
(define-key qnx-extended-map "\M-\C-b" [f2])
(define-key qnx-extended-map "\M-\C-c" [f3])
(define-key qnx-extended-map "\M-\C-d" [f4])
(define-key qnx-extended-map "\M-\C-e" [f5])
(define-key qnx-extended-map "\M-\C-f" [f6])
(define-key qnx-extended-map "\M-\C-g" [f7])
(define-key qnx-extended-map "\M-\C-h" [f8])
(define-key qnx-extended-map "\M-\C-i" [f9])
(define-key qnx-extended-map "\M-\C-j" [f10])
(define-key qnx-extended-map "\M-." [f11])
(define-key qnx-extended-map "\M-/" [f12])

(define-key qnx-extended-map "\M-'" [kp-plus])
(define-key qnx-extended-map "\M-#" [kp-minus])
(define-key qnx-extended-map "\M-7" [C-kp-plus])
(define-key qnx-extended-map "\M-3" [C-kp-minus])
(define-key qnx-extended-map "\M-g" [A-kp-plus])
(define-key qnx-extended-map "\M-c" [A-kp-minus])
  
(define-key qnx-extended-map "\M--" [prtscr])
(define-key qnx-extended-map "\M-=" [C-prtscr])
(define-key qnx-extended-map "\M-]" [A-prtscr])
  
(define-key qnx-extended-map "\M-\C-@" [S-tab])
(define-key qnx-extended-map "\M-\C-_" [C-tab])
  
(define-key qnx-extended-map "\M-1" [C-up])
(define-key qnx-extended-map "\M-9" [C-down])
(define-key qnx-extended-map "\M-4" [C-left])
(define-key qnx-extended-map "\M-6" [C-right])
(define-key qnx-extended-map "\M-2" [C-prior])
(define-key qnx-extended-map "\M-:" [C-next])
(define-key qnx-extended-map "\M-;" [C-insert])
(define-key qnx-extended-map "\M-0" [C-home])
(define-key qnx-extended-map "\M-8" [C-end])
(define-key qnx-extended-map "\M-<" [C-deletechar])
(define-key qnx-extended-map "\M-^" [C-backspace])
(define-key qnx-extended-map "\M-\C-u" [C-f1])
(define-key qnx-extended-map "\M-\C-v" [C-f2])
(define-key qnx-extended-map "\M-\C-w" [C-f3])
(define-key qnx-extended-map "\M-\C-x" [C-f4])
(define-key qnx-extended-map "\M-\C-y" [C-f5])
(define-key qnx-extended-map "\M-\C-z" [C-f6])
(define-key qnx-extended-map "\M-\e" [C-f7])
(define-key qnx-extended-map "\M-\C-\\" [C-f8])
(define-key qnx-extended-map "\M-\C-]" [C-f9])
(define-key qnx-extended-map "\M-\C-^" [C-f10])
(define-key qnx-extended-map "\M->" [C-f11])
(define-key qnx-extended-map "\M-?" [C-f12])
  
(define-key qnx-extended-map "\M-|" [S-backspace])
(define-key qnx-extended-map "\M-k" [S-f1])
(define-key qnx-extended-map "\M-l" [S-f2])
(define-key qnx-extended-map "\M-m" [S-f3])
(define-key qnx-extended-map "\M-n" [S-f4])
(define-key qnx-extended-map "\M-o" [S-f5])
(define-key qnx-extended-map "\M-p" [S-f6])
(define-key qnx-extended-map "\M-q" [S-f7])
(define-key qnx-extended-map "\M-r" [S-f8])
(define-key qnx-extended-map "\M-s" [S-f9])
(define-key qnx-extended-map "\M-t" [S-f10])
(define-key qnx-extended-map "\M-[" [S-f11])
(define-key qnx-extended-map "\M-\\" [S-f12])
  
(define-key qnx-extended-map "\M-a" [A-up])
(define-key qnx-extended-map "\M-i" [A-down])
(define-key qnx-extended-map "\M-d" [A-left])
(define-key qnx-extended-map "\M-f" [A-right])
(define-key qnx-extended-map "\M-b" [A-prior])
(define-key qnx-extended-map "\M-j" [A-next])
(define-key qnx-extended-map "\M-k" [A-insert])
(define-key qnx-extended-map "\M-@" [A-home])
(define-key qnx-extended-map "\M-h" [A-end])
(define-key qnx-extended-map "\M-l" [A-deletechar])
(define-key qnx-extended-map "\M-_" [A-backspace])
(define-key qnx-extended-map "\M-q" [A-f1])
(define-key qnx-extended-map "\M-r" [A-f2])
(define-key qnx-extended-map "\M-s" [A-f3])
(define-key qnx-extended-map "\M-t" [A-f4])
(define-key qnx-extended-map "\M-u" [A-f5])
(define-key qnx-extended-map "\M-v" [A-f6])
(define-key qnx-extended-map "\M-w" [A-f7])
(define-key qnx-extended-map "\M-x" [A-f8])
(define-key qnx-extended-map "\M-y" [A-f9])
(define-key qnx-extended-map "\M-z" [A-f10])
(define-key qnx-extended-map "\M-N" [A-f11])
(define-key qnx-extended-map "\M-O" [A-f12])

;; Map all of the ALT-letter keys
(let ((i ?a) ss)
  (while (<= i ?z)
    (setq ss (concat "\e" (char-to-string i)))
    (define-key qnx-extended-map ss (concat "\e" (char-to-string i)))
    (setq i (1+ i))
    )
  )

(defun execute-key-sequence (key)
  "Execute the key sequence given by KEY.
The key sequence must be complete, and must not contain multiple key
sequences." 
  (let ( (function (key-binding key)) )
    (if function
	(progn
	  (setq this-command function)
	  (call-interactively function)
	  )
      (progn
	(ding)
	)
      )
    )
  )

(defun pc-key-home ()
  "Execute the function bound to the C-a key."
  (interactive "")
  (execute-key-sequence "\^a")
  )

(defun pc-key-end ()
  "Execute the function bound to the C-e key."
  (interactive "")
  (execute-key-sequence "\^e")
  )

(defun pc-key-left ()
  "Execute the function bound to the C-b key."
  (interactive "")
  (execute-key-sequence "\^b")
  )

(defun pc-key-right ()
  "Execute the function bound to the C-f key."
  (interactive "")
  (execute-key-sequence "\^f")
  )

(defun pc-key-up ()
  "Execute the function bound to the C-p key."
  (interactive "")
  (execute-key-sequence "\^p")
  )

(defun pc-key-down ()
  "Execute the function bound to the C-n key."
  (interactive "")
  (execute-key-sequence "\^n")
  )

(defun pc-key-pgup ()
  "Execute the function bound to the ESC v key."
  (interactive "")
  (execute-key-sequence "\ev")
  )

(defun pc-key-pgdn ()
  "Execute the function bound to the C-v key."
  (interactive "")
  (execute-key-sequence "\^v")
  )

(defun kill-word-previous ()
  (interactive)
  (kill-word -1))

(define-key global-map [f1] 'help-for-help)
(define-key global-map [home] 'pc-key-home)
(define-key global-map [end] 'pc-key-end)
(define-key global-map [up] 'pc-key-up)
(define-key global-map [down] 'pc-key-down)
(define-key global-map [left] 'pc-key-left)
(define-key global-map [right] 'pc-key-right)
(define-key global-map [prior] 'pc-key-pgup)
(define-key global-map [next] 'pc-key-pgdn)
(define-key global-map [insert] 'overwrite-mode)
(define-key global-map [deletechar] 'delete-char)
(define-key global-map [C-home] 'beginning-of-buffer)
(define-key global-map [C-end] 'end-of-buffer)

;;(define-key global-map "\M-4" 'backward-word)
;;(define-key global-map "\M-6" 'forward-word)
;;(define-key global-map "\M-_" 'kill-word-previous)
