/*
 * Autoloading functions.  If a symbol is not recognized, look in the
 * autoload list to determine where we should get it.
 */

_auto_load_alist_ := nil;

function AutoLoad (pattern, action)
{
	if (!string_p (pattern))
		error ("Auto load pattern must be string.");
	
	_auto_load_alist_ = cons (cons (pattern, action), _auto_load_alist_);
}

function NoAutoLoad (pattern)
{
	local		removals, pa;

	with pa in _auto_load_alist_ removals=tcollect
		pattern == car(pa) ? pa : nil;

	_auto_load_alist_ = difference (_auto_load_alist_, removals);
}

function ClearAutoLoad ()
{
	_auto_load_alist_ = nil;
}

function AutoMapFunction (name, rettype, args)
{
	local		_function, lib;
	
	if ((lib = dlopen (nil, RTLD_NOW | RTLD_GLOBAL)) != 0)
	{
		if (!dlfunc (lib, name, rettype, args))
			dlclose (lib);
	}
}

function autoload_undefined_symbol (!sym)
{
	local		pa, str;

	str = string (sym);
	for (pa = _auto_load_alist_; pa; pa=cdr(pa))
	  {
		if (shell_match (str, caar(pa)))
		  {
			try
			  {
				eval (cdar(pa));
				if (!undefined_symbol_p(sym))
				  pa = nil;
			  }
			catch
			  {
			  }
		  }
	  }
}

add_hook (#undefined_symbol_hook, #autoload_undefined_symbol);
