(defclass Hooks nil nil
  (hook_alist))

(defmethod Hooks AddHook (name code)
  (self RemoveHook name)
  (-> self hook_alist (cons (cons name code) @hook_alist))
  )

(defmethod Hooks Execute ()
  (for i in @hook_alist do
       (eval (cdr i))))

(defmethod Hooks RemoveHook (name)
  (let ((oldhook (car (assoc name @hook_alist))))
    (if oldhook
	(-> self hook_alist (nremove oldhook @hook_alist)))
    )
  )
