;;;
;;; Make a thumbnail which fits within a goal width and heigth while
;;; maintaining the aspect ratio.
;;;

(defun ImageThumbNail (image wgoal hgoal)
  (let ((xscale (/ wgoal (@ (@ image size) w)))
	(yscale (/ hgoal (@ (@ image size) h)))
	(scale (if (> xscale yscale) yscale xscale)))
    (PxReduceImage image scale scale)))

;;;
;;; Break an image into NxM pieces, and store in a list
;;;

(defun ImageSubDivide (image cols rows)
  (let (result chunk
	(xchunk (/ (@ (@ image size) w) cols))
	(ychunk (/ (@ (@ image size) h) rows)))
    (do ((i 0 (++ i)))
	((>= i rows))
	(do ((j 0 (++ j)))
	    ((>= j cols))
	    (setq chunk (PxSubImage image (* j xchunk) (* i ychunk)
				    xchunk ychunk))
	    (setq result (cons chunk result))
	    )
	)
    (reverse result)
    )
  )

;;;
;;; Put an image into a PtLabel, and return the label
;;;

(defun ImageToLabel (image)
  (let ((lab (new PtLabel)))
    (lab SetArea 0 0 0 0)
    (-> lab label_type Pt_IMAGE)
    (-> lab border_width 0)
    (-> lab margin_width 0)
    (-> lab margin_height 0)
    (-> lab label_data image)
    lab
    )
  )
