;;;
;;; Function to create a modal dialog box
;;;

(defun modal (code exit_condition)
  (let (modnum result parent)
    (unwind_protect
	(progn (setq modnum (PtModalStart))
	       (setq parent (PtSetParentWidget nil))
	       (if (instance_p parent) (-> parent flags Pt_BLOCKED))
	       (setq result (eval code))
	       (while (not (eval exit_condition)) (PtProcessEvent)))
      (progn (PtModalEnd modnum)
	     (if (instance_p parent)
		 (-> parent flags `(,Pt_BLOCKED . nil)))
	     (if (not (destroyed_p parent))
		 (PtSetParentWidget parent))
	     result)
      )
    )
  )
