/*
 * This file contains generally useful functions to support MySQL
 * database connectivity.
 */

function mysql_class_from_table (mysql, symclassname, superclass, tablename)
{
  local		resp, klass, kstring, ivars, cvars;

  if (undefined_symbol_p (symclassname) || !class_p (eval(symclassname)))
	{
	  resp = mysql_query_and_store (mysql, string ("describe ", tablename));
	  if (resp)
		{
		  if (class_p (superclass))
			superclass = class_name(superclass);
		  with x in resp.Data() ivars=collect symbol(x[0]);
		  cvars = list (#__table);
		  kstring = string ("(defclass ", symclassname, " ",
							superclass, " ", cvars, " ", ivars, ")");
		  klass = eval_string (kstring);
		  klass.__table = tablename;
		}
	}
  klass;
}

function mysql_query_to_class (mysql, klass, query_string)
{
  if (resp = mysql_query_and_store (mysql, query_string))
	{
	  if (symbol_p(klass))
		{
		  if (undefined_p (klass = eval(klass)))
			error ("Class is not defined");
		}
	  if (!class_p (klass))
		error ("Class is not defined");

	  instances = mysql_map_class (klass, resp.fields, resp.Data());
	}
  instances;
}

function mysql_query_and_store (mysql, query_string)
{
  local		resp;
  
  resp = mysql_query (mysql, query_string);
  if (resp != -1)
	{
	  resp = mysql_store_result (mysql);
	}
  else
	{
	  error (string("'", query_string, "': Error: ", mysql_error(mysql)));
	}
  resp;
}

function mysql_class_from_fields (symclassname, superclass, fields)
{
  local		klass, ivars, cvars, kstring, name;

  /* We have the option of disallowing the creation of a class that
	 is already created.  This is legal in Gamma, and will simply
	 generate two different classes with the same name.  When all
	 references to the old class are destroyed, the class will be
	 garbage collected.  This is useful if using the same class name
	 for temporary queries. */
  //  if (undefined_symbol_p (symclassname) || !class_p (eval(symclassname)))
	{
	  if (class_p (superclass))
		superclass = class_name(superclass);
	  with x in fields ivars=collect
	  {
		if (strchr(x.name,'.') != -1)
		  name = cadr(string_split(x.name, ".", 3));
		else
		  name = x.name;
		
		name = car(string_split(name, " \t\n/-+=*", 2));
		symbol(name);
	  }
	  cvars = list (#__table);
	  kstring = string ("(defclass ", symclassname, " ",
						superclass, " ", cvars, " ", ivars, ")");
	  
	  klass = eval_string (kstring);
	  klass.__table = nil;
	}
  klass;
}

function mysql_classes_from_tables (mysql, superclass, verbose?=nil)
{
  local		tables;

  resp = mysql_query_and_store (mysql, "show tables;");
  if (resp)
	{
	  with table in resp.Data() do
		{
		  if (verbose)
			princ ("Create class from table: ", table[0], "\n");
		  mysql_class_from_table (mysql, symbol(table[0]), superclass,
								  table[0]);
		}
	}
}

function mysql_query_to_temp_class (mysql, superclass, query)
{
  local		resp, klass, rows;
  
  resp = mysql_query_and_store (mysql, query);
  if (resp)
	{
	  klass = mysql_class_from_fields (#TempQuery, superclass, resp.fields);
	  rows = mysql_map_class (klass, resp.fields, resp.Data());
	}
  TempQuery = nil;
  rows;
}
