/*
 * Functions used when creating a PhAB application directly within PhAB
 */

function internalize_src (executable, file, name, type)
{
	local		fin, fout, tname, line;

	tname = string (file, "__.tmp");
	
	if (fin = open (file, "r", t))
	{
		if (fout = open (tname, "w"))
		{
			while ((line = read (fin)) != _eof_)
			{
				write (fout, line);
				terpri (fout);
			}
			close (fout);
			internalize (executable, tname, name, type);
			unlink (tname);
		}
		close (fin);
	}
}

function phab_internalize_files (list_file, executable)
{
	local		fptr, line, type;
	
	if (fptr = open (list_file, "r"))
	{
		while ((line = read_line (fptr)) != _eof_)
		{
			line = string_split (line, "", 0);
			for (; line; line = cdr(line))
			{
				if (car(line) != "ABSRC" && car(line) != "=")
				{
					if (car(line) == "abmain.c")
						type = 2;
					else
						type = 1;
					internalize_src (executable, car(line), car(line), type);
				}
			}
		}
		close (fptr);
	}
}
