(signal SIGPIPE '(error "Pipe closed"))

(defvar ChildDead nil)

(defun child_died ()
  (let ((pid (wait)))
    (princ "Child " pid "died\n")
    (setq ChildDead t)
    )
  )

(defun capture (cmd &rest &optional (args nil))
  (let ((fds (pipe)) chs answer
	(oldsig (signal SIGCHLD '(child_died))))
    (setq ChildDead nil)
    (qnx_spawn_process nil 0 -1 -1 0 cmd args fds -1)
    (unwind_protect
	(let (line)
	  (while (and (or (not ChildDead)
			  (> (setq chs (chars_waiting (car fds))) 0))
		      (not (eq (setq line (read (car fds))) _eof_)))
	    (princ chs ": " line "\n")
	    (setq answer (cons line answer)))
	  (princ "Chars: " (chars_waiting (car fds)) " error: " (errno) "\n")
	  )
      (progn (close (car fds)) (close (cadr fds)))
      )
    (signal SIGCHLD oldsig)
    answer
    )
  )

(defun opencmd (cmd &rest &optional (args nil))
  (let ((pstdin (pipe)) (pstdout (pipe)) (pstderr (pipe)) taskid)
    (setq taskid (qnx_spawn_process nil 0 -1 -1 0 cmd args
				    (list (car pstdin) (cadr pstdout)
					  (cadr pstderr)) -1))
    (if (> taskid 0)
	(list (cadr pstdin) (car pstdout) (car pstderr))
      nil)
    )
  )
