class PtPopupMenu PtMenu
{
  static:
	current;
}

class PopupMenuItem
{
	name;
	shortcut;
	action;
	icon;
}

class PopupMenu
{
	title;
	titlefont;
	itemfont;
	items = make_array(0);
	bgcolor;
	fgcolor;
	itembgcolor;
	itemfgcolor;
	topbordercolor;
	botbordercolor;
}


method PopupMenu.constructor ()
{
	.bgcolor = 0xa0;
	.fgcolor = 0xffffff;
	.itembgcolor = 0xa0;
	.itemfgcolor = 0xffff00;
	.topbordercolor = 0x80ff;
	.botbordercolor = 0x40;
}

/* Instantiates a PopupMenu */

function pos (x, y)
{
	local p = new (PhPoint);
	p.x = x;
	p.y = y;
	p;
}

function MenuSep (menu)
{
	local		but;

	but = new (PtSeparator);
	but.sep_type = Pt_ETCHED_IN;
	if (menu.botbordercolor)
		but.bot_border_color = menu.botbordercolor;
	if (menu.topbordercolor)
		but.top_border_color = menu.topbordercolor;
	but;
}

method PopupMenu.SetColors (bgcolor, fgcolor, itembgcolor, itemfgcolor,
					   topbordercolor, botbordercolor)
{
	if (bgcolor) .bgcolor = bgcolor;
	if (fgcolor) .fgcolor = fgcolor;
	if (itembgcolor) .itembgcolor = itembgcolor;
	if (itemfgcolor) .itemfgcolor = itemfgcolor;
	if (topbordercolor) .topbordercolor = topbordercolor;
	if (botbordercolor) .botbordercolor = botbordercolor;
}

method PopupMenu.CreateTransient (parent, pos, is_sub)
{
	local		item, button, menu;

	PtSetParentWidget (parent);
	menu = new (PtPopupMenu);
	menu.menu_flags = is_sub ? Pt_MENU_CHILD|Pt_MENU_AUTO : Pt_MENU_TRANSIENT;

	if (.bgcolor)
		menu.fill_color = .bgcolor;
	if (.fgcolor)
		menu.color = .fgcolor;
	if (.topbordercolor)
		menu.top_border_color = .topbordercolor;
	if (.botbordercolor)
		menu.bot_border_color = .botbordercolor;
	if (pos)
		menu.pos = pos;
	if (.title)
		menu.menu_title = .title;
	if (.titlefont)
		menu.menu_title_font = .titlefont;
	if (.itemfont)
		menu.menu_text_font = .itemfont;
	
	with item in .items do
	{
		if (item.name == "-" && !item.action)
			MenuSep (self);
		else
		{
			button = new (PtMenuButton);
			if (.itembgcolor)
				button.fill_color = .itembgcolor;
			if (.itemfgcolor)
				button.color = .itemfgcolor;
			if (.botbordercolor)
				button.bot_border_color = .botbordercolor;
			if (.topbordercolor)
				button.top_border_color = .topbordercolor;
			
			if (item.name)
				button.text_string = item.name;
			if (item.shortcut)
			{
				if (cons_p(item.shortcut))
				{
					button.accel_text = car(item.shortcut);
					button.accel_key = cdr(item.shortcut);
				}
				else
					button.accel_text = item.shortcut;
			}
			if (instance_p (item.action) && class_of(item.action) == PopupMenu)
			{
				button.button_type = Pt_MENU_RIGHT;
				item.action.CreateTransient (button, nil, t);
			}
			else
			{
				if (string_p(func = item.action))
					func = `EmitString (@func, nil);
				PtAttachCallback (button, Pt_CB_ACTIVATE, func);
			}
			PtSetParentWidget (menu);
		}
	}
	menu;
}

method PopupMenu.Instantiate (parent, pos)
{
	local		menu;
//	if (PtPopupMenu.current)
//		PtDestroyWidget (PtPopupMenu.current);
	PtSyncPhoton();
	gc();
	menu = .CreateTransient (parent, pos, nil);
	PtRealizeWidget (menu);
	PtPopupMenu.current = menu;
}

method PopupMenu.AddItem (name, shortcut, action, icon, pos?=nil)
{
	local		item = new (PopupMenuItem), where, i;
	item.name = name;
	item.shortcut = shortcut;
	item.action = action;
	item.icon = icon;

	if (number_p(pos))
		insert (.items, pos, item);
	else if (string_p(pos))
	{
		for (i=length(.items)-1; !where && i>=0; i --)
		{
			if (.items[i].name == pos)
				where = i+1;
		}
		if (where)
			insert (.items, where, item);
		else
			.items[length(.items)] = item;
	}
	else
		.items[length(.items)] = item;
	
	item;
}

method PopupMenu.DelItem (name)
{
	local		item, i;
	
	for (i=length(.items)-1; !item && i>=0; i --)
	{
		if (.items[i].name == name)
			item = delete (.items, i);
	}
	item;
}

function NewPopupMenu (title, titlefont, itemfont, items)
{
	local		menu = new (PopupMenu);
	menu.title = title;
	menu.titlefont = titlefont;
	menu.itemfont = itemfont;
	if (items)
		menu.items = items;
	menu;
}

function MultiPopupMenu (title, titlefont, itemfont, itemspecs...)
{
	local		items = make_array(0), item, menu;

	menu = NewPopupMenu (title, titlefont, itemfont, nil);
	
	for (; itemspecs; )
	{
		item = new (PopupMenuItem);
		menu.AddItem (car(itemspecs), cadr(itemspecs), caddr(itemspecs),
					  car(cdddr(itemspecs)));
		itemspecs = cdr(cdddr(itemspecs));
	}
	menu;
}

method PtPopupMenu.destructor ()
{
	if (self == PtPopupMenu.current)
		PtPopupMenu.current = nil;
}
