;;;
;;; Function to generate simple profile printout
;;;

(defun has_calls (f)
  (and (function_p f) (> (function_calls f) 0))
  )

(defun sort_by_time (f g)
  (let ((n (- (function_runtime (eval f)) (function_runtime (eval g)))))
    (* n 1000)))

(defun profiled_functions ()
  (let (fns fn)
    (setq fns (sort (apropos "*" has_calls) sort_by_time))
    (princ (format "%25s  %8s  %s\n" "Function" "Calls" "Total Time"))
    (for i in fns do
	 (setq fn (eval i))
	 (princ (format "%25s  %8d  %g\n"
			(string i) (function_calls fn) (function_runtime fn)))
	 )
    )
  )
