(signal SIGCHLD '(child_died))

(defvar ChildDead nil)

(defun child_died ()
  (let ((pid (wait)))
    ;; (princ "Child died: " pid "\n")
    (setq ChildDead t)))

(defun capture (cmd &rest &optional (args nil))
  (setq ChildDead nil)
  (let ((fds (funcall pty (cons cmd args))) answer)
    (sleep 1)
    (setq fds (cdr fds))
    (unwind_protect
	(let (line)
	  (while (and (or (not ChildDead)
			  (> (chars_waiting (cadr fds)) 0))
		      (not (eq (setq line (read_line (cadr fds))) _eof_)))
	    (setq answer (cons line answer)))
	  )
      (progn
	(close (car fds))
	(close (cadr fds))
	(close (caddr fds)))
      )
    (reverse answer)
    )
  )
