require ("dialog");

dialog_datahub_file := "datahub.wgtw";
dialog_datahub := nil;

class DataHubDialog Dialog
{
	testpoints;
	test_timer;
  static:
	current;
}

PhabAttachWidgets (DataHubDialog, dialog_datahub_file);

method DataHubDialog.destructor ()
{
	.current = nil;
	remove_hook (#taskstarted_hook, #DataHubDialog_taskstarted);
	remove_hook (#taskdied_hook, #DataHubDialog_taskdied);
	if (.test_timer)
		cancel (.test_timer);
}

function _ivar_filter(!x...?)
{
	nil;
}

method DataHubDialog.killme ()
{
	destroy(.datahub);
}

method DataHubDialog.constructor ()
{
	local		names;

	PtSetParentWidget (nil);
	
	.PhabInstantiate(t);
	.current = self;
	PtAttachCallback (.BDH_Done, Pt_CB_ACTIVATE, `(@self).killme());
	PtAttachCallback (.BDH_Kill, Pt_CB_ACTIVATE, `(@self).StopSelected());
	PtAttachCallback (.BDH_View, Pt_CB_ACTIVATE, `(@self).ViewSelected());
	PtAttachCallback (.BDH_Test, Pt_CB_ACTIVATE, `(@self).TestSelected());
	PtAttachCallback (.BDH_Stop, Pt_CB_ACTIVATE, `(@self).StopTestSelected());
	PtAttachCallback (.BDH_Start, Pt_CB_ACTIVATE, `(@self).StartNamed());

	/* Fill the list with known datahubs */

	with x in window_main.running_tasks do
	{
		if (substr(x.name, 0, 4) == "/dh/")
		{
			names = cons (x.name, names);
		}
	}

	.DH_List.items = names;

	add_hook (#taskstarted_hook, #DataHubDialog_taskstarted);
	add_hook (#taskdied_hook, #DataHubDialog_taskdied);

	PtAttachCallback (.datahub, Pt_CB_DESTROYED,
					  `progn { if (!destroyed_p(@self)) destroy(@self); });
}

method DataHubDialog.StartNamed()
{
	local		name = .DH_Name.text_string;

	if (strlen(name) <= 11)
	{
		if (name == "")
			name = "default";
		system (string ("datahub -d ", name));
	}
}

method DataHubDialog.StopSelected()
{
	local		items = .DH_List.selection_indexes;
	local		name, tsk;

	if (length(items) > 0)
	{
		with item in items do
		{
			name = .DH_List.items[item-1];
			tsk = locate_task (name, nil);
			if (tsk)
			{
				send (tsk, #exit(0));
				close_task (tsk);
			}
			else
			{
				princ ("Task ", name, " no longer exists\n");
			}
		}
	}
}

method DataHubDialog.ViewSelected()
{
	local		items = .DH_List.selection_indexes;
	local		name, tsk;

	if (length(items) > 0)
	{
		with item in items do
		{
			name = .DH_List.items[item-1];
			system (string ("phdhview -d ", substr(name, 4, -1), "&"));
		}
	}
}

method DataHubDialog.TestSelected()
{
	local		items = .DH_List.selection_indexes;
	local		name, tsk, viewer;

	if (length(items) > 0)
	{
		with item in items do
		{
			name = substr (.DH_List.items[item-1], 4, -1);
			if (!find (symbol(string(name,":test1")), .testpoints))
			{
				.testpoints = cons (symbol(string(name,":test1")),.testpoints);
				.testpoints = cons (symbol(string(name,":test2")),.testpoints);
				.testpoints = cons (symbol(string(name,":test3")),.testpoints);
			}

			viewer = nil;
			with x in window_main.running_tasks do
			{
				if (substr(x.name, 0, 6) == "dhview" && x.domain == name)
					viewer = x;
			}
			if (!viewer)
			{
				system (string ("phdhview -d ", name, "&"));
			}
		}
	}
	.TriggerTests();
}

method DataHubDialog.StopTestSelected()
{
	local		items = .DH_List.selection_indexes;
	local		name, tsk;

	if (length(items) > 0)
	{
		with item in items do
		{
			name = substr (.DH_List.items[item-1], 4, -1);
			.testpoints = remove (symbol(string(name,":test1")), .testpoints);
			.testpoints = remove (symbol(string(name,":test2")), .testpoints);
			.testpoints = remove (symbol(string(name,":test3")), .testpoints);
		}
	}
	.TriggerTests();
}

method DataHubDialog.TriggerTests()
{
	if (.testpoints)
	{
		if (!.test_timer)
			.test_timer = every (0.05, `(@self).TestPoints());
	}
	else if (.test_timer)
	{
		cancel (.test_timer);
		.test_timer = nil;
	}
}

method DataHubDialog.TestPoints ()
{
	with x in .testpoints do
	{
		write_point (x, floor (random() * 101));
	}
}

function DataHubDialog_taskstarted (name, others...)
{
	local		dialog, items;

	if (substr(name, 0, 4) == "/dh/")
	{
		dialog = DataHubDialog.current;
		items = dialog.DH_List.items;
		items[length(items)] = name;
		dialog.DH_List.items = items;
	}
}

function DataHubDialog_taskdied (name, others...)
{
	local		dialog, items;
	
	if (substr(name, 0, 4) == "/dh/")
	{
		dialog = DataHubDialog.current;
		items = array_to_list(dialog.DH_List.items);
		items = remove (name, items, t);
		dialog.DH_List.items = list_to_array(items);
	}
}

function OpenDataHubDialog()
{
	if (access ("/usr/cogent/bin/datahub", 0) != 0)
	{
		msg = new (PtMessage);
		msg.msg_text =
			string ("The Cascade DataHub is not installed on your\n",
					"system.  Please install the Cascade DataHub\n",
					"repository and try this demonstration again.\n");
		PtAttachCallback (msg, Pt_CB_MSG_BUTTON1, `destroy(@msg));
		PtRealizeWidget (msg);
		nil;
	}
	else
	{
		if (!DataHubDialog.current)
			new (DataHubDialog);
		else
			PtWidgetToFront (DataHubDialog.current.datahub);
		DataHubDialog.current;
	}
}

method DataHubDialog.Execute()
{
	(..(Dialog.Execute))(.datahub);
}
