require ("mainwindow");

function start_support ()
{
	local		count;
	
	if (access ("/dev/qserve", 0) != 0)
	{
		system ("qserve");
		count = 0;
		princ ("Starting qserve ...\n");
		system ("slay -Q nserve");
		while (access ("/dev/qserve", 0) != 0 && ++count < 10)
			nanosleep (0, 100000000);
	}
	if (access ("/dev/nserve", 0) != 0)
	{
		system ("nserve");
		count = 0;
		princ ("Starting nserve ...\n");
		while (access ("/dev/nserve", 0) != 0 && ++count < 10)
			nanosleep (0, 100000000);
	}
}

function check_support ()
{
	if (access ("/dev/qserve", 0) != 0 ||
		access ("/dev/nserve", 0) != 0)
	{
		msg = new (PtMessage);
		if (access ("/usr/cogent/bin/qserve", 0) != 0 ||
			access ("/usr/cogent/bin/qserve", 0) != 0)
			msg.msg_text = string ("Could not start qserve and nserve.\n",
								   "They do not appear to be installed in /usr/cogent/bin",
								   "Please install all of the Cogent packages.");
		else if (strstr (getenv ("PATH"), "/usr/local/bin") == -1 &&
				 strstr (getenv ("PATH"), "/usr/cogent/bin") == -1)
			msg.msg_text = string ("Could not start qserve and nserve.\n",
								   "Please ensure that /usr/local/bin or /usr/cogent/bin\n",
								   "are in your PATH by placing a line like\n",
								   "'PATH=$PATH:/usr/local/bin' in the file /etc/profile,\n",
								   "then log out and log back in for it to take effect.");
		
		else
			msg.msg_text = string ("Could not start qserve and nserve.\n",
								   "These are needed to run the Cogent tools.\n",
								   "They appear to be installed, and your PATH is set\n",
								   "correctly.  Please contact Cogent at support@cogent.ca\n",
								   "and we will assist you.");
		PtAttachCallback (msg, Pt_CB_MSG_BUTTON1, #exit_program(-1));
		PtAttachCallback (msg, Pt_CB_DESTROYED, #exit_program(-1));
		PtRealizeWidget (msg);
		PtMainLoop();
	}
}

function main ()
{
	local		msg;

	start_support ();

	if (access ("/dev/nserve", 0) == 0)
	{
		init_ipc ("gammaintro", "gammaintro");
	}
	else
	{
		princ ("Could not register the name 'gammaintro'\n");
	}
	
	PtInit (nil);

	check_support();

	window_main = new (MainWindow);
	window_main.WatchTasks();
	
	PtRealizeWidget (window_main.gammaintro);

	PtMainLoop();
}
