DataHubDescription =
"The Cascade DataHub is a collector and distributor of information allowing multiple applications to share a common data set.  An application may start or stop at any time without affecting the others.  Since one application does not need to know what the ultimate producers and consumers of the data are, it is possible to replace individual applications with simulators or special-purpose simulacra without modifying any other application in the system.

Some common uses for the Cascade DataHub:
- Many-to-many data sharing among cooperating tasks:
      This is typical of process control applications.
- One-to-many event triggering:
      A single data change can trigger activity in many
      other applications.
- Live registry:
      The Cascade DataHub can be used like a \"registry\",
      where programs can share common configuration information.
      Changes in information are immediately transmitted to all
      interested applications.
- Distributed applications:
      The Cascade DataHub is network-aware, using the native
      QNX networking protocol.  Applications anywhere on the
      network can share data seamlessly.

The Cascade DataHub uses a publish/subscribe model, where any application can be a publisher and any number of applications can be subscribers.  Whenever a data value changes, all subscribers are instantly notified of that change.  The Cascade DataHub even takes care of subscribers with different processing and transmission speeds to ensure that fast subscribers are not affected by slower ones (such as applications operating through a network link).  Processes never need to poll the Cascade DataHub, so if there is no data activity in your system, there is no CPU usage.

Programs written for the Cascade DataHub are source-code compatible across QNX6, Linux and QNX4.
";

LoggerDescription =
"The Cascade Text Logger is designed to maintain a log of data value changes in the Cascade DataHub, in a user-specified ASCII format.  This is normally useful when collecting logs that will be imported by other programs, such as Excel, where the import format is already specified.  The Cascade Text Logger is also useful when the output should be immediately human-readable.

In a typical control or embedded system, data events occur asynchronously, so that related information may occur at slightly different times.  The Cascade Text Logger is able to collect data that is related in time into a single output record.  This makes it possible to generate tables of information from an asynchronous data stream.  If a particular value in a record is unavailable, the you can select how the Cascade Text Logger fills in the missing value.

The Cascade Text Logger is available for QNX6, Linux and QNX4.
";

HistorianDescription =
"The Cascade Historian maintains a time histories of data value changes in the Cascade DataHub.  The data is stored in an efficient binary representation that supports quick searching and querying through the included C API, including:
  - Y vs. Time
  - Y vs. X
  - time-interval interpolated Y vs. Time
  - time-interval interpolated Y vs. X

The Cascade Historian stores its data in one or more files per data point, allowing for easy backup and cleanup operations.

The Cascade Historian is available for QNX6, Linux and QNX4.
";

WelcomeDescription =
"Welcome to the Cogent Cascade Toolset, the fastest way to create control and embedded systems for QNX6, Linux and QNX4.

This program is a graphical introduction to the Cascade Toolset.  From here you can read about Cogent's tools, and launch demonstration programs as we make them available.

This program is written entirely in Gamma, Cogent's Photon capable scripting language.  All windows were created using the Photon Application Builder. Please feel free to add to this program.  You can find the source code in /usr/cogent/src/cogentintro.  If you make a change that you would like to see included, please send it via email to support@cogent.ca.

If you would like to know more about Cogent's tools, please visit http://www.cogent.ca, or send us an e-mail at info@cogent.ca.
";

ConnectDescription =
"Cascade Connect is the simplest way to transmit your real-time data between your control or embedded application and MS-Windows.  It acts as a portal between the native QNX messaging system and Windows DDE, giving virtually any Windows task access to your data.  There is no programming at all in MS-Windows.  If you are using the Cascade DataHub, then there is also no programming in QNX or Linux.

Cascade Connect uses TCP/IP as its intermediate communication protocol, so you can run your Windows application across your corporate LAN, or even across the Internet.  Cascade Connect is perfect for remote access to your control system, or for those who prefer to combine the stability of a POSIX operating system for control with a Microsoft operating system for compatibility.

Cascade Connect is available for QNX6, Linux and QNX4.
";

NserveDescription =
"The Cascade Name Server is a utility that keeps track of application name and connection information, allowing processes on a network to locate and connect to one another. In QNX6, this is a unique facility that vastly simplifies the problem of applications locating one another throughout the local network.

In addition to simply storing task names, the Cascade Name Server generates asynchronous messages to all named tasks whenever another task starts or stops, anywhere on the network.  With this facility, it is trivial to create applications with up-to-the-instance awareness of the execution state of all other participating tasks.

The Cascade Name Server is available for QNX6, Linux (non-networked only) and QNX4.
";

GammaDescription =
"Gamma is Cogent's flagship programming language used to simplify control and embedded system development.  Gamma offers a number of special features designed specifically for real-time environments, such as:
   - a unified event model
   - unlimited timers
   - Cascade DataHub support
   - Photon and GTK support
   - active values
   - hot-replaceable code
 Gamma supports hot-replaceable code, so you can modify your running application without ever shutting it down.

Gamma's engine is based on a dialect of LISP with object-oriented extensions.  This makes the execution engine very small and quick, while still including important features such as garbage collection and dynamic storage types.  At the same time, Gamma's syntax is very similar to C and C++, making it possible for most programmers to become quickly profient.  The LISP heritage of Gamma allows you to easily write code that writes code, a very useful feature in dynamic systems, and something that is clumsy or impossible in most programming languages.

Gamma contains over 400 built-in functions, and includes an extension facility for dynamically adding compiled C functions through shared libraries.  In fact, the entire Photon and GTK support are provided as separate shared libraries.

All of Cogent's tools contain a trivial LISP interface, allowing Gamma to transmit configuration and commands to any other Cogent tool.  Gamma can thus be used as a scripting tool for automating your entire system.  The Cogent API includes facilities to ensure that your application is also scriptable with Gamma.

Gamma is available for QNX6, Linux and QNX4.
";

HelpDescription =
"Cogent's tools are fully documented using the QNX Helpviewer.  Please open up the Helpviewer application and look for the Cogent Documentation tab.  The latest version of our documentation is also on-line at www.cogent.ca.

If you would like to get the latest version of any of Cogent's tools, you can add the repository http://developers.cogentrts.com/repository to your package installer.

Cogent's tools are free for non-commercial use.  If you would like to purchase commercial licenses, please contact Cogent at 1-888-628-2028 or 905-702-7851, or by email at info@cogent.ca.
";
