require_lisp ("PhabTemplate");
require ("datahub");
require ("helptext");

window_main_file := "gammaintro.wgtw";
window_main := nil;

class Task
{
	name;
	domain;
	qname;
	nidname;
	pid;
	chid;
}

class MainWindow
{
	running_tasks;
}

PhabAttachWidgets (MainWindow, window_main_file);

method MainWindow.constructor ()
{
	.PhabInstantiate(t);

	PtAttachCallback (.gammaintro, Pt_CB_RAW,
					  #progn { if (event_data.window_event.event_f == Ph_WM_CLOSE)
								exit_program(0); },
					  Ph_EV_WM);
	
	PtAttachCallback (.B_Exit, Pt_CB_ACTIVATE, #exit_program(0));
	PtAttachCallback (.B_DataHub, Pt_CB_ACTIVATE,
					  #window_main.StartDataHub ());
	PtAttachCallback (.B_Help, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (HelpDescription));

	PtAttachCallback (.I_Welcome, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (WelcomeDescription));
	PtAttachCallback (.I_DataHub, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (DataHubDescription));
	PtAttachCallback (.I_Historian, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (HistorianDescription));
	PtAttachCallback (.I_Logger, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (LoggerDescription));
	PtAttachCallback (.I_Nserve, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (NserveDescription));
	PtAttachCallback (.I_Connect, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (ConnectDescription));
	PtAttachCallback (.I_Gamma, Pt_CB_ACTIVATE,
					  `(@self).WriteInformation (GammaDescription));

	.WriteInformation (WelcomeDescription);
}

method MainWindow.destructor ()
{
	exit_program(0);
}

method MainWindow.WriteInformation (str)
{
	.MT_Instructions.text_string = str;
}

function nserve_names ()
{
	local		flist, dirlist, result, dir;

	dirlist = list ("/dev/nserve");
	while (dirlist)
	{
		dir = car(dirlist);
		dirlist = cdr(dirlist);
		
		flist = directory (dir, 1, t);
		with i in flist flist=tcollect
			shell_match (i, ".*") || shell_match (i, "*/.*") ||
			shell_match (i, "/dev/nserve/ns/*") ? nil : i;
		result = nappend (result, flist);
		dirlist = nappend (dirlist, directory (dir, 2, t));
	}
	result;
}

method MainWindow.WatchTasks ()
{
	local		flist, fptr;
	
	add_hook (#taskstarted_hook, #TaskStarted);
	add_hook (#taskdied_hook, #TaskDied);

	/* Find all currently running tasks */

	flist = nserve_names();

	with name in flist do
	{
		fptr = open (name, "r", nil);
		line = read (fptr);
		close (fptr);
		eval (cons (#TaskStarted, line));
	}
}

method MainWindow.StartDataHub ()
{
	local		dialog;

	.WriteInformation (DataHubDescription);
	
	dialog = OpenDataHubDialog();
	if (dialog)
		dialog.Execute ();
}

function TaskStarted (name, domain, queue, nidname, nid, pid, chid)
{
	local		task;
	
	task = new (Task);
	task.name = name;
	task.domain = domain;
	task.qname = queue;
	task.nidname = nidname;
	task.pid = pid;
	task.chid = chid;

	window_main.AddApplication (task);
}

function TaskDied (name, domain, queue, nidname, nid, pid, chid)
{
	window_main.RemoveApplication (name);
}

method MainWindow.AddApplication (task)
{
	.running_tasks = cons (task, .running_tasks);
}

method MainWindow.RemoveApplication (name)
{
	local		found;

	with x in .running_tasks do
	{
		if (x.name == name)
			found = x;
	}
	.running_tasks = remove (found, .running_tasks);
}
