#!/usr/cogent/bin/phgamma

/*
 * This example demonstrates how to create a Photon application in Gamma.
 * Since the Photon widget set is mapped as OOP classes in Gamma, any
 * Photon widget can be created using the 'new' function and then
 * manipulated by simply modifying its instance variables.
 * 
 * This file is best viewed with a tab width of 4.
 */
 
/*
 * Load some Photon Widget convenience functions.  As with the Usage
 * library in example01, we can load canned function and method
 * definitions to make our job easier.  In this case, we are loading
 * support for the SetDim and SetPos functions which we use later.
 */
require_lisp("PhotonWidgets");

/*
 * Initiate the graphics session with the Photon window manager.  This
 * must always be done before any Photon call can be made.
 */
PtInit(nil);

/*
 * Create a new instance of a PtWindow object.  You can look up PtWindow
 * in the online help for Photon.  Gamma uses the same resources and
 * constants, except that resource names are in lower case, and have the
 * Pt_ARG_ prefix removed.  All constants are named identically to the
 * ones named in the Photon documentation.
 */
window = new(PtWindow);

/*
 * Set the width and height of the window
 */
window.SetDim (220,100);

/*
 * Create a PtLabel Widget and set resources
 */
label = new(PtLabel);
label.SetPos(10,35);
label.text_string = "My First Gamma Photon Application";

/*
 * Realize the widget on the screen.  A widget is not visible until it
 * has been explicitly realized, or until its container is realized.
 */
PtRealizeWidget(window);

/*
 * Start an infinite event loop to handle Photon events
 */
PtMainLoop();
