#!/usr/cogent/bin/phgamma

/*
 * This example shows the minimal program required to create a Photon
 * application using Gamma and a window created in PhAB.  PhAB creates a
 * file with a .wgtw extension which Gamma can read and display.  Widget
 * names in PhAB are mapped to Gamma global variables for easy access.
 * Creating windows using PhAB gives you all of the advantages of using a
 * graphical editor to quickly create your user interface, while still
 * using Gamma to create the application code in a fraction of the time
 * required for the same C functionality.
 * 
 * This file is best viewed with a tab width of 4.
 */

/*
 * Include support for loading windows created in PhAB.  This file defines
 * the function 'PhabLoad', which loads PhAB files of the Window and Dialog
 * types.  These are files with the extension .wgtw and .wgtd.
 */
require_lisp("PhabTemplate");

/*
 * initiate the graphics session with the Photon window manager
 */
PtInit(nil);

/*
 * Load and convert the window created in PhAB using the PhabLoad function.
 * Wload returns the entire window definition (the window plus all
 * child widgets) in a tree format.  The first widget in the tree is
 * always the root PtWindow from the file.  We can extract this window
 * as the first element (car) of the returned list.
 */
win = car(PhabLoad("wgt/example07.wgtw"));

/*
 * Start an infinite event loop to handle Photon events
 */
PtMainLoop();
