/*--------------------------------------------------------------------
 * File:        gtkcontrol.g
 *
 * Description: This program displays a window with buttons that start
 *              the PID Emulator, Monitor, DataHub Viewer, Log, and
 *              History.  It has text windows to display information
 *              about programs in the demo and their process status.
 *
 * Functions:
 *                control_button
 *                create_control_win
 *                main
 *------------------------------------------------------------------*/

/* Access common functions. */
require("lib/common.g");

/*--------------------------------------------------------------------
 * Function:    control_button
 * Returns:     A GtkToggleButton
 * Description: Builds control buttons.
 *------------------------------------------------------------------*/
function control_button(lbl, color, prog, process_name, arg1,
                        arg2, arg3, container, wgt, msg)
{
  local button;
  button = new(GtkToggleButton);
  button.label = lbl;
  button.set_color(1, GTK_STATE_NORMAL, color);
  button.set_color(1, GTK_STATE_PRELIGHT, (color + 0x111111));
  button.set_color(1, GTK_STATE_ACTIVE, (color - 0x111111));
  container.pack_start(button, TRUE, TRUE, 0);
  button.signal("toggled", `start_stop(@button, @prog, @process_name,
                                       @arg1, @arg2, @arg3));
  button.signal("enter", `anygui_show_text(@wgt, read_msg(@msg), 1));
  button.signal("leave", `anygui_show_text(@wgt, read_msg("1"), 1));
  button.show();
  button;
}

/*--------------------------------------------------------------------
 * Function:    create_control_win
 * Returns:     A GtkWindow
 * Description: Creates the Controller window.
 *------------------------------------------------------------------*/
function create_control_win()
{
  local control_win, title, frame, box1, box2;
  local pbut, mbut, dbut, xbut;
  
  control_win = new (GtkWindow);
  control_win.signal ("destroy", #control_win = nil);
  control_win.title = "Cogent Tools Demo: Controller";
  control_win.set_color(1, GTK_STATE_NORMAL, 0xdddddd);
  control_win.set_uposition(20, 20);
  control_win.border_width = 10;
  box1 = new(GtkVBox);
  title = new (GtkLabel);
  title.set_text("Cogent Tools Demo - Controller");
  title.set_color(1, GTK_STATE_NORMAL, 0xff0000);
  title.height = 25;

  frame = new(GtkFrame);
  frame.set_color(1, GTK_STATE_NORMAL, 0xff0000);
  frame.add(title);
  frame.border_width = 5;
  box1.pack_start(frame, TRUE, TRUE, 5);
  control_win.add (box1);
  box2 = new(GtkHBox);
  box1.pack_start(box2, TRUE, TRUE, 0);
  box2.show();

  box3 = new (GtkVButtonBox);
  box2.pack_start(box3, TRUE, TRUE, 0);
  box3.border_width = 5;
  box3.show();

  text = new(GtkText);
  text.set_editable(FALSE);
  text.width = 200;
  text.height = 250;
  text.set_word_wrap(TRUE);
  anygui_show_text(text, read_msg("1"), 1);

  text2 = new(GtkText);
  text2.set_editable(FALSE);
  text2.height = 130;
  text2.set_word_wrap(TRUE);
  show_names(text2);

  pbut = control_button("PID\nEmulator", 0xbbeecc, "gamma", "emul",
                        "emul.g", nil, nil, box3, text, "2");
  mbut = control_button("Monitor", 0xbbeecc, "gamma", "monitor",
                        "gtkmonitor.g", nil, nil, box3, text, "3");
  dbut = control_button("DataHub\nViewer", 0xeecc99, "xdhview",
                        "pidviewer", "-d", "toolsdemo", nil, box3,
                        text, "4");
  lbut = control_button("Log", 0xbbeecc, "gamma", "log",
                        "gtklog.g", nil, nil, box3, text, "5");
  hbut = control_button("History", 0xbbeecc, "gamma", "history",
                        "gtkhistory.g", nil, nil, box3, text, "6");

  hbut = new(GtkButton);
  hbut.label = "Help";
  hbut.signal("clicked", `anyos_help());
  box3.pack_start (hbut, TRUE, TRUE, 0);
  hbut.show();

  xbut = new(GtkButton);
  xbut.label = "Exit";
  xbut.signal("clicked", `(@control_win).destroy());
  box3.pack_start (xbut, TRUE, TRUE, 0);
  xbut.show();

  box2.pack_start(text, TRUE, TRUE, 5);  

  box2 = new(GtkVBox);
  box2.border_width = 5;
  box1.pack_start(box2, TRUE, TRUE, 0);

  box3 = new(GtkHBox);
  box3.border_width = 5;
  box2.pack_start(box3, TRUE, TRUE, 0);

  label = new(GtkLabel);
  label.set_text("                Process Status                ");
  box3.pack_start(label, TRUE, TRUE, 0);

  rawbut = new(GtkToggleButton);
  rawbut.label = "Raw names";
  rawbut.signal("toggled", `toggle_raw(@rawbut, @text2));
  box3.pack_start (rawbut, TRUE, TRUE, 0);
  box2.pack_start(text2, TRUE, TRUE, 0);

  control_win.show_all();
  control_win.reposition(5,5);
  control_win;
}

/*--------------------------------------------------------------------
 * Function:    main
 * Returns:     doesn't return
 * Description: Calls the common.g program_startup() function and loops.
 *------------------------------------------------------------------*/
function main()
{
  program_startup("control", "controlq", #create_control_win(), "1");
  
  atexit(#stop_processes());

  /* Loop forever handling events. */
  gtk_main ();
}

