/*
 * Introduction program for the Cogent Tool Suite
 */

require_lisp ("PhotonWidgets");
require_lisp ("ImageProc");

ImageDir := "intro/img";

function main ()
{
	local		window;
	local		background;
	local		xpos = nil, ypos = 80, yadd = 40;

	set_cwd();
	
	PtInit (nil);
	
	window = new (PtWindow);
	window.title = "Cogent Tools Demo";
	window.render_flags = cons (0, 0xffffffff);
	window.fill_color = 0xffffff;
	
	background = loadimage ("QNX6_background_10.gif");
	background.fill_color = 0xffffff;

	new GButton ("Icon_1", xpos, ypos, `show_intro(@window));
	new GButton ("Icon_2", xpos, ypos += yadd, #run_demo());
	new GButton ("Icon_3", xpos, ypos += yadd, #helpviewer("Cogent Tools Demo and Tutorial"));
	new GButton ("Icon_5", xpos, ypos += yadd, #helpviewer(""));
	new GButton ("Icon_4", xpos, ypos += yadd, #visit_cogent());
	new GButton ("Icon_6", xpos, ypos += yadd * 2, #exit_program(0));

	PtExtentWidgetFamily (window);
	window.Center();
	PtRealizeWidget (window);

	PtMainLoop();
}

/* Add a method to PtWindow to center on the current screen */

method PtWindow.Center (xoff?=0, yoff?=0)
{
	local		rect;
	
	rect = PhWindowQueryVisible (0, 0, 0);
	.SetPos ((rect.lr.x - rect.ul.x) / 2 - .dim.w / 2 + rect.ul.x + xoff,
			 (rect.lr.y - rect.ul.y) / 2 - .dim.h / 2 + rect.ul.y + yoff);
}

/* Force the current working directory to be the directory from which
   we loaded this file. */

function set_cwd ()
{
	local		cwd;

	cwd = dirname (car(argv));
	if (cwd == car(argv))
		cwd = ".";
	cd (cwd);
}

function helpviewer (pagename)
{
	if (access ("/usr/help/product/cogent-set", 0) == 0 &&
		access ("/usr/cogent/help/cogent-set", 0) == 0)
	{
		PxHelpTopicRoot ("/Cogent Documentation");
		PxHelpTopic (pagename);
	}
	else
	{
		local	msg = new PtWindow();
		local	lab = new PtLabel();
		local	but = new PtButton();
		lab.text_string = "Please install the Cogent Help package\nin order to see this documentation.";
		but.text_string = "Close";
		PtAttachCallback (but, Pt_CB_ACTIVATE, `PtDestroyWidget(@msg));
		msg.title = "Help Not Installed";
		PtExtentWidgetFamily (msg);
		msg.Center();
		but.SetPos ((msg.dim.w - but.dim.w) / 2, lab.dim.h + lab.pos.y + 5);
		PtRealizeWidget (msg);
	}
}

function visit_cogent ()
{
	system ("voyager -u http://www.cogent.ca &");
}

function run_demo ()
{
	system ("PATH=$PATH:/usr/cogent/bin gamma demo &");
}

function show_intro (parent)
{
	local		w, closebutton;
	
	PtSetParentWidget (parent);
	w = new (PtWindow);
	w.render_flags = cons (0,0xffffffff);
	image = loadimage ("QNX6_intro_1.gif");
	closebutton = new GButton ("Icon_8", 0, 0, `destroy(@w));
	PtExtentWidgetFamily (w);
	closebutton.SetPos ((w.dim.w - closebutton.dim.w) / 2,
						(w.dim.h - closebutton.dim.h - 10));
	w.Center(0, 20);
	PtRealizeWidget (w);
	PtSetParentWidget (nil);
}

function loadimage (filename)
{
	local		image = PxLoadImage (string (ImageDir, "/", filename));
	local		label = ImageToLabel (image);
	label;
}

/* Specialize the PtButton class to hold some extra data, and to allow
   us to do three-phase button behaviour (mouse down, up, rollover) */

class GButton PtButton
{
	off_image;
	on_image;
	click_image;
}

method GButton.constructor (filename, x, y, code)
{
	.off_image = PxLoadImage (string (ImageDir, "/",
									  filename, "_off.gif"));
	.on_image = PxLoadImage (string (ImageDir, "/",
									 filename, "_on.gif"));
	.click_image = PxLoadImage (string (ImageDir, "/",
										filename, "_click.gif"));

	.flags = cons (Pt_GETS_FOCUS | Pt_FOCUS_RENDER | Pt_HIGHLIGHTED, nil);
	.label_flags = cons (Pt_LABEL_SELECT_SHIFT, nil);
	.label_type = Pt_IMAGE;
	.border_width = .margin_height = .margin_width = 0;
	.label_data = .off_image;
	.arm_image = .click_image;
	
	if (x == nil)
	{
		PtExtentWidgetFamily (PtWidgetParent(self));
		x = (PtWidgetParent(self).dim.w - .dim.w) / 2;
	}
	.SetPos (x, y);

	PtAttachCallback (self, Pt_CB_RAW, `(@self).RollOver(),
					  Ph_EV_BOUNDARY);
	PtAttachCallback (self, Pt_CB_ACTIVATE, code);
}

method GButton.RollOver()
{
	if (cbinfo.event.subtype == Ph_EV_PTR_ENTER)
		.label_data = .on_image;
	else if (cbinfo.event.subtype == Ph_EV_PTR_LEAVE)
		.label_data = .off_image;
}
