/*--------------------------------------------------------------------
 * File:        gtk.g
 *
 * Description: Functions that run only in GTK.
 *
 * Functions:
 *                GtkButton.switched_on
 *                button_messages
 *                anygui_show_text
 *                anygui_sigchild
 *                anygui_destroyer
 *                anygui_move_window
 *                anygui_makemsg
 *------------------------------------------------------------------*/


/* Define constants and fonts for Gamma.*/
TRUE := 1;
FALSE := 0;

FONT1 = "-adobe-new century schoolbook-medium-r-normal-*-*-120-*-*-p-*-iso8859-1";
FONT2 = "-misc-fixed-medium-r-semicondensed-*-*-120-*-*-c-*-koi8-r";
FONT3 = "-adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*";

/*--------------------------------------------------------------------
 * Function:    GtkButton.switched_on
 * Returns:     t or nil
 * Description: Creates common method to check Gtk and Photon buttons's 
 *              toggled status.
 *------------------------------------------------------------------*/
method GtkButton.switched_on()
{
  if (.get_active() == TRUE)
    t;
  else
    nil;
}

/*--------------------------------------------------------------------
 * Function:    button_messages
 * Returns:     t or nil
 * Description: Calls send_message() for 3 button callbacks.  This
 *              function is used only in GTK-specific code, so there is
 *              no Photon counterpart. The "clicked" callback is only
 *              strictly necessary for the radio buttons in the Monitor.
 *------------------------------------------------------------------*/
function button_messages (button, msg1, msg2)
{
  button.signal("enter", `send_message(@msg1));
  button.signal("clicked", `send_message(@msg1));
  button.signal("leave", `send_message(@msg2));
}

/*--------------------------------------------------------------------
 * Function:    anygui_show_text
 * Returns:     t or nil
 * Description: Displays a message string in a text widget.  The fnt
 *              argument is only used in the GTK version of this
 *              function, and is ignored by the Photon version.
 *------------------------------------------------------------------*/
function anygui_show_text(wgt, str, fnt)
{
  local font;
  switch (fnt)
    {
    case 1: font = gdk_font_load (FONT1);
    case 2: font = gdk_font_load (FONT2);
    case 3: font = gdk_font_load (FONT3);
    }
  wgt.delete_text(0, -1);
  wgt.insert(font, nil, nil, str, -1);
}

/*--------------------------------------------------------------------
 * Function:    anygui_sigchild
 * Returns:     t or nil
 * Description: Pops out a button when the corresponding child dies.
 *------------------------------------------------------------------*/
function anygui_sigchild ()
{
  child_died(#button.set_active(FALSE));
}

/*--------------------------------------------------------------------
 * Function:    anygui_destroyer
 * Returns:     t or nil
 * Description: Tells a program to exit when a widget (generally its
 *              main window) gets destroyed.
 *------------------------------------------------------------------*/
function anygui_destroyer(wgt)
{
  wgt.signal ("destroy", #exit_program(0));
}

/*--------------------------------------------------------------------
 * Function:    anygui_move_window
 * Returns:     t or nil
 * Description: Moves the History or Log window to the left when the 
 *              Plot button is pressed to allow space to show the plot.
 *------------------------------------------------------------------*/
function anygui_move_window(button, window, old_x, old_y, new_x, new_y)
{
  if(instance_p(window))
    {
      if (button.switched_on())
        window.reposition(new_x, new_y);
      else
        window.reposition(old_x, old_y);
    }
}


/*--------------------------------------------------------------------
 * Function:    anyos_change_settings
 * Application: Monitor
 * Returns:     t or nil
 * Description: Changes PID settings in the Monitor, and optionally
 *              unclicks the Auto button if it is on.
 *------------------------------------------------------------------*/
function anyos_change_settings(button, auto, sp1, v1, sp2, v2, sp3, v3, sp4,
                               v4, sp5, v5, sp6, v6, msgno, autobutton?)
{
  if (button.get_active() == TRUE)
    {
      if (auto == nil)
        {
          if (AUTO_001 != 0)
            autobutton.clicked();
        }
      else
        sp1.set_value(v1);
      sp2.set_value(v2);
      sp3.set_value(v3);
      sp4.set_value(v4);
      sp5.set_value(v5);
      sp6.set_value(v6);
    }
}

/*--------------------------------------------------------------------
 * Function:    anygui_makemsg
 * Returns:     t or nil
 * Description: Creates and displays a message window.
 *------------------------------------------------------------------*/
function anygui_makemsg(msg)
{
  if ((undefined_p(win_dialog)) || (win_dialog == nil))
    {
      local vbox, vboxchildren, separator, action_area, button, label;
      
      win_dialog = new (GtkDialog);
      win_dialog.signal ("destroy", #win_dialog = nil);
      win_dialog.set_usize(550, 170);
      win_dialog.set_title("Advisory");
      
      vbox = car(win_dialog.children());
      separator = car(vbox.children());
      action_area = cadr(vbox.children());
      
      button = new(GtkButton);
      button.label = "OK";
      button.width = 70;
      button.can_default = TRUE;
      button.signal("clicked", `(@win_dialog).destroy());
      action_area.pack_start(button, FALSE, FALSE, 0);
      button.grab_default();
      button.show();
      
      lbl = new(GtkLabel);
      lbl.set_text(msg);
      lbl.set_padding(10, 10);
      vbox.pack_start(lbl, TRUE, TRUE, 0);
      lbl.show();
      
      win_dialog.show();
      win_dialog;
    }
  else
      if(instance_p(win_dialog))
        win_dialog.destroy();
}

princ("GUI is GTK.\n");
