/*--------------------------------------------------------------------
 * File:        qnx.g
 *
 * Description: Functions that run on both QNX 4 and QNX 6.
 *
 * Functions:
 *              anyos_system
 *              anyos_change_settings
 *              anyos_makemsg
 *              anyos_help
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Function:    anyos_system
 * Application: common 
 * Returns:     t or nil
 * Description: A wrapper for the Gamma system() function that blocks
 *              signals while making a call, then reassigns a signal
 *              and unblocks the signals.  This is necessary for QNX4,
 *              and perhaps QNX6, because in that OS a system() call
 *              emits a signal.  
 *------------------------------------------------------------------*/
function anyos_system(call, sig)
{
  block_signal(sig);
  system(call);
  signal(sig, `anygui_sigchild());
  unblock_signal(sig);
}

/*--------------------------------------------------------------------
 * Function:    anyos_help
 * Returns:     t or nil
 * Description: Starts up the Helpviewer and displays the Tutorial docs.
 *------------------------------------------------------------------*/
function anyos_help()
{
  local help_url = "/usr/cogent/help/cogent-set/booktu/booktu.html";
  
  if (is_file(help_url))
    {
      PxHelpTopicRoot("/Cogent Documentation/Cogent Tools Demo and Tutorial");
      PxHelpTopic("booktu.html");
    }
  else
    anygui_makemsg(string("\nSorry, the Cogent Tools Demo and Tutorial",
                          "\nmanual is not available on your system.\n",
                          "\nPlease check your",
                          "\nCogent Documentation installation.\n\n"));
}

princ("OS is QNX.\n");

