/*--------------------------------------------------------------------
 * File:        qnx6.g
 *
 * Description: Functions that run only in QNX 6.
 *
 * Functions:
 *                gui_require
 *                anyver_loadlibs
 *                anyos_find_process
 *                anyos_assign
 *                anyver_num_callback
 *                anyver_numeric_assign
 *                anyver_change_settings
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Function:    gui_require
 * Application: common
 * Returns:     function
 * Description: Tests for GUI, and chooses GTK or Photon libraries.
 *------------------------------------------------------------------*/
function gui_require()
{
  local str_arg = string(car(argv));
  
  if (strstr(str_arg, "gtk") != -1)
    require("lib/gtk.g");
  else
    require("lib/photon.g");
}

gui_require();

/*--------------------------------------------------------------------
 * Function:    anyver_loadlibs
 * Application: common
 * Returns:     t or nil
 * Description: Not currently used in QNX 6.  A place-holder for 
 *              functionality needed in QNX 4.
 *------------------------------------------------------------------*/
function anyver_loadlibs()
{
  nil;
}

/*--------------------------------------------------------------------
 * Function:    anyos_find_process
 * Application: common
 * Returns:     t or nil
 * Description: Finds a process based on the name of a command, rather
 *              than the name of a processes (as is done in QNX 4 and
 *              Linux).  The qnx_name_locate function is not available
 *              in QNX 6 due to its unique kernel architecture.
 *------------------------------------------------------------------*/
function anyos_find_process(command, name)
{
  if(access(string("/dev/", command), 0) == -1)
    nil;
  else
    t;        
}

/*--------------------------------------------------------------------
 * Function:    anyos_assign
 * Application: common
 * Returns:     a string
 * Description: Creates a way to reassign a single string to different
 *              strings, based on the OS.
 *------------------------------------------------------------------*/
function anyos_assign(str)
{
  switch(str)
    {
    case "control_widgetfile": "ph2controlwin/wgt/Ptcontrol.wgtw";
    case "monitor_widgetfile": "ph2monitorwin/wgt/Ptmonitor.wgtw";
    case "log_widgetfile": "ph2logwin/wgt/Ptlog.wgtw";
    case "history_widgetfile": "ph2historywin/wgt/PtHist.wgtw";
    case "deadband_widgetfile": "ph2historywin/wgt/DeadBandWindow.wgtw";
    case "gamstring": "gamma";
    case "graph_font": "TextFont07";
    }
}

/*--------------------------------------------------------------------
 * Function:    anyver_num_callback
 * Application: Monitor
 * Returns:     t or nil
 * Description: Handles an annoying characteristic in Photon 2 whose
 *              PtNumericFloat widget does not work properly in Gamma.
 *              Thus we need to use a PtNumericInteger widget, and 
 *              convert back and forth to write points.  The widget
 *              that corresponds to FREQ_001 is a PtNumericInteger.
 *------------------------------------------------------------------*/
function anyver_num_callback(num, !pnt)
{
  if (eval(pnt) != #FREQ_001)
    {
      PtAttachCallback(num, Pt_CB_NUMERIC_CHANGED,
                       `write_point(@pnt, ((@eval(num)).numeric_value) / 100.0));
      pnt = eval(pnt);
      num.numeric_value = round(eval(pnt) * 100);
      add_exception_function(pnt, `(@num).numeric_value = eval(@pnt) * 100);
    }
  else
    {
      PtAttachCallback(num, Pt_CB_NUMERIC_CHANGED,
                       `write_point(@pnt, ((@eval(num)).numeric_value)));
      pnt = eval(pnt);
      num.numeric_value = eval(pnt);
      add_exception_function(pnt, `(@num).numeric_value = eval(@pnt));
    }
}

/*--------------------------------------------------------------------
 * Function:    anyver_numeric_assign
 * Application: Monitor
 * Returns:     t or nil
 * Description: Converts DataHub entries to integer values for use in
 *              PtNumericInteger widgets.  This is necessary because the
 *              Photon 2 PtNumeric Float widget does not work properly 
 *              in Gamma.
 *------------------------------------------------------------------*/
function anyver_numeric_assign(num1, num2, num3, num4, num5)
{
  num1.numeric_value = round(read_point(#PID1_Kp) * 100);
  num2.numeric_value = round(read_point(#PID1_Ki) * 100);
  num3.numeric_value = round(read_point(#PID1_Kd) * 100);
  num4.numeric_value = round(read_point(#PROP_001) * 100);
  num5.numeric_value = round(read_point(#INT_001) * 100);
}

/*--------------------------------------------------------------------
 * Function:    anyver_change_settings
 * Application: Monitor
 * Returns:     t or nil
 * Description: Changes the settings on a group of PtNumeric widgets.
 *              For QNX 4, these are PtNumericInteger widgets, but for
 *              QNX 6, they are PtNumericFloat widgets.  Thus this
 *              function has to convert variable values to integers for
 *              the widget.  We multiply the integer values in the widget
 *              by 100 to allow a 2-digit level of accuracy.
 *------------------------------------------------------------------*/
function anyver_change_settings(n2, v2, n3, v3, n4,
                                v4, n5, v5, n6, v6)
{
  n2.numeric_value = v2 * 100;
  n3.numeric_value = v3 * 100;
  n4.numeric_value = v4 * 100;
  n5.numeric_value = v5 * 100;
  n6.numeric_value = v6 * 100;
}

princ("Version is QNX6.\n");

