/*--------------------------------------------------------------------
 * File:        phcontrol.g
 *
 * Description: This program displays a window with buttons that start
 *              the PID Emulator, Monitor, DataHub Viewer, Log, and
 *              History.  It has text windows to display information
 *              about programs in the demo and their process status.
 *
 * Functions:
 *                create_control_win
 *                main
 *------------------------------------------------------------------*/

/* Keep track of all child processes that this process has started.
 */
Children := nil;


/*--------------------------------------------------------------------
 * Function:    create_control_win
 * Returns:     doesn't return
 * Description: Creates the Controller window.
 *------------------------------------------------------------------*/
function create_control_win()
{
  local wfile, window, control_win, pbut, mbut, dbut, lbut;
  local hbut, xbut, text, textatt, control_widgetfile, gamstring;

  wfile = PhabReadWidgetFile(anyos_assign("control_widgetfile"));
  gamstring = anyos_assign("gamstring");
  window = PhabCreateWidgets(wfile, nil, nil);
  control_win = PhabLookupWidget(window, #Ptcontrol, nil);
  tframe =  PhabLookupWidget(window, #PtTitle, nil);
  pbut = PhabLookupWidget(window, #Ptpbut, nil);
  mbut = PhabLookupWidget(window, #Ptmbut, nil);
  dbut = PhabLookupWidget(window, #Ptdbut, nil);
  lbut = PhabLookupWidget(window, #Ptlbut, nil);
  hbut = PhabLookupWidget(window, #Pthbut, nil);
  helpbut = PhabLookupWidget(window, #Pthelpbut, nil);
  xbut = PhabLookupWidget(window, #Ptxbut, nil);
  rbut = PhabLookupWidget(window, #Ptrbut, nil);
  text = PhabLookupWidget(window, #Pttext, nil);
  anygui_show_text(text, read_msg("1"), nil);
  text2 = PhabLookupWidget(window, #Pttext2, nil);
  show_names(text2);

  attach_msg(pbut, "2", "1");
  attach_msg(mbut, "3", "1");
  attach_msg(dbut, "4", "1");
  attach_msg(lbut, "5", "1");
  attach_msg(hbut, "6", "1");

  PtAttachCallback(pbut, Pt_CB_ACTIVATE, 
                   `start_stop(@pbut, gamstring, "emul", "emul.g"));
  PtAttachCallback(mbut, Pt_CB_ACTIVATE, 
                   `start_stop(@mbut, gamstring, "monitor", "phmonitor.g"));
  PtAttachCallback(dbut, Pt_CB_ACTIVATE, 
                   `start_stop(@dbut, "phdhview", "pidviewer", "-d", "toolsdemo"));
  PtAttachCallback(lbut, Pt_CB_ACTIVATE, 
                   `start_stop(@lbut, gamstring, "log", "phlog.g"));
  PtAttachCallback(hbut, Pt_CB_ACTIVATE, 
                   `start_stop(@hbut, gamstring, "history", "phhistory.g"));
  PtAttachCallback(rbut, Pt_CB_ACTIVATE, `toggle_raw(@rbut, @text2));
  
  PtAttachCallback(helpbut, Pt_CB_ACTIVATE, #anyos_help());
  PtAttachCallback(xbut, Pt_CB_ACTIVATE, #stop_processes());
  PtAttachCallback(xbut, Pt_CB_ACTIVATE, #exit_program(-1));

  control_win.SetPos(0, 0);
  
  PtRealizeWidget(control_win);
  
  PtMainLoop();
}


/*--------------------------------------------------------------------
 * Function:    main
 * Returns:     doesn't return
 * Description: Calls the common.g program_startup() function.
 *------------------------------------------------------------------*/
function main()
{
  /* Get access to the library of common functions. */
  require("lib/common.g");
  
  program_startup("control", "controlq", #create_control_win(), "1");
}

