/*--------------------------------------------------------------------
 * File:        phlog.g
 *
 * Description: Demonstrates the Cascade TextLogger
 *
 * Functions:
 *                create_log
 *                main
 *------------------------------------------------------------------*/

/* Keep track of all child processes that this process has started.
 */
Children := nil;

/*--------------------------------------------------------------------
 * Function:    start_logging
 * Returns:     t or nil
 * Description: Coordinates callbacks for the Log to button.
 *------------------------------------------------------------------*/
function start_logging (logbut, textwgt, fbut, sbut, anybut, fbut, allbut)
{
  start_stop(logbut, "textlog", "tlog", "-n", "tlog", 
              "-d", "toolsdemo", "-D", "tl.cfg");
  log_toggle(logbut, textwgt, fbut, sbut, anybut, fbut, allbut);
  send_message("nsnames");
}
     
/*--------------------------------------------------------------------
 * Function:    create_log
 * Returns:     doesn't return
 * Description: Creates the Log window
 *------------------------------------------------------------------*/
function create_log ()
{
  local log_win;
  
  wfile = PhabReadWidgetFile(anyos_assign("log_widgetfile"));
  window = PhabCreateWidgets(wfile, nil, nil);
  log_win = PhabLookupWidget(window, #Ptlog, nil);
  text = PhabLookupWidget(window, #Pttext, nil);
  logbut = PhabLookupWidget(window, #PtButtonLogto, nil);
  filebut = PhabLookupWidget(window, #PtToggleFile, nil);
  stdoutbut = PhabLookupWidget(window, #PtToggleStdout, nil);
  anybut = PhabLookupWidget(window, #PtToggleAny, nil);
  fillbut = PhabLookupWidget(window, #PtToggleFill, nil);
  allbut = PhabLookupWidget(window, #PtToggleAll, nil);
  insertbut = PhabLookupWidget(window, #PtButtonInsertText, nil);
  sendbut = PhabLookupWidget(window, #PtButtonSendCmd, nil);
  xbut = PhabLookupWidget(window, #PtButtonExit, nil);
  inserttxt = PhabLookupWidget(window, #PtTextInsert, nil);
  cmdtxt = PhabLookupWidget(window, #PtTextCmd, nil);

  anygui_show_text(text, string("To start the demo, ensure the PID Emulator\n", 
                                "is running, then press the Log to: button\n\n",
                                read_msg("5.11")), 1);

  attach_msg(log_win, "5", "1");
  attach_msg(anybut, "5.1", "5");
  attach_msg(fillbut, "5.2", "5");
  attach_msg(allbut, "5.3", "5");
  attach_msg(insertbut, "5.4", "5");
  attach_msg(sendbut, "5.5", "5");
  attach_msg(logbut, "5.6", "5");
  attach_msg(filebut, "5.7", "5");
  attach_msg(stdoutbut, "5.8", "5");

  PtAttachCallback(logbut, Pt_CB_ACTIVATE,
                   `start_logging(@logbut, @text, @filebut, @stdoutbut,
                                 @anybut, @fillbut, @allbut));

  PtAttachCallback(insertbut, Pt_CB_ACTIVATE,
                   `send_command(@inserttxt, "send-text", nil));
  PtAttachCallback(sendbut, Pt_CB_ACTIVATE,
                   `send_command(@cmdtxt, "send-cmd", nil));
  PtAttachCallback(filebut, Pt_CB_ACTIVATE,
                   `send_command(@filebut, "file-stdout", "tldemoboth"));
  PtAttachCallback(stdoutbut, Pt_CB_ACTIVATE,
                   `send_command(@stdoutbut, "file-stdout", "tldemostdout"));
  PtAttachCallback(anybut, Pt_CB_ACTIVATE,
                   `send_command(@anybut, "collect", "any"));
  PtAttachCallback(allbut, Pt_CB_ACTIVATE,
                   `send_command(@allbut, "collect", "all"));
  PtAttachCallback(fillbut, Pt_CB_ACTIVATE,
                   `send_command(@fillbut, "collect", "fill"));
  PtAttachCallback(xbut, Pt_CB_ACTIVATE, #exit_program(-1));

  atexit(#stop_processes());
  
  log_win.SetPos(360, 200);
  
  PtRealizeWidget(log_win);
  send_message("nsnames");
  
  PtMainLoop();
}

/*--------------------------------------------------------------------
 * Function:    main
 * Returns:     doesn't return
 * Description: Calls the common.g program_startup() function.
 *------------------------------------------------------------------*/
function main()
{
  /* Get access to the library of common functions. */
  require("lib/common.g");

  program_startup("log", "logq", #create_log(), "5");
}

