#ifndef __PGILIB_H__
#define __PGILIB_H__

#if __cplusplus
extern "C" {
#endif

#include <PGLib/PGGLib.h>

// Since keyboard/mouse I/O are often closely tied to the display, their
// access functions are included in this library.
//
// keyboard/mouse I/O is quite easy.  All you do is set the callback to point
// to your keyboard or mouse function.  This callback will receive any keyboard
// or mouse events occuring in your display.
void PGI_SetCBKeyboard(PGG_Display d,void (*cb)(PGG_Display d,int32_t key,int32_t flags));
void PGI_SetCBMouse(PGG_Display d,void (*cb)(PGG_Display d,int32_t x,int32_t y,int32_t b,int32_t flags));

// To enable/disable keyboard magic (full screen/scaling with numpad <ENTER>/+)
void PGI_SetKeyboardMagic(PGG_Display disp,int32_t magic);

#define PGI_MOUSE_DOWN	0x00010000
#define PGI_MOUSE_UP	0x00020000
#define PGI_MOUSE_MOVED	0x00040000

#define PGI_KEYMASK_DOWN        0x00000001
#define PGI_KEYMASK_LCONTROL    0x00010000
#define PGI_KEYMASK_RCONTROL    0x00020000
#define PGI_KEYMASK_CONTROL (PGI_KEYMASK_LCONTROL|PGI_KEYMASK_RCONTROL)

#if __cplusplus
};
#endif

#endif

