#ifndef __PGULIB_H__
#define __PGULIB_H__

#include <inttypes.h>

#if __cplusplus
extern "C" {
#endif

#include <PGLib/PG_Platform.h>

typedef struct PGU_Semaphore_t *PGU_Semaphore;
typedef struct PGU_Thread_t *PGU_Thread;
typedef struct PGU_List_t *PGU_List;
typedef struct PGU_Lock_t *PGU_Lock;
typedef struct PGU_LockedQ_t *PGU_LockedQ;

int PGU_Main(int argc,char *argv[],int (*oldmain)(int argc,char *argv[]));


int32_t PGU_TimeMS(void);
void PGU_TimeDelayMS(int32_t ms);
void PGU_TimeDelayUS(int32_t us);
void PGU_TimeDelayDisable(int32_t disable);	// for testing mostly
int32_t PGU_TimeDelayDisabled(void);		// for testing mostly

PGU_Lock PGU_LockCreate(void);
void PGU_LockDelete(PGU_Lock l);
int32_t PGU_LockAcquire(PGU_Lock l);
void PGU_LockRelease(PGU_Lock l);

PGU_Thread PGU_ThreadCreate(int32_t (*func)(void*),char *name,void *obj);
int32_t PGU_ThreadWait(PGU_Thread t);
void PGU_ThreadExit(int32_t val);

char *PGU_ConfigPath(const char *gamename,char *filename,char *path);
char *PGU_DataPath(const char *gamename,char *filename,char *path);

int32_t PGU_DirMake(const char *path);
int32_t PGU_DirExists(const char *path);

int32_t PGU_Debugger(const char *text);
int32_t PGU_Alert(const char *text,const char *but1,const char *but2,const char *but3);

PGU_List PGU_ListCreate(int32_t blockcount);
void PGU_ListDelete(PGU_List);
void PGU_ListEmpty(PGU_List);
int32_t PGU_ListIsEmpty(PGU_List);
void *PGU_ListItemAt(PGU_List,int32_t);
int32_t PGU_ListCount(PGU_List);
void *PGU_ListRemoveAt(PGU_List,int32_t);
void PGU_ListRemoveItem(PGU_List,void *);
void PGU_ListInsertAt(PGU_List,int32_t,void *);
void PGU_ListAddItem(PGU_List,void *);
void PGU_ListReplaceAt(PGU_List,int32_t,void*);
int32_t PGU_ListHasItem(PGU_List,void *item);

PGU_LockedQ PGU_LockedQCreate(void);
void PGU_LockedQDelete(PGU_LockedQ q);
void PGU_LockedQAdd(PGU_LockedQ q,void *obj);
void *PGU_LockedQRemove(PGU_LockedQ q);
int32_t PGU_LockedQIsEmpty(PGU_LockedQ q);
void PGU_LockedQEmpty(PGU_LockedQ q);

// raw image data copying:
int32_t PGU_ImageCopyRect8(uint8_t *sdata,int32_t sbpl,uint8_t *ddata,int32_t dpbl,int32_t sx,int32_t sy,int32_t dx,int32_t dy,int32_t w,int32_t h);
int32_t PGU_ImageCopyRect8MaskSource(uint8_t *sdata,int32_t sbpl,uint8_t *ddata,int32_t dpbl,int32_t sx,int32_t sy,int32_t dx,int32_t dy,int32_t w,int32_t h,int32_t mask);
int32_t PGU_ImageFillRect8(uint8_t *bits,int32_t bpl,int32_t x,int32_t y,int32_t w,int32_t h,int32_t c);
int32_t PGU_ImageFillRect1(uint8_t *data,int32_t width,int32_t height,int32_t wbytes,int32_t x,int32_t y,int32_t c);

#ifndef TRUE
#define TRUE true
#endif
#ifndef FALSE
#define FALSE false
#endif

#if __cplusplus
};
#endif

#endif

