//Copyright, 2002-2003, Astra Network Inc.  All Rights Reserved

//This source code has been published by Astra Network Inc. However, any
//use, reproduction, modification, distribution or transfer of this
//software, or any software which includes or is based upon any of this
//code, is only permitted if expressly authorized by a written license
//agreement from Astra. Contact your Astra representative directly for
//more information.

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>

#define PIPENAME "/tmp/simple"

int
main (int argc, char *argv[])
{
  int pd;			// fd for named pipe

  srand(time(NULL));
  if (mkfifo (PIPENAME, S_IRUSR | S_IWUSR))
    {
      if (errno != EEXIST)
	{
	  printf ("Unable to make fifo \"%s\" (%s)\n",
		  PIPENAME, strerror (errno));
	  exit (EXIT_FAILURE);
	}
    }

  pd = open (PIPENAME, O_WRONLY);

  if (pd == -1)
    {
      printf ("Unable to open fifo \"%s\" (%s)\n",
	      PIPENAME, strerror (errno));
      exit (EXIT_FAILURE);
    }

  while (1)
    {
      if( (rand()%25) == 0 )
        write( pd, 
               "This is bad data and has to be at least 25 chars!!!!", 
               52 );
      else
        write (pd, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", 26);
      sleep (1);
    }
  close (pd);

  exit (EXIT_SUCCESS);
}
